// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.DatabaseConnectionOverview;
import com.azure.resourcemanager.appservice.models.EnterpriseGradeCdnStatus;
import com.azure.resourcemanager.appservice.models.ResponseMessageEnvelopeRemotePrivateEndpointConnection;
import com.azure.resourcemanager.appservice.models.StagingEnvironmentPolicy;
import com.azure.resourcemanager.appservice.models.StaticSiteBuildProperties;
import com.azure.resourcemanager.appservice.models.StaticSiteLinkedBackend;
import com.azure.resourcemanager.appservice.models.StaticSiteTemplateOptions;
import com.azure.resourcemanager.appservice.models.StaticSiteUserProvidedFunctionApp;
import java.io.IOException;
import java.util.List;

/**
 * A static site.
 */
@Fluent
public final class StaticSite implements JsonSerializable<StaticSite> {
    /*
     * The default autogenerated hostname for the static site.
     */
    private String defaultHostname;

    /*
     * URL for the repository of the static site.
     */
    private String repositoryUrl;

    /*
     * The target branch in the repository.
     */
    private String branch;

    /*
     * The custom domains associated with this static site.
     */
    private List<String> customDomains;

    /*
     * A user's github repository token. This is used to setup the Github Actions workflow file and API secrets.
     */
    private String repositoryToken;

    /*
     * Build properties to configure on the repository.
     */
    private StaticSiteBuildProperties buildProperties;

    /*
     * Private endpoint connections
     */
    private List<ResponseMessageEnvelopeRemotePrivateEndpointConnection> privateEndpointConnections;

    /*
     * State indicating whether staging environments are allowed or not allowed for a static web app.
     */
    private StagingEnvironmentPolicy stagingEnvironmentPolicy;

    /*
     * <code>false</code> if config file is locked for this static web app; otherwise, <code>true</code>.
     */
    private Boolean allowConfigFileUpdates;

    /*
     * Template options for generating a new repository.
     */
    private StaticSiteTemplateOptions templateProperties;

    /*
     * The content distribution endpoint for the static site.
     */
    private String contentDistributionEndpoint;

    /*
     * Identity to use for Key Vault Reference authentication.
     */
    private String keyVaultReferenceIdentity;

    /*
     * User provided function apps registered with the static site
     */
    private List<StaticSiteUserProvidedFunctionApp> userProvidedFunctionApps;

    /*
     * Backends linked to the static side
     */
    private List<StaticSiteLinkedBackend> linkedBackends;

    /*
     * The provider that submitted the last deployment to the primary environment of the static site.
     */
    private String provider;

    /*
     * State indicating the status of the enterprise grade CDN serving traffic to the static web app.
     */
    private EnterpriseGradeCdnStatus enterpriseGradeCdnStatus;

    /*
     * State indicating whether public traffic are allowed or not for a static web app. Allowed Values: 'Enabled',
     * 'Disabled' or an empty string.
     */
    private String publicNetworkAccess;

    /*
     * Database connections for the static site
     */
    private List<DatabaseConnectionOverview> databaseConnections;

    /**
     * Creates an instance of StaticSite class.
     */
    public StaticSite() {
    }

    /**
     * Get the defaultHostname property: The default autogenerated hostname for the static site.
     * 
     * @return the defaultHostname value.
     */
    public String defaultHostname() {
        return this.defaultHostname;
    }

    /**
     * Get the repositoryUrl property: URL for the repository of the static site.
     * 
     * @return the repositoryUrl value.
     */
    public String repositoryUrl() {
        return this.repositoryUrl;
    }

    /**
     * Set the repositoryUrl property: URL for the repository of the static site.
     * 
     * @param repositoryUrl the repositoryUrl value to set.
     * @return the StaticSite object itself.
     */
    public StaticSite withRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
        return this;
    }

    /**
     * Get the branch property: The target branch in the repository.
     * 
     * @return the branch value.
     */
    public String branch() {
        return this.branch;
    }

    /**
     * Set the branch property: The target branch in the repository.
     * 
     * @param branch the branch value to set.
     * @return the StaticSite object itself.
     */
    public StaticSite withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    /**
     * Get the customDomains property: The custom domains associated with this static site.
     * 
     * @return the customDomains value.
     */
    public List<String> customDomains() {
        return this.customDomains;
    }

    /**
     * Get the repositoryToken property: A user's github repository token. This is used to setup the Github Actions
     * workflow file and API secrets.
     * 
     * @return the repositoryToken value.
     */
    public String repositoryToken() {
        return this.repositoryToken;
    }

    /**
     * Set the repositoryToken property: A user's github repository token. This is used to setup the Github Actions
     * workflow file and API secrets.
     * 
     * @param repositoryToken the repositoryToken value to set.
     * @return the StaticSite object itself.
     */
    public StaticSite withRepositoryToken(String repositoryToken) {
        this.repositoryToken = repositoryToken;
        return this;
    }

    /**
     * Get the buildProperties property: Build properties to configure on the repository.
     * 
     * @return the buildProperties value.
     */
    public StaticSiteBuildProperties buildProperties() {
        return this.buildProperties;
    }

    /**
     * Set the buildProperties property: Build properties to configure on the repository.
     * 
     * @param buildProperties the buildProperties value to set.
     * @return the StaticSite object itself.
     */
    public StaticSite withBuildProperties(StaticSiteBuildProperties buildProperties) {
        this.buildProperties = buildProperties;
        return this;
    }

    /**
     * Get the privateEndpointConnections property: Private endpoint connections.
     * 
     * @return the privateEndpointConnections value.
     */
    public List<ResponseMessageEnvelopeRemotePrivateEndpointConnection> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    /**
     * Get the stagingEnvironmentPolicy property: State indicating whether staging environments are allowed or not
     * allowed for a static web app.
     * 
     * @return the stagingEnvironmentPolicy value.
     */
    public StagingEnvironmentPolicy stagingEnvironmentPolicy() {
        return this.stagingEnvironmentPolicy;
    }

    /**
     * Set the stagingEnvironmentPolicy property: State indicating whether staging environments are allowed or not
     * allowed for a static web app.
     * 
     * @param stagingEnvironmentPolicy the stagingEnvironmentPolicy value to set.
     * @return the StaticSite object itself.
     */
    public StaticSite withStagingEnvironmentPolicy(StagingEnvironmentPolicy stagingEnvironmentPolicy) {
        this.stagingEnvironmentPolicy = stagingEnvironmentPolicy;
        return this;
    }

    /**
     * Get the allowConfigFileUpdates property: &lt;code&gt;false&lt;/code&gt; if config file is locked for this static
     * web app; otherwise, &lt;code&gt;true&lt;/code&gt;.
     * 
     * @return the allowConfigFileUpdates value.
     */
    public Boolean allowConfigFileUpdates() {
        return this.allowConfigFileUpdates;
    }

    /**
     * Set the allowConfigFileUpdates property: &lt;code&gt;false&lt;/code&gt; if config file is locked for this static
     * web app; otherwise, &lt;code&gt;true&lt;/code&gt;.
     * 
     * @param allowConfigFileUpdates the allowConfigFileUpdates value to set.
     * @return the StaticSite object itself.
     */
    public StaticSite withAllowConfigFileUpdates(Boolean allowConfigFileUpdates) {
        this.allowConfigFileUpdates = allowConfigFileUpdates;
        return this;
    }

    /**
     * Get the templateProperties property: Template options for generating a new repository.
     * 
     * @return the templateProperties value.
     */
    public StaticSiteTemplateOptions templateProperties() {
        return this.templateProperties;
    }

    /**
     * Set the templateProperties property: Template options for generating a new repository.
     * 
     * @param templateProperties the templateProperties value to set.
     * @return the StaticSite object itself.
     */
    public StaticSite withTemplateProperties(StaticSiteTemplateOptions templateProperties) {
        this.templateProperties = templateProperties;
        return this;
    }

    /**
     * Get the contentDistributionEndpoint property: The content distribution endpoint for the static site.
     * 
     * @return the contentDistributionEndpoint value.
     */
    public String contentDistributionEndpoint() {
        return this.contentDistributionEndpoint;
    }

    /**
     * Get the keyVaultReferenceIdentity property: Identity to use for Key Vault Reference authentication.
     * 
     * @return the keyVaultReferenceIdentity value.
     */
    public String keyVaultReferenceIdentity() {
        return this.keyVaultReferenceIdentity;
    }

    /**
     * Get the userProvidedFunctionApps property: User provided function apps registered with the static site.
     * 
     * @return the userProvidedFunctionApps value.
     */
    public List<StaticSiteUserProvidedFunctionApp> userProvidedFunctionApps() {
        return this.userProvidedFunctionApps;
    }

    /**
     * Get the linkedBackends property: Backends linked to the static side.
     * 
     * @return the linkedBackends value.
     */
    public List<StaticSiteLinkedBackend> linkedBackends() {
        return this.linkedBackends;
    }

    /**
     * Get the provider property: The provider that submitted the last deployment to the primary environment of the
     * static site.
     * 
     * @return the provider value.
     */
    public String provider() {
        return this.provider;
    }

    /**
     * Set the provider property: The provider that submitted the last deployment to the primary environment of the
     * static site.
     * 
     * @param provider the provider value to set.
     * @return the StaticSite object itself.
     */
    public StaticSite withProvider(String provider) {
        this.provider = provider;
        return this;
    }

    /**
     * Get the enterpriseGradeCdnStatus property: State indicating the status of the enterprise grade CDN serving
     * traffic to the static web app.
     * 
     * @return the enterpriseGradeCdnStatus value.
     */
    public EnterpriseGradeCdnStatus enterpriseGradeCdnStatus() {
        return this.enterpriseGradeCdnStatus;
    }

    /**
     * Set the enterpriseGradeCdnStatus property: State indicating the status of the enterprise grade CDN serving
     * traffic to the static web app.
     * 
     * @param enterpriseGradeCdnStatus the enterpriseGradeCdnStatus value to set.
     * @return the StaticSite object itself.
     */
    public StaticSite withEnterpriseGradeCdnStatus(EnterpriseGradeCdnStatus enterpriseGradeCdnStatus) {
        this.enterpriseGradeCdnStatus = enterpriseGradeCdnStatus;
        return this;
    }

    /**
     * Get the publicNetworkAccess property: State indicating whether public traffic are allowed or not for a static web
     * app. Allowed Values: 'Enabled', 'Disabled' or an empty string.
     * 
     * @return the publicNetworkAccess value.
     */
    public String publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: State indicating whether public traffic are allowed or not for a static web
     * app. Allowed Values: 'Enabled', 'Disabled' or an empty string.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the StaticSite object itself.
     */
    public StaticSite withPublicNetworkAccess(String publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Get the databaseConnections property: Database connections for the static site.
     * 
     * @return the databaseConnections value.
     */
    public List<DatabaseConnectionOverview> databaseConnections() {
        return this.databaseConnections;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (buildProperties() != null) {
            buildProperties().validate();
        }
        if (privateEndpointConnections() != null) {
            privateEndpointConnections().forEach(e -> e.validate());
        }
        if (templateProperties() != null) {
            templateProperties().validate();
        }
        if (userProvidedFunctionApps() != null) {
            userProvidedFunctionApps().forEach(e -> e.validate());
        }
        if (linkedBackends() != null) {
            linkedBackends().forEach(e -> e.validate());
        }
        if (databaseConnections() != null) {
            databaseConnections().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("repositoryUrl", this.repositoryUrl);
        jsonWriter.writeStringField("branch", this.branch);
        jsonWriter.writeStringField("repositoryToken", this.repositoryToken);
        jsonWriter.writeJsonField("buildProperties", this.buildProperties);
        jsonWriter.writeStringField("stagingEnvironmentPolicy",
            this.stagingEnvironmentPolicy == null ? null : this.stagingEnvironmentPolicy.toString());
        jsonWriter.writeBooleanField("allowConfigFileUpdates", this.allowConfigFileUpdates);
        jsonWriter.writeJsonField("templateProperties", this.templateProperties);
        jsonWriter.writeStringField("provider", this.provider);
        jsonWriter.writeStringField("enterpriseGradeCdnStatus",
            this.enterpriseGradeCdnStatus == null ? null : this.enterpriseGradeCdnStatus.toString());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StaticSite from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StaticSite if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the StaticSite.
     */
    public static StaticSite fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StaticSite deserializedStaticSite = new StaticSite();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("defaultHostname".equals(fieldName)) {
                    deserializedStaticSite.defaultHostname = reader.getString();
                } else if ("repositoryUrl".equals(fieldName)) {
                    deserializedStaticSite.repositoryUrl = reader.getString();
                } else if ("branch".equals(fieldName)) {
                    deserializedStaticSite.branch = reader.getString();
                } else if ("customDomains".equals(fieldName)) {
                    List<String> customDomains = reader.readArray(reader1 -> reader1.getString());
                    deserializedStaticSite.customDomains = customDomains;
                } else if ("repositoryToken".equals(fieldName)) {
                    deserializedStaticSite.repositoryToken = reader.getString();
                } else if ("buildProperties".equals(fieldName)) {
                    deserializedStaticSite.buildProperties = StaticSiteBuildProperties.fromJson(reader);
                } else if ("privateEndpointConnections".equals(fieldName)) {
                    List<ResponseMessageEnvelopeRemotePrivateEndpointConnection> privateEndpointConnections = reader
                        .readArray(reader1 -> ResponseMessageEnvelopeRemotePrivateEndpointConnection.fromJson(reader1));
                    deserializedStaticSite.privateEndpointConnections = privateEndpointConnections;
                } else if ("stagingEnvironmentPolicy".equals(fieldName)) {
                    deserializedStaticSite.stagingEnvironmentPolicy
                        = StagingEnvironmentPolicy.fromString(reader.getString());
                } else if ("allowConfigFileUpdates".equals(fieldName)) {
                    deserializedStaticSite.allowConfigFileUpdates = reader.getNullable(JsonReader::getBoolean);
                } else if ("templateProperties".equals(fieldName)) {
                    deserializedStaticSite.templateProperties = StaticSiteTemplateOptions.fromJson(reader);
                } else if ("contentDistributionEndpoint".equals(fieldName)) {
                    deserializedStaticSite.contentDistributionEndpoint = reader.getString();
                } else if ("keyVaultReferenceIdentity".equals(fieldName)) {
                    deserializedStaticSite.keyVaultReferenceIdentity = reader.getString();
                } else if ("userProvidedFunctionApps".equals(fieldName)) {
                    List<StaticSiteUserProvidedFunctionApp> userProvidedFunctionApps
                        = reader.readArray(reader1 -> StaticSiteUserProvidedFunctionApp.fromJson(reader1));
                    deserializedStaticSite.userProvidedFunctionApps = userProvidedFunctionApps;
                } else if ("linkedBackends".equals(fieldName)) {
                    List<StaticSiteLinkedBackend> linkedBackends
                        = reader.readArray(reader1 -> StaticSiteLinkedBackend.fromJson(reader1));
                    deserializedStaticSite.linkedBackends = linkedBackends;
                } else if ("provider".equals(fieldName)) {
                    deserializedStaticSite.provider = reader.getString();
                } else if ("enterpriseGradeCdnStatus".equals(fieldName)) {
                    deserializedStaticSite.enterpriseGradeCdnStatus
                        = EnterpriseGradeCdnStatus.fromString(reader.getString());
                } else if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedStaticSite.publicNetworkAccess = reader.getString();
                } else if ("databaseConnections".equals(fieldName)) {
                    List<DatabaseConnectionOverview> databaseConnections
                        = reader.readArray(reader1 -> DatabaseConnectionOverview.fromJson(reader1));
                    deserializedStaticSite.databaseConnections = databaseConnections;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStaticSite;
        });
    }
}
