// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.FunctionAppMajorVersion;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.StackPreferredOs;
import java.io.IOException;
import java.util.List;

/**
 * Function App Stack.
 */
@Fluent
public final class FunctionAppStackInner extends ProxyOnlyResource {
    /*
     * Function App stack location.
     */
    private String location;

    /*
     * FunctionAppStack resource specific properties
     */
    private FunctionAppStackProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of FunctionAppStackInner class.
     */
    public FunctionAppStackInner() {
    }

    /**
     * Get the location property: Function App stack location.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the innerProperties property: FunctionAppStack resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private FunctionAppStackProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public FunctionAppStackInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the displayText property: Function App stack (display only).
     * 
     * @return the displayText value.
     */
    public String displayText() {
        return this.innerProperties() == null ? null : this.innerProperties().displayText();
    }

    /**
     * Get the value property: Function App stack name.
     * 
     * @return the value value.
     */
    public String value() {
        return this.innerProperties() == null ? null : this.innerProperties().value();
    }

    /**
     * Get the majorVersions property: List of major versions available.
     * 
     * @return the majorVersions value.
     */
    public List<FunctionAppMajorVersion> majorVersions() {
        return this.innerProperties() == null ? null : this.innerProperties().majorVersions();
    }

    /**
     * Get the preferredOs property: Function App stack preferred OS.
     * 
     * @return the preferredOs value.
     */
    public StackPreferredOs preferredOs() {
        return this.innerProperties() == null ? null : this.innerProperties().preferredOs();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FunctionAppStackInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FunctionAppStackInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FunctionAppStackInner.
     */
    public static FunctionAppStackInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FunctionAppStackInner deserializedFunctionAppStackInner = new FunctionAppStackInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedFunctionAppStackInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedFunctionAppStackInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedFunctionAppStackInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedFunctionAppStackInner.withKind(reader.getString());
                } else if ("location".equals(fieldName)) {
                    deserializedFunctionAppStackInner.location = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedFunctionAppStackInner.innerProperties = FunctionAppStackProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFunctionAppStackInner;
        });
    }
}
