// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Represents the workflow health.
 */
@Fluent
public final class WorkflowHealth {
    /*
     * Gets or sets the workflow health state.
     */
    @JsonProperty(value = "state", required = true)
    private WorkflowHealthState state;

    /*
     * Gets or sets the workflow error.
     */
    @JsonProperty(value = "error")
    private ErrorEntity error;

    /**
     * Creates an instance of WorkflowHealth class.
     */
    public WorkflowHealth() {
    }

    /**
     * Get the state property: Gets or sets the workflow health state.
     * 
     * @return the state value.
     */
    public WorkflowHealthState state() {
        return this.state;
    }

    /**
     * Set the state property: Gets or sets the workflow health state.
     * 
     * @param state the state value to set.
     * @return the WorkflowHealth object itself.
     */
    public WorkflowHealth withState(WorkflowHealthState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the error property: Gets or sets the workflow error.
     * 
     * @return the error value.
     */
    public ErrorEntity error() {
        return this.error;
    }

    /**
     * Set the error property: Gets or sets the workflow error.
     * 
     * @param error the error value to set.
     * @return the WorkflowHealth object itself.
     */
    public WorkflowHealth withError(ErrorEntity error) {
        this.error = error;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (state() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property state in model WorkflowHealth"));
        }
        if (error() != null) {
            error().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(WorkflowHealth.class);
}
