// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/**
 * The SiteDnsConfig model.
 */
@Fluent
public final class SiteDnsConfig {
    /*
     * List of custom DNS servers to be used by an app for lookups. Maximum 5 dns servers can be set.
     */
    @JsonProperty(value = "dnsServers")
    private List<String> dnsServers;

    /*
     * Alternate DNS server to be used by apps. This property replicates the WEBSITE_DNS_ALT_SERVER app setting.
     */
    @JsonProperty(value = "dnsAltServer")
    private String dnsAltServer;

    /*
     * Timeout for a single dns lookup in seconds. Allowed range: 1-30. Default is 3.
     */
    @JsonProperty(value = "dnsRetryAttemptTimeout")
    private Integer dnsRetryAttemptTimeout;

    /*
     * Total number of retries for dns lookup. Allowed range: 1-5. Default is 3.
     */
    @JsonProperty(value = "dnsRetryAttemptCount")
    private Integer dnsRetryAttemptCount;

    /*
     * Custom time for DNS to be cached in seconds. Allowed range: 0-60. Default is 30 seconds. 0 means caching disabled.
     */
    @JsonProperty(value = "dnsMaxCacheTimeout")
    private Integer dnsMaxCacheTimeout;

    /*
     * Indicates that sites using Virtual network custom DNS servers are still sorting the list of DNS servers. Read-Only.
     */
    @JsonProperty(value = "dnsLegacySortOrder", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean dnsLegacySortOrder;

    /**
     * Creates an instance of SiteDnsConfig class.
     */
    public SiteDnsConfig() {
    }

    /**
     * Get the dnsServers property: List of custom DNS servers to be used by an app for lookups. Maximum 5 dns servers
     * can be set.
     *
     * @return the dnsServers value.
     */
    public List<String> dnsServers() {
        return this.dnsServers;
    }

    /**
     * Set the dnsServers property: List of custom DNS servers to be used by an app for lookups. Maximum 5 dns servers
     * can be set.
     *
     * @param dnsServers the dnsServers value to set.
     * @return the SiteDnsConfig object itself.
     */
    public SiteDnsConfig withDnsServers(List<String> dnsServers) {
        this.dnsServers = dnsServers;
        return this;
    }

    /**
     * Get the dnsAltServer property: Alternate DNS server to be used by apps. This property replicates the
     * WEBSITE_DNS_ALT_SERVER app setting.
     *
     * @return the dnsAltServer value.
     */
    public String dnsAltServer() {
        return this.dnsAltServer;
    }

    /**
     * Set the dnsAltServer property: Alternate DNS server to be used by apps. This property replicates the
     * WEBSITE_DNS_ALT_SERVER app setting.
     *
     * @param dnsAltServer the dnsAltServer value to set.
     * @return the SiteDnsConfig object itself.
     */
    public SiteDnsConfig withDnsAltServer(String dnsAltServer) {
        this.dnsAltServer = dnsAltServer;
        return this;
    }

    /**
     * Get the dnsRetryAttemptTimeout property: Timeout for a single dns lookup in seconds. Allowed range: 1-30. Default
     * is 3.
     *
     * @return the dnsRetryAttemptTimeout value.
     */
    public Integer dnsRetryAttemptTimeout() {
        return this.dnsRetryAttemptTimeout;
    }

    /**
     * Set the dnsRetryAttemptTimeout property: Timeout for a single dns lookup in seconds. Allowed range: 1-30. Default
     * is 3.
     *
     * @param dnsRetryAttemptTimeout the dnsRetryAttemptTimeout value to set.
     * @return the SiteDnsConfig object itself.
     */
    public SiteDnsConfig withDnsRetryAttemptTimeout(Integer dnsRetryAttemptTimeout) {
        this.dnsRetryAttemptTimeout = dnsRetryAttemptTimeout;
        return this;
    }

    /**
     * Get the dnsRetryAttemptCount property: Total number of retries for dns lookup. Allowed range: 1-5. Default is 3.
     *
     * @return the dnsRetryAttemptCount value.
     */
    public Integer dnsRetryAttemptCount() {
        return this.dnsRetryAttemptCount;
    }

    /**
     * Set the dnsRetryAttemptCount property: Total number of retries for dns lookup. Allowed range: 1-5. Default is 3.
     *
     * @param dnsRetryAttemptCount the dnsRetryAttemptCount value to set.
     * @return the SiteDnsConfig object itself.
     */
    public SiteDnsConfig withDnsRetryAttemptCount(Integer dnsRetryAttemptCount) {
        this.dnsRetryAttemptCount = dnsRetryAttemptCount;
        return this;
    }

    /**
     * Get the dnsMaxCacheTimeout property: Custom time for DNS to be cached in seconds. Allowed range: 0-60. Default is
     * 30 seconds. 0 means caching disabled.
     *
     * @return the dnsMaxCacheTimeout value.
     */
    public Integer dnsMaxCacheTimeout() {
        return this.dnsMaxCacheTimeout;
    }

    /**
     * Set the dnsMaxCacheTimeout property: Custom time for DNS to be cached in seconds. Allowed range: 0-60. Default is
     * 30 seconds. 0 means caching disabled.
     *
     * @param dnsMaxCacheTimeout the dnsMaxCacheTimeout value to set.
     * @return the SiteDnsConfig object itself.
     */
    public SiteDnsConfig withDnsMaxCacheTimeout(Integer dnsMaxCacheTimeout) {
        this.dnsMaxCacheTimeout = dnsMaxCacheTimeout;
        return this;
    }

    /**
     * Get the dnsLegacySortOrder property: Indicates that sites using Virtual network custom DNS servers are still
     * sorting the list of DNS servers. Read-Only.
     *
     * @return the dnsLegacySortOrder value.
     */
    public Boolean dnsLegacySortOrder() {
        return this.dnsLegacySortOrder;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
