// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Scale and concurrency settings for the function app triggers.
 */
@Fluent
public final class FunctionsScaleAndConcurrencyTriggers {
    /*
     * Scale and concurrency settings for the HTTP trigger.
     */
    @JsonProperty(value = "http")
    private FunctionsScaleAndConcurrencyTriggersHttp http;

    /**
     * Creates an instance of FunctionsScaleAndConcurrencyTriggers class.
     */
    public FunctionsScaleAndConcurrencyTriggers() {
    }

    /**
     * Get the http property: Scale and concurrency settings for the HTTP trigger.
     * 
     * @return the http value.
     */
    public FunctionsScaleAndConcurrencyTriggersHttp http() {
        return this.http;
    }

    /**
     * Set the http property: Scale and concurrency settings for the HTTP trigger.
     * 
     * @param http the http value to set.
     * @return the FunctionsScaleAndConcurrencyTriggers object itself.
     */
    public FunctionsScaleAndConcurrencyTriggers withHttp(FunctionsScaleAndConcurrencyTriggersHttp http) {
        this.http = http;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (http() != null) {
            http().validate();
        }
    }
}
