// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/**
 * Scale and concurrency settings for the function app.
 */
@Fluent
public final class FunctionsScaleAndConcurrency {
    /*
     * 'Always Ready' configuration for the function app.
     */
    @JsonProperty(value = "alwaysReady")
    private List<FunctionsAlwaysReadyConfig> alwaysReady;

    /*
     * The maximum number of instances for the function app.
     */
    @JsonProperty(value = "maximumInstanceCount")
    private Float maximumInstanceCount;

    /*
     * Set the amount of memory allocated to each instance of the function app in MB. CPU and network bandwidth are allocated proportionally.
     */
    @JsonProperty(value = "instanceMemoryMB")
    private Float instanceMemoryMB;

    /*
     * Scale and concurrency settings for the function app triggers.
     */
    @JsonProperty(value = "triggers")
    private FunctionsScaleAndConcurrencyTriggers triggers;

    /**
     * Creates an instance of FunctionsScaleAndConcurrency class.
     */
    public FunctionsScaleAndConcurrency() {
    }

    /**
     * Get the alwaysReady property: 'Always Ready' configuration for the function app.
     *
     * @return the alwaysReady value.
     */
    public List<FunctionsAlwaysReadyConfig> alwaysReady() {
        return this.alwaysReady;
    }

    /**
     * Set the alwaysReady property: 'Always Ready' configuration for the function app.
     *
     * @param alwaysReady the alwaysReady value to set.
     * @return the FunctionsScaleAndConcurrency object itself.
     */
    public FunctionsScaleAndConcurrency withAlwaysReady(List<FunctionsAlwaysReadyConfig> alwaysReady) {
        this.alwaysReady = alwaysReady;
        return this;
    }

    /**
     * Get the maximumInstanceCount property: The maximum number of instances for the function app.
     *
     * @return the maximumInstanceCount value.
     */
    public Float maximumInstanceCount() {
        return this.maximumInstanceCount;
    }

    /**
     * Set the maximumInstanceCount property: The maximum number of instances for the function app.
     *
     * @param maximumInstanceCount the maximumInstanceCount value to set.
     * @return the FunctionsScaleAndConcurrency object itself.
     */
    public FunctionsScaleAndConcurrency withMaximumInstanceCount(Float maximumInstanceCount) {
        this.maximumInstanceCount = maximumInstanceCount;
        return this;
    }

    /**
     * Get the instanceMemoryMB property: Set the amount of memory allocated to each instance of the function app in MB.
     * CPU and network bandwidth are allocated proportionally.
     *
     * @return the instanceMemoryMB value.
     */
    public Float instanceMemoryMB() {
        return this.instanceMemoryMB;
    }

    /**
     * Set the instanceMemoryMB property: Set the amount of memory allocated to each instance of the function app in MB.
     * CPU and network bandwidth are allocated proportionally.
     *
     * @param instanceMemoryMB the instanceMemoryMB value to set.
     * @return the FunctionsScaleAndConcurrency object itself.
     */
    public FunctionsScaleAndConcurrency withInstanceMemoryMB(Float instanceMemoryMB) {
        this.instanceMemoryMB = instanceMemoryMB;
        return this;
    }

    /**
     * Get the triggers property: Scale and concurrency settings for the function app triggers.
     *
     * @return the triggers value.
     */
    public FunctionsScaleAndConcurrencyTriggers triggers() {
        return this.triggers;
    }

    /**
     * Set the triggers property: Scale and concurrency settings for the function app triggers.
     *
     * @param triggers the triggers value to set.
     * @return the FunctionsScaleAndConcurrency object itself.
     */
    public FunctionsScaleAndConcurrency withTriggers(FunctionsScaleAndConcurrencyTriggers triggers) {
        this.triggers = triggers;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (alwaysReady() != null) {
            alwaysReady().forEach(e -> e.validate());
        }
        if (triggers() != null) {
            triggers().validate();
        }
    }
}
