// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Function app runtime name and version.
 */
@Fluent
public final class FunctionsRuntime {
    /*
     * Function app runtime name. Available options: dotnet-isolated, node, java, powershell, python, custom
     */
    @JsonProperty(value = "name")
    private RuntimeName name;

    /*
     * Function app runtime version. Example: 8 (for dotnet-isolated)
     */
    @JsonProperty(value = "version")
    private String version;

    /**
     * Creates an instance of FunctionsRuntime class.
     */
    public FunctionsRuntime() {
    }

    /**
     * Get the name property: Function app runtime name. Available options: dotnet-isolated, node, java, powershell,
     * python, custom.
     * 
     * @return the name value.
     */
    public RuntimeName name() {
        return this.name;
    }

    /**
     * Set the name property: Function app runtime name. Available options: dotnet-isolated, node, java, powershell,
     * python, custom.
     * 
     * @param name the name value to set.
     * @return the FunctionsRuntime object itself.
     */
    public FunctionsRuntime withName(RuntimeName name) {
        this.name = name;
        return this;
    }

    /**
     * Get the version property: Function app runtime version. Example: 8 (for dotnet-isolated).
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: Function app runtime version. Example: 8 (for dotnet-isolated).
     * 
     * @param version the version value to set.
     * @return the FunctionsRuntime object itself.
     */
    public FunctionsRuntime withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
