// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Function app configuration.
 */
@Fluent
public final class FunctionAppConfig {
    /*
     * Function app deployment configuration.
     */
    @JsonProperty(value = "deployment")
    private FunctionsDeployment deployment;

    /*
     * Function app runtime settings.
     */
    @JsonProperty(value = "runtime")
    private FunctionsRuntime runtime;

    /*
     * Function app scale and concurrency settings.
     */
    @JsonProperty(value = "scaleAndConcurrency")
    private FunctionsScaleAndConcurrency scaleAndConcurrency;

    /**
     * Creates an instance of FunctionAppConfig class.
     */
    public FunctionAppConfig() {
    }

    /**
     * Get the deployment property: Function app deployment configuration.
     * 
     * @return the deployment value.
     */
    public FunctionsDeployment deployment() {
        return this.deployment;
    }

    /**
     * Set the deployment property: Function app deployment configuration.
     * 
     * @param deployment the deployment value to set.
     * @return the FunctionAppConfig object itself.
     */
    public FunctionAppConfig withDeployment(FunctionsDeployment deployment) {
        this.deployment = deployment;
        return this;
    }

    /**
     * Get the runtime property: Function app runtime settings.
     * 
     * @return the runtime value.
     */
    public FunctionsRuntime runtime() {
        return this.runtime;
    }

    /**
     * Set the runtime property: Function app runtime settings.
     * 
     * @param runtime the runtime value to set.
     * @return the FunctionAppConfig object itself.
     */
    public FunctionAppConfig withRuntime(FunctionsRuntime runtime) {
        this.runtime = runtime;
        return this;
    }

    /**
     * Get the scaleAndConcurrency property: Function app scale and concurrency settings.
     * 
     * @return the scaleAndConcurrency value.
     */
    public FunctionsScaleAndConcurrency scaleAndConcurrency() {
        return this.scaleAndConcurrency;
    }

    /**
     * Set the scaleAndConcurrency property: Function app scale and concurrency settings.
     * 
     * @param scaleAndConcurrency the scaleAndConcurrency value to set.
     * @return the FunctionAppConfig object itself.
     */
    public FunctionAppConfig withScaleAndConcurrency(FunctionsScaleAndConcurrency scaleAndConcurrency) {
        this.scaleAndConcurrency = scaleAndConcurrency;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (deployment() != null) {
            deployment().validate();
        }
        if (runtime() != null) {
            runtime().validate();
        }
        if (scaleAndConcurrency() != null) {
            scaleAndConcurrency().validate();
        }
    }
}
