// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Static Site User ARM resource.
 */
@Fluent
public final class StaticSiteUserArmResourceInner extends ProxyOnlyResource {
    /*
     * StaticSiteUserARMResource resource specific properties
     */
    @JsonProperty(value = "properties")
    private StaticSiteUserArmResourceProperties innerProperties;

    /**
     * Creates an instance of StaticSiteUserArmResourceInner class.
     */
    public StaticSiteUserArmResourceInner() {
    }

    /**
     * Get the innerProperties property: StaticSiteUserARMResource resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private StaticSiteUserArmResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public StaticSiteUserArmResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the provider property: The identity provider for the static site user.
     * 
     * @return the provider value.
     */
    public String provider() {
        return this.innerProperties() == null ? null : this.innerProperties().provider();
    }

    /**
     * Get the userId property: The user id for the static site user.
     * 
     * @return the userId value.
     */
    public String userId() {
        return this.innerProperties() == null ? null : this.innerProperties().userId();
    }

    /**
     * Get the displayName property: The display name for the static site user.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Get the roles property: The roles for the static site user, in free-form string format.
     * 
     * @return the roles value.
     */
    public String roles() {
        return this.innerProperties() == null ? null : this.innerProperties().roles();
    }

    /**
     * Set the roles property: The roles for the static site user, in free-form string format.
     * 
     * @param roles the roles value to set.
     * @return the StaticSiteUserArmResourceInner object itself.
     */
    public StaticSiteUserArmResourceInner withRoles(String roles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteUserArmResourceProperties();
        }
        this.innerProperties().withRoles(roles);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
