/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.Contact;
import com.azure.resourcemanager.appservice.models.DnsType;
import com.azure.resourcemanager.appservice.models.DomainPurchaseConsent;
import com.azure.resourcemanager.appservice.models.DomainStatus;
import com.azure.resourcemanager.appservice.models.Hostname;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.ResourceNotRenewableReason;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class DomainPatchResourceProperties {
    @JsonProperty(value="contactAdmin", required=true)
    private Contact contactAdmin;
    @JsonProperty(value="contactBilling", required=true)
    private Contact contactBilling;
    @JsonProperty(value="contactRegistrant", required=true)
    private Contact contactRegistrant;
    @JsonProperty(value="contactTech", required=true)
    private Contact contactTech;
    @JsonProperty(value="registrationStatus", access=JsonProperty.Access.WRITE_ONLY)
    private DomainStatus registrationStatus;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="nameServers", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> nameServers;
    @JsonProperty(value="privacy")
    private Boolean privacy;
    @JsonProperty(value="createdTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdTime;
    @JsonProperty(value="expirationTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime expirationTime;
    @JsonProperty(value="lastRenewedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastRenewedTime;
    @JsonProperty(value="autoRenew")
    private Boolean autoRenew;
    @JsonProperty(value="readyForDnsRecordManagement", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean readyForDnsRecordManagement;
    @JsonProperty(value="managedHostNames", access=JsonProperty.Access.WRITE_ONLY)
    private List<Hostname> managedHostNames;
    @JsonProperty(value="consent", required=true)
    private DomainPurchaseConsent consent;
    @JsonProperty(value="domainNotRenewableReasons", access=JsonProperty.Access.WRITE_ONLY)
    private List<ResourceNotRenewableReason> domainNotRenewableReasons;
    @JsonProperty(value="dnsType")
    private DnsType dnsType;
    @JsonProperty(value="dnsZoneId")
    private String dnsZoneId;
    @JsonProperty(value="targetDnsType")
    private DnsType targetDnsType;
    @JsonProperty(value="authCode")
    private String authCode;
    private static final ClientLogger LOGGER = new ClientLogger(DomainPatchResourceProperties.class);

    public Contact contactAdmin() {
        return this.contactAdmin;
    }

    public DomainPatchResourceProperties withContactAdmin(Contact contactAdmin) {
        this.contactAdmin = contactAdmin;
        return this;
    }

    public Contact contactBilling() {
        return this.contactBilling;
    }

    public DomainPatchResourceProperties withContactBilling(Contact contactBilling) {
        this.contactBilling = contactBilling;
        return this;
    }

    public Contact contactRegistrant() {
        return this.contactRegistrant;
    }

    public DomainPatchResourceProperties withContactRegistrant(Contact contactRegistrant) {
        this.contactRegistrant = contactRegistrant;
        return this;
    }

    public Contact contactTech() {
        return this.contactTech;
    }

    public DomainPatchResourceProperties withContactTech(Contact contactTech) {
        this.contactTech = contactTech;
        return this;
    }

    public DomainStatus registrationStatus() {
        return this.registrationStatus;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<String> nameServers() {
        return this.nameServers;
    }

    public Boolean privacy() {
        return this.privacy;
    }

    public DomainPatchResourceProperties withPrivacy(Boolean privacy) {
        this.privacy = privacy;
        return this;
    }

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public OffsetDateTime expirationTime() {
        return this.expirationTime;
    }

    public OffsetDateTime lastRenewedTime() {
        return this.lastRenewedTime;
    }

    public Boolean autoRenew() {
        return this.autoRenew;
    }

    public DomainPatchResourceProperties withAutoRenew(Boolean autoRenew) {
        this.autoRenew = autoRenew;
        return this;
    }

    public Boolean readyForDnsRecordManagement() {
        return this.readyForDnsRecordManagement;
    }

    public List<Hostname> managedHostNames() {
        return this.managedHostNames;
    }

    public DomainPurchaseConsent consent() {
        return this.consent;
    }

    public DomainPatchResourceProperties withConsent(DomainPurchaseConsent consent) {
        this.consent = consent;
        return this;
    }

    public List<ResourceNotRenewableReason> domainNotRenewableReasons() {
        return this.domainNotRenewableReasons;
    }

    public DnsType dnsType() {
        return this.dnsType;
    }

    public DomainPatchResourceProperties withDnsType(DnsType dnsType) {
        this.dnsType = dnsType;
        return this;
    }

    public String dnsZoneId() {
        return this.dnsZoneId;
    }

    public DomainPatchResourceProperties withDnsZoneId(String dnsZoneId) {
        this.dnsZoneId = dnsZoneId;
        return this;
    }

    public DnsType targetDnsType() {
        return this.targetDnsType;
    }

    public DomainPatchResourceProperties withTargetDnsType(DnsType targetDnsType) {
        this.targetDnsType = targetDnsType;
        return this;
    }

    public String authCode() {
        return this.authCode;
    }

    public DomainPatchResourceProperties withAuthCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    public void validate() {
        if (this.contactAdmin() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property contactAdmin in model DomainPatchResourceProperties"));
        }
        this.contactAdmin().validate();
        if (this.contactBilling() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property contactBilling in model DomainPatchResourceProperties"));
        }
        this.contactBilling().validate();
        if (this.contactRegistrant() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property contactRegistrant in model DomainPatchResourceProperties"));
        }
        this.contactRegistrant().validate();
        if (this.contactTech() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property contactTech in model DomainPatchResourceProperties"));
        }
        this.contactTech().validate();
        if (this.managedHostNames() != null) {
            this.managedHostNames().forEach(e -> e.validate());
        }
        if (this.consent() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property consent in model DomainPatchResourceProperties"));
        }
        this.consent().validate();
    }
}

