/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.StaticSiteDatabaseConnectionConfigurationFileOverview;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class DatabaseConnectionProperties {
    @JsonProperty(value="resourceId", required=true)
    private String resourceId;
    @JsonProperty(value="connectionIdentity")
    private String connectionIdentity;
    @JsonProperty(value="connectionString")
    private String connectionString;
    @JsonProperty(value="region", required=true)
    private String region;
    @JsonProperty(value="configurationFiles", access=JsonProperty.Access.WRITE_ONLY)
    private List<StaticSiteDatabaseConnectionConfigurationFileOverview> configurationFiles;
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseConnectionProperties.class);

    public String resourceId() {
        return this.resourceId;
    }

    public DatabaseConnectionProperties withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String connectionIdentity() {
        return this.connectionIdentity;
    }

    public DatabaseConnectionProperties withConnectionIdentity(String connectionIdentity) {
        this.connectionIdentity = connectionIdentity;
        return this;
    }

    public String connectionString() {
        return this.connectionString;
    }

    public DatabaseConnectionProperties withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public String region() {
        return this.region;
    }

    public DatabaseConnectionProperties withRegion(String region) {
        this.region = region;
        return this;
    }

    public List<StaticSiteDatabaseConnectionConfigurationFileOverview> configurationFiles() {
        return this.configurationFiles;
    }

    public void validate() {
        if (this.resourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceId in model DatabaseConnectionProperties"));
        }
        if (this.region() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property region in model DatabaseConnectionProperties"));
        }
        if (this.configurationFiles() != null) {
            this.configurationFiles().forEach(e -> e.validate());
        }
    }
}

