// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.fluent.models.MigrateMySqlRequestProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * MySQL migration request.
 */
@Fluent
public final class MigrateMySqlRequest extends ProxyOnlyResource {
    /*
     * MigrateMySqlRequest resource specific properties
     */
    @JsonProperty(value = "properties")
    private MigrateMySqlRequestProperties innerProperties;

    /**
     * Creates an instance of MigrateMySqlRequest class.
     */
    public MigrateMySqlRequest() {
    }

    /**
     * Get the innerProperties property: MigrateMySqlRequest resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private MigrateMySqlRequestProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MigrateMySqlRequest withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the connectionString property: Connection string to the remote MySQL database.
     * 
     * @return the connectionString value.
     */
    public String connectionString() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionString();
    }

    /**
     * Set the connectionString property: Connection string to the remote MySQL database.
     * 
     * @param connectionString the connectionString value to set.
     * @return the MigrateMySqlRequest object itself.
     */
    public MigrateMySqlRequest withConnectionString(String connectionString) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrateMySqlRequestProperties();
        }
        this.innerProperties().withConnectionString(connectionString);
        return this;
    }

    /**
     * Get the migrationType property: The type of migration operation to be done.
     * 
     * @return the migrationType value.
     */
    public MySqlMigrationType migrationType() {
        return this.innerProperties() == null ? null : this.innerProperties().migrationType();
    }

    /**
     * Set the migrationType property: The type of migration operation to be done.
     * 
     * @param migrationType the migrationType value to set.
     * @return the MigrateMySqlRequest object itself.
     */
    public MigrateMySqlRequest withMigrationType(MySqlMigrationType migrationType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrateMySqlRequestProperties();
        }
        this.innerProperties().withMigrationType(migrationType);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
