// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Sets the number of 'Always Ready' instances for a function group or a specific function.
 */
@Fluent
public final class FunctionsAlwaysReadyConfig {
    /*
     * Either a function group or a function name is required. For additional information see https://aka.ms/flexconsumption/alwaysready.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Sets the number of 'Always Ready' instances for a given function group or a specific function. For additional information see https://aka.ms/flexconsumption/alwaysready.
     */
    @JsonProperty(value = "instanceCount")
    private Float instanceCount;

    /**
     * Creates an instance of FunctionsAlwaysReadyConfig class.
     */
    public FunctionsAlwaysReadyConfig() {
    }

    /**
     * Get the name property: Either a function group or a function name is required. For additional information see
     * https://aka.ms/flexconsumption/alwaysready.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Either a function group or a function name is required. For additional information see
     * https://aka.ms/flexconsumption/alwaysready.
     * 
     * @param name the name value to set.
     * @return the FunctionsAlwaysReadyConfig object itself.
     */
    public FunctionsAlwaysReadyConfig withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the instanceCount property: Sets the number of 'Always Ready' instances for a given function group or a
     * specific function. For additional information see https://aka.ms/flexconsumption/alwaysready.
     * 
     * @return the instanceCount value.
     */
    public Float instanceCount() {
        return this.instanceCount;
    }

    /**
     * Set the instanceCount property: Sets the number of 'Always Ready' instances for a given function group or a
     * specific function. For additional information see https://aka.ms/flexconsumption/alwaysready.
     * 
     * @param instanceCount the instanceCount value to set.
     * @return the FunctionsAlwaysReadyConfig object itself.
     */
    public FunctionsAlwaysReadyConfig withInstanceCount(Float instanceCount) {
        this.instanceCount = instanceCount;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
