// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Auth Type.
 */
public enum AuthType {
    /**
     * Enum value Anonymous.
     */
    ANONYMOUS("Anonymous"),

    /**
     * Enum value UserCredentials.
     */
    USER_CREDENTIALS("UserCredentials"),

    /**
     * Enum value SystemIdentity.
     */
    SYSTEM_IDENTITY("SystemIdentity"),

    /**
     * Enum value UserAssigned.
     */
    USER_ASSIGNED("UserAssigned");

    /**
     * The actual serialized value for a AuthType instance.
     */
    private final String value;

    AuthType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a AuthType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed AuthType object, or null if unable to parse.
     */
    @JsonCreator
    public static AuthType fromString(String value) {
        if (value == null) {
            return null;
        }
        AuthType[] items = AuthType.values();
        for (AuthType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
