// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.appservice.fluent.WebAppsClient;
import com.azure.resourcemanager.appservice.fluent.models.ApiKVReferenceInner;
import com.azure.resourcemanager.appservice.fluent.models.AzureStoragePropertyDictionaryResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.BackupItemInner;
import com.azure.resourcemanager.appservice.fluent.models.BackupRequestInner;
import com.azure.resourcemanager.appservice.fluent.models.ConnectionStringDictionaryInner;
import com.azure.resourcemanager.appservice.fluent.models.ContinuousWebJobInner;
import com.azure.resourcemanager.appservice.fluent.models.CsmPublishingCredentialsPoliciesEntityInner;
import com.azure.resourcemanager.appservice.fluent.models.CsmUsageQuotaInner;
import com.azure.resourcemanager.appservice.fluent.models.CustomHostnameAnalysisResultInner;
import com.azure.resourcemanager.appservice.fluent.models.DeploymentInner;
import com.azure.resourcemanager.appservice.fluent.models.FunctionEnvelopeInner;
import com.azure.resourcemanager.appservice.fluent.models.FunctionSecretsInner;
import com.azure.resourcemanager.appservice.fluent.models.HostKeysInner;
import com.azure.resourcemanager.appservice.fluent.models.HostnameBindingInner;
import com.azure.resourcemanager.appservice.fluent.models.HybridConnectionInner;
import com.azure.resourcemanager.appservice.fluent.models.IdentifierInner;
import com.azure.resourcemanager.appservice.fluent.models.KeyInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.MigrateMySqlStatusInner;
import com.azure.resourcemanager.appservice.fluent.models.MSDeployLogInner;
import com.azure.resourcemanager.appservice.fluent.models.MSDeployStatusInner;
import com.azure.resourcemanager.appservice.fluent.models.NetworkFeaturesInner;
import com.azure.resourcemanager.appservice.fluent.models.NetworkTraceInner;
import com.azure.resourcemanager.appservice.fluent.models.OperationInner;
import com.azure.resourcemanager.appservice.fluent.models.PerfMonResponseInner;
import com.azure.resourcemanager.appservice.fluent.models.PremierAddOnInner;
import com.azure.resourcemanager.appservice.fluent.models.PrivateAccessInner;
import com.azure.resourcemanager.appservice.fluent.models.PrivateLinkResourcesWrapperInner;
import com.azure.resourcemanager.appservice.fluent.models.ProcessInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.ProcessModuleInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.ProcessThreadInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.PublicCertificateInner;
import com.azure.resourcemanager.appservice.fluent.models.PushSettingsInner;
import com.azure.resourcemanager.appservice.fluent.models.RelayServiceConnectionEntityInner;
import com.azure.resourcemanager.appservice.fluent.models.RemotePrivateEndpointConnectionArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.RestoreRequestInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteAuthSettingsInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteAuthSettingsV2Inner;
import com.azure.resourcemanager.appservice.fluent.models.SiteCloneabilityInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigurationSnapshotInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteContainerInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteExtensionInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.azure.resourcemanager.appservice.fluent.models.SitePatchResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SitePhpErrorLogFlagInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteSourceControlInner;
import com.azure.resourcemanager.appservice.fluent.models.SlotConfigNamesResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SlotDifferenceInner;
import com.azure.resourcemanager.appservice.fluent.models.SnapshotInner;
import com.azure.resourcemanager.appservice.fluent.models.StorageMigrationResponseInner;
import com.azure.resourcemanager.appservice.fluent.models.StringDictionaryInner;
import com.azure.resourcemanager.appservice.fluent.models.SwiftVirtualNetworkInner;
import com.azure.resourcemanager.appservice.fluent.models.TriggeredJobHistoryInner;
import com.azure.resourcemanager.appservice.fluent.models.TriggeredWebJobInner;
import com.azure.resourcemanager.appservice.fluent.models.UserInner;
import com.azure.resourcemanager.appservice.fluent.models.VnetGatewayInner;
import com.azure.resourcemanager.appservice.fluent.models.VnetInfoResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.WebJobInner;
import com.azure.resourcemanager.appservice.fluent.models.WebSiteInstanceStatusInner;
import com.azure.resourcemanager.appservice.fluent.models.WorkflowEnvelopeInner;
import com.azure.resourcemanager.appservice.models.ApiKVReferenceCollection;
import com.azure.resourcemanager.appservice.models.BackupItemCollection;
import com.azure.resourcemanager.appservice.models.ContinuousWebJobCollection;
import com.azure.resourcemanager.appservice.models.CsmDeploymentStatus;
import com.azure.resourcemanager.appservice.models.CsmDeploymentStatusCollection;
import com.azure.resourcemanager.appservice.models.CsmPublishingProfileOptions;
import com.azure.resourcemanager.appservice.models.CsmSlotEntity;
import com.azure.resourcemanager.appservice.models.CsmUsageQuotaCollection;
import com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException;
import com.azure.resourcemanager.appservice.models.DeletedAppRestoreRequest;
import com.azure.resourcemanager.appservice.models.DeploymentCollection;
import com.azure.resourcemanager.appservice.models.FunctionEnvelopeCollection;
import com.azure.resourcemanager.appservice.models.HostnameBindingCollection;
import com.azure.resourcemanager.appservice.models.IdentifierCollection;
import com.azure.resourcemanager.appservice.models.MigrateMySqlRequest;
import com.azure.resourcemanager.appservice.models.MSDeploy;
import com.azure.resourcemanager.appservice.models.PerfMonCounterCollection;
import com.azure.resourcemanager.appservice.models.PremierAddOnPatchResource;
import com.azure.resourcemanager.appservice.models.PrivateEndpointConnectionCollection;
import com.azure.resourcemanager.appservice.models.ProcessInfoCollection;
import com.azure.resourcemanager.appservice.models.ProcessModuleInfoCollection;
import com.azure.resourcemanager.appservice.models.ProcessThreadInfoCollection;
import com.azure.resourcemanager.appservice.models.PublicCertificateCollection;
import com.azure.resourcemanager.appservice.models.PublishingCredentialsPoliciesCollection;
import com.azure.resourcemanager.appservice.models.SiteConfigResourceCollection;
import com.azure.resourcemanager.appservice.models.SiteConfigurationSnapshotInfoCollection;
import com.azure.resourcemanager.appservice.models.SiteContainerCollection;
import com.azure.resourcemanager.appservice.models.SiteExtensionInfoCollection;
import com.azure.resourcemanager.appservice.models.SlotDifferenceCollection;
import com.azure.resourcemanager.appservice.models.SnapshotCollection;
import com.azure.resourcemanager.appservice.models.SnapshotRestoreRequest;
import com.azure.resourcemanager.appservice.models.StorageMigrationOptions;
import com.azure.resourcemanager.appservice.models.TriggeredJobHistoryCollection;
import com.azure.resourcemanager.appservice.models.TriggeredWebJobCollection;
import com.azure.resourcemanager.appservice.models.WebAppCollection;
import com.azure.resourcemanager.appservice.models.WebAppInstanceStatusCollection;
import com.azure.resourcemanager.appservice.models.WebJobCollection;
import com.azure.resourcemanager.appservice.models.WorkflowArtifacts;
import com.azure.resourcemanager.appservice.models.WorkflowEnvelopeCollection;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in WebAppsClient.
 */
public final class WebAppsClientImpl
    implements InnerSupportsGet<SiteInner>, InnerSupportsListing<SiteInner>, InnerSupportsDelete<Void>, WebAppsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final WebAppsService service;

    /**
     * The service client containing this operation class.
     */
    private final WebSiteManagementClientImpl client;

    /**
     * Initializes an instance of WebAppsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    WebAppsClientImpl(WebSiteManagementClientImpl client) {
        this.service = RestProxy.create(WebAppsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for WebSiteManagementClientWebApps to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "WebSiteManagementCli")
    public interface WebAppsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Web/sites")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebAppCollection>> list(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebAppCollection>> listByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @QueryParam("includeSlots") Boolean includeSlots,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteInner>> getByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SiteInner siteEnvelope, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> delete(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @QueryParam("deleteMetrics") Boolean deleteMetrics,
            @QueryParam("deleteEmptyServerFarm") Boolean deleteEmptyServerFarm,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> update(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SitePatchResourceInner siteEnvelope, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/analyzeCustomHostname")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CustomHostnameAnalysisResultInner>> analyzeCustomHostname(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @QueryParam("hostName") String hostname, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/applySlotConfig")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> applySlotConfigToProduction(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CsmSlotEntity slotSwapEntity, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backup")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BackupItemInner>> backup(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") BackupRequestInner request, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BackupItemCollection>> listBackups(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BackupItemInner>> getBackupStatus(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("backupId") String backupId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteBackup(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("backupId") String backupId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/list")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BackupItemInner>> listBackupStatusSecrets(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("backupId") String backupId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") BackupRequestInner request,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/restore")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> restore(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("backupId") String backupId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") RestoreRequestInner request,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/basicPublishingCredentialsPolicies")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PublishingCredentialsPoliciesCollection>> listBasicPublishingCredentialsPolicies(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/basicPublishingCredentialsPolicies/ftp")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> getFtpAllowed(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/basicPublishingCredentialsPolicies/ftp")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> updateFtpAllowed(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/basicPublishingCredentialsPolicies/scm")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> getScmAllowed(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/basicPublishingCredentialsPolicies/scm")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> updateScmAllowed(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteConfigResourceCollection>> listConfigurations(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> updateApplicationSettings(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StringDictionaryInner appSettings, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings/list")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StringDictionaryInner>> listApplicationSettings(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteAuthSettingsInner>> updateAuthSettings(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SiteAuthSettingsInner siteAuthSettings, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings/list")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteAuthSettingsInner>> getAuthSettings(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettingsV2")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteAuthSettingsV2Inner>> getAuthSettingsV2WithoutSecrets(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettingsV2")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteAuthSettingsV2Inner>> updateAuthSettingsV2(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SiteAuthSettingsV2Inner siteAuthSettingsV2,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettingsV2/list")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteAuthSettingsV2Inner>> getAuthSettingsV2(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/azurestorageaccounts")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<AzureStoragePropertyDictionaryResourceInner>> updateAzureStorageAccounts(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") AzureStoragePropertyDictionaryResourceInner azureStorageAccounts,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/azurestorageaccounts/list")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<AzureStoragePropertyDictionaryResourceInner>> listAzureStorageAccounts(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BackupRequestInner>> updateBackupConfiguration(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") BackupRequestInner request, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteBackupConfiguration(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup/list")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BackupRequestInner>> getBackupConfiguration(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/configreferences/appsettings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ApiKVReferenceCollection>> getAppSettingsKeyVaultReferences(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/configreferences/appsettings/{appSettingKey}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ApiKVReferenceInner>> getAppSettingKeyVaultReference(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("appSettingKey") String appSettingKey, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/configreferences/connectionstrings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ApiKVReferenceCollection>> getSiteConnectionStringKeyVaultReferences(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/configreferences/connectionstrings/{connectionStringKey}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ApiKVReferenceInner>> getSiteConnectionStringKeyVaultReference(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("connectionStringKey") String connectionStringKey,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ConnectionStringDictionaryInner>> updateConnectionStrings(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ConnectionStringDictionaryInner connectionStrings,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings/list")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ConnectionStringDictionaryInner>> listConnectionStrings(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteLogsConfigInner>> getDiagnosticLogsConfiguration(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteLogsConfigInner>> updateDiagnosticLogsConfig(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SiteLogsConfigInner siteLogsConfig, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StringDictionaryInner>> updateMetadata(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StringDictionaryInner metadata, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata/list")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StringDictionaryInner>> listMetadata(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/publishingcredentials/list")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> listPublishingCredentials(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/pushsettings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PushSettingsInner>> updateSitePushSettings(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") PushSettingsInner pushSettings, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/pushsettings/list")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PushSettingsInner>> listSitePushSettings(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SlotConfigNamesResourceInner>> listSlotConfigurationNames(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SlotConfigNamesResourceInner>> updateSlotConfigurationNames(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SlotConfigNamesResourceInner slotConfigNames,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteConfigResourceInner>> getConfiguration(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdateConfiguration(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SiteConfigResourceInner siteConfig, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteConfigResourceInner>> updateConfiguration(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SiteConfigResourceInner siteConfig, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteConfigurationSnapshotInfoCollection>> listConfigurationSnapshotInfo(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots/{snapshotId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteConfigResourceInner>> getConfigurationSnapshot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("snapshotId") String snapshotId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots/{snapshotId}/recover")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> recoverSiteConfigurationSnapshot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("snapshotId") String snapshotId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/containerlogs")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<BinaryData>> getWebSiteContainerLogs(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/containerlogs/zip/download")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<BinaryData>> getContainerLogsZip(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ContinuousWebJobCollection>> listContinuousWebJobs(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ContinuousWebJobInner>> getContinuousWebJob(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("webJobName") String webJobName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteContinuousWebJob(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("webJobName") String webJobName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}/start")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> startContinuousWebJob(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("webJobName") String webJobName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}/stop")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> stopContinuousWebJob(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("webJobName") String webJobName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deploymentStatus")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CsmDeploymentStatusCollection>> listProductionSiteDeploymentStatuses(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deploymentStatus/{deploymentStatusId}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> getProductionSiteDeploymentStatus(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("deploymentStatusId") String deploymentStatusId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DeploymentCollection>> listDeployments(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DeploymentInner>> getDeployment(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("id") String id, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DeploymentInner>> createDeployment(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("id") String id, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") DeploymentInner deployment,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteDeployment(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("id") String id, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}/log")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DeploymentInner>> listDeploymentLog(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("id") String id, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/discoverbackup")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RestoreRequestInner>> discoverBackup(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") RestoreRequestInner request, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<IdentifierCollection>> listDomainOwnershipIdentifiers(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<IdentifierInner>> getDomainOwnershipIdentifier(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("domainOwnershipIdentifierName") String domainOwnershipIdentifierName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<IdentifierInner>> createOrUpdateDomainOwnershipIdentifier(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("domainOwnershipIdentifierName") String domainOwnershipIdentifierName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") IdentifierInner domainOwnershipIdentifier,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteDomainOwnershipIdentifier(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("domainOwnershipIdentifierName") String domainOwnershipIdentifierName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<IdentifierInner>> updateDomainOwnershipIdentifier(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("domainOwnershipIdentifierName") String domainOwnershipIdentifierName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") IdentifierInner domainOwnershipIdentifier,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<MSDeployStatusInner>> getMSDeployStatus(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 409 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createMSDeployOperation(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") MSDeploy mSDeploy, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy/log")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<MSDeployLogInner>> getMSDeployLog(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/onedeploy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Object>> getOneDeployStatus(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/onedeploy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Object>> createOneDeployOperation(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<FunctionEnvelopeCollection>> listFunctions(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/admin/token")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<String>> getFunctionsAdminToken(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<FunctionEnvelopeInner>> getFunction(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("functionName") String functionName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createFunction(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("functionName") String functionName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") FunctionEnvelopeInner functionEnvelope, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteFunction(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("functionName") String functionName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}/keys/{keyName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<KeyInfoInner>> createOrUpdateFunctionSecret(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("functionName") String functionName, @PathParam("keyName") String keyName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyInfoInner key, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}/keys/{keyName}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteFunctionSecret(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("functionName") String functionName, @PathParam("keyName") String keyName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}/listkeys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StringDictionaryInner>> listFunctionKeys(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("functionName") String functionName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}/listsecrets")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<FunctionSecretsInner>> listFunctionSecrets(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("functionName") String functionName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/host/default/listkeys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<HostKeysInner>> listHostKeys(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/host/default/listsyncstatus")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> listSyncStatus(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/host/default/sync")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> syncFunctions(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/host/default/{keyType}/{keyName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<KeyInfoInner>> createOrUpdateHostSecret(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("keyType") String keyType, @PathParam("keyName") String keyName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyInfoInner key, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/host/default/{keyType}/{keyName}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteHostSecret(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("keyType") String keyType, @PathParam("keyName") String keyName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<HostnameBindingCollection>> listHostnameBindings(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<HostnameBindingInner>> getHostnameBinding(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("hostName") String hostname, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<HostnameBindingInner>> createOrUpdateHostnameBinding(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("hostName") String hostname, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") HostnameBindingInner hostnameBinding, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteHostnameBinding(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("hostName") String hostname, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<HybridConnectionInner>> getHybridConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("namespaceName") String namespaceName, @PathParam("relayName") String relayName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<HybridConnectionInner>> createOrUpdateHybridConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("namespaceName") String namespaceName, @PathParam("relayName") String relayName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") HybridConnectionInner connectionEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteHybridConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("namespaceName") String namespaceName, @PathParam("relayName") String relayName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<HybridConnectionInner>> updateHybridConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("namespaceName") String namespaceName, @PathParam("relayName") String relayName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") HybridConnectionInner connectionEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionRelays")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<HybridConnectionInner>> listHybridConnections(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RelayServiceConnectionEntityInner>> listRelayServiceConnections(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RelayServiceConnectionEntityInner>> getRelayServiceConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("entityName") String entityName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RelayServiceConnectionEntityInner>> createOrUpdateRelayServiceConnection(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("entityName") String entityName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") RelayServiceConnectionEntityInner connectionEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteRelayServiceConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("entityName") String entityName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RelayServiceConnectionEntityInner>> updateRelayServiceConnection(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("entityName") String entityName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") RelayServiceConnectionEntityInner connectionEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebAppInstanceStatusCollection>> listInstanceIdentifiers(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebSiteInstanceStatusInner>> getInstanceInfo(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("instanceId") String instanceId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<MSDeployStatusInner>> getInstanceMsDeployStatus(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("instanceId") String instanceId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 409 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createInstanceMSDeployOperation(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("instanceId") String instanceId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") MSDeploy mSDeploy,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy/log")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<MSDeployLogInner>> getInstanceMSDeployLog(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("instanceId") String instanceId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessInfoCollection>> listInstanceProcesses(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("instanceId") String instanceId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessInfoInner>> getInstanceProcess(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("instanceId") String instanceId,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteInstanceProcess(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("instanceId") String instanceId,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/dump")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BinaryData>> getInstanceProcessDump(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("instanceId") String instanceId,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/modules")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessModuleInfoCollection>> listInstanceProcessModules(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("instanceId") String instanceId,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/modules/{baseAddress}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessModuleInfoInner>> getInstanceProcessModule(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("baseAddress") String baseAddress,
            @PathParam("instanceId") String instanceId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/threads")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessThreadInfoCollection>> listInstanceProcessThreads(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("instanceId") String instanceId,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/iscloneable")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteCloneabilityInner>> isCloneable(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/listbackups")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BackupItemCollection>> listSiteBackups(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/listsyncfunctiontriggerstatus")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<FunctionSecretsInner>> listSyncFunctionTriggers(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migrate")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> migrateStorage(@HostParam("$host") String endpoint,
            @QueryParam("subscriptionName") String subscriptionName,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StorageMigrationOptions migrationOptions,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migratemysql")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> migrateMySql(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") MigrateMySqlRequest migrationRequestEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migratemysql/status")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<MigrateMySqlStatusInner>> getMigrateMySqlStatus(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkConfig/virtualNetwork")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SwiftVirtualNetworkInner>> getSwiftVirtualNetworkConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkConfig/virtualNetwork")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SwiftVirtualNetworkInner>> createOrUpdateSwiftVirtualNetworkConnectionWithCheck(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SwiftVirtualNetworkInner connectionEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkConfig/virtualNetwork")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteSwiftVirtualNetwork(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkConfig/virtualNetwork")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SwiftVirtualNetworkInner>> updateSwiftVirtualNetworkConnectionWithCheck(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SwiftVirtualNetworkInner connectionEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkFeatures/{view}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<NetworkFeaturesInner>> listNetworkFeatures(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("view") String view, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/operationresults/{operationId}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Object>> getNetworkTraceOperation(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("operationId") String operationId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/start")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<String>> startWebSiteNetworkTrace(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @QueryParam("durationInSeconds") Integer durationInSeconds,
            @QueryParam("maxFrameLength") Integer maxFrameLength, @QueryParam("sasUrl") String sasUrl,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/startOperation")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> startWebSiteNetworkTraceOperation(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @QueryParam("durationInSeconds") Integer durationInSeconds,
            @QueryParam("maxFrameLength") Integer maxFrameLength, @QueryParam("sasUrl") String sasUrl,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/stop")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> stopWebSiteNetworkTrace(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/{operationId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<List<NetworkTraceInner>>> getNetworkTraces(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("operationId") String operationId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTraces/current/operationresults/{operationId}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Object>> getNetworkTraceOperationV2(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("operationId") String operationId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTraces/{operationId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<List<NetworkTraceInner>>> getNetworkTracesV2(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("operationId") String operationId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/newpassword")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> generateNewSitePublishingPassword(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/perfcounters")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PerfMonCounterCollection>> listPerfMonCounters(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @QueryParam(value = "$filter", encoded = true) String filter, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/phplogging")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SitePhpErrorLogFlagInner>> getSitePhpErrorLogFlag(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PremierAddOnInner>> listPremierAddOns(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PremierAddOnInner>> getPremierAddOn(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("premierAddOnName") String premierAddOnName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PremierAddOnInner>> addPremierAddOn(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("premierAddOnName") String premierAddOnName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") PremierAddOnInner premierAddOn,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deletePremierAddOn(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("premierAddOnName") String premierAddOnName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PremierAddOnInner>> updatePremierAddOn(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("premierAddOnName") String premierAddOnName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") PremierAddOnPatchResource premierAddOn, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateAccess/virtualNetworks")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PrivateAccessInner>> getPrivateAccess(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateAccess/virtualNetworks")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PrivateAccessInner>> putPrivateAccessVnet(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") PrivateAccessInner access, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateEndpointConnections")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PrivateEndpointConnectionCollection>> getPrivateEndpointConnectionList(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RemotePrivateEndpointConnectionArmResourceInner>> getPrivateEndpointConnection(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name,
            @PathParam("privateEndpointConnectionName") String privateEndpointConnectionName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> approveOrRejectPrivateEndpointConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("privateEndpointConnectionName") String privateEndpointConnectionName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") RemotePrivateEndpointConnectionArmResourceInner privateEndpointWrapper,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> deletePrivateEndpointConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("privateEndpointConnectionName") String privateEndpointConnectionName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateLinkResources")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PrivateLinkResourcesWrapperInner>> getPrivateLinkResources(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessInfoCollection>> listProcesses(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessInfoInner>> getProcess(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteProcess(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/dump")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BinaryData>> getProcessDump(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/modules")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessModuleInfoCollection>> listProcessModules(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/modules/{baseAddress}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessModuleInfoInner>> getProcessModule(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("baseAddress") String baseAddress,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/threads")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessThreadInfoCollection>> listProcessThreads(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PublicCertificateCollection>> listPublicCertificates(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PublicCertificateInner>> getPublicCertificate(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("publicCertificateName") String publicCertificateName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PublicCertificateInner>> createOrUpdatePublicCertificate(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("publicCertificateName") String publicCertificateName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") PublicCertificateInner publicCertificate,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deletePublicCertificate(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("publicCertificateName") String publicCertificateName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publishxml")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BinaryData>> listPublishingProfileXmlWithSecrets(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CsmPublishingProfileOptions publishingProfileOptions,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/resetSlotConfig")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> resetProductionSlotConfig(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restart")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> restart(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @QueryParam("softRestart") Boolean softRestart, @QueryParam("synchronous") Boolean synchronous,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restoreFromBackupBlob")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> restoreFromBackupBlob(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") RestoreRequestInner request, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restoreFromDeletedApp")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> restoreFromDeletedApp(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DeletedAppRestoreRequest restoreRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restoreSnapshot")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> restoreSnapshot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SnapshotRestoreRequest restoreRequest, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sitecontainers")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteContainerCollection>> listSiteContainers(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sitecontainers/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteContainerInner>> getSiteContainer(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("containerName") String containerName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sitecontainers/{containerName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteContainerInner>> createOrUpdateSiteContainer(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("containerName") String containerName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") SiteContainerInner request,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sitecontainers/{containerName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteSiteContainer(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("containerName") String containerName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteExtensionInfoCollection>> listSiteExtensions(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteExtensionInfoInner>> getSiteExtension(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("siteExtensionId") String siteExtensionId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 429 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> installSiteExtension(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("siteExtensionId") String siteExtensionId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteSiteExtension(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("siteExtensionId") String siteExtensionId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebAppCollection>> listSlots(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteInner>> getSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdateSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") SiteInner siteEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @QueryParam("deleteMetrics") Boolean deleteMetrics,
            @QueryParam("deleteEmptyServerFarm") Boolean deleteEmptyServerFarm,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteInner>> updateSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SitePatchResourceInner siteEnvelope, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/analyzeCustomHostname")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CustomHostnameAnalysisResultInner>> analyzeCustomHostnameSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @QueryParam("hostName") String hostname,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/applySlotConfig")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> applySlotConfigurationSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") CsmSlotEntity slotSwapEntity,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backup")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BackupItemInner>> backupSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") BackupRequestInner request,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BackupItemCollection>> listBackupsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BackupItemInner>> getBackupStatusSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("backupId") String backupId, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteBackupSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("backupId") String backupId, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/list")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BackupItemInner>> listBackupStatusSecretsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("backupId") String backupId, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") BackupRequestInner request, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/restore")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> restoreSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("backupId") String backupId, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") RestoreRequestInner request, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/basicPublishingCredentialsPolicies")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PublishingCredentialsPoliciesCollection>> listBasicPublishingCredentialsPoliciesSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/basicPublishingCredentialsPolicies/ftp")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> getFtpAllowedSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/basicPublishingCredentialsPolicies/ftp")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> updateFtpAllowedSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/basicPublishingCredentialsPolicies/scm")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> getScmAllowedSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/basicPublishingCredentialsPolicies/scm")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> updateScmAllowedSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteConfigResourceCollection>> listConfigurationsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StringDictionaryInner>> updateApplicationSettingsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StringDictionaryInner appSettings, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings/list")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StringDictionaryInner>> listApplicationSettingsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteAuthSettingsInner>> updateAuthSettingsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SiteAuthSettingsInner siteAuthSettings, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings/list")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteAuthSettingsInner>> getAuthSettingsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettingsV2")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteAuthSettingsV2Inner>> getAuthSettingsV2WithoutSecretsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettingsV2")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteAuthSettingsV2Inner>> updateAuthSettingsV2Slot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SiteAuthSettingsV2Inner siteAuthSettingsV2,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettingsV2/list")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteAuthSettingsV2Inner>> getAuthSettingsV2Slot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/azurestorageaccounts")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<AzureStoragePropertyDictionaryResourceInner>> updateAzureStorageAccountsSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") AzureStoragePropertyDictionaryResourceInner azureStorageAccounts,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/azurestorageaccounts/list")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<AzureStoragePropertyDictionaryResourceInner>> listAzureStorageAccountsSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BackupRequestInner>> updateBackupConfigurationSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") BackupRequestInner request,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteBackupConfigurationSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup/list")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BackupRequestInner>> getBackupConfigurationSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/configreferences/appsettings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ApiKVReferenceCollection>> getAppSettingsKeyVaultReferencesSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/configreferences/appsettings/{appSettingKey}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ApiKVReferenceInner>> getAppSettingKeyVaultReferenceSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("appSettingKey") String appSettingKey, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/configreferences/connectionstrings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ApiKVReferenceCollection>> getSiteConnectionStringKeyVaultReferencesSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/configreferences/connectionstrings/{connectionStringKey}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ApiKVReferenceInner>> getSiteConnectionStringKeyVaultReferenceSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("connectionStringKey") String connectionStringKey,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ConnectionStringDictionaryInner>> updateConnectionStringsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ConnectionStringDictionaryInner connectionStrings,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings/list")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ConnectionStringDictionaryInner>> listConnectionStringsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteLogsConfigInner>> getDiagnosticLogsConfigurationSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteLogsConfigInner>> updateDiagnosticLogsConfigSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SiteLogsConfigInner siteLogsConfig, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StringDictionaryInner>> updateMetadataSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") StringDictionaryInner metadata,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata/list")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StringDictionaryInner>> listMetadataSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/publishingcredentials/list")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> listPublishingCredentialsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/pushsettings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PushSettingsInner>> updateSitePushSettingsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") PushSettingsInner pushSettings,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/pushsettings/list")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PushSettingsInner>> listSitePushSettingsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteConfigResourceInner>> getConfigurationSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteConfigResourceInner>> createOrUpdateConfigurationSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SiteConfigResourceInner siteConfig, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteConfigResourceInner>> updateConfigurationSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SiteConfigResourceInner siteConfig, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteConfigurationSnapshotInfoCollection>> listConfigurationSnapshotInfoSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots/{snapshotId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteConfigResourceInner>> getConfigurationSnapshotSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("snapshotId") String snapshotId, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots/{snapshotId}/recover")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> recoverSiteConfigurationSnapshotSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("snapshotId") String snapshotId, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/containerlogs")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<BinaryData>> getWebSiteContainerLogsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/containerlogs/zip/download")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<BinaryData>> getContainerLogsZipSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ContinuousWebJobCollection>> listContinuousWebJobsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs/{webJobName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ContinuousWebJobInner>> getContinuousWebJobSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("webJobName") String webJobName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs/{webJobName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteContinuousWebJobSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("webJobName") String webJobName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs/{webJobName}/start")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> startContinuousWebJobSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("webJobName") String webJobName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs/{webJobName}/stop")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> stopContinuousWebJobSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("webJobName") String webJobName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deploymentStatus")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CsmDeploymentStatusCollection>> listSlotSiteDeploymentStatusesSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deploymentStatus/{deploymentStatusId}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> getSlotSiteDeploymentStatusSlot(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("deploymentStatusId") String deploymentStatusId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DeploymentCollection>> listDeploymentsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DeploymentInner>> getDeploymentSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("id") String id, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DeploymentInner>> createDeploymentSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("id") String id, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DeploymentInner deployment, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteDeploymentSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("id") String id, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}/log")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DeploymentInner>> listDeploymentLogSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("id") String id, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/discoverbackup")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RestoreRequestInner>> discoverBackupSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") RestoreRequestInner request,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<IdentifierCollection>> listDomainOwnershipIdentifiersSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<IdentifierInner>> getDomainOwnershipIdentifierSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("domainOwnershipIdentifierName") String domainOwnershipIdentifierName,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<IdentifierInner>> createOrUpdateDomainOwnershipIdentifierSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("domainOwnershipIdentifierName") String domainOwnershipIdentifierName,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") IdentifierInner domainOwnershipIdentifier,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteDomainOwnershipIdentifierSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("domainOwnershipIdentifierName") String domainOwnershipIdentifierName,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<IdentifierInner>> updateDomainOwnershipIdentifierSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("domainOwnershipIdentifierName") String domainOwnershipIdentifierName,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") IdentifierInner domainOwnershipIdentifier,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/extensions/MSDeploy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<MSDeployStatusInner>> getMSDeployStatusSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/extensions/MSDeploy")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 409 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createMSDeployOperationSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") MSDeploy mSDeploy,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/extensions/MSDeploy/log")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<MSDeployLogInner>> getMSDeployLogSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<FunctionEnvelopeCollection>> listInstanceFunctionsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/admin/token")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<String>> getFunctionsAdminTokenSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<FunctionEnvelopeInner>> getInstanceFunctionSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("functionName") String functionName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createInstanceFunctionSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("functionName") String functionName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") FunctionEnvelopeInner functionEnvelope, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteInstanceFunctionSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("functionName") String functionName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}/keys/{keyName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<KeyInfoInner>> createOrUpdateFunctionSecretSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("functionName") String functionName, @PathParam("keyName") String keyName,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") KeyInfoInner key,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}/keys/{keyName}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteFunctionSecretSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("functionName") String functionName, @PathParam("keyName") String keyName,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}/listkeys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StringDictionaryInner>> listFunctionKeysSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("functionName") String functionName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}/listsecrets")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<FunctionSecretsInner>> listFunctionSecretsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("functionName") String functionName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/host/default/listkeys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<HostKeysInner>> listHostKeysSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/host/default/listsyncstatus")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> listSyncStatusSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/host/default/sync")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> syncFunctionsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/host/default/{keyType}/{keyName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<KeyInfoInner>> createOrUpdateHostSecretSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("keyType") String keyType, @PathParam("keyName") String keyName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyInfoInner key, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/host/default/{keyType}/{keyName}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteHostSecretSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("keyType") String keyType, @PathParam("keyName") String keyName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<HostnameBindingCollection>> listHostnameBindingsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<HostnameBindingInner>> getHostnameBindingSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("hostName") String hostname,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<HostnameBindingInner>> createOrUpdateHostnameBindingSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("hostName") String hostname, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") HostnameBindingInner hostnameBinding, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteHostnameBindingSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("hostName") String hostname,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<HybridConnectionInner>> getHybridConnectionSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("namespaceName") String namespaceName, @PathParam("relayName") String relayName,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<HybridConnectionInner>> createOrUpdateHybridConnectionSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("namespaceName") String namespaceName, @PathParam("relayName") String relayName,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") HybridConnectionInner connectionEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteHybridConnectionSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("namespaceName") String namespaceName, @PathParam("relayName") String relayName,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<HybridConnectionInner>> updateHybridConnectionSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("namespaceName") String namespaceName, @PathParam("relayName") String relayName,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") HybridConnectionInner connectionEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionRelays")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<HybridConnectionInner>> listHybridConnectionsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RelayServiceConnectionEntityInner>> listRelayServiceConnectionsSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RelayServiceConnectionEntityInner>> getRelayServiceConnectionSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("entityName") String entityName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RelayServiceConnectionEntityInner>> createOrUpdateRelayServiceConnectionSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("entityName") String entityName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") RelayServiceConnectionEntityInner connectionEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteRelayServiceConnectionSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("entityName") String entityName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RelayServiceConnectionEntityInner>> updateRelayServiceConnectionSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("entityName") String entityName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") RelayServiceConnectionEntityInner connectionEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebAppInstanceStatusCollection>> listInstanceIdentifiersSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebSiteInstanceStatusInner>> getInstanceInfoSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("instanceId") String instanceId, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/extensions/MSDeploy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<MSDeployStatusInner>> getInstanceMsDeployStatusSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("instanceId") String instanceId,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/extensions/MSDeploy")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 409 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createInstanceMSDeployOperationSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("instanceId") String instanceId,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") MSDeploy mSDeploy, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/extensions/MSDeploy/log")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<MSDeployLogInner>> getInstanceMSDeployLogSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("instanceId") String instanceId,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessInfoCollection>> listInstanceProcessesSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("instanceId") String instanceId,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessInfoInner>> getInstanceProcessSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("slot") String slot,
            @PathParam("instanceId") String instanceId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteInstanceProcessSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("slot") String slot,
            @PathParam("instanceId") String instanceId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/dump")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BinaryData>> getInstanceProcessDumpSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("slot") String slot,
            @PathParam("instanceId") String instanceId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/modules")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessModuleInfoCollection>> listInstanceProcessModulesSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("slot") String slot,
            @PathParam("instanceId") String instanceId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/modules/{baseAddress}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessModuleInfoInner>> getInstanceProcessModuleSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("baseAddress") String baseAddress,
            @PathParam("slot") String slot, @PathParam("instanceId") String instanceId,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/threads")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessThreadInfoCollection>> listInstanceProcessThreadsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("slot") String slot,
            @PathParam("instanceId") String instanceId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/iscloneable")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteCloneabilityInner>> isCloneableSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/listbackups")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BackupItemCollection>> listSiteBackupsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/listsyncfunctiontriggerstatus")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<FunctionSecretsInner>> listSyncFunctionTriggersSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/migratemysql/status")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<MigrateMySqlStatusInner>> getMigrateMySqlStatusSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkConfig/virtualNetwork")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SwiftVirtualNetworkInner>> getSwiftVirtualNetworkConnectionSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkConfig/virtualNetwork")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SwiftVirtualNetworkInner>> createOrUpdateSwiftVirtualNetworkConnectionWithCheckSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SwiftVirtualNetworkInner connectionEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkConfig/virtualNetwork")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteSwiftVirtualNetworkSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkConfig/virtualNetwork")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SwiftVirtualNetworkInner>> updateSwiftVirtualNetworkConnectionWithCheckSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SwiftVirtualNetworkInner connectionEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkFeatures/{view}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<NetworkFeaturesInner>> listNetworkFeaturesSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("view") String view, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/operationresults/{operationId}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Object>> getNetworkTraceOperationSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("operationId") String operationId, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/start")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<String>> startWebSiteNetworkTraceSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @QueryParam("durationInSeconds") Integer durationInSeconds, @PathParam("slot") String slot,
            @QueryParam("maxFrameLength") Integer maxFrameLength, @QueryParam("sasUrl") String sasUrl,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/startOperation")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> startWebSiteNetworkTraceOperationSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @QueryParam("durationInSeconds") Integer durationInSeconds, @PathParam("slot") String slot,
            @QueryParam("maxFrameLength") Integer maxFrameLength, @QueryParam("sasUrl") String sasUrl,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/stop")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> stopWebSiteNetworkTraceSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/{operationId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<List<NetworkTraceInner>>> getNetworkTracesSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("operationId") String operationId, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTraces/current/operationresults/{operationId}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Object>> getNetworkTraceOperationSlotV2(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("operationId") String operationId, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTraces/{operationId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<List<NetworkTraceInner>>> getNetworkTracesSlotV2(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("operationId") String operationId, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/newpassword")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> generateNewSitePublishingPasswordSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/perfcounters")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PerfMonCounterCollection>> listPerfMonCountersSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @QueryParam(value = "$filter", encoded = true) String filter,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/phplogging")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SitePhpErrorLogFlagInner>> getSitePhpErrorLogFlagSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PremierAddOnInner>> listPremierAddOnsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PremierAddOnInner>> getPremierAddOnSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("premierAddOnName") String premierAddOnName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PremierAddOnInner>> addPremierAddOnSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("premierAddOnName") String premierAddOnName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") PremierAddOnInner premierAddOn, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deletePremierAddOnSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("premierAddOnName") String premierAddOnName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PremierAddOnInner>> updatePremierAddOnSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("premierAddOnName") String premierAddOnName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") PremierAddOnPatchResource premierAddOn, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/privateAccess/virtualNetworks")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PrivateAccessInner>> getPrivateAccessSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/privateAccess/virtualNetworks")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PrivateAccessInner>> putPrivateAccessVnetSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") PrivateAccessInner access,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/privateEndpointConnections")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PrivateEndpointConnectionCollection>> getPrivateEndpointConnectionListSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RemotePrivateEndpointConnectionArmResourceInner>> getPrivateEndpointConnectionSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name,
            @PathParam("privateEndpointConnectionName") String privateEndpointConnectionName,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> approveOrRejectPrivateEndpointConnectionSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name,
            @PathParam("privateEndpointConnectionName") String privateEndpointConnectionName,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") RemotePrivateEndpointConnectionArmResourceInner privateEndpointWrapper,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> deletePrivateEndpointConnectionSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("privateEndpointConnectionName") String privateEndpointConnectionName,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/privateLinkResources")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PrivateLinkResourcesWrapperInner>> getPrivateLinkResourcesSlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessInfoCollection>> listProcessesSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessInfoInner>> getProcessSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteProcessSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/dump")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BinaryData>> getProcessDumpSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/modules")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessModuleInfoCollection>> listProcessModulesSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/modules/{baseAddress}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessModuleInfoInner>> getProcessModuleSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("baseAddress") String baseAddress,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/threads")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessThreadInfoCollection>> listProcessThreadsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("processId") String processId, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PublicCertificateCollection>> listPublicCertificatesSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates/{publicCertificateName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PublicCertificateInner>> getPublicCertificateSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("publicCertificateName") String publicCertificateName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates/{publicCertificateName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PublicCertificateInner>> createOrUpdatePublicCertificateSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("publicCertificateName") String publicCertificateName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") PublicCertificateInner publicCertificate,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates/{publicCertificateName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deletePublicCertificateSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("publicCertificateName") String publicCertificateName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publishxml")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BinaryData>> listPublishingProfileXmlWithSecretsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CsmPublishingProfileOptions publishingProfileOptions,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/resetSlotConfig")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> resetSlotConfigurationSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restart")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> restartSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @QueryParam("softRestart") Boolean softRestart,
            @QueryParam("synchronous") Boolean synchronous, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restoreFromBackupBlob")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> restoreFromBackupBlobSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") RestoreRequestInner request,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restoreFromDeletedApp")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> restoreFromDeletedAppSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DeletedAppRestoreRequest restoreRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restoreSnapshot")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> restoreSnapshotSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SnapshotRestoreRequest restoreRequest, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sitecontainers")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteContainerCollection>> listSiteContainersSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sitecontainers/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteContainerInner>> getSiteContainerSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("containerName") String containerName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sitecontainers/{containerName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteContainerInner>> createOrUpdateSiteContainerSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("containerName") String containerName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SiteContainerInner request, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sitecontainers/{containerName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteSiteContainerSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("containerName") String containerName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteExtensionInfoCollection>> listSiteExtensionsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{siteExtensionId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteExtensionInfoInner>> getSiteExtensionSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("siteExtensionId") String siteExtensionId, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{siteExtensionId}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 429 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> installSiteExtensionSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("siteExtensionId") String siteExtensionId, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{siteExtensionId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteSiteExtensionSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("siteExtensionId") String siteExtensionId, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotsdiffs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SlotDifferenceCollection>> listSlotDifferencesSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") CsmSlotEntity slotSwapEntity,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotsswap")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> swapSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") CsmSlotEntity slotSwapEntity,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/snapshots")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SnapshotCollection>> listSnapshotsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/snapshotsdr")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SnapshotCollection>> listSnapshotsFromDRSecondarySlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web")
        @ExpectedResponses({ 200, 201, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteSourceControlInner>> getSourceControlSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web")
        @ExpectedResponses({ 200, 201, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdateSourceControlSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SiteSourceControlInner siteSourceControl,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteSourceControlSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @QueryParam("additionalFlags") String additionalFlags,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web")
        @ExpectedResponses({ 200, 201, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteSourceControlInner>> updateSourceControlSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SiteSourceControlInner siteSourceControl,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/start")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> startSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/startNetworkTrace")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> startNetworkTraceSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @QueryParam("durationInSeconds") Integer durationInSeconds, @PathParam("slot") String slot,
            @QueryParam("maxFrameLength") Integer maxFrameLength, @QueryParam("sasUrl") String sasUrl,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/stop")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> stopSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/stopNetworkTrace")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> stopNetworkTraceSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sync")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> syncRepositorySlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/syncfunctiontriggers")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> syncFunctionTriggersSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<TriggeredWebJobCollection>> listTriggeredWebJobsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<TriggeredWebJobInner>> getTriggeredWebJobSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("webJobName") String webJobName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteTriggeredWebJobSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("webJobName") String webJobName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}/history")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<TriggeredJobHistoryCollection>> listTriggeredWebJobHistorySlot(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("webJobName") String webJobName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}/history/{id}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<TriggeredJobHistoryInner>> getTriggeredWebJobHistorySlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("webJobName") String webJobName, @PathParam("id") String id, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}/run")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> runTriggeredWebJobSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("webJobName") String webJobName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/usages")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CsmUsageQuotaCollection>> listUsagesSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @QueryParam(value = "$filter", encoded = true) String filter,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<List<VnetInfoResourceInner>>> listVnetConnectionsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<VnetInfoResourceInner>> getVnetConnectionSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("vnetName") String vnetName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<VnetInfoResourceInner>> createOrUpdateVnetConnectionSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("vnetName") String vnetName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") VnetInfoResourceInner connectionEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteVnetConnectionSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("vnetName") String vnetName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<VnetInfoResourceInner>> updateVnetConnectionSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("vnetName") String vnetName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") VnetInfoResourceInner connectionEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<VnetGatewayInner>> getVnetConnectionGatewaySlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("vnetName") String vnetName, @PathParam("gatewayName") String gatewayName,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<VnetGatewayInner>> createOrUpdateVnetConnectionGatewaySlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("vnetName") String vnetName, @PathParam("gatewayName") String gatewayName,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") VnetGatewayInner connectionEnvelope, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<VnetGatewayInner>> updateVnetConnectionGatewaySlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("vnetName") String vnetName, @PathParam("gatewayName") String gatewayName,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") VnetGatewayInner connectionEnvelope, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/webjobs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebJobCollection>> listWebJobsSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/webjobs/{webJobName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebJobInner>> getWebJobSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("webJobName") String webJobName, @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotsdiffs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SlotDifferenceCollection>> listSlotDifferencesFromProduction(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CsmSlotEntity slotSwapEntity, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotsswap")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> swapSlotWithProduction(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CsmSlotEntity slotSwapEntity, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/snapshots")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SnapshotCollection>> listSnapshots(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/snapshotsdr")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SnapshotCollection>> listSnapshotsFromDRSecondary(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web")
        @ExpectedResponses({ 200, 201, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteSourceControlInner>> getSourceControl(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web")
        @ExpectedResponses({ 200, 201, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdateSourceControl(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SiteSourceControlInner siteSourceControl,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteSourceControl(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @QueryParam("additionalFlags") String additionalFlags, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web")
        @ExpectedResponses({ 200, 201, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteSourceControlInner>> updateSourceControl(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SiteSourceControlInner siteSourceControl,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/start")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> start(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/startNetworkTrace")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> startNetworkTrace(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @QueryParam("durationInSeconds") Integer durationInSeconds,
            @QueryParam("maxFrameLength") Integer maxFrameLength, @QueryParam("sasUrl") String sasUrl,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/stop")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> stop(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/stopNetworkTrace")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> stopNetworkTrace(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sync")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> syncRepository(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/syncfunctiontriggers")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> syncFunctionTriggers(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<TriggeredWebJobCollection>> listTriggeredWebJobs(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<TriggeredWebJobInner>> getTriggeredWebJob(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("webJobName") String webJobName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteTriggeredWebJob(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("webJobName") String webJobName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}/history")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<TriggeredJobHistoryCollection>> listTriggeredWebJobHistory(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("webJobName") String webJobName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}/history/{id}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<TriggeredJobHistoryInner>> getTriggeredWebJobHistory(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("webJobName") String webJobName, @PathParam("id") String id,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}/run")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> runTriggeredWebJob(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("webJobName") String webJobName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/usages")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CsmUsageQuotaCollection>> listUsages(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @QueryParam(value = "$filter", encoded = true) String filter, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<List<VnetInfoResourceInner>>> listVnetConnections(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<VnetInfoResourceInner>> getVnetConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("vnetName") String vnetName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<VnetInfoResourceInner>> createOrUpdateVnetConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("vnetName") String vnetName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") VnetInfoResourceInner connectionEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteVnetConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("vnetName") String vnetName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<VnetInfoResourceInner>> updateVnetConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("vnetName") String vnetName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") VnetInfoResourceInner connectionEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<VnetGatewayInner>> getVnetConnectionGateway(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("vnetName") String vnetName, @PathParam("gatewayName") String gatewayName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<VnetGatewayInner>> createOrUpdateVnetConnectionGateway(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("vnetName") String vnetName, @PathParam("gatewayName") String gatewayName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") VnetGatewayInner connectionEnvelope, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<VnetGatewayInner>> updateVnetConnectionGateway(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("vnetName") String vnetName, @PathParam("gatewayName") String gatewayName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") VnetGatewayInner connectionEnvelope, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/webjobs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebJobCollection>> listWebJobs(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/webjobs/{webJobName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebJobInner>> getWebJob(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("webJobName") String webJobName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployWorkflowArtifacts")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deployWorkflowArtifacts(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") WorkflowArtifacts workflowArtifacts, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployWorkflowArtifacts")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deployWorkflowArtifactsSlot(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") WorkflowArtifacts workflowArtifacts, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/workflows")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WorkflowEnvelopeCollection>> listInstanceWorkflowsSlot(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/workflows/{workflowName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WorkflowEnvelopeInner>> getInstanceWorkflowSlot(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("workflowName") String workflowName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/listWorkflowsConnections")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WorkflowEnvelopeInner>> listWorkflowsConnectionsSlot(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/workflows")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WorkflowEnvelopeCollection>> listWorkflows(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/workflows/{workflowName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WorkflowEnvelopeInner>> getWorkflow(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("workflowName") String workflowName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/listWorkflowsConnections")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WorkflowEnvelopeInner>> listWorkflowsConnections(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebAppCollection>> listNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebAppCollection>> listByResourceGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BackupItemCollection>> listBackupsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PublishingCredentialsPoliciesCollection>> listBasicPublishingCredentialsPoliciesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteConfigResourceCollection>> listConfigurationsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ApiKVReferenceCollection>> getAppSettingsKeyVaultReferencesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ApiKVReferenceCollection>> getSiteConnectionStringKeyVaultReferencesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteConfigurationSnapshotInfoCollection>> listConfigurationSnapshotInfoNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ContinuousWebJobCollection>> listContinuousWebJobsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CsmDeploymentStatusCollection>> listProductionSiteDeploymentStatusesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DeploymentCollection>> listDeploymentsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<IdentifierCollection>> listDomainOwnershipIdentifiersNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<FunctionEnvelopeCollection>> listFunctionsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<HostnameBindingCollection>> listHostnameBindingsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebAppInstanceStatusCollection>> listInstanceIdentifiersNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessInfoCollection>> listInstanceProcessesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessModuleInfoCollection>> listInstanceProcessModulesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessThreadInfoCollection>> listInstanceProcessThreadsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BackupItemCollection>> listSiteBackupsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PerfMonCounterCollection>> listPerfMonCountersNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PrivateEndpointConnectionCollection>> getPrivateEndpointConnectionListNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessInfoCollection>> listProcessesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessModuleInfoCollection>> listProcessModulesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessThreadInfoCollection>> listProcessThreadsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PublicCertificateCollection>> listPublicCertificatesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteContainerCollection>> listSiteContainersNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteExtensionInfoCollection>> listSiteExtensionsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebAppCollection>> listSlotsNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BackupItemCollection>> listBackupsSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PublishingCredentialsPoliciesCollection>> listBasicPublishingCredentialsPoliciesSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteConfigResourceCollection>> listConfigurationsSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ApiKVReferenceCollection>> getAppSettingsKeyVaultReferencesSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ApiKVReferenceCollection>> getSiteConnectionStringKeyVaultReferencesSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteConfigurationSnapshotInfoCollection>> listConfigurationSnapshotInfoSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ContinuousWebJobCollection>> listContinuousWebJobsSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CsmDeploymentStatusCollection>> listSlotSiteDeploymentStatusesSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DeploymentCollection>> listDeploymentsSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<IdentifierCollection>> listDomainOwnershipIdentifiersSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<FunctionEnvelopeCollection>> listInstanceFunctionsSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<HostnameBindingCollection>> listHostnameBindingsSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebAppInstanceStatusCollection>> listInstanceIdentifiersSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessInfoCollection>> listInstanceProcessesSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessModuleInfoCollection>> listInstanceProcessModulesSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessThreadInfoCollection>> listInstanceProcessThreadsSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<BackupItemCollection>> listSiteBackupsSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PerfMonCounterCollection>> listPerfMonCountersSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PrivateEndpointConnectionCollection>> getPrivateEndpointConnectionListSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessInfoCollection>> listProcessesSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessModuleInfoCollection>> listProcessModulesSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ProcessThreadInfoCollection>> listProcessThreadsSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PublicCertificateCollection>> listPublicCertificatesSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteContainerCollection>> listSiteContainersSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SiteExtensionInfoCollection>> listSiteExtensionsSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SlotDifferenceCollection>> listSlotDifferencesSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SnapshotCollection>> listSnapshotsSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SnapshotCollection>> listSnapshotsFromDRSecondarySlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<TriggeredWebJobCollection>> listTriggeredWebJobsSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<TriggeredJobHistoryCollection>> listTriggeredWebJobHistorySlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CsmUsageQuotaCollection>> listUsagesSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebJobCollection>> listWebJobsSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SlotDifferenceCollection>> listSlotDifferencesFromProductionNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SnapshotCollection>> listSnapshotsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<SnapshotCollection>> listSnapshotsFromDRSecondaryNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<TriggeredWebJobCollection>> listTriggeredWebJobsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ManagementException.class, code = { 404 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<TriggeredJobHistoryCollection>> listTriggeredWebJobHistoryNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CsmUsageQuotaCollection>> listUsagesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebJobCollection>> listWebJobsNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WorkflowEnvelopeCollection>> listInstanceWorkflowsSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WorkflowEnvelopeCollection>> listWorkflowsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Get all apps for a subscription.
     * 
     * Description for Get all apps for a subscription.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SiteInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .<PagedResponse<SiteInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get all apps for a subscription.
     * 
     * Description for Get all apps for a subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SiteInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), accept,
                context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get all apps for a subscription.
     * 
     * Description for Get all apps for a subscription.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SiteInner> listAsync() {
        return new PagedFlux<>(() -> listSinglePageAsync(), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Get all apps for a subscription.
     * 
     * Description for Get all apps for a subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SiteInner> listAsync(Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get all apps for a subscription.
     * 
     * Description for Get all apps for a subscription.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SiteInner> list() {
        return new PagedIterable<>(listAsync());
    }

    /**
     * Get all apps for a subscription.
     * 
     * Description for Get all apps for a subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SiteInner> list(Context context) {
        return new PagedIterable<>(listAsync(context));
    }

    /**
     * Gets all web, mobile, and API apps in the specified resource group.
     * 
     * Description for Gets all web, mobile, and API apps in the specified resource group.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param includeSlots Specify &lt;strong&gt;true&lt;/strong&gt; to include deployment slots in results. The default
     * is false, which only gives you the production slot of all apps.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SiteInner>> listByResourceGroupSinglePageAsync(String resourceGroupName,
        Boolean includeSlots) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName,
                includeSlots, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<SiteInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets all web, mobile, and API apps in the specified resource group.
     * 
     * Description for Gets all web, mobile, and API apps in the specified resource group.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param includeSlots Specify &lt;strong&gt;true&lt;/strong&gt; to include deployment slots in results. The default
     * is false, which only gives you the production slot of all apps.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SiteInner>> listByResourceGroupSinglePageAsync(String resourceGroupName,
        Boolean includeSlots, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(this.client.getEndpoint(), resourceGroupName, includeSlots,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets all web, mobile, and API apps in the specified resource group.
     * 
     * Description for Gets all web, mobile, and API apps in the specified resource group.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param includeSlots Specify &lt;strong&gt;true&lt;/strong&gt; to include deployment slots in results. The default
     * is false, which only gives you the production slot of all apps.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SiteInner> listByResourceGroupAsync(String resourceGroupName, Boolean includeSlots) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, includeSlots),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Gets all web, mobile, and API apps in the specified resource group.
     * 
     * Description for Gets all web, mobile, and API apps in the specified resource group.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SiteInner> listByResourceGroupAsync(String resourceGroupName) {
        final Boolean includeSlots = null;
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, includeSlots),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Gets all web, mobile, and API apps in the specified resource group.
     * 
     * Description for Gets all web, mobile, and API apps in the specified resource group.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param includeSlots Specify &lt;strong&gt;true&lt;/strong&gt; to include deployment slots in results. The default
     * is false, which only gives you the production slot of all apps.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SiteInner> listByResourceGroupAsync(String resourceGroupName, Boolean includeSlots,
        Context context) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, includeSlots, context),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets all web, mobile, and API apps in the specified resource group.
     * 
     * Description for Gets all web, mobile, and API apps in the specified resource group.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SiteInner> listByResourceGroup(String resourceGroupName) {
        final Boolean includeSlots = null;
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, includeSlots));
    }

    /**
     * Gets all web, mobile, and API apps in the specified resource group.
     * 
     * Description for Gets all web, mobile, and API apps in the specified resource group.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param includeSlots Specify &lt;strong&gt;true&lt;/strong&gt; to include deployment slots in results. The default
     * is false, which only gives you the production slot of all apps.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SiteInner> listByResourceGroup(String resourceGroupName, Boolean includeSlots,
        Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, includeSlots, context));
    }

    /**
     * Gets the details of a web, mobile, or API app.
     * 
     * Description for Gets the details of a web, mobile, or API app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SiteInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the details of a web, mobile, or API app.
     * 
     * Description for Gets the details of a web, mobile, or API app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SiteInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String name,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the details of a web, mobile, or API app.
     * 
     * Description for Gets the details of a web, mobile, or API app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SiteInner> getByResourceGroupAsync(String resourceGroupName, String name) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the details of a web, mobile, or API app.
     * 
     * Description for Gets the details of a web, mobile, or API app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SiteInner> getByResourceGroupWithResponse(String resourceGroupName, String name, Context context) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets the details of a web, mobile, or API app.
     * 
     * Description for Gets the details of a web, mobile, or API app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SiteInner getByResourceGroup(String resourceGroupName, String name) {
        return getByResourceGroupWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     * parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String name,
        SiteInner siteEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteEnvelope == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteEnvelope is required and cannot be null."));
        } else {
            siteEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), siteEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     * parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String name,
        SiteInner siteEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteEnvelope == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteEnvelope is required and cannot be null."));
        } else {
            siteEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), siteEnvelope, accept, context);
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     * parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<SiteInner>, SiteInner> beginCreateOrUpdateAsync(String resourceGroupName, String name,
        SiteInner siteEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateWithResponseAsync(resourceGroupName, name, siteEnvelope);
        return this.client.<SiteInner, SiteInner>getLroResult(mono, this.client.getHttpPipeline(), SiteInner.class,
            SiteInner.class, this.client.getContext());
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     * parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SiteInner>, SiteInner> beginCreateOrUpdateAsync(String resourceGroupName, String name,
        SiteInner siteEnvelope, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateWithResponseAsync(resourceGroupName, name, siteEnvelope, context);
        return this.client.<SiteInner, SiteInner>getLroResult(mono, this.client.getHttpPipeline(), SiteInner.class,
            SiteInner.class, context);
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     * parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SiteInner>, SiteInner> beginCreateOrUpdate(String resourceGroupName, String name,
        SiteInner siteEnvelope) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, name, siteEnvelope).getSyncPoller();
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     * parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SiteInner>, SiteInner> beginCreateOrUpdate(String resourceGroupName, String name,
        SiteInner siteEnvelope, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, name, siteEnvelope, context).getSyncPoller();
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     * parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SiteInner> createOrUpdateAsync(String resourceGroupName, String name, SiteInner siteEnvelope) {
        return beginCreateOrUpdateAsync(resourceGroupName, name, siteEnvelope).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     * parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SiteInner> createOrUpdateAsync(String resourceGroupName, String name, SiteInner siteEnvelope,
        Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, name, siteEnvelope, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     * parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SiteInner createOrUpdate(String resourceGroupName, String name, SiteInner siteEnvelope) {
        return createOrUpdateAsync(resourceGroupName, name, siteEnvelope).block();
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     * parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SiteInner createOrUpdate(String resourceGroupName, String name, SiteInner siteEnvelope, Context context) {
        return createOrUpdateAsync(resourceGroupName, name, siteEnvelope, context).block();
    }

    /**
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     * 
     * Description for Deletes a web, mobile, or API app, or one of the deployment slots.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @param deleteMetrics If true, web app metrics are also deleted.
     * @param deleteEmptyServerFarm Specify false if you want to keep empty App Service plan. By default, empty App
     * Service plan is deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String name, Boolean deleteMetrics,
        Boolean deleteEmptyServerFarm) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), resourceGroupName, name, deleteMetrics,
                deleteEmptyServerFarm, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     * 
     * Description for Deletes a web, mobile, or API app, or one of the deployment slots.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @param deleteMetrics If true, web app metrics are also deleted.
     * @param deleteEmptyServerFarm Specify false if you want to keep empty App Service plan. By default, empty App
     * Service plan is deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String name, Boolean deleteMetrics,
        Boolean deleteEmptyServerFarm, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), resourceGroupName, name, deleteMetrics, deleteEmptyServerFarm,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     * 
     * Description for Deletes a web, mobile, or API app, or one of the deployment slots.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String name) {
        final Boolean deleteMetrics = null;
        final Boolean deleteEmptyServerFarm = null;
        return deleteWithResponseAsync(resourceGroupName, name, deleteMetrics, deleteEmptyServerFarm)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     * 
     * Description for Deletes a web, mobile, or API app, or one of the deployment slots.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @param deleteMetrics If true, web app metrics are also deleted.
     * @param deleteEmptyServerFarm Specify false if you want to keep empty App Service plan. By default, empty App
     * Service plan is deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String name, Boolean deleteMetrics,
        Boolean deleteEmptyServerFarm, Context context) {
        return deleteWithResponseAsync(resourceGroupName, name, deleteMetrics, deleteEmptyServerFarm, context).block();
    }

    /**
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     * 
     * Description for Deletes a web, mobile, or API app, or one of the deployment slots.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String name) {
        final Boolean deleteMetrics = null;
        final Boolean deleteEmptyServerFarm = null;
        deleteWithResponse(resourceGroupName, name, deleteMetrics, deleteEmptyServerFarm, Context.NONE);
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     * parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String name,
        SitePatchResourceInner siteEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteEnvelope == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteEnvelope is required and cannot be null."));
        } else {
            siteEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), siteEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     * parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String name,
        SitePatchResourceInner siteEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteEnvelope == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteEnvelope is required and cannot be null."));
        } else {
            siteEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(),
            this.client.getApiVersion(), siteEnvelope, accept, context);
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     * parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<SiteInner>, SiteInner> beginUpdateAsync(String resourceGroupName, String name,
        SitePatchResourceInner siteEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, name, siteEnvelope);
        return this.client.<SiteInner, SiteInner>getLroResult(mono, this.client.getHttpPipeline(), SiteInner.class,
            SiteInner.class, this.client.getContext());
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     * parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SiteInner>, SiteInner> beginUpdateAsync(String resourceGroupName, String name,
        SitePatchResourceInner siteEnvelope, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, name, siteEnvelope, context);
        return this.client.<SiteInner, SiteInner>getLroResult(mono, this.client.getHttpPipeline(), SiteInner.class,
            SiteInner.class, context);
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     * parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SiteInner>, SiteInner> beginUpdate(String resourceGroupName, String name,
        SitePatchResourceInner siteEnvelope) {
        return this.beginUpdateAsync(resourceGroupName, name, siteEnvelope).getSyncPoller();
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     * parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SiteInner>, SiteInner> beginUpdate(String resourceGroupName, String name,
        SitePatchResourceInner siteEnvelope, Context context) {
        return this.beginUpdateAsync(resourceGroupName, name, siteEnvelope, context).getSyncPoller();
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     * parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SiteInner> updateAsync(String resourceGroupName, String name, SitePatchResourceInner siteEnvelope) {
        return beginUpdateAsync(resourceGroupName, name, siteEnvelope).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     * parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SiteInner> updateAsync(String resourceGroupName, String name, SitePatchResourceInner siteEnvelope,
        Context context) {
        return beginUpdateAsync(resourceGroupName, name, siteEnvelope, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     * parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SiteInner update(String resourceGroupName, String name, SitePatchResourceInner siteEnvelope) {
        return updateAsync(resourceGroupName, name, siteEnvelope).block();
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     * parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SiteInner update(String resourceGroupName, String name, SitePatchResourceInner siteEnvelope,
        Context context) {
        return updateAsync(resourceGroupName, name, siteEnvelope, context).block();
    }

    /**
     * Analyze a custom hostname.
     * 
     * Description for Analyze a custom hostname.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param hostname Custom hostname.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain analysis along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CustomHostnameAnalysisResultInner>>
        analyzeCustomHostnameWithResponseAsync(String resourceGroupName, String name, String hostname) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.analyzeCustomHostname(this.client.getEndpoint(), resourceGroupName, name,
                hostname, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Analyze a custom hostname.
     * 
     * Description for Analyze a custom hostname.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param hostname Custom hostname.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain analysis along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<CustomHostnameAnalysisResultInner>> analyzeCustomHostnameWithResponseAsync(
        String resourceGroupName, String name, String hostname, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.analyzeCustomHostname(this.client.getEndpoint(), resourceGroupName, name, hostname,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Analyze a custom hostname.
     * 
     * Description for Analyze a custom hostname.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain analysis on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CustomHostnameAnalysisResultInner> analyzeCustomHostnameAsync(String resourceGroupName, String name) {
        final String hostname = null;
        return analyzeCustomHostnameWithResponseAsync(resourceGroupName, name, hostname)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Analyze a custom hostname.
     * 
     * Description for Analyze a custom hostname.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param hostname Custom hostname.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain analysis along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CustomHostnameAnalysisResultInner> analyzeCustomHostnameWithResponse(String resourceGroupName,
        String name, String hostname, Context context) {
        return analyzeCustomHostnameWithResponseAsync(resourceGroupName, name, hostname, context).block();
    }

    /**
     * Analyze a custom hostname.
     * 
     * Description for Analyze a custom hostname.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain analysis.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CustomHostnameAnalysisResultInner analyzeCustomHostname(String resourceGroupName, String name) {
        final String hostname = null;
        return analyzeCustomHostnameWithResponse(resourceGroupName, name, hostname, Context.NONE).getValue();
    }

    /**
     * Applies the configuration settings from the target slot onto the current slot.
     * 
     * Description for Applies the configuration settings from the target slot onto the current slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotSwapEntity JSON object that contains the target slot name. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> applySlotConfigToProductionWithResponseAsync(String resourceGroupName, String name,
        CsmSlotEntity slotSwapEntity) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (slotSwapEntity == null) {
            return Mono.error(new IllegalArgumentException("Parameter slotSwapEntity is required and cannot be null."));
        } else {
            slotSwapEntity.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.applySlotConfigToProduction(this.client.getEndpoint(), resourceGroupName,
                name, this.client.getSubscriptionId(), this.client.getApiVersion(), slotSwapEntity, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Applies the configuration settings from the target slot onto the current slot.
     * 
     * Description for Applies the configuration settings from the target slot onto the current slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotSwapEntity JSON object that contains the target slot name. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> applySlotConfigToProductionWithResponseAsync(String resourceGroupName, String name,
        CsmSlotEntity slotSwapEntity, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (slotSwapEntity == null) {
            return Mono.error(new IllegalArgumentException("Parameter slotSwapEntity is required and cannot be null."));
        } else {
            slotSwapEntity.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.applySlotConfigToProduction(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), slotSwapEntity, accept, context);
    }

    /**
     * Applies the configuration settings from the target slot onto the current slot.
     * 
     * Description for Applies the configuration settings from the target slot onto the current slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotSwapEntity JSON object that contains the target slot name. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> applySlotConfigToProductionAsync(String resourceGroupName, String name,
        CsmSlotEntity slotSwapEntity) {
        return applySlotConfigToProductionWithResponseAsync(resourceGroupName, name, slotSwapEntity)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Applies the configuration settings from the target slot onto the current slot.
     * 
     * Description for Applies the configuration settings from the target slot onto the current slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotSwapEntity JSON object that contains the target slot name. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> applySlotConfigToProductionWithResponse(String resourceGroupName, String name,
        CsmSlotEntity slotSwapEntity, Context context) {
        return applySlotConfigToProductionWithResponseAsync(resourceGroupName, name, slotSwapEntity, context).block();
    }

    /**
     * Applies the configuration settings from the target slot onto the current slot.
     * 
     * Description for Applies the configuration settings from the target slot onto the current slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotSwapEntity JSON object that contains the target slot name. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void applySlotConfigToProduction(String resourceGroupName, String name, CsmSlotEntity slotSwapEntity) {
        applySlotConfigToProductionWithResponse(resourceGroupName, name, slotSwapEntity, Context.NONE);
    }

    /**
     * Creates a backup of an app.
     * 
     * Description for Creates a backup of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Backup configuration. You can use the JSON response from the POST action as input here.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BackupItemInner>> backupWithResponseAsync(String resourceGroupName, String name,
        BackupRequestInner request) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.backup(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), request, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates a backup of an app.
     * 
     * Description for Creates a backup of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Backup configuration. You can use the JSON response from the POST action as input here.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<BackupItemInner>> backupWithResponseAsync(String resourceGroupName, String name,
        BackupRequestInner request, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.backup(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(),
            this.client.getApiVersion(), request, accept, context);
    }

    /**
     * Creates a backup of an app.
     * 
     * Description for Creates a backup of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Backup configuration. You can use the JSON response from the POST action as input here.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BackupItemInner> backupAsync(String resourceGroupName, String name, BackupRequestInner request) {
        return backupWithResponseAsync(resourceGroupName, name, request)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a backup of an app.
     * 
     * Description for Creates a backup of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Backup configuration. You can use the JSON response from the POST action as input here.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BackupItemInner> backupWithResponse(String resourceGroupName, String name,
        BackupRequestInner request, Context context) {
        return backupWithResponseAsync(resourceGroupName, name, request, context).block();
    }

    /**
     * Creates a backup of an app.
     * 
     * Description for Creates a backup of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Backup configuration. You can use the JSON response from the POST action as input here.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BackupItemInner backup(String resourceGroupName, String name, BackupRequestInner request) {
        return backupWithResponse(resourceGroupName, name, request, Context.NONE).getValue();
    }

    /**
     * Gets existing backups of an app.
     * 
     * Description for Gets existing backups of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of backup items along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BackupItemInner>> listBackupsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listBackups(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<BackupItemInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets existing backups of an app.
     * 
     * Description for Gets existing backups of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of backup items along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BackupItemInner>> listBackupsSinglePageAsync(String resourceGroupName, String name,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listBackups(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets existing backups of an app.
     * 
     * Description for Gets existing backups of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of backup items as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BackupItemInner> listBackupsAsync(String resourceGroupName, String name) {
        return new PagedFlux<>(() -> listBackupsSinglePageAsync(resourceGroupName, name),
            nextLink -> listBackupsNextSinglePageAsync(nextLink));
    }

    /**
     * Gets existing backups of an app.
     * 
     * Description for Gets existing backups of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of backup items as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<BackupItemInner> listBackupsAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux<>(() -> listBackupsSinglePageAsync(resourceGroupName, name, context),
            nextLink -> listBackupsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets existing backups of an app.
     * 
     * Description for Gets existing backups of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of backup items as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BackupItemInner> listBackups(String resourceGroupName, String name) {
        return new PagedIterable<>(listBackupsAsync(resourceGroupName, name));
    }

    /**
     * Gets existing backups of an app.
     * 
     * Description for Gets existing backups of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of backup items as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BackupItemInner> listBackups(String resourceGroupName, String name, Context context) {
        return new PagedIterable<>(listBackupsAsync(resourceGroupName, name, context));
    }

    /**
     * Gets a backup of an app by its ID.
     * 
     * Description for Gets a backup of an app by its ID.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BackupItemInner>> getBackupStatusWithResponseAsync(String resourceGroupName, String name,
        String backupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getBackupStatus(this.client.getEndpoint(), resourceGroupName, name,
                backupId, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a backup of an app by its ID.
     * 
     * Description for Gets a backup of an app by its ID.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<BackupItemInner>> getBackupStatusWithResponseAsync(String resourceGroupName, String name,
        String backupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getBackupStatus(this.client.getEndpoint(), resourceGroupName, name, backupId,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets a backup of an app by its ID.
     * 
     * Description for Gets a backup of an app by its ID.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BackupItemInner> getBackupStatusAsync(String resourceGroupName, String name, String backupId) {
        return getBackupStatusWithResponseAsync(resourceGroupName, name, backupId)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a backup of an app by its ID.
     * 
     * Description for Gets a backup of an app by its ID.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BackupItemInner> getBackupStatusWithResponse(String resourceGroupName, String name, String backupId,
        Context context) {
        return getBackupStatusWithResponseAsync(resourceGroupName, name, backupId, context).block();
    }

    /**
     * Gets a backup of an app by its ID.
     * 
     * Description for Gets a backup of an app by its ID.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BackupItemInner getBackupStatus(String resourceGroupName, String name, String backupId) {
        return getBackupStatusWithResponse(resourceGroupName, name, backupId, Context.NONE).getValue();
    }

    /**
     * Deletes a backup of an app by its ID.
     * 
     * Description for Deletes a backup of an app by its ID.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteBackupWithResponseAsync(String resourceGroupName, String name, String backupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteBackup(this.client.getEndpoint(), resourceGroupName, name, backupId,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a backup of an app by its ID.
     * 
     * Description for Deletes a backup of an app by its ID.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteBackupWithResponseAsync(String resourceGroupName, String name, String backupId,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteBackup(this.client.getEndpoint(), resourceGroupName, name, backupId,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes a backup of an app by its ID.
     * 
     * Description for Deletes a backup of an app by its ID.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteBackupAsync(String resourceGroupName, String name, String backupId) {
        return deleteBackupWithResponseAsync(resourceGroupName, name, backupId).flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a backup of an app by its ID.
     * 
     * Description for Deletes a backup of an app by its ID.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteBackupWithResponse(String resourceGroupName, String name, String backupId,
        Context context) {
        return deleteBackupWithResponseAsync(resourceGroupName, name, backupId, context).block();
    }

    /**
     * Deletes a backup of an app by its ID.
     * 
     * Description for Deletes a backup of an app by its ID.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteBackup(String resourceGroupName, String name, String backupId) {
        deleteBackupWithResponse(resourceGroupName, name, backupId, Context.NONE);
    }

    /**
     * Gets status of a web app backup that may be in progress, including secrets associated with the backup, such as
     * the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is passed in the
     * request body.
     * 
     * Description for Gets status of a web app backup that may be in progress, including secrets associated with the
     * backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is
     * passed in the request body.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param backupId ID of backup.
     * @param request Information on backup request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BackupItemInner>> listBackupStatusSecretsWithResponseAsync(String resourceGroupName,
        String name, String backupId, BackupRequestInner request) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listBackupStatusSecrets(this.client.getEndpoint(), resourceGroupName, name,
                backupId, this.client.getSubscriptionId(), this.client.getApiVersion(), request, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets status of a web app backup that may be in progress, including secrets associated with the backup, such as
     * the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is passed in the
     * request body.
     * 
     * Description for Gets status of a web app backup that may be in progress, including secrets associated with the
     * backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is
     * passed in the request body.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param backupId ID of backup.
     * @param request Information on backup request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<BackupItemInner>> listBackupStatusSecretsWithResponseAsync(String resourceGroupName,
        String name, String backupId, BackupRequestInner request, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listBackupStatusSecrets(this.client.getEndpoint(), resourceGroupName, name, backupId,
            this.client.getSubscriptionId(), this.client.getApiVersion(), request, accept, context);
    }

    /**
     * Gets status of a web app backup that may be in progress, including secrets associated with the backup, such as
     * the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is passed in the
     * request body.
     * 
     * Description for Gets status of a web app backup that may be in progress, including secrets associated with the
     * backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is
     * passed in the request body.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param backupId ID of backup.
     * @param request Information on backup request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BackupItemInner> listBackupStatusSecretsAsync(String resourceGroupName, String name, String backupId,
        BackupRequestInner request) {
        return listBackupStatusSecretsWithResponseAsync(resourceGroupName, name, backupId, request)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets status of a web app backup that may be in progress, including secrets associated with the backup, such as
     * the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is passed in the
     * request body.
     * 
     * Description for Gets status of a web app backup that may be in progress, including secrets associated with the
     * backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is
     * passed in the request body.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param backupId ID of backup.
     * @param request Information on backup request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BackupItemInner> listBackupStatusSecretsWithResponse(String resourceGroupName, String name,
        String backupId, BackupRequestInner request, Context context) {
        return listBackupStatusSecretsWithResponseAsync(resourceGroupName, name, backupId, request, context).block();
    }

    /**
     * Gets status of a web app backup that may be in progress, including secrets associated with the backup, such as
     * the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is passed in the
     * request body.
     * 
     * Description for Gets status of a web app backup that may be in progress, including secrets associated with the
     * backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is
     * passed in the request body.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param backupId ID of backup.
     * @param request Information on backup request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BackupItemInner listBackupStatusSecrets(String resourceGroupName, String name, String backupId,
        BackupRequestInner request) {
        return listBackupStatusSecretsWithResponse(resourceGroupName, name, backupId, request, Context.NONE).getValue();
    }

    /**
     * Restores a specific backup to another app (or deployment slot, if specified).
     * 
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> restoreWithResponseAsync(String resourceGroupName, String name,
        String backupId, RestoreRequestInner request) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.restore(this.client.getEndpoint(), resourceGroupName, name, backupId,
                this.client.getSubscriptionId(), this.client.getApiVersion(), request, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Restores a specific backup to another app (or deployment slot, if specified).
     * 
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restoreWithResponseAsync(String resourceGroupName, String name,
        String backupId, RestoreRequestInner request, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.restore(this.client.getEndpoint(), resourceGroupName, name, backupId,
            this.client.getSubscriptionId(), this.client.getApiVersion(), request, accept, context);
    }

    /**
     * Restores a specific backup to another app (or deployment slot, if specified).
     * 
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginRestoreAsync(String resourceGroupName, String name, String backupId,
        RestoreRequestInner request) {
        Mono<Response<Flux<ByteBuffer>>> mono = restoreWithResponseAsync(resourceGroupName, name, backupId, request);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Restores a specific backup to another app (or deployment slot, if specified).
     * 
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRestoreAsync(String resourceGroupName, String name, String backupId,
        RestoreRequestInner request, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = restoreWithResponseAsync(resourceGroupName, name, backupId, request, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Restores a specific backup to another app (or deployment slot, if specified).
     * 
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestore(String resourceGroupName, String name, String backupId,
        RestoreRequestInner request) {
        return this.beginRestoreAsync(resourceGroupName, name, backupId, request).getSyncPoller();
    }

    /**
     * Restores a specific backup to another app (or deployment slot, if specified).
     * 
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestore(String resourceGroupName, String name, String backupId,
        RestoreRequestInner request, Context context) {
        return this.beginRestoreAsync(resourceGroupName, name, backupId, request, context).getSyncPoller();
    }

    /**
     * Restores a specific backup to another app (or deployment slot, if specified).
     * 
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> restoreAsync(String resourceGroupName, String name, String backupId,
        RestoreRequestInner request) {
        return beginRestoreAsync(resourceGroupName, name, backupId, request).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Restores a specific backup to another app (or deployment slot, if specified).
     * 
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> restoreAsync(String resourceGroupName, String name, String backupId, RestoreRequestInner request,
        Context context) {
        return beginRestoreAsync(resourceGroupName, name, backupId, request, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Restores a specific backup to another app (or deployment slot, if specified).
     * 
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void restore(String resourceGroupName, String name, String backupId, RestoreRequestInner request) {
        restoreAsync(resourceGroupName, name, backupId, request).block();
    }

    /**
     * Restores a specific backup to another app (or deployment slot, if specified).
     * 
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void restore(String resourceGroupName, String name, String backupId, RestoreRequestInner request,
        Context context) {
        restoreAsync(resourceGroupName, name, backupId, request, context).block();
    }

    /**
     * Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.
     * 
     * Description for Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies entity collection ARM resource along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CsmPublishingCredentialsPoliciesEntityInner>>
        listBasicPublishingCredentialsPoliciesSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listBasicPublishingCredentialsPolicies(this.client.getEndpoint(),
                resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<CsmPublishingCredentialsPoliciesEntityInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.
     * 
     * Description for Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies entity collection ARM resource along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CsmPublishingCredentialsPoliciesEntityInner>>
        listBasicPublishingCredentialsPoliciesSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listBasicPublishingCredentialsPolicies(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.
     * 
     * Description for Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies entity collection ARM resource as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<CsmPublishingCredentialsPoliciesEntityInner>
        listBasicPublishingCredentialsPoliciesAsync(String resourceGroupName, String name) {
        return new PagedFlux<>(() -> listBasicPublishingCredentialsPoliciesSinglePageAsync(resourceGroupName, name),
            nextLink -> listBasicPublishingCredentialsPoliciesNextSinglePageAsync(nextLink));
    }

    /**
     * Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.
     * 
     * Description for Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies entity collection ARM resource as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<CsmPublishingCredentialsPoliciesEntityInner>
        listBasicPublishingCredentialsPoliciesAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux<>(
            () -> listBasicPublishingCredentialsPoliciesSinglePageAsync(resourceGroupName, name, context),
            nextLink -> listBasicPublishingCredentialsPoliciesNextSinglePageAsync(nextLink, context));
    }

    /**
     * Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.
     * 
     * Description for Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies entity collection ARM resource as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CsmPublishingCredentialsPoliciesEntityInner>
        listBasicPublishingCredentialsPolicies(String resourceGroupName, String name) {
        return new PagedIterable<>(listBasicPublishingCredentialsPoliciesAsync(resourceGroupName, name));
    }

    /**
     * Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.
     * 
     * Description for Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies entity collection ARM resource as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CsmPublishingCredentialsPoliciesEntityInner>
        listBasicPublishingCredentialsPolicies(String resourceGroupName, String name, Context context) {
        return new PagedIterable<>(listBasicPublishingCredentialsPoliciesAsync(resourceGroupName, name, context));
    }

    /**
     * Returns whether FTP is allowed on the site or not.
     * 
     * Description for Returns whether FTP is allowed on the site or not.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>>
        getFtpAllowedWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getFtpAllowed(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns whether FTP is allowed on the site or not.
     * 
     * Description for Returns whether FTP is allowed on the site or not.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>>
        getFtpAllowedWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getFtpAllowed(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Returns whether FTP is allowed on the site or not.
     * 
     * Description for Returns whether FTP is allowed on the site or not.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CsmPublishingCredentialsPoliciesEntityInner> getFtpAllowedAsync(String resourceGroupName, String name) {
        return getFtpAllowedWithResponseAsync(resourceGroupName, name).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Returns whether FTP is allowed on the site or not.
     * 
     * Description for Returns whether FTP is allowed on the site or not.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CsmPublishingCredentialsPoliciesEntityInner> getFtpAllowedWithResponse(String resourceGroupName,
        String name, Context context) {
        return getFtpAllowedWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Returns whether FTP is allowed on the site or not.
     * 
     * Description for Returns whether FTP is allowed on the site or not.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CsmPublishingCredentialsPoliciesEntityInner getFtpAllowed(String resourceGroupName, String name) {
        return getFtpAllowedWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Updates whether FTP is allowed on the site or not.
     * 
     * Description for Updates whether FTP is allowed on the site or not.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> updateFtpAllowedWithResponseAsync(
        String resourceGroupName, String name,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (csmPublishingAccessPoliciesEntity == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter csmPublishingAccessPoliciesEntity is required and cannot be null."));
        } else {
            csmPublishingAccessPoliciesEntity.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateFtpAllowed(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), csmPublishingAccessPoliciesEntity, accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates whether FTP is allowed on the site or not.
     * 
     * Description for Updates whether FTP is allowed on the site or not.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> updateFtpAllowedWithResponseAsync(
        String resourceGroupName, String name,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (csmPublishingAccessPoliciesEntity == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter csmPublishingAccessPoliciesEntity is required and cannot be null."));
        } else {
            csmPublishingAccessPoliciesEntity.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateFtpAllowed(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), csmPublishingAccessPoliciesEntity, accept,
            context);
    }

    /**
     * Updates whether FTP is allowed on the site or not.
     * 
     * Description for Updates whether FTP is allowed on the site or not.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CsmPublishingCredentialsPoliciesEntityInner> updateFtpAllowedAsync(String resourceGroupName,
        String name, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity) {
        return updateFtpAllowedWithResponseAsync(resourceGroupName, name, csmPublishingAccessPoliciesEntity)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates whether FTP is allowed on the site or not.
     * 
     * Description for Updates whether FTP is allowed on the site or not.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CsmPublishingCredentialsPoliciesEntityInner> updateFtpAllowedWithResponse(String resourceGroupName,
        String name, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity, Context context) {
        return updateFtpAllowedWithResponseAsync(resourceGroupName, name, csmPublishingAccessPoliciesEntity, context)
            .block();
    }

    /**
     * Updates whether FTP is allowed on the site or not.
     * 
     * Description for Updates whether FTP is allowed on the site or not.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CsmPublishingCredentialsPoliciesEntityInner updateFtpAllowed(String resourceGroupName, String name,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity) {
        return updateFtpAllowedWithResponse(resourceGroupName, name, csmPublishingAccessPoliciesEntity, Context.NONE)
            .getValue();
    }

    /**
     * Returns whether Scm basic auth is allowed on the site or not.
     * 
     * Description for Returns whether Scm basic auth is allowed on the site or not.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>>
        getScmAllowedWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getScmAllowed(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns whether Scm basic auth is allowed on the site or not.
     * 
     * Description for Returns whether Scm basic auth is allowed on the site or not.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>>
        getScmAllowedWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getScmAllowed(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Returns whether Scm basic auth is allowed on the site or not.
     * 
     * Description for Returns whether Scm basic auth is allowed on the site or not.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CsmPublishingCredentialsPoliciesEntityInner> getScmAllowedAsync(String resourceGroupName, String name) {
        return getScmAllowedWithResponseAsync(resourceGroupName, name).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Returns whether Scm basic auth is allowed on the site or not.
     * 
     * Description for Returns whether Scm basic auth is allowed on the site or not.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CsmPublishingCredentialsPoliciesEntityInner> getScmAllowedWithResponse(String resourceGroupName,
        String name, Context context) {
        return getScmAllowedWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Returns whether Scm basic auth is allowed on the site or not.
     * 
     * Description for Returns whether Scm basic auth is allowed on the site or not.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CsmPublishingCredentialsPoliciesEntityInner getScmAllowed(String resourceGroupName, String name) {
        return getScmAllowedWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Updates whether user publishing credentials are allowed on the site or not.
     * 
     * Description for Updates whether user publishing credentials are allowed on the site or not.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> updateScmAllowedWithResponseAsync(
        String resourceGroupName, String name,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (csmPublishingAccessPoliciesEntity == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter csmPublishingAccessPoliciesEntity is required and cannot be null."));
        } else {
            csmPublishingAccessPoliciesEntity.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateScmAllowed(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), csmPublishingAccessPoliciesEntity, accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates whether user publishing credentials are allowed on the site or not.
     * 
     * Description for Updates whether user publishing credentials are allowed on the site or not.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> updateScmAllowedWithResponseAsync(
        String resourceGroupName, String name,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (csmPublishingAccessPoliciesEntity == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter csmPublishingAccessPoliciesEntity is required and cannot be null."));
        } else {
            csmPublishingAccessPoliciesEntity.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateScmAllowed(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), csmPublishingAccessPoliciesEntity, accept,
            context);
    }

    /**
     * Updates whether user publishing credentials are allowed on the site or not.
     * 
     * Description for Updates whether user publishing credentials are allowed on the site or not.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CsmPublishingCredentialsPoliciesEntityInner> updateScmAllowedAsync(String resourceGroupName,
        String name, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity) {
        return updateScmAllowedWithResponseAsync(resourceGroupName, name, csmPublishingAccessPoliciesEntity)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates whether user publishing credentials are allowed on the site or not.
     * 
     * Description for Updates whether user publishing credentials are allowed on the site or not.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CsmPublishingCredentialsPoliciesEntityInner> updateScmAllowedWithResponse(String resourceGroupName,
        String name, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity, Context context) {
        return updateScmAllowedWithResponseAsync(resourceGroupName, name, csmPublishingAccessPoliciesEntity, context)
            .block();
    }

    /**
     * Updates whether user publishing credentials are allowed on the site or not.
     * 
     * Description for Updates whether user publishing credentials are allowed on the site or not.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CsmPublishingCredentialsPoliciesEntityInner updateScmAllowed(String resourceGroupName, String name,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity) {
        return updateScmAllowedWithResponse(resourceGroupName, name, csmPublishingAccessPoliciesEntity, Context.NONE)
            .getValue();
    }

    /**
     * List the configurations of an app
     * 
     * Description for List the configurations of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of site configurations along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SiteConfigResourceInner>> listConfigurationsSinglePageAsync(String resourceGroupName,
        String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listConfigurations(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<SiteConfigResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List the configurations of an app
     * 
     * Description for List the configurations of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of site configurations along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SiteConfigResourceInner>> listConfigurationsSinglePageAsync(String resourceGroupName,
        String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listConfigurations(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * List the configurations of an app
     * 
     * Description for List the configurations of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of site configurations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SiteConfigResourceInner> listConfigurationsAsync(String resourceGroupName, String name) {
        return new PagedFlux<>(() -> listConfigurationsSinglePageAsync(resourceGroupName, name),
            nextLink -> listConfigurationsNextSinglePageAsync(nextLink));
    }

    /**
     * List the configurations of an app
     * 
     * Description for List the configurations of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of site configurations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SiteConfigResourceInner> listConfigurationsAsync(String resourceGroupName, String name,
        Context context) {
        return new PagedFlux<>(() -> listConfigurationsSinglePageAsync(resourceGroupName, name, context),
            nextLink -> listConfigurationsNextSinglePageAsync(nextLink, context));
    }

    /**
     * List the configurations of an app
     * 
     * Description for List the configurations of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of site configurations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SiteConfigResourceInner> listConfigurations(String resourceGroupName, String name) {
        return new PagedIterable<>(listConfigurationsAsync(resourceGroupName, name));
    }

    /**
     * List the configurations of an app
     * 
     * Description for List the configurations of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of site configurations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SiteConfigResourceInner> listConfigurations(String resourceGroupName, String name,
        Context context) {
        return new PagedIterable<>(listConfigurationsAsync(resourceGroupName, name, context));
    }

    /**
     * Replaces the application settings of an app.
     * 
     * Description for Replaces the application settings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettings Application settings of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateApplicationSettingsWithResponseAsync(String resourceGroupName,
        String name, StringDictionaryInner appSettings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error(new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        } else {
            appSettings.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateApplicationSettings(this.client.getEndpoint(), resourceGroupName,
                name, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Replaces the application settings of an app.
     * 
     * Description for Replaces the application settings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettings Application settings of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateApplicationSettingsWithResponseAsync(String resourceGroupName,
        String name, StringDictionaryInner appSettings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error(new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        } else {
            appSettings.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateApplicationSettings(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, accept, context);
    }

    /**
     * Replaces the application settings of an app.
     * 
     * Description for Replaces the application settings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettings Application settings of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<StringDictionaryInner>, StringDictionaryInner>
        beginUpdateApplicationSettingsAsync(String resourceGroupName, String name, StringDictionaryInner appSettings) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateApplicationSettingsWithResponseAsync(resourceGroupName, name, appSettings);
        return this.client.<StringDictionaryInner, StringDictionaryInner>getLroResult(mono,
            this.client.getHttpPipeline(), StringDictionaryInner.class, StringDictionaryInner.class,
            this.client.getContext());
    }

    /**
     * Replaces the application settings of an app.
     * 
     * Description for Replaces the application settings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettings Application settings of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<StringDictionaryInner>, StringDictionaryInner> beginUpdateApplicationSettingsAsync(
        String resourceGroupName, String name, StringDictionaryInner appSettings, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateApplicationSettingsWithResponseAsync(resourceGroupName, name, appSettings, context);
        return this.client.<StringDictionaryInner, StringDictionaryInner>getLroResult(mono,
            this.client.getHttpPipeline(), StringDictionaryInner.class, StringDictionaryInner.class, context);
    }

    /**
     * Replaces the application settings of an app.
     * 
     * Description for Replaces the application settings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettings Application settings of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<StringDictionaryInner>, StringDictionaryInner>
        beginUpdateApplicationSettings(String resourceGroupName, String name, StringDictionaryInner appSettings) {
        return this.beginUpdateApplicationSettingsAsync(resourceGroupName, name, appSettings).getSyncPoller();
    }

    /**
     * Replaces the application settings of an app.
     * 
     * Description for Replaces the application settings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettings Application settings of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<StringDictionaryInner>, StringDictionaryInner> beginUpdateApplicationSettings(
        String resourceGroupName, String name, StringDictionaryInner appSettings, Context context) {
        return this.beginUpdateApplicationSettingsAsync(resourceGroupName, name, appSettings, context).getSyncPoller();
    }

    /**
     * Replaces the application settings of an app.
     * 
     * Description for Replaces the application settings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettings Application settings of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StringDictionaryInner> updateApplicationSettingsAsync(String resourceGroupName, String name,
        StringDictionaryInner appSettings) {
        return beginUpdateApplicationSettingsAsync(resourceGroupName, name, appSettings).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Replaces the application settings of an app.
     * 
     * Description for Replaces the application settings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettings Application settings of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<StringDictionaryInner> updateApplicationSettingsAsync(String resourceGroupName, String name,
        StringDictionaryInner appSettings, Context context) {
        return beginUpdateApplicationSettingsAsync(resourceGroupName, name, appSettings, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Replaces the application settings of an app.
     * 
     * Description for Replaces the application settings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettings Application settings of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StringDictionaryInner updateApplicationSettings(String resourceGroupName, String name,
        StringDictionaryInner appSettings) {
        return updateApplicationSettingsAsync(resourceGroupName, name, appSettings).block();
    }

    /**
     * Replaces the application settings of an app.
     * 
     * Description for Replaces the application settings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettings Application settings of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StringDictionaryInner updateApplicationSettings(String resourceGroupName, String name,
        StringDictionaryInner appSettings, Context context) {
        return updateApplicationSettingsAsync(resourceGroupName, name, appSettings, context).block();
    }

    /**
     * Gets the application settings of an app.
     * 
     * Description for Gets the application settings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>> listApplicationSettingsWithResponseAsync(String resourceGroupName,
        String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listApplicationSettings(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the application settings of an app.
     * 
     * Description for Gets the application settings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>> listApplicationSettingsWithResponseAsync(String resourceGroupName,
        String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listApplicationSettings(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the application settings of an app.
     * 
     * Description for Gets the application settings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StringDictionaryInner> listApplicationSettingsAsync(String resourceGroupName, String name) {
        return listApplicationSettingsWithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the application settings of an app.
     * 
     * Description for Gets the application settings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StringDictionaryInner> listApplicationSettingsWithResponse(String resourceGroupName, String name,
        Context context) {
        return listApplicationSettingsWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets the application settings of an app.
     * 
     * Description for Gets the application settings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StringDictionaryInner listApplicationSettings(String resourceGroupName, String name) {
        return listApplicationSettingsWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Updates the Authentication / Authorization settings associated with web app.
     * 
     * Description for Updates the Authentication / Authorization settings associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettings Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SiteAuthSettingsInner>> updateAuthSettingsWithResponseAsync(String resourceGroupName,
        String name, SiteAuthSettingsInner siteAuthSettings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteAuthSettings == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter siteAuthSettings is required and cannot be null."));
        } else {
            siteAuthSettings.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateAuthSettings(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), siteAuthSettings, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates the Authentication / Authorization settings associated with web app.
     * 
     * Description for Updates the Authentication / Authorization settings associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettings Auth settings associated with web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SiteAuthSettingsInner>> updateAuthSettingsWithResponseAsync(String resourceGroupName,
        String name, SiteAuthSettingsInner siteAuthSettings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteAuthSettings == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter siteAuthSettings is required and cannot be null."));
        } else {
            siteAuthSettings.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateAuthSettings(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), siteAuthSettings, accept, context);
    }

    /**
     * Updates the Authentication / Authorization settings associated with web app.
     * 
     * Description for Updates the Authentication / Authorization settings associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettings Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SiteAuthSettingsInner> updateAuthSettingsAsync(String resourceGroupName, String name,
        SiteAuthSettingsInner siteAuthSettings) {
        return updateAuthSettingsWithResponseAsync(resourceGroupName, name, siteAuthSettings)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the Authentication / Authorization settings associated with web app.
     * 
     * Description for Updates the Authentication / Authorization settings associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettings Auth settings associated with web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SiteAuthSettingsInner> updateAuthSettingsWithResponse(String resourceGroupName, String name,
        SiteAuthSettingsInner siteAuthSettings, Context context) {
        return updateAuthSettingsWithResponseAsync(resourceGroupName, name, siteAuthSettings, context).block();
    }

    /**
     * Updates the Authentication / Authorization settings associated with web app.
     * 
     * Description for Updates the Authentication / Authorization settings associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettings Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SiteAuthSettingsInner updateAuthSettings(String resourceGroupName, String name,
        SiteAuthSettingsInner siteAuthSettings) {
        return updateAuthSettingsWithResponse(resourceGroupName, name, siteAuthSettings, Context.NONE).getValue();
    }

    /**
     * Gets the Authentication/Authorization settings of an app.
     * 
     * Description for Gets the Authentication/Authorization settings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SiteAuthSettingsInner>> getAuthSettingsWithResponseAsync(String resourceGroupName,
        String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getAuthSettings(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the Authentication/Authorization settings of an app.
     * 
     * Description for Gets the Authentication/Authorization settings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SiteAuthSettingsInner>> getAuthSettingsWithResponseAsync(String resourceGroupName,
        String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getAuthSettings(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the Authentication/Authorization settings of an app.
     * 
     * Description for Gets the Authentication/Authorization settings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SiteAuthSettingsInner> getAuthSettingsAsync(String resourceGroupName, String name) {
        return getAuthSettingsWithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the Authentication/Authorization settings of an app.
     * 
     * Description for Gets the Authentication/Authorization settings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SiteAuthSettingsInner> getAuthSettingsWithResponse(String resourceGroupName, String name,
        Context context) {
        return getAuthSettingsWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets the Authentication/Authorization settings of an app.
     * 
     * Description for Gets the Authentication/Authorization settings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SiteAuthSettingsInner getAuthSettings(String resourceGroupName, String name) {
        return getAuthSettingsWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Gets site's Authentication / Authorization settings for apps via the V2 format
     * 
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SiteAuthSettingsV2Inner>>
        getAuthSettingsV2WithoutSecretsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getAuthSettingsV2WithoutSecrets(this.client.getEndpoint(),
                resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets site's Authentication / Authorization settings for apps via the V2 format
     * 
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SiteAuthSettingsV2Inner>>
        getAuthSettingsV2WithoutSecretsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getAuthSettingsV2WithoutSecrets(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets site's Authentication / Authorization settings for apps via the V2 format
     * 
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SiteAuthSettingsV2Inner> getAuthSettingsV2WithoutSecretsAsync(String resourceGroupName, String name) {
        return getAuthSettingsV2WithoutSecretsWithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets site's Authentication / Authorization settings for apps via the V2 format
     * 
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SiteAuthSettingsV2Inner> getAuthSettingsV2WithoutSecretsWithResponse(String resourceGroupName,
        String name, Context context) {
        return getAuthSettingsV2WithoutSecretsWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets site's Authentication / Authorization settings for apps via the V2 format
     * 
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SiteAuthSettingsV2Inner getAuthSettingsV2WithoutSecrets(String resourceGroupName, String name) {
        return getAuthSettingsV2WithoutSecretsWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Updates site's Authentication / Authorization settings for apps via the V2 format
     * 
     * Description for Updates site's Authentication / Authorization settings for apps via the V2 format.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettingsV2 Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SiteAuthSettingsV2Inner>> updateAuthSettingsV2WithResponseAsync(String resourceGroupName,
        String name, SiteAuthSettingsV2Inner siteAuthSettingsV2) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteAuthSettingsV2 == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter siteAuthSettingsV2 is required and cannot be null."));
        } else {
            siteAuthSettingsV2.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateAuthSettingsV2(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), siteAuthSettingsV2, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates site's Authentication / Authorization settings for apps via the V2 format
     * 
     * Description for Updates site's Authentication / Authorization settings for apps via the V2 format.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettingsV2 Auth settings associated with web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SiteAuthSettingsV2Inner>> updateAuthSettingsV2WithResponseAsync(String resourceGroupName,
        String name, SiteAuthSettingsV2Inner siteAuthSettingsV2, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteAuthSettingsV2 == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter siteAuthSettingsV2 is required and cannot be null."));
        } else {
            siteAuthSettingsV2.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateAuthSettingsV2(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), siteAuthSettingsV2, accept, context);
    }

    /**
     * Updates site's Authentication / Authorization settings for apps via the V2 format
     * 
     * Description for Updates site's Authentication / Authorization settings for apps via the V2 format.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettingsV2 Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SiteAuthSettingsV2Inner> updateAuthSettingsV2Async(String resourceGroupName, String name,
        SiteAuthSettingsV2Inner siteAuthSettingsV2) {
        return updateAuthSettingsV2WithResponseAsync(resourceGroupName, name, siteAuthSettingsV2)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates site's Authentication / Authorization settings for apps via the V2 format
     * 
     * Description for Updates site's Authentication / Authorization settings for apps via the V2 format.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettingsV2 Auth settings associated with web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SiteAuthSettingsV2Inner> updateAuthSettingsV2WithResponse(String resourceGroupName, String name,
        SiteAuthSettingsV2Inner siteAuthSettingsV2, Context context) {
        return updateAuthSettingsV2WithResponseAsync(resourceGroupName, name, siteAuthSettingsV2, context).block();
    }

    /**
     * Updates site's Authentication / Authorization settings for apps via the V2 format
     * 
     * Description for Updates site's Authentication / Authorization settings for apps via the V2 format.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettingsV2 Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SiteAuthSettingsV2Inner updateAuthSettingsV2(String resourceGroupName, String name,
        SiteAuthSettingsV2Inner siteAuthSettingsV2) {
        return updateAuthSettingsV2WithResponse(resourceGroupName, name, siteAuthSettingsV2, Context.NONE).getValue();
    }

    /**
     * Gets site's Authentication / Authorization settings for apps via the V2 format
     * 
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SiteAuthSettingsV2Inner>> getAuthSettingsV2WithResponseAsync(String resourceGroupName,
        String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getAuthSettingsV2(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets site's Authentication / Authorization settings for apps via the V2 format
     * 
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SiteAuthSettingsV2Inner>> getAuthSettingsV2WithResponseAsync(String resourceGroupName,
        String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getAuthSettingsV2(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets site's Authentication / Authorization settings for apps via the V2 format
     * 
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SiteAuthSettingsV2Inner> getAuthSettingsV2Async(String resourceGroupName, String name) {
        return getAuthSettingsV2WithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets site's Authentication / Authorization settings for apps via the V2 format
     * 
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SiteAuthSettingsV2Inner> getAuthSettingsV2WithResponse(String resourceGroupName, String name,
        Context context) {
        return getAuthSettingsV2WithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets site's Authentication / Authorization settings for apps via the V2 format
     * 
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SiteAuthSettingsV2Inner getAuthSettingsV2(String resourceGroupName, String name) {
        return getAuthSettingsV2WithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Updates the Azure storage account configurations of an app.
     * 
     * Description for Updates the Azure storage account configurations of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param azureStorageAccounts Azure storage accounts of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AzureStoragePropertyDictionaryResourceInner>> updateAzureStorageAccountsWithResponseAsync(
        String resourceGroupName, String name, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (azureStorageAccounts == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter azureStorageAccounts is required and cannot be null."));
        } else {
            azureStorageAccounts.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateAzureStorageAccounts(this.client.getEndpoint(), resourceGroupName,
                name, this.client.getSubscriptionId(), this.client.getApiVersion(), azureStorageAccounts, accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates the Azure storage account configurations of an app.
     * 
     * Description for Updates the Azure storage account configurations of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param azureStorageAccounts Azure storage accounts of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<AzureStoragePropertyDictionaryResourceInner>> updateAzureStorageAccountsWithResponseAsync(
        String resourceGroupName, String name, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (azureStorageAccounts == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter azureStorageAccounts is required and cannot be null."));
        } else {
            azureStorageAccounts.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateAzureStorageAccounts(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), azureStorageAccounts, accept, context);
    }

    /**
     * Updates the Azure storage account configurations of an app.
     * 
     * Description for Updates the Azure storage account configurations of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param azureStorageAccounts Azure storage accounts of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AzureStoragePropertyDictionaryResourceInner> updateAzureStorageAccountsAsync(String resourceGroupName,
        String name, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts) {
        return updateAzureStorageAccountsWithResponseAsync(resourceGroupName, name, azureStorageAccounts)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the Azure storage account configurations of an app.
     * 
     * Description for Updates the Azure storage account configurations of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param azureStorageAccounts Azure storage accounts of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AzureStoragePropertyDictionaryResourceInner> updateAzureStorageAccountsWithResponse(
        String resourceGroupName, String name, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts,
        Context context) {
        return updateAzureStorageAccountsWithResponseAsync(resourceGroupName, name, azureStorageAccounts, context)
            .block();
    }

    /**
     * Updates the Azure storage account configurations of an app.
     * 
     * Description for Updates the Azure storage account configurations of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param azureStorageAccounts Azure storage accounts of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AzureStoragePropertyDictionaryResourceInner updateAzureStorageAccounts(String resourceGroupName, String name,
        AzureStoragePropertyDictionaryResourceInner azureStorageAccounts) {
        return updateAzureStorageAccountsWithResponse(resourceGroupName, name, azureStorageAccounts, Context.NONE)
            .getValue();
    }

    /**
     * Gets the Azure storage account configurations of an app.
     * 
     * Description for Gets the Azure storage account configurations of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AzureStoragePropertyDictionaryResourceInner>>
        listAzureStorageAccountsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listAzureStorageAccounts(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the Azure storage account configurations of an app.
     * 
     * Description for Gets the Azure storage account configurations of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<AzureStoragePropertyDictionaryResourceInner>>
        listAzureStorageAccountsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listAzureStorageAccounts(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the Azure storage account configurations of an app.
     * 
     * Description for Gets the Azure storage account configurations of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AzureStoragePropertyDictionaryResourceInner> listAzureStorageAccountsAsync(String resourceGroupName,
        String name) {
        return listAzureStorageAccountsWithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the Azure storage account configurations of an app.
     * 
     * Description for Gets the Azure storage account configurations of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AzureStoragePropertyDictionaryResourceInner>
        listAzureStorageAccountsWithResponse(String resourceGroupName, String name, Context context) {
        return listAzureStorageAccountsWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets the Azure storage account configurations of an app.
     * 
     * Description for Gets the Azure storage account configurations of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AzureStoragePropertyDictionaryResourceInner listAzureStorageAccounts(String resourceGroupName, String name) {
        return listAzureStorageAccountsWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Updates the backup configuration of an app.
     * 
     * Description for Updates the backup configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Edited backup configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BackupRequestInner>> updateBackupConfigurationWithResponseAsync(String resourceGroupName,
        String name, BackupRequestInner request) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateBackupConfiguration(this.client.getEndpoint(), resourceGroupName,
                name, this.client.getSubscriptionId(), this.client.getApiVersion(), request, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates the backup configuration of an app.
     * 
     * Description for Updates the backup configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Edited backup configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<BackupRequestInner>> updateBackupConfigurationWithResponseAsync(String resourceGroupName,
        String name, BackupRequestInner request, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateBackupConfiguration(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), request, accept, context);
    }

    /**
     * Updates the backup configuration of an app.
     * 
     * Description for Updates the backup configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Edited backup configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BackupRequestInner> updateBackupConfigurationAsync(String resourceGroupName, String name,
        BackupRequestInner request) {
        return updateBackupConfigurationWithResponseAsync(resourceGroupName, name, request)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the backup configuration of an app.
     * 
     * Description for Updates the backup configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Edited backup configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BackupRequestInner> updateBackupConfigurationWithResponse(String resourceGroupName, String name,
        BackupRequestInner request, Context context) {
        return updateBackupConfigurationWithResponseAsync(resourceGroupName, name, request, context).block();
    }

    /**
     * Updates the backup configuration of an app.
     * 
     * Description for Updates the backup configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Edited backup configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BackupRequestInner updateBackupConfiguration(String resourceGroupName, String name,
        BackupRequestInner request) {
        return updateBackupConfigurationWithResponse(resourceGroupName, name, request, Context.NONE).getValue();
    }

    /**
     * Deletes the backup configuration of an app.
     * 
     * Description for Deletes the backup configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteBackupConfigurationWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteBackupConfiguration(this.client.getEndpoint(), resourceGroupName,
                name, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes the backup configuration of an app.
     * 
     * Description for Deletes the backup configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteBackupConfigurationWithResponseAsync(String resourceGroupName, String name,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteBackupConfiguration(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes the backup configuration of an app.
     * 
     * Description for Deletes the backup configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteBackupConfigurationAsync(String resourceGroupName, String name) {
        return deleteBackupConfigurationWithResponseAsync(resourceGroupName, name).flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes the backup configuration of an app.
     * 
     * Description for Deletes the backup configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteBackupConfigurationWithResponse(String resourceGroupName, String name,
        Context context) {
        return deleteBackupConfigurationWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Deletes the backup configuration of an app.
     * 
     * Description for Deletes the backup configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteBackupConfiguration(String resourceGroupName, String name) {
        deleteBackupConfigurationWithResponse(resourceGroupName, name, Context.NONE);
    }

    /**
     * Gets the backup configuration of an app.
     * 
     * Description for Gets the backup configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BackupRequestInner>> getBackupConfigurationWithResponseAsync(String resourceGroupName,
        String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getBackupConfiguration(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the backup configuration of an app.
     * 
     * Description for Gets the backup configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<BackupRequestInner>> getBackupConfigurationWithResponseAsync(String resourceGroupName,
        String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getBackupConfiguration(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the backup configuration of an app.
     * 
     * Description for Gets the backup configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BackupRequestInner> getBackupConfigurationAsync(String resourceGroupName, String name) {
        return getBackupConfigurationWithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the backup configuration of an app.
     * 
     * Description for Gets the backup configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BackupRequestInner> getBackupConfigurationWithResponse(String resourceGroupName, String name,
        Context context) {
        return getBackupConfigurationWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets the backup configuration of an app.
     * 
     * Description for Gets the backup configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BackupRequestInner getBackupConfiguration(String resourceGroupName, String name) {
        return getBackupConfigurationWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Gets the config reference app settings and status of an app
     * 
     * Description for Gets the config reference app settings and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ApiKVReferenceInner>>
        getAppSettingsKeyVaultReferencesSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getAppSettingsKeyVaultReferences(this.client.getEndpoint(),
                resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<ApiKVReferenceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the config reference app settings and status of an app
     * 
     * Description for Gets the config reference app settings and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ApiKVReferenceInner>>
        getAppSettingsKeyVaultReferencesSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getAppSettingsKeyVaultReferences(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets the config reference app settings and status of an app
     * 
     * Description for Gets the config reference app settings and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ApiKVReferenceInner> getAppSettingsKeyVaultReferencesAsync(String resourceGroupName, String name) {
        return new PagedFlux<>(() -> getAppSettingsKeyVaultReferencesSinglePageAsync(resourceGroupName, name),
            nextLink -> getAppSettingsKeyVaultReferencesNextSinglePageAsync(nextLink));
    }

    /**
     * Gets the config reference app settings and status of an app
     * 
     * Description for Gets the config reference app settings and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ApiKVReferenceInner> getAppSettingsKeyVaultReferencesAsync(String resourceGroupName, String name,
        Context context) {
        return new PagedFlux<>(() -> getAppSettingsKeyVaultReferencesSinglePageAsync(resourceGroupName, name, context),
            nextLink -> getAppSettingsKeyVaultReferencesNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets the config reference app settings and status of an app
     * 
     * Description for Gets the config reference app settings and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ApiKVReferenceInner> getAppSettingsKeyVaultReferences(String resourceGroupName, String name) {
        return new PagedIterable<>(getAppSettingsKeyVaultReferencesAsync(resourceGroupName, name));
    }

    /**
     * Gets the config reference app settings and status of an app
     * 
     * Description for Gets the config reference app settings and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ApiKVReferenceInner> getAppSettingsKeyVaultReferences(String resourceGroupName, String name,
        Context context) {
        return new PagedIterable<>(getAppSettingsKeyVaultReferencesAsync(resourceGroupName, name, context));
    }

    /**
     * Gets the config reference and status of an app
     * 
     * Description for Gets the config reference and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettingKey App Setting key name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ApiKVReferenceInner>> getAppSettingKeyVaultReferenceWithResponseAsync(String resourceGroupName,
        String name, String appSettingKey) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (appSettingKey == null) {
            return Mono.error(new IllegalArgumentException("Parameter appSettingKey is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getAppSettingKeyVaultReference(this.client.getEndpoint(), resourceGroupName,
                name, appSettingKey, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the config reference and status of an app
     * 
     * Description for Gets the config reference and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettingKey App Setting key name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ApiKVReferenceInner>> getAppSettingKeyVaultReferenceWithResponseAsync(
        String resourceGroupName, String name, String appSettingKey, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (appSettingKey == null) {
            return Mono.error(new IllegalArgumentException("Parameter appSettingKey is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getAppSettingKeyVaultReference(this.client.getEndpoint(), resourceGroupName, name, appSettingKey,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the config reference and status of an app
     * 
     * Description for Gets the config reference and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettingKey App Setting key name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ApiKVReferenceInner> getAppSettingKeyVaultReferenceAsync(String resourceGroupName, String name,
        String appSettingKey) {
        return getAppSettingKeyVaultReferenceWithResponseAsync(resourceGroupName, name, appSettingKey)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the config reference and status of an app
     * 
     * Description for Gets the config reference and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettingKey App Setting key name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ApiKVReferenceInner> getAppSettingKeyVaultReferenceWithResponse(String resourceGroupName,
        String name, String appSettingKey, Context context) {
        return getAppSettingKeyVaultReferenceWithResponseAsync(resourceGroupName, name, appSettingKey, context).block();
    }

    /**
     * Gets the config reference and status of an app
     * 
     * Description for Gets the config reference and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettingKey App Setting key name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ApiKVReferenceInner getAppSettingKeyVaultReference(String resourceGroupName, String name,
        String appSettingKey) {
        return getAppSettingKeyVaultReferenceWithResponse(resourceGroupName, name, appSettingKey, Context.NONE)
            .getValue();
    }

    /**
     * Gets the config reference app settings and status of an app
     * 
     * Description for Gets the config reference app settings and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ApiKVReferenceInner>>
        getSiteConnectionStringKeyVaultReferencesSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getSiteConnectionStringKeyVaultReferences(this.client.getEndpoint(),
                resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<ApiKVReferenceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the config reference app settings and status of an app
     * 
     * Description for Gets the config reference app settings and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ApiKVReferenceInner>> getSiteConnectionStringKeyVaultReferencesSinglePageAsync(
        String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getSiteConnectionStringKeyVaultReferences(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets the config reference app settings and status of an app
     * 
     * Description for Gets the config reference app settings and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferencesAsync(String resourceGroupName,
        String name) {
        return new PagedFlux<>(() -> getSiteConnectionStringKeyVaultReferencesSinglePageAsync(resourceGroupName, name),
            nextLink -> getSiteConnectionStringKeyVaultReferencesNextSinglePageAsync(nextLink));
    }

    /**
     * Gets the config reference app settings and status of an app
     * 
     * Description for Gets the config reference app settings and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferencesAsync(String resourceGroupName,
        String name, Context context) {
        return new PagedFlux<>(
            () -> getSiteConnectionStringKeyVaultReferencesSinglePageAsync(resourceGroupName, name, context),
            nextLink -> getSiteConnectionStringKeyVaultReferencesNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets the config reference app settings and status of an app
     * 
     * Description for Gets the config reference app settings and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferences(String resourceGroupName,
        String name) {
        return new PagedIterable<>(getSiteConnectionStringKeyVaultReferencesAsync(resourceGroupName, name));
    }

    /**
     * Gets the config reference app settings and status of an app
     * 
     * Description for Gets the config reference app settings and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferences(String resourceGroupName,
        String name, Context context) {
        return new PagedIterable<>(getSiteConnectionStringKeyVaultReferencesAsync(resourceGroupName, name, context));
    }

    /**
     * Gets the config reference and status of an app
     * 
     * Description for Gets the config reference and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStringKey The connectionStringKey parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ApiKVReferenceInner>> getSiteConnectionStringKeyVaultReferenceWithResponseAsync(
        String resourceGroupName, String name, String connectionStringKey) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (connectionStringKey == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter connectionStringKey is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getSiteConnectionStringKeyVaultReference(this.client.getEndpoint(),
                resourceGroupName, name, connectionStringKey, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the config reference and status of an app
     * 
     * Description for Gets the config reference and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStringKey The connectionStringKey parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ApiKVReferenceInner>> getSiteConnectionStringKeyVaultReferenceWithResponseAsync(
        String resourceGroupName, String name, String connectionStringKey, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (connectionStringKey == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter connectionStringKey is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getSiteConnectionStringKeyVaultReference(this.client.getEndpoint(), resourceGroupName, name,
            connectionStringKey, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the config reference and status of an app
     * 
     * Description for Gets the config reference and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStringKey The connectionStringKey parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferenceAsync(String resourceGroupName,
        String name, String connectionStringKey) {
        return getSiteConnectionStringKeyVaultReferenceWithResponseAsync(resourceGroupName, name, connectionStringKey)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the config reference and status of an app
     * 
     * Description for Gets the config reference and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStringKey The connectionStringKey parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferenceWithResponse(String resourceGroupName,
        String name, String connectionStringKey, Context context) {
        return getSiteConnectionStringKeyVaultReferenceWithResponseAsync(resourceGroupName, name, connectionStringKey,
            context).block();
    }

    /**
     * Gets the config reference and status of an app
     * 
     * Description for Gets the config reference and status of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStringKey The connectionStringKey parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ApiKVReferenceInner getSiteConnectionStringKeyVaultReference(String resourceGroupName, String name,
        String connectionStringKey) {
        return getSiteConnectionStringKeyVaultReferenceWithResponse(resourceGroupName, name, connectionStringKey,
            Context.NONE).getValue();
    }

    /**
     * Replaces the connection strings of an app.
     * 
     * Description for Replaces the connection strings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStrings Connection strings of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ConnectionStringDictionaryInner>> updateConnectionStringsWithResponseAsync(
        String resourceGroupName, String name, ConnectionStringDictionaryInner connectionStrings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectionStrings == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter connectionStrings is required and cannot be null."));
        } else {
            connectionStrings.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateConnectionStrings(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), connectionStrings, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Replaces the connection strings of an app.
     * 
     * Description for Replaces the connection strings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStrings Connection strings of the app or deployment slot. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ConnectionStringDictionaryInner>> updateConnectionStringsWithResponseAsync(
        String resourceGroupName, String name, ConnectionStringDictionaryInner connectionStrings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectionStrings == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter connectionStrings is required and cannot be null."));
        } else {
            connectionStrings.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateConnectionStrings(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), connectionStrings, accept, context);
    }

    /**
     * Replaces the connection strings of an app.
     * 
     * Description for Replaces the connection strings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStrings Connection strings of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ConnectionStringDictionaryInner> updateConnectionStringsAsync(String resourceGroupName, String name,
        ConnectionStringDictionaryInner connectionStrings) {
        return updateConnectionStringsWithResponseAsync(resourceGroupName, name, connectionStrings)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Replaces the connection strings of an app.
     * 
     * Description for Replaces the connection strings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStrings Connection strings of the app or deployment slot. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ConnectionStringDictionaryInner> updateConnectionStringsWithResponse(String resourceGroupName,
        String name, ConnectionStringDictionaryInner connectionStrings, Context context) {
        return updateConnectionStringsWithResponseAsync(resourceGroupName, name, connectionStrings, context).block();
    }

    /**
     * Replaces the connection strings of an app.
     * 
     * Description for Replaces the connection strings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStrings Connection strings of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ConnectionStringDictionaryInner updateConnectionStrings(String resourceGroupName, String name,
        ConnectionStringDictionaryInner connectionStrings) {
        return updateConnectionStringsWithResponse(resourceGroupName, name, connectionStrings, Context.NONE).getValue();
    }

    /**
     * Gets the connection strings of an app.
     * 
     * Description for Gets the connection strings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ConnectionStringDictionaryInner>>
        listConnectionStringsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listConnectionStrings(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the connection strings of an app.
     * 
     * Description for Gets the connection strings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ConnectionStringDictionaryInner>>
        listConnectionStringsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listConnectionStrings(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the connection strings of an app.
     * 
     * Description for Gets the connection strings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ConnectionStringDictionaryInner> listConnectionStringsAsync(String resourceGroupName, String name) {
        return listConnectionStringsWithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the connection strings of an app.
     * 
     * Description for Gets the connection strings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ConnectionStringDictionaryInner> listConnectionStringsWithResponse(String resourceGroupName,
        String name, Context context) {
        return listConnectionStringsWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets the connection strings of an app.
     * 
     * Description for Gets the connection strings of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ConnectionStringDictionaryInner listConnectionStrings(String resourceGroupName, String name) {
        return listConnectionStringsWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Gets the logging configuration of an app.
     * 
     * Description for Gets the logging configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SiteLogsConfigInner>> getDiagnosticLogsConfigurationWithResponseAsync(String resourceGroupName,
        String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getDiagnosticLogsConfiguration(this.client.getEndpoint(), resourceGroupName,
                name, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the logging configuration of an app.
     * 
     * Description for Gets the logging configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SiteLogsConfigInner>>
        getDiagnosticLogsConfigurationWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getDiagnosticLogsConfiguration(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the logging configuration of an app.
     * 
     * Description for Gets the logging configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SiteLogsConfigInner> getDiagnosticLogsConfigurationAsync(String resourceGroupName, String name) {
        return getDiagnosticLogsConfigurationWithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the logging configuration of an app.
     * 
     * Description for Gets the logging configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SiteLogsConfigInner> getDiagnosticLogsConfigurationWithResponse(String resourceGroupName,
        String name, Context context) {
        return getDiagnosticLogsConfigurationWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets the logging configuration of an app.
     * 
     * Description for Gets the logging configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SiteLogsConfigInner getDiagnosticLogsConfiguration(String resourceGroupName, String name) {
        return getDiagnosticLogsConfigurationWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Updates the logging configuration of an app.
     * 
     * Description for Updates the logging configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteLogsConfig A SiteLogsConfig JSON object that contains the logging configuration to change in the
     * "properties" property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SiteLogsConfigInner>> updateDiagnosticLogsConfigWithResponseAsync(String resourceGroupName,
        String name, SiteLogsConfigInner siteLogsConfig) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteLogsConfig == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteLogsConfig is required and cannot be null."));
        } else {
            siteLogsConfig.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateDiagnosticLogsConfig(this.client.getEndpoint(), resourceGroupName,
                name, this.client.getSubscriptionId(), this.client.getApiVersion(), siteLogsConfig, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates the logging configuration of an app.
     * 
     * Description for Updates the logging configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteLogsConfig A SiteLogsConfig JSON object that contains the logging configuration to change in the
     * "properties" property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SiteLogsConfigInner>> updateDiagnosticLogsConfigWithResponseAsync(String resourceGroupName,
        String name, SiteLogsConfigInner siteLogsConfig, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteLogsConfig == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteLogsConfig is required and cannot be null."));
        } else {
            siteLogsConfig.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateDiagnosticLogsConfig(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), siteLogsConfig, accept, context);
    }

    /**
     * Updates the logging configuration of an app.
     * 
     * Description for Updates the logging configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteLogsConfig A SiteLogsConfig JSON object that contains the logging configuration to change in the
     * "properties" property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SiteLogsConfigInner> updateDiagnosticLogsConfigAsync(String resourceGroupName, String name,
        SiteLogsConfigInner siteLogsConfig) {
        return updateDiagnosticLogsConfigWithResponseAsync(resourceGroupName, name, siteLogsConfig)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the logging configuration of an app.
     * 
     * Description for Updates the logging configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteLogsConfig A SiteLogsConfig JSON object that contains the logging configuration to change in the
     * "properties" property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SiteLogsConfigInner> updateDiagnosticLogsConfigWithResponse(String resourceGroupName, String name,
        SiteLogsConfigInner siteLogsConfig, Context context) {
        return updateDiagnosticLogsConfigWithResponseAsync(resourceGroupName, name, siteLogsConfig, context).block();
    }

    /**
     * Updates the logging configuration of an app.
     * 
     * Description for Updates the logging configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteLogsConfig A SiteLogsConfig JSON object that contains the logging configuration to change in the
     * "properties" property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SiteLogsConfigInner updateDiagnosticLogsConfig(String resourceGroupName, String name,
        SiteLogsConfigInner siteLogsConfig) {
        return updateDiagnosticLogsConfigWithResponse(resourceGroupName, name, siteLogsConfig, Context.NONE).getValue();
    }

    /**
     * Replaces the metadata of an app.
     * 
     * Description for Replaces the metadata of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param metadata Edited metadata of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>> updateMetadataWithResponseAsync(String resourceGroupName, String name,
        StringDictionaryInner metadata) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (metadata == null) {
            return Mono.error(new IllegalArgumentException("Parameter metadata is required and cannot be null."));
        } else {
            metadata.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateMetadata(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), metadata, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Replaces the metadata of an app.
     * 
     * Description for Replaces the metadata of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param metadata Edited metadata of the app or deployment slot. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>> updateMetadataWithResponseAsync(String resourceGroupName, String name,
        StringDictionaryInner metadata, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (metadata == null) {
            return Mono.error(new IllegalArgumentException("Parameter metadata is required and cannot be null."));
        } else {
            metadata.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateMetadata(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), metadata, accept, context);
    }

    /**
     * Replaces the metadata of an app.
     * 
     * Description for Replaces the metadata of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param metadata Edited metadata of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StringDictionaryInner> updateMetadataAsync(String resourceGroupName, String name,
        StringDictionaryInner metadata) {
        return updateMetadataWithResponseAsync(resourceGroupName, name, metadata)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Replaces the metadata of an app.
     * 
     * Description for Replaces the metadata of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param metadata Edited metadata of the app or deployment slot. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StringDictionaryInner> updateMetadataWithResponse(String resourceGroupName, String name,
        StringDictionaryInner metadata, Context context) {
        return updateMetadataWithResponseAsync(resourceGroupName, name, metadata, context).block();
    }

    /**
     * Replaces the metadata of an app.
     * 
     * Description for Replaces the metadata of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param metadata Edited metadata of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StringDictionaryInner updateMetadata(String resourceGroupName, String name, StringDictionaryInner metadata) {
        return updateMetadataWithResponse(resourceGroupName, name, metadata, Context.NONE).getValue();
    }

    /**
     * Gets the metadata of an app.
     * 
     * Description for Gets the metadata of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>> listMetadataWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listMetadata(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the metadata of an app.
     * 
     * Description for Gets the metadata of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>> listMetadataWithResponseAsync(String resourceGroupName, String name,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listMetadata(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(),
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the metadata of an app.
     * 
     * Description for Gets the metadata of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StringDictionaryInner> listMetadataAsync(String resourceGroupName, String name) {
        return listMetadataWithResponseAsync(resourceGroupName, name).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the metadata of an app.
     * 
     * Description for Gets the metadata of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StringDictionaryInner> listMetadataWithResponse(String resourceGroupName, String name,
        Context context) {
        return listMetadataWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets the metadata of an app.
     * 
     * Description for Gets the metadata of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StringDictionaryInner listMetadata(String resourceGroupName, String name) {
        return listMetadataWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Gets the Git/FTP publishing credentials of an app.
     * 
     * Description for Gets the Git/FTP publishing credentials of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> listPublishingCredentialsWithResponseAsync(String resourceGroupName,
        String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listPublishingCredentials(this.client.getEndpoint(), resourceGroupName,
                name, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the Git/FTP publishing credentials of an app.
     * 
     * Description for Gets the Git/FTP publishing credentials of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> listPublishingCredentialsWithResponseAsync(String resourceGroupName,
        String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listPublishingCredentials(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the Git/FTP publishing credentials of an app.
     * 
     * Description for Gets the Git/FTP publishing credentials of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<UserInner>, UserInner> beginListPublishingCredentialsAsync(String resourceGroupName,
        String name) {
        Mono<Response<Flux<ByteBuffer>>> mono = listPublishingCredentialsWithResponseAsync(resourceGroupName, name);
        return this.client.<UserInner, UserInner>getLroResult(mono, this.client.getHttpPipeline(), UserInner.class,
            UserInner.class, this.client.getContext());
    }

    /**
     * Gets the Git/FTP publishing credentials of an app.
     * 
     * Description for Gets the Git/FTP publishing credentials of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<UserInner>, UserInner> beginListPublishingCredentialsAsync(String resourceGroupName,
        String name, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = listPublishingCredentialsWithResponseAsync(resourceGroupName, name, context);
        return this.client.<UserInner, UserInner>getLroResult(mono, this.client.getHttpPipeline(), UserInner.class,
            UserInner.class, context);
    }

    /**
     * Gets the Git/FTP publishing credentials of an app.
     * 
     * Description for Gets the Git/FTP publishing credentials of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<UserInner>, UserInner> beginListPublishingCredentials(String resourceGroupName,
        String name) {
        return this.beginListPublishingCredentialsAsync(resourceGroupName, name).getSyncPoller();
    }

    /**
     * Gets the Git/FTP publishing credentials of an app.
     * 
     * Description for Gets the Git/FTP publishing credentials of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<UserInner>, UserInner> beginListPublishingCredentials(String resourceGroupName,
        String name, Context context) {
        return this.beginListPublishingCredentialsAsync(resourceGroupName, name, context).getSyncPoller();
    }

    /**
     * Gets the Git/FTP publishing credentials of an app.
     * 
     * Description for Gets the Git/FTP publishing credentials of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<UserInner> listPublishingCredentialsAsync(String resourceGroupName, String name) {
        return beginListPublishingCredentialsAsync(resourceGroupName, name).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets the Git/FTP publishing credentials of an app.
     * 
     * Description for Gets the Git/FTP publishing credentials of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<UserInner> listPublishingCredentialsAsync(String resourceGroupName, String name, Context context) {
        return beginListPublishingCredentialsAsync(resourceGroupName, name, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets the Git/FTP publishing credentials of an app.
     * 
     * Description for Gets the Git/FTP publishing credentials of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public UserInner listPublishingCredentials(String resourceGroupName, String name) {
        return listPublishingCredentialsAsync(resourceGroupName, name).block();
    }

    /**
     * Gets the Git/FTP publishing credentials of an app.
     * 
     * Description for Gets the Git/FTP publishing credentials of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public UserInner listPublishingCredentials(String resourceGroupName, String name, Context context) {
        return listPublishingCredentialsAsync(resourceGroupName, name, context).block();
    }

    /**
     * Updates the Push settings associated with web app.
     * 
     * Description for Updates the Push settings associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param pushSettings Push settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PushSettingsInner>> updateSitePushSettingsWithResponseAsync(String resourceGroupName,
        String name, PushSettingsInner pushSettings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (pushSettings == null) {
            return Mono.error(new IllegalArgumentException("Parameter pushSettings is required and cannot be null."));
        } else {
            pushSettings.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateSitePushSettings(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), pushSettings, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates the Push settings associated with web app.
     * 
     * Description for Updates the Push settings associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param pushSettings Push settings associated with web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PushSettingsInner>> updateSitePushSettingsWithResponseAsync(String resourceGroupName,
        String name, PushSettingsInner pushSettings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (pushSettings == null) {
            return Mono.error(new IllegalArgumentException("Parameter pushSettings is required and cannot be null."));
        } else {
            pushSettings.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateSitePushSettings(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), pushSettings, accept, context);
    }

    /**
     * Updates the Push settings associated with web app.
     * 
     * Description for Updates the Push settings associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param pushSettings Push settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PushSettingsInner> updateSitePushSettingsAsync(String resourceGroupName, String name,
        PushSettingsInner pushSettings) {
        return updateSitePushSettingsWithResponseAsync(resourceGroupName, name, pushSettings)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the Push settings associated with web app.
     * 
     * Description for Updates the Push settings associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param pushSettings Push settings associated with web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PushSettingsInner> updateSitePushSettingsWithResponse(String resourceGroupName, String name,
        PushSettingsInner pushSettings, Context context) {
        return updateSitePushSettingsWithResponseAsync(resourceGroupName, name, pushSettings, context).block();
    }

    /**
     * Updates the Push settings associated with web app.
     * 
     * Description for Updates the Push settings associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param pushSettings Push settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PushSettingsInner updateSitePushSettings(String resourceGroupName, String name,
        PushSettingsInner pushSettings) {
        return updateSitePushSettingsWithResponse(resourceGroupName, name, pushSettings, Context.NONE).getValue();
    }

    /**
     * Gets the Push settings associated with web app.
     * 
     * Description for Gets the Push settings associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PushSettingsInner>> listSitePushSettingsWithResponseAsync(String resourceGroupName,
        String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listSitePushSettings(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the Push settings associated with web app.
     * 
     * Description for Gets the Push settings associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PushSettingsInner>> listSitePushSettingsWithResponseAsync(String resourceGroupName,
        String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listSitePushSettings(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the Push settings associated with web app.
     * 
     * Description for Gets the Push settings associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PushSettingsInner> listSitePushSettingsAsync(String resourceGroupName, String name) {
        return listSitePushSettingsWithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the Push settings associated with web app.
     * 
     * Description for Gets the Push settings associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PushSettingsInner> listSitePushSettingsWithResponse(String resourceGroupName, String name,
        Context context) {
        return listSitePushSettingsWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets the Push settings associated with web app.
     * 
     * Description for Gets the Push settings associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PushSettingsInner listSitePushSettings(String resourceGroupName, String name) {
        return listSitePushSettingsWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Gets the names of app settings and connection strings that stick to the slot (not swapped).
     * 
     * Description for Gets the names of app settings and connection strings that stick to the slot (not swapped).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return slot Config names azure resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SlotConfigNamesResourceInner>>
        listSlotConfigurationNamesWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listSlotConfigurationNames(this.client.getEndpoint(), resourceGroupName,
                name, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the names of app settings and connection strings that stick to the slot (not swapped).
     * 
     * Description for Gets the names of app settings and connection strings that stick to the slot (not swapped).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return slot Config names azure resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SlotConfigNamesResourceInner>>
        listSlotConfigurationNamesWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listSlotConfigurationNames(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the names of app settings and connection strings that stick to the slot (not swapped).
     * 
     * Description for Gets the names of app settings and connection strings that stick to the slot (not swapped).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return slot Config names azure resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SlotConfigNamesResourceInner> listSlotConfigurationNamesAsync(String resourceGroupName, String name) {
        return listSlotConfigurationNamesWithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the names of app settings and connection strings that stick to the slot (not swapped).
     * 
     * Description for Gets the names of app settings and connection strings that stick to the slot (not swapped).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return slot Config names azure resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SlotConfigNamesResourceInner> listSlotConfigurationNamesWithResponse(String resourceGroupName,
        String name, Context context) {
        return listSlotConfigurationNamesWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets the names of app settings and connection strings that stick to the slot (not swapped).
     * 
     * Description for Gets the names of app settings and connection strings that stick to the slot (not swapped).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return slot Config names azure resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SlotConfigNamesResourceInner listSlotConfigurationNames(String resourceGroupName, String name) {
        return listSlotConfigurationNamesWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Updates the names of application settings and connection string that remain with the slot during swap operation.
     * 
     * Description for Updates the names of application settings and connection string that remain with the slot during
     * swap operation.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotConfigNames Names of application settings and connection strings. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return slot Config names azure resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SlotConfigNamesResourceInner>> updateSlotConfigurationNamesWithResponseAsync(
        String resourceGroupName, String name, SlotConfigNamesResourceInner slotConfigNames) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (slotConfigNames == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter slotConfigNames is required and cannot be null."));
        } else {
            slotConfigNames.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateSlotConfigurationNames(this.client.getEndpoint(), resourceGroupName,
                name, this.client.getSubscriptionId(), this.client.getApiVersion(), slotConfigNames, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates the names of application settings and connection string that remain with the slot during swap operation.
     * 
     * Description for Updates the names of application settings and connection string that remain with the slot during
     * swap operation.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotConfigNames Names of application settings and connection strings. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return slot Config names azure resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SlotConfigNamesResourceInner>> updateSlotConfigurationNamesWithResponseAsync(
        String resourceGroupName, String name, SlotConfigNamesResourceInner slotConfigNames, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (slotConfigNames == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter slotConfigNames is required and cannot be null."));
        } else {
            slotConfigNames.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateSlotConfigurationNames(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), slotConfigNames, accept, context);
    }

    /**
     * Updates the names of application settings and connection string that remain with the slot during swap operation.
     * 
     * Description for Updates the names of application settings and connection string that remain with the slot during
     * swap operation.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotConfigNames Names of application settings and connection strings. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return slot Config names azure resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SlotConfigNamesResourceInner> updateSlotConfigurationNamesAsync(String resourceGroupName, String name,
        SlotConfigNamesResourceInner slotConfigNames) {
        return updateSlotConfigurationNamesWithResponseAsync(resourceGroupName, name, slotConfigNames)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the names of application settings and connection string that remain with the slot during swap operation.
     * 
     * Description for Updates the names of application settings and connection string that remain with the slot during
     * swap operation.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotConfigNames Names of application settings and connection strings. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return slot Config names azure resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SlotConfigNamesResourceInner> updateSlotConfigurationNamesWithResponse(String resourceGroupName,
        String name, SlotConfigNamesResourceInner slotConfigNames, Context context) {
        return updateSlotConfigurationNamesWithResponseAsync(resourceGroupName, name, slotConfigNames, context).block();
    }

    /**
     * Updates the names of application settings and connection string that remain with the slot during swap operation.
     * 
     * Description for Updates the names of application settings and connection string that remain with the slot during
     * swap operation.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotConfigNames Names of application settings and connection strings. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return slot Config names azure resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SlotConfigNamesResourceInner updateSlotConfigurationNames(String resourceGroupName, String name,
        SlotConfigNamesResourceInner slotConfigNames) {
        return updateSlotConfigurationNamesWithResponse(resourceGroupName, name, slotConfigNames, Context.NONE)
            .getValue();
    }

    /**
     * Gets the configuration of an app, such as platform version and bitness, default documents, virtual applications,
     * Always On, etc.
     * 
     * Description for Gets the configuration of an app, such as platform version and bitness, default documents,
     * virtual applications, Always On, etc.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SiteConfigResourceInner>> getConfigurationWithResponseAsync(String resourceGroupName,
        String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getConfiguration(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the configuration of an app, such as platform version and bitness, default documents, virtual applications,
     * Always On, etc.
     * 
     * Description for Gets the configuration of an app, such as platform version and bitness, default documents,
     * virtual applications, Always On, etc.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SiteConfigResourceInner>> getConfigurationWithResponseAsync(String resourceGroupName,
        String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getConfiguration(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the configuration of an app, such as platform version and bitness, default documents, virtual applications,
     * Always On, etc.
     * 
     * Description for Gets the configuration of an app, such as platform version and bitness, default documents,
     * virtual applications, Always On, etc.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SiteConfigResourceInner> getConfigurationAsync(String resourceGroupName, String name) {
        return getConfigurationWithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the configuration of an app, such as platform version and bitness, default documents, virtual applications,
     * Always On, etc.
     * 
     * Description for Gets the configuration of an app, such as platform version and bitness, default documents,
     * virtual applications, Always On, etc.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SiteConfigResourceInner> getConfigurationWithResponse(String resourceGroupName, String name,
        Context context) {
        return getConfigurationWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets the configuration of an app, such as platform version and bitness, default documents, virtual applications,
     * Always On, etc.
     * 
     * Description for Gets the configuration of an app, such as platform version and bitness, default documents,
     * virtual applications, Always On, etc.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SiteConfigResourceInner getConfiguration(String resourceGroupName, String name) {
        return getConfigurationWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Updates the configuration of an app.
     * 
     * Description for Updates the configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateConfigurationWithResponseAsync(String resourceGroupName,
        String name, SiteConfigResourceInner siteConfig) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteConfig == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteConfig is required and cannot be null."));
        } else {
            siteConfig.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdateConfiguration(this.client.getEndpoint(), resourceGroupName,
                name, this.client.getSubscriptionId(), this.client.getApiVersion(), siteConfig, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates the configuration of an app.
     * 
     * Description for Updates the configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateConfigurationWithResponseAsync(String resourceGroupName,
        String name, SiteConfigResourceInner siteConfig, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteConfig == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteConfig is required and cannot be null."));
        } else {
            siteConfig.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdateConfiguration(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), siteConfig, accept, context);
    }

    /**
     * Updates the configuration of an app.
     * 
     * Description for Updates the configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of web app configuration ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<SiteConfigResourceInner>, SiteConfigResourceInner>
        beginCreateOrUpdateConfigurationAsync(String resourceGroupName, String name,
            SiteConfigResourceInner siteConfig) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateConfigurationWithResponseAsync(resourceGroupName, name, siteConfig);
        return this.client.<SiteConfigResourceInner, SiteConfigResourceInner>getLroResult(mono,
            this.client.getHttpPipeline(), SiteConfigResourceInner.class, SiteConfigResourceInner.class,
            this.client.getContext());
    }

    /**
     * Updates the configuration of an app.
     * 
     * Description for Updates the configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of web app configuration ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SiteConfigResourceInner>, SiteConfigResourceInner>
        beginCreateOrUpdateConfigurationAsync(String resourceGroupName, String name, SiteConfigResourceInner siteConfig,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateConfigurationWithResponseAsync(resourceGroupName, name, siteConfig, context);
        return this.client.<SiteConfigResourceInner, SiteConfigResourceInner>getLroResult(mono,
            this.client.getHttpPipeline(), SiteConfigResourceInner.class, SiteConfigResourceInner.class, context);
    }

    /**
     * Updates the configuration of an app.
     * 
     * Description for Updates the configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of web app configuration ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SiteConfigResourceInner>, SiteConfigResourceInner>
        beginCreateOrUpdateConfiguration(String resourceGroupName, String name, SiteConfigResourceInner siteConfig) {
        return this.beginCreateOrUpdateConfigurationAsync(resourceGroupName, name, siteConfig).getSyncPoller();
    }

    /**
     * Updates the configuration of an app.
     * 
     * Description for Updates the configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of web app configuration ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SiteConfigResourceInner>, SiteConfigResourceInner> beginCreateOrUpdateConfiguration(
        String resourceGroupName, String name, SiteConfigResourceInner siteConfig, Context context) {
        return this.beginCreateOrUpdateConfigurationAsync(resourceGroupName, name, siteConfig, context).getSyncPoller();
    }

    /**
     * Updates the configuration of an app.
     * 
     * Description for Updates the configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SiteConfigResourceInner> createOrUpdateConfigurationAsync(String resourceGroupName, String name,
        SiteConfigResourceInner siteConfig) {
        return beginCreateOrUpdateConfigurationAsync(resourceGroupName, name, siteConfig).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates the configuration of an app.
     * 
     * Description for Updates the configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SiteConfigResourceInner> createOrUpdateConfigurationAsync(String resourceGroupName, String name,
        SiteConfigResourceInner siteConfig, Context context) {
        return beginCreateOrUpdateConfigurationAsync(resourceGroupName, name, siteConfig, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates the configuration of an app.
     * 
     * Description for Updates the configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SiteConfigResourceInner createOrUpdateConfiguration(String resourceGroupName, String name,
        SiteConfigResourceInner siteConfig) {
        return createOrUpdateConfigurationAsync(resourceGroupName, name, siteConfig).block();
    }

    /**
     * Updates the configuration of an app.
     * 
     * Description for Updates the configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SiteConfigResourceInner createOrUpdateConfiguration(String resourceGroupName, String name,
        SiteConfigResourceInner siteConfig, Context context) {
        return createOrUpdateConfigurationAsync(resourceGroupName, name, siteConfig, context).block();
    }

    /**
     * Updates the configuration of an app.
     * 
     * Description for Updates the configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SiteConfigResourceInner>> updateConfigurationWithResponseAsync(String resourceGroupName,
        String name, SiteConfigResourceInner siteConfig) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteConfig == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteConfig is required and cannot be null."));
        } else {
            siteConfig.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateConfiguration(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), siteConfig, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates the configuration of an app.
     * 
     * Description for Updates the configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SiteConfigResourceInner>> updateConfigurationWithResponseAsync(String resourceGroupName,
        String name, SiteConfigResourceInner siteConfig, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteConfig == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteConfig is required and cannot be null."));
        } else {
            siteConfig.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateConfiguration(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), siteConfig, accept, context);
    }

    /**
     * Updates the configuration of an app.
     * 
     * Description for Updates the configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SiteConfigResourceInner> updateConfigurationAsync(String resourceGroupName, String name,
        SiteConfigResourceInner siteConfig) {
        return updateConfigurationWithResponseAsync(resourceGroupName, name, siteConfig)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the configuration of an app.
     * 
     * Description for Updates the configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SiteConfigResourceInner> updateConfigurationWithResponse(String resourceGroupName, String name,
        SiteConfigResourceInner siteConfig, Context context) {
        return updateConfigurationWithResponseAsync(resourceGroupName, name, siteConfig, context).block();
    }

    /**
     * Updates the configuration of an app.
     * 
     * Description for Updates the configuration of an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SiteConfigResourceInner updateConfiguration(String resourceGroupName, String name,
        SiteConfigResourceInner siteConfig) {
        return updateConfigurationWithResponse(resourceGroupName, name, siteConfig, Context.NONE).getValue();
    }

    /**
     * Gets a list of web app configuration snapshots identifiers. Each element of the list contains a timestamp and the
     * ID of the snapshot.
     * 
     * Description for Gets a list of web app configuration snapshots identifiers. Each element of the list contains a
     * timestamp and the ID of the snapshot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of metadata for the app configuration snapshots that can be restored along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SiteConfigurationSnapshotInfoInner>>
        listConfigurationSnapshotInfoSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listConfigurationSnapshotInfo(this.client.getEndpoint(), resourceGroupName,
                name, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<SiteConfigurationSnapshotInfoInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a list of web app configuration snapshots identifiers. Each element of the list contains a timestamp and the
     * ID of the snapshot.
     * 
     * Description for Gets a list of web app configuration snapshots identifiers. Each element of the list contains a
     * timestamp and the ID of the snapshot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of metadata for the app configuration snapshots that can be restored along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SiteConfigurationSnapshotInfoInner>>
        listConfigurationSnapshotInfoSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listConfigurationSnapshotInfo(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets a list of web app configuration snapshots identifiers. Each element of the list contains a timestamp and the
     * ID of the snapshot.
     * 
     * Description for Gets a list of web app configuration snapshots identifiers. Each element of the list contains a
     * timestamp and the ID of the snapshot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of metadata for the app configuration snapshots that can be restored as paginated response
     * with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SiteConfigurationSnapshotInfoInner> listConfigurationSnapshotInfoAsync(String resourceGroupName,
        String name) {
        return new PagedFlux<>(() -> listConfigurationSnapshotInfoSinglePageAsync(resourceGroupName, name),
            nextLink -> listConfigurationSnapshotInfoNextSinglePageAsync(nextLink));
    }

    /**
     * Gets a list of web app configuration snapshots identifiers. Each element of the list contains a timestamp and the
     * ID of the snapshot.
     * 
     * Description for Gets a list of web app configuration snapshots identifiers. Each element of the list contains a
     * timestamp and the ID of the snapshot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of metadata for the app configuration snapshots that can be restored as paginated response
     * with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SiteConfigurationSnapshotInfoInner> listConfigurationSnapshotInfoAsync(String resourceGroupName,
        String name, Context context) {
        return new PagedFlux<>(() -> listConfigurationSnapshotInfoSinglePageAsync(resourceGroupName, name, context),
            nextLink -> listConfigurationSnapshotInfoNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets a list of web app configuration snapshots identifiers. Each element of the list contains a timestamp and the
     * ID of the snapshot.
     * 
     * Description for Gets a list of web app configuration snapshots identifiers. Each element of the list contains a
     * timestamp and the ID of the snapshot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of metadata for the app configuration snapshots that can be restored as paginated response
     * with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SiteConfigurationSnapshotInfoInner> listConfigurationSnapshotInfo(String resourceGroupName,
        String name) {
        return new PagedIterable<>(listConfigurationSnapshotInfoAsync(resourceGroupName, name));
    }

    /**
     * Gets a list of web app configuration snapshots identifiers. Each element of the list contains a timestamp and the
     * ID of the snapshot.
     * 
     * Description for Gets a list of web app configuration snapshots identifiers. Each element of the list contains a
     * timestamp and the ID of the snapshot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of metadata for the app configuration snapshots that can be restored as paginated response
     * with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SiteConfigurationSnapshotInfoInner> listConfigurationSnapshotInfo(String resourceGroupName,
        String name, Context context) {
        return new PagedIterable<>(listConfigurationSnapshotInfoAsync(resourceGroupName, name, context));
    }

    /**
     * Gets a snapshot of the configuration of an app at a previous point in time.
     * 
     * Description for Gets a snapshot of the configuration of an app at a previous point in time.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SiteConfigResourceInner>> getConfigurationSnapshotWithResponseAsync(String resourceGroupName,
        String name, String snapshotId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (snapshotId == null) {
            return Mono.error(new IllegalArgumentException("Parameter snapshotId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getConfigurationSnapshot(this.client.getEndpoint(), resourceGroupName, name,
                snapshotId, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a snapshot of the configuration of an app at a previous point in time.
     * 
     * Description for Gets a snapshot of the configuration of an app at a previous point in time.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SiteConfigResourceInner>> getConfigurationSnapshotWithResponseAsync(String resourceGroupName,
        String name, String snapshotId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (snapshotId == null) {
            return Mono.error(new IllegalArgumentException("Parameter snapshotId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getConfigurationSnapshot(this.client.getEndpoint(), resourceGroupName, name, snapshotId,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets a snapshot of the configuration of an app at a previous point in time.
     * 
     * Description for Gets a snapshot of the configuration of an app at a previous point in time.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SiteConfigResourceInner> getConfigurationSnapshotAsync(String resourceGroupName, String name,
        String snapshotId) {
        return getConfigurationSnapshotWithResponseAsync(resourceGroupName, name, snapshotId)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a snapshot of the configuration of an app at a previous point in time.
     * 
     * Description for Gets a snapshot of the configuration of an app at a previous point in time.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SiteConfigResourceInner> getConfigurationSnapshotWithResponse(String resourceGroupName, String name,
        String snapshotId, Context context) {
        return getConfigurationSnapshotWithResponseAsync(resourceGroupName, name, snapshotId, context).block();
    }

    /**
     * Gets a snapshot of the configuration of an app at a previous point in time.
     * 
     * Description for Gets a snapshot of the configuration of an app at a previous point in time.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SiteConfigResourceInner getConfigurationSnapshot(String resourceGroupName, String name, String snapshotId) {
        return getConfigurationSnapshotWithResponse(resourceGroupName, name, snapshotId, Context.NONE).getValue();
    }

    /**
     * Reverts the configuration of an app to a previous snapshot.
     * 
     * Description for Reverts the configuration of an app to a previous snapshot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> recoverSiteConfigurationSnapshotWithResponseAsync(String resourceGroupName, String name,
        String snapshotId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (snapshotId == null) {
            return Mono.error(new IllegalArgumentException("Parameter snapshotId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.recoverSiteConfigurationSnapshot(this.client.getEndpoint(), resourceGroupName, name,
                    snapshotId, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Reverts the configuration of an app to a previous snapshot.
     * 
     * Description for Reverts the configuration of an app to a previous snapshot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> recoverSiteConfigurationSnapshotWithResponseAsync(String resourceGroupName,
        String name, String snapshotId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (snapshotId == null) {
            return Mono.error(new IllegalArgumentException("Parameter snapshotId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.recoverSiteConfigurationSnapshot(this.client.getEndpoint(), resourceGroupName, name, snapshotId,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Reverts the configuration of an app to a previous snapshot.
     * 
     * Description for Reverts the configuration of an app to a previous snapshot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> recoverSiteConfigurationSnapshotAsync(String resourceGroupName, String name, String snapshotId) {
        return recoverSiteConfigurationSnapshotWithResponseAsync(resourceGroupName, name, snapshotId)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Reverts the configuration of an app to a previous snapshot.
     * 
     * Description for Reverts the configuration of an app to a previous snapshot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> recoverSiteConfigurationSnapshotWithResponse(String resourceGroupName, String name,
        String snapshotId, Context context) {
        return recoverSiteConfigurationSnapshotWithResponseAsync(resourceGroupName, name, snapshotId, context).block();
    }

    /**
     * Reverts the configuration of an app to a previous snapshot.
     * 
     * Description for Reverts the configuration of an app to a previous snapshot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void recoverSiteConfigurationSnapshot(String resourceGroupName, String name, String snapshotId) {
        recoverSiteConfigurationSnapshotWithResponse(resourceGroupName, name, snapshotId, Context.NONE);
    }

    /**
     * Gets the last lines of docker logs for the given site
     * 
     * Description for Gets the last lines of docker logs for the given site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getWebSiteContainerLogsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/octet-stream";
        return FluxUtil
            .withContext(context -> service.getWebSiteContainerLogs(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the last lines of docker logs for the given site
     * 
     * Description for Gets the last lines of docker logs for the given site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<BinaryData>> getWebSiteContainerLogsWithResponseAsync(String resourceGroupName, String name,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/octet-stream";
        context = this.client.mergeContext(context);
        return service.getWebSiteContainerLogs(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the last lines of docker logs for the given site
     * 
     * Description for Gets the last lines of docker logs for the given site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BinaryData> getWebSiteContainerLogsAsync(String resourceGroupName, String name) {
        return getWebSiteContainerLogsWithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the last lines of docker logs for the given site
     * 
     * Description for Gets the last lines of docker logs for the given site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getWebSiteContainerLogsWithResponse(String resourceGroupName, String name,
        Context context) {
        return getWebSiteContainerLogsWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets the last lines of docker logs for the given site
     * 
     * Description for Gets the last lines of docker logs for the given site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BinaryData getWebSiteContainerLogs(String resourceGroupName, String name) {
        return getWebSiteContainerLogsWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Gets the ZIP archived docker log files for the given site
     * 
     * Description for Gets the ZIP archived docker log files for the given site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getContainerLogsZipWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/zip";
        return FluxUtil
            .withContext(context -> service.getContainerLogsZip(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the ZIP archived docker log files for the given site
     * 
     * Description for Gets the ZIP archived docker log files for the given site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<BinaryData>> getContainerLogsZipWithResponseAsync(String resourceGroupName, String name,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/zip";
        context = this.client.mergeContext(context);
        return service.getContainerLogsZip(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the ZIP archived docker log files for the given site
     * 
     * Description for Gets the ZIP archived docker log files for the given site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BinaryData> getContainerLogsZipAsync(String resourceGroupName, String name) {
        return getContainerLogsZipWithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the ZIP archived docker log files for the given site
     * 
     * Description for Gets the ZIP archived docker log files for the given site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getContainerLogsZipWithResponse(String resourceGroupName, String name,
        Context context) {
        return getContainerLogsZipWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets the ZIP archived docker log files for the given site
     * 
     * Description for Gets the ZIP archived docker log files for the given site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BinaryData getContainerLogsZip(String resourceGroupName, String name) {
        return getContainerLogsZipWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * List continuous web jobs for an app, or a deployment slot.
     * 
     * Description for List continuous web jobs for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu continuous web job information elements along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ContinuousWebJobInner>> listContinuousWebJobsSinglePageAsync(String resourceGroupName,
        String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listContinuousWebJobs(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<ContinuousWebJobInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List continuous web jobs for an app, or a deployment slot.
     * 
     * Description for List continuous web jobs for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu continuous web job information elements along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ContinuousWebJobInner>> listContinuousWebJobsSinglePageAsync(String resourceGroupName,
        String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listContinuousWebJobs(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * List continuous web jobs for an app, or a deployment slot.
     * 
     * Description for List continuous web jobs for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu continuous web job information elements as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ContinuousWebJobInner> listContinuousWebJobsAsync(String resourceGroupName, String name) {
        return new PagedFlux<>(() -> listContinuousWebJobsSinglePageAsync(resourceGroupName, name),
            nextLink -> listContinuousWebJobsNextSinglePageAsync(nextLink));
    }

    /**
     * List continuous web jobs for an app, or a deployment slot.
     * 
     * Description for List continuous web jobs for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu continuous web job information elements as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ContinuousWebJobInner> listContinuousWebJobsAsync(String resourceGroupName, String name,
        Context context) {
        return new PagedFlux<>(() -> listContinuousWebJobsSinglePageAsync(resourceGroupName, name, context),
            nextLink -> listContinuousWebJobsNextSinglePageAsync(nextLink, context));
    }

    /**
     * List continuous web jobs for an app, or a deployment slot.
     * 
     * Description for List continuous web jobs for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu continuous web job information elements as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ContinuousWebJobInner> listContinuousWebJobs(String resourceGroupName, String name) {
        return new PagedIterable<>(listContinuousWebJobsAsync(resourceGroupName, name));
    }

    /**
     * List continuous web jobs for an app, or a deployment slot.
     * 
     * Description for List continuous web jobs for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu continuous web job information elements as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ContinuousWebJobInner> listContinuousWebJobs(String resourceGroupName, String name,
        Context context) {
        return new PagedIterable<>(listContinuousWebJobsAsync(resourceGroupName, name, context));
    }

    /**
     * Gets a continuous web job by its ID for an app, or a deployment slot.
     * 
     * Description for Gets a continuous web job by its ID for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return continuous Web Job Information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ContinuousWebJobInner>> getContinuousWebJobWithResponseAsync(String resourceGroupName,
        String name, String webJobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (webJobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webJobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getContinuousWebJob(this.client.getEndpoint(), resourceGroupName, name,
                webJobName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a continuous web job by its ID for an app, or a deployment slot.
     * 
     * Description for Gets a continuous web job by its ID for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return continuous Web Job Information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ContinuousWebJobInner>> getContinuousWebJobWithResponseAsync(String resourceGroupName,
        String name, String webJobName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (webJobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webJobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getContinuousWebJob(this.client.getEndpoint(), resourceGroupName, name, webJobName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets a continuous web job by its ID for an app, or a deployment slot.
     * 
     * Description for Gets a continuous web job by its ID for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return continuous Web Job Information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ContinuousWebJobInner> getContinuousWebJobAsync(String resourceGroupName, String name,
        String webJobName) {
        return getContinuousWebJobWithResponseAsync(resourceGroupName, name, webJobName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a continuous web job by its ID for an app, or a deployment slot.
     * 
     * Description for Gets a continuous web job by its ID for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return continuous Web Job Information along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ContinuousWebJobInner> getContinuousWebJobWithResponse(String resourceGroupName, String name,
        String webJobName, Context context) {
        return getContinuousWebJobWithResponseAsync(resourceGroupName, name, webJobName, context).block();
    }

    /**
     * Gets a continuous web job by its ID for an app, or a deployment slot.
     * 
     * Description for Gets a continuous web job by its ID for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return continuous Web Job Information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ContinuousWebJobInner getContinuousWebJob(String resourceGroupName, String name, String webJobName) {
        return getContinuousWebJobWithResponse(resourceGroupName, name, webJobName, Context.NONE).getValue();
    }

    /**
     * Delete a continuous web job by its ID for an app, or a deployment slot.
     * 
     * Description for Delete a continuous web job by its ID for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteContinuousWebJobWithResponseAsync(String resourceGroupName, String name,
        String webJobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (webJobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webJobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteContinuousWebJob(this.client.getEndpoint(), resourceGroupName, name,
                webJobName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete a continuous web job by its ID for an app, or a deployment slot.
     * 
     * Description for Delete a continuous web job by its ID for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteContinuousWebJobWithResponseAsync(String resourceGroupName, String name,
        String webJobName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (webJobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webJobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteContinuousWebJob(this.client.getEndpoint(), resourceGroupName, name, webJobName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Delete a continuous web job by its ID for an app, or a deployment slot.
     * 
     * Description for Delete a continuous web job by its ID for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteContinuousWebJobAsync(String resourceGroupName, String name, String webJobName) {
        return deleteContinuousWebJobWithResponseAsync(resourceGroupName, name, webJobName)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete a continuous web job by its ID for an app, or a deployment slot.
     * 
     * Description for Delete a continuous web job by its ID for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteContinuousWebJobWithResponse(String resourceGroupName, String name, String webJobName,
        Context context) {
        return deleteContinuousWebJobWithResponseAsync(resourceGroupName, name, webJobName, context).block();
    }

    /**
     * Delete a continuous web job by its ID for an app, or a deployment slot.
     * 
     * Description for Delete a continuous web job by its ID for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteContinuousWebJob(String resourceGroupName, String name, String webJobName) {
        deleteContinuousWebJobWithResponse(resourceGroupName, name, webJobName, Context.NONE);
    }

    /**
     * Start a continuous web job for an app, or a deployment slot.
     * 
     * Description for Start a continuous web job for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> startContinuousWebJobWithResponseAsync(String resourceGroupName, String name,
        String webJobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (webJobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webJobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.startContinuousWebJob(this.client.getEndpoint(), resourceGroupName, name,
                webJobName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Start a continuous web job for an app, or a deployment slot.
     * 
     * Description for Start a continuous web job for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> startContinuousWebJobWithResponseAsync(String resourceGroupName, String name,
        String webJobName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (webJobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webJobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.startContinuousWebJob(this.client.getEndpoint(), resourceGroupName, name, webJobName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Start a continuous web job for an app, or a deployment slot.
     * 
     * Description for Start a continuous web job for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> startContinuousWebJobAsync(String resourceGroupName, String name, String webJobName) {
        return startContinuousWebJobWithResponseAsync(resourceGroupName, name, webJobName)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Start a continuous web job for an app, or a deployment slot.
     * 
     * Description for Start a continuous web job for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> startContinuousWebJobWithResponse(String resourceGroupName, String name, String webJobName,
        Context context) {
        return startContinuousWebJobWithResponseAsync(resourceGroupName, name, webJobName, context).block();
    }

    /**
     * Start a continuous web job for an app, or a deployment slot.
     * 
     * Description for Start a continuous web job for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void startContinuousWebJob(String resourceGroupName, String name, String webJobName) {
        startContinuousWebJobWithResponse(resourceGroupName, name, webJobName, Context.NONE);
    }

    /**
     * Stop a continuous web job for an app, or a deployment slot.
     * 
     * Description for Stop a continuous web job for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> stopContinuousWebJobWithResponseAsync(String resourceGroupName, String name,
        String webJobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (webJobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webJobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.stopContinuousWebJob(this.client.getEndpoint(), resourceGroupName, name,
                webJobName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Stop a continuous web job for an app, or a deployment slot.
     * 
     * Description for Stop a continuous web job for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> stopContinuousWebJobWithResponseAsync(String resourceGroupName, String name,
        String webJobName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (webJobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webJobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.stopContinuousWebJob(this.client.getEndpoint(), resourceGroupName, name, webJobName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Stop a continuous web job for an app, or a deployment slot.
     * 
     * Description for Stop a continuous web job for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> stopContinuousWebJobAsync(String resourceGroupName, String name, String webJobName) {
        return stopContinuousWebJobWithResponseAsync(resourceGroupName, name, webJobName)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Stop a continuous web job for an app, or a deployment slot.
     * 
     * Description for Stop a continuous web job for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> stopContinuousWebJobWithResponse(String resourceGroupName, String name, String webJobName,
        Context context) {
        return stopContinuousWebJobWithResponseAsync(resourceGroupName, name, webJobName, context).block();
    }

    /**
     * Stop a continuous web job for an app, or a deployment slot.
     * 
     * Description for Stop a continuous web job for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws ManagementException thrown if the request is rejected by server on status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void stopContinuousWebJob(String resourceGroupName, String name, String webJobName) {
        stopContinuousWebJobWithResponse(resourceGroupName, name, webJobName, Context.NONE);
    }

    /**
     * List deployment statuses for an app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment status collection ARM resource along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CsmDeploymentStatus>>
        listProductionSiteDeploymentStatusesSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listProductionSiteDeploymentStatuses(this.client.getEndpoint(),
                resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<CsmDeploymentStatus>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List deployment statuses for an app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment status collection ARM resource along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CsmDeploymentStatus>>
        listProductionSiteDeploymentStatusesSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listProductionSiteDeploymentStatuses(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * List deployment statuses for an app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment status collection ARM resource as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<CsmDeploymentStatus> listProductionSiteDeploymentStatusesAsync(String resourceGroupName,
        String name) {
        return new PagedFlux<>(() -> listProductionSiteDeploymentStatusesSinglePageAsync(resourceGroupName, name),
            nextLink -> listProductionSiteDeploymentStatusesNextSinglePageAsync(nextLink));
    }

    /**
     * List deployment statuses for an app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment status collection ARM resource as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<CsmDeploymentStatus> listProductionSiteDeploymentStatusesAsync(String resourceGroupName,
        String name, Context context) {
        return new PagedFlux<>(
            () -> listProductionSiteDeploymentStatusesSinglePageAsync(resourceGroupName, name, context),
            nextLink -> listProductionSiteDeploymentStatusesNextSinglePageAsync(nextLink, context));
    }

    /**
     * List deployment statuses for an app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment status collection ARM resource as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CsmDeploymentStatus> listProductionSiteDeploymentStatuses(String resourceGroupName,
        String name) {
        return new PagedIterable<>(listProductionSiteDeploymentStatusesAsync(resourceGroupName, name));
    }

    /**
     * List deployment statuses for an app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment status collection ARM resource as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CsmDeploymentStatus> listProductionSiteDeploymentStatuses(String resourceGroupName,
        String name, Context context) {
        return new PagedIterable<>(listProductionSiteDeploymentStatusesAsync(resourceGroupName, name, context));
    }

    /**
     * Gets the deployment status for an app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param deploymentStatusId GUID of the deployment operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment status for an app (or deployment slot, if specified) along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> getProductionSiteDeploymentStatusWithResponseAsync(String resourceGroupName,
        String name, String deploymentStatusId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (deploymentStatusId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStatusId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getProductionSiteDeploymentStatus(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, name, deploymentStatusId,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the deployment status for an app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param deploymentStatusId GUID of the deployment operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment status for an app (or deployment slot, if specified) along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getProductionSiteDeploymentStatusWithResponseAsync(
        String resourceGroupName, String name, String deploymentStatusId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (deploymentStatusId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStatusId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getProductionSiteDeploymentStatus(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, name, deploymentStatusId, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the deployment status for an app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param deploymentStatusId GUID of the deployment operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the deployment status for an app (or deployment slot, if
     * specified).
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<CsmDeploymentStatus>, CsmDeploymentStatus>
        beginGetProductionSiteDeploymentStatusAsync(String resourceGroupName, String name, String deploymentStatusId) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = getProductionSiteDeploymentStatusWithResponseAsync(resourceGroupName, name, deploymentStatusId);
        return this.client.<CsmDeploymentStatus, CsmDeploymentStatus>getLroResult(mono, this.client.getHttpPipeline(),
            CsmDeploymentStatus.class, CsmDeploymentStatus.class, this.client.getContext());
    }

    /**
     * Gets the deployment status for an app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param deploymentStatusId GUID of the deployment operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the deployment status for an app (or deployment slot, if
     * specified).
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CsmDeploymentStatus>, CsmDeploymentStatus>
        beginGetProductionSiteDeploymentStatusAsync(String resourceGroupName, String name, String deploymentStatusId,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = getProductionSiteDeploymentStatusWithResponseAsync(resourceGroupName, name, deploymentStatusId, context);
        return this.client.<CsmDeploymentStatus, CsmDeploymentStatus>getLroResult(mono, this.client.getHttpPipeline(),
            CsmDeploymentStatus.class, CsmDeploymentStatus.class, context);
    }

    /**
     * Gets the deployment status for an app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param deploymentStatusId GUID of the deployment operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the deployment status for an app (or deployment slot, if
     * specified).
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CsmDeploymentStatus>, CsmDeploymentStatus>
        beginGetProductionSiteDeploymentStatus(String resourceGroupName, String name, String deploymentStatusId) {
        return this.beginGetProductionSiteDeploymentStatusAsync(resourceGroupName, name, deploymentStatusId)
            .getSyncPoller();
    }

    /**
     * Gets the deployment status for an app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param deploymentStatusId GUID of the deployment operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the deployment status for an app (or deployment slot, if
     * specified).
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CsmDeploymentStatus>, CsmDeploymentStatus> beginGetProductionSiteDeploymentStatus(
        String resourceGroupName, String name, String deploymentStatusId, Context context) {
        return this.beginGetProductionSiteDeploymentStatusAsync(resourceGroupName, name, deploymentStatusId, context)
            .getSyncPoller();
    }

    /**
     * Gets the deployment status for an app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param deploymentStatusId GUID of the deployment operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment status for an app (or deployment slot, if specified) on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CsmDeploymentStatus> getProductionSiteDeploymentStatusAsync(String resourceGroupName, String name,
        String deploymentStatusId) {
        return beginGetProductionSiteDeploymentStatusAsync(resourceGroupName, name, deploymentStatusId).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets the deployment status for an app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param deploymentStatusId GUID of the deployment operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment status for an app (or deployment slot, if specified) on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<CsmDeploymentStatus> getProductionSiteDeploymentStatusAsync(String resourceGroupName, String name,
        String deploymentStatusId, Context context) {
        return beginGetProductionSiteDeploymentStatusAsync(resourceGroupName, name, deploymentStatusId, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets the deployment status for an app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param deploymentStatusId GUID of the deployment operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment status for an app (or deployment slot, if specified).
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CsmDeploymentStatus getProductionSiteDeploymentStatus(String resourceGroupName, String name,
        String deploymentStatusId) {
        return getProductionSiteDeploymentStatusAsync(resourceGroupName, name, deploymentStatusId).block();
    }

    /**
     * Gets the deployment status for an app (or deployment slot, if specified).
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param deploymentStatusId GUID of the deployment operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment status for an app (or deployment slot, if specified).
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CsmDeploymentStatus getProductionSiteDeploymentStatus(String resourceGroupName, String name,
        String deploymentStatusId, Context context) {
        return getProductionSiteDeploymentStatusAsync(resourceGroupName, name, deploymentStatusId, context).block();
    }

    /**
     * List deployments for an app, or a deployment slot.
     * 
     * Description for List deployments for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of app deployments along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentInner>> listDeploymentsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listDeployments(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<DeploymentInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List deployments for an app, or a deployment slot.
     * 
     * Description for List deployments for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of app deployments along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentInner>> listDeploymentsSinglePageAsync(String resourceGroupName, String name,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listDeployments(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * List deployments for an app, or a deployment slot.
     * 
     * Description for List deployments for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of app deployments as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeploymentInner> listDeploymentsAsync(String resourceGroupName, String name) {
        return new PagedFlux<>(() -> listDeploymentsSinglePageAsync(resourceGroupName, name),
            nextLink -> listDeploymentsNextSinglePageAsync(nextLink));
    }

    /**
     * List deployments for an app, or a deployment slot.
     * 
     * Description for List deployments for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of app deployments as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DeploymentInner> listDeploymentsAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux<>(() -> listDeploymentsSinglePageAsync(resourceGroupName, name, context),
            nextLink -> listDeploymentsNextSinglePageAsync(nextLink, context));
    }

    /**
     * List deployments for an app, or a deployment slot.
     * 
     * Description for List deployments for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of app deployments as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeploymentInner> listDeployments(String resourceGroupName, String name) {
        return new PagedIterable<>(listDeploymentsAsync(resourceGroupName, name));
    }

    /**
     * List deployments for an app, or a deployment slot.
     * 
     * Description for List deployments for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of app deployments as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeploymentInner> listDeployments(String resourceGroupName, String name, Context context) {
        return new PagedIterable<>(listDeploymentsAsync(resourceGroupName, name, context));
    }

    /**
     * Get a deployment by its ID for an app, or a deployment slot.
     * 
     * Description for Get a deployment by its ID for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeploymentInner>> getDeploymentWithResponseAsync(String resourceGroupName, String name,
        String id) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error(new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getDeployment(this.client.getEndpoint(), resourceGroupName, name, id,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get a deployment by its ID for an app, or a deployment slot.
     * 
     * Description for Get a deployment by its ID for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeploymentInner>> getDeploymentWithResponseAsync(String resourceGroupName, String name,
        String id, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error(new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getDeployment(this.client.getEndpoint(), resourceGroupName, name, id,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Get a deployment by its ID for an app, or a deployment slot.
     * 
     * Description for Get a deployment by its ID for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentInner> getDeploymentAsync(String resourceGroupName, String name, String id) {
        return getDeploymentWithResponseAsync(resourceGroupName, name, id)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get a deployment by its ID for an app, or a deployment slot.
     * 
     * Description for Get a deployment by its ID for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeploymentInner> getDeploymentWithResponse(String resourceGroupName, String name, String id,
        Context context) {
        return getDeploymentWithResponseAsync(resourceGroupName, name, id, context).block();
    }

    /**
     * Get a deployment by its ID for an app, or a deployment slot.
     * 
     * Description for Get a deployment by its ID for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentInner getDeployment(String resourceGroupName, String name, String id) {
        return getDeploymentWithResponse(resourceGroupName, name, id, Context.NONE).getValue();
    }

    /**
     * Create a deployment for an app, or a deployment slot.
     * 
     * Description for Create a deployment for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id ID of an existing deployment.
     * @param deployment Deployment details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeploymentInner>> createDeploymentWithResponseAsync(String resourceGroupName, String name,
        String id, DeploymentInner deployment) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error(new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deployment == null) {
            return Mono.error(new IllegalArgumentException("Parameter deployment is required and cannot be null."));
        } else {
            deployment.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createDeployment(this.client.getEndpoint(), resourceGroupName, name, id,
                this.client.getSubscriptionId(), this.client.getApiVersion(), deployment, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create a deployment for an app, or a deployment slot.
     * 
     * Description for Create a deployment for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id ID of an existing deployment.
     * @param deployment Deployment details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeploymentInner>> createDeploymentWithResponseAsync(String resourceGroupName, String name,
        String id, DeploymentInner deployment, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error(new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deployment == null) {
            return Mono.error(new IllegalArgumentException("Parameter deployment is required and cannot be null."));
        } else {
            deployment.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createDeployment(this.client.getEndpoint(), resourceGroupName, name, id,
            this.client.getSubscriptionId(), this.client.getApiVersion(), deployment, accept, context);
    }

    /**
     * Create a deployment for an app, or a deployment slot.
     * 
     * Description for Create a deployment for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id ID of an existing deployment.
     * @param deployment Deployment details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentInner> createDeploymentAsync(String resourceGroupName, String name, String id,
        DeploymentInner deployment) {
        return createDeploymentWithResponseAsync(resourceGroupName, name, id, deployment)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Create a deployment for an app, or a deployment slot.
     * 
     * Description for Create a deployment for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id ID of an existing deployment.
     * @param deployment Deployment details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeploymentInner> createDeploymentWithResponse(String resourceGroupName, String name, String id,
        DeploymentInner deployment, Context context) {
        return createDeploymentWithResponseAsync(resourceGroupName, name, id, deployment, context).block();
    }

    /**
     * Create a deployment for an app, or a deployment slot.
     * 
     * Description for Create a deployment for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id ID of an existing deployment.
     * @param deployment Deployment details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentInner createDeployment(String resourceGroupName, String name, String id,
        DeploymentInner deployment) {
        return createDeploymentWithResponse(resourceGroupName, name, id, deployment, Context.NONE).getValue();
    }

    /**
     * Delete a deployment by its ID for an app, or a deployment slot.
     * 
     * Description for Delete a deployment by its ID for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDeploymentWithResponseAsync(String resourceGroupName, String name, String id) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error(new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteDeployment(this.client.getEndpoint(), resourceGroupName, name, id,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete a deployment by its ID for an app, or a deployment slot.
     * 
     * Description for Delete a deployment by its ID for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteDeploymentWithResponseAsync(String resourceGroupName, String name, String id,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error(new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteDeployment(this.client.getEndpoint(), resourceGroupName, name, id,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Delete a deployment by its ID for an app, or a deployment slot.
     * 
     * Description for Delete a deployment by its ID for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteDeploymentAsync(String resourceGroupName, String name, String id) {
        return deleteDeploymentWithResponseAsync(resourceGroupName, name, id).flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete a deployment by its ID for an app, or a deployment slot.
     * 
     * Description for Delete a deployment by its ID for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteDeploymentWithResponse(String resourceGroupName, String name, String id,
        Context context) {
        return deleteDeploymentWithResponseAsync(resourceGroupName, name, id, context).block();
    }

    /**
     * Delete a deployment by its ID for an app, or a deployment slot.
     * 
     * Description for Delete a deployment by its ID for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteDeployment(String resourceGroupName, String name, String id) {
        deleteDeploymentWithResponse(resourceGroupName, name, id, Context.NONE);
    }

    /**
     * List deployment log for specific deployment for an app, or a deployment slot.
     * 
     * Description for List deployment log for specific deployment for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id The ID of a specific deployment. This is the value of the name property in the JSON response from "GET
     * /api/sites/{siteName}/deployments".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeploymentInner>> listDeploymentLogWithResponseAsync(String resourceGroupName, String name,
        String id) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error(new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listDeploymentLog(this.client.getEndpoint(), resourceGroupName, name, id,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List deployment log for specific deployment for an app, or a deployment slot.
     * 
     * Description for List deployment log for specific deployment for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id The ID of a specific deployment. This is the value of the name property in the JSON response from "GET
     * /api/sites/{siteName}/deployments".
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeploymentInner>> listDeploymentLogWithResponseAsync(String resourceGroupName, String name,
        String id, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error(new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listDeploymentLog(this.client.getEndpoint(), resourceGroupName, name, id,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * List deployment log for specific deployment for an app, or a deployment slot.
     * 
     * Description for List deployment log for specific deployment for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id The ID of a specific deployment. This is the value of the name property in the JSON response from "GET
     * /api/sites/{siteName}/deployments".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentInner> listDeploymentLogAsync(String resourceGroupName, String name, String id) {
        return listDeploymentLogWithResponseAsync(resourceGroupName, name, id)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * List deployment log for specific deployment for an app, or a deployment slot.
     * 
     * Description for List deployment log for specific deployment for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id The ID of a specific deployment. This is the value of the name property in the JSON response from "GET
     * /api/sites/{siteName}/deployments".
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeploymentInner> listDeploymentLogWithResponse(String resourceGroupName, String name, String id,
        Context context) {
        return listDeploymentLogWithResponseAsync(resourceGroupName, name, id, context).block();
    }

    /**
     * List deployment log for specific deployment for an app, or a deployment slot.
     * 
     * Description for List deployment log for specific deployment for an app, or a deployment slot.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id The ID of a specific deployment. This is the value of the name property in the JSON response from "GET
     * /api/sites/{siteName}/deployments".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentInner listDeploymentLog(String resourceGroupName, String name, String id) {
        return listDeploymentLogWithResponse(resourceGroupName, name, id, Context.NONE).getValue();
    }

    /**
     * Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to get information
     * about the databases stored in a backup.
     * 
     * Description for Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
     * get information about the databases stored in a backup.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request A RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a restore request along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RestoreRequestInner>> discoverBackupWithResponseAsync(String resourceGroupName, String name,
        RestoreRequestInner request) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.discoverBackup(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), request, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to get information
     * about the databases stored in a backup.
     * 
     * Description for Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
     * get information about the databases stored in a backup.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request A RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a restore request along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RestoreRequestInner>> discoverBackupWithResponseAsync(String resourceGroupName, String name,
        RestoreRequestInner request, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.discoverBackup(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), request, accept, context);
    }

    /**
     * Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to get information
     * about the databases stored in a backup.
     * 
     * Description for Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
     * get information about the databases stored in a backup.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request A RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a restore request on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RestoreRequestInner> discoverBackupAsync(String resourceGroupName, String name,
        RestoreRequestInner request) {
        return discoverBackupWithResponseAsync(resourceGroupName, name, request)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to get information
     * about the databases stored in a backup.
     * 
     * Description for Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
     * get information about the databases stored in a backup.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request A RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a restore request along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RestoreRequestInner> discoverBackupWithResponse(String resourceGroupName, String name,
        RestoreRequestInner request, Context context) {
        return discoverBackupWithResponseAsync(resourceGroupName, name, request, context).block();
    }

    /**
     * Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to get information
     * about the databases stored in a backup.
     * 
     * Description for Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
     * get information about the databases stored in a backup.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request A RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a restore request.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RestoreRequestInner discoverBackup(String resourceGroupName, String name, RestoreRequestInner request) {
        return discoverBackupWithResponse(resourceGroupName, name, request, Context.NONE).getValue();
    }

    /**
     * Lists ownership identifiers for domain associated with web app.
     * 
     * Description for Lists ownership identifiers for domain associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of identifiers along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<IdentifierInner>> listDomainOwnershipIdentifiersSinglePageAsync(String resourceGroupName,
        String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listDomainOwnershipIdentifiers(this.client.getEndpoint(), resourceGroupName,
                name, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<IdentifierInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists ownership identifiers for domain associated with web app.
     * 
     * Description for Lists ownership identifiers for domain associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of identifiers along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<IdentifierInner>> listDomainOwnershipIdentifiersSinglePageAsync(String resourceGroupName,
        String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listDomainOwnershipIdentifiers(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists ownership identifiers for domain associated with web app.
     * 
     * Description for Lists ownership identifiers for domain associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of identifiers as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<IdentifierInner> listDomainOwnershipIdentifiersAsync(String resourceGroupName, String name) {
        return new PagedFlux<>(() -> listDomainOwnershipIdentifiersSinglePageAsync(resourceGroupName, name),
            nextLink -> listDomainOwnershipIdentifiersNextSinglePageAsync(nextLink));
    }

    /**
     * Lists ownership identifiers for domain associated with web app.
     * 
     * Description for Lists ownership identifiers for domain associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of identifiers as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<IdentifierInner> listDomainOwnershipIdentifiersAsync(String resourceGroupName, String name,
        Context context) {
        return new PagedFlux<>(() -> listDomainOwnershipIdentifiersSinglePageAsync(resourceGroupName, name, context),
            nextLink -> listDomainOwnershipIdentifiersNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists ownership identifiers for domain associated with web app.
     * 
     * Description for Lists ownership identifiers for domain associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of identifiers as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<IdentifierInner> listDomainOwnershipIdentifiers(String resourceGroupName, String name) {
        return new PagedIterable<>(listDomainOwnershipIdentifiersAsync(resourceGroupName, name));
    }

    /**
     * Lists ownership identifiers for domain associated with web app.
     * 
     * Description for Lists ownership identifiers for domain associated with web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of identifiers as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<IdentifierInner> listDomainOwnershipIdentifiers(String resourceGroupName, String name,
        Context context) {
        return new PagedIterable<>(listDomainOwnershipIdentifiersAsync(resourceGroupName, name, context));
    }

    /**
     * Get domain ownership identifier for web app.
     * 
     * Description for Get domain ownership identifier for web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<IdentifierInner>> getDomainOwnershipIdentifierWithResponseAsync(String resourceGroupName,
        String name, String domainOwnershipIdentifierName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainOwnershipIdentifierName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter domainOwnershipIdentifierName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getDomainOwnershipIdentifier(this.client.getEndpoint(), resourceGroupName,
                name, domainOwnershipIdentifierName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get domain ownership identifier for web app.
     * 
     * Description for Get domain ownership identifier for web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<IdentifierInner>> getDomainOwnershipIdentifierWithResponseAsync(String resourceGroupName,
        String name, String domainOwnershipIdentifierName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainOwnershipIdentifierName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter domainOwnershipIdentifierName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getDomainOwnershipIdentifier(this.client.getEndpoint(), resourceGroupName, name,
            domainOwnershipIdentifierName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Get domain ownership identifier for web app.
     * 
     * Description for Get domain ownership identifier for web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<IdentifierInner> getDomainOwnershipIdentifierAsync(String resourceGroupName, String name,
        String domainOwnershipIdentifierName) {
        return getDomainOwnershipIdentifierWithResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get domain ownership identifier for web app.
     * 
     * Description for Get domain ownership identifier for web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<IdentifierInner> getDomainOwnershipIdentifierWithResponse(String resourceGroupName, String name,
        String domainOwnershipIdentifierName, Context context) {
        return getDomainOwnershipIdentifierWithResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName,
            context).block();
    }

    /**
     * Get domain ownership identifier for web app.
     * 
     * Description for Get domain ownership identifier for web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public IdentifierInner getDomainOwnershipIdentifier(String resourceGroupName, String name,
        String domainOwnershipIdentifierName) {
        return getDomainOwnershipIdentifierWithResponse(resourceGroupName, name, domainOwnershipIdentifierName,
            Context.NONE).getValue();
    }

    /**
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     * 
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<IdentifierInner>> createOrUpdateDomainOwnershipIdentifierWithResponseAsync(
        String resourceGroupName, String name, String domainOwnershipIdentifierName,
        IdentifierInner domainOwnershipIdentifier) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainOwnershipIdentifierName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter domainOwnershipIdentifierName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (domainOwnershipIdentifier == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter domainOwnershipIdentifier is required and cannot be null."));
        } else {
            domainOwnershipIdentifier.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdateDomainOwnershipIdentifier(this.client.getEndpoint(),
                resourceGroupName, name, domainOwnershipIdentifierName, this.client.getSubscriptionId(),
                this.client.getApiVersion(), domainOwnershipIdentifier, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     * 
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<IdentifierInner>> createOrUpdateDomainOwnershipIdentifierWithResponseAsync(
        String resourceGroupName, String name, String domainOwnershipIdentifierName,
        IdentifierInner domainOwnershipIdentifier, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainOwnershipIdentifierName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter domainOwnershipIdentifierName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (domainOwnershipIdentifier == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter domainOwnershipIdentifier is required and cannot be null."));
        } else {
            domainOwnershipIdentifier.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdateDomainOwnershipIdentifier(this.client.getEndpoint(), resourceGroupName, name,
            domainOwnershipIdentifierName, this.client.getSubscriptionId(), this.client.getApiVersion(),
            domainOwnershipIdentifier, accept, context);
    }

    /**
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     * 
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<IdentifierInner> createOrUpdateDomainOwnershipIdentifierAsync(String resourceGroupName, String name,
        String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier) {
        return createOrUpdateDomainOwnershipIdentifierWithResponseAsync(resourceGroupName, name,
            domainOwnershipIdentifierName, domainOwnershipIdentifier).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     * 
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<IdentifierInner> createOrUpdateDomainOwnershipIdentifierWithResponse(String resourceGroupName,
        String name, String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier, Context context) {
        return createOrUpdateDomainOwnershipIdentifierWithResponseAsync(resourceGroupName, name,
            domainOwnershipIdentifierName, domainOwnershipIdentifier, context).block();
    }

    /**
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     * 
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public IdentifierInner createOrUpdateDomainOwnershipIdentifier(String resourceGroupName, String name,
        String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier) {
        return createOrUpdateDomainOwnershipIdentifierWithResponse(resourceGroupName, name,
            domainOwnershipIdentifierName, domainOwnershipIdentifier, Context.NONE).getValue();
    }

    /**
     * Deletes a domain ownership identifier for a web app.
     * 
     * Description for Deletes a domain ownership identifier for a web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDomainOwnershipIdentifierWithResponseAsync(String resourceGroupName, String name,
        String domainOwnershipIdentifierName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainOwnershipIdentifierName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter domainOwnershipIdentifierName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteDomainOwnershipIdentifier(this.client.getEndpoint(),
                resourceGroupName, name, domainOwnershipIdentifierName, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a domain ownership identifier for a web app.
     * 
     * Description for Deletes a domain ownership identifier for a web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteDomainOwnershipIdentifierWithResponseAsync(String resourceGroupName, String name,
        String domainOwnershipIdentifierName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainOwnershipIdentifierName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter domainOwnershipIdentifierName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteDomainOwnershipIdentifier(this.client.getEndpoint(), resourceGroupName, name,
            domainOwnershipIdentifierName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Deletes a domain ownership identifier for a web app.
     * 
     * Description for Deletes a domain ownership identifier for a web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteDomainOwnershipIdentifierAsync(String resourceGroupName, String name,
        String domainOwnershipIdentifierName) {
        return deleteDomainOwnershipIdentifierWithResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a domain ownership identifier for a web app.
     * 
     * Description for Deletes a domain ownership identifier for a web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteDomainOwnershipIdentifierWithResponse(String resourceGroupName, String name,
        String domainOwnershipIdentifierName, Context context) {
        return deleteDomainOwnershipIdentifierWithResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName,
            context).block();
    }

    /**
     * Deletes a domain ownership identifier for a web app.
     * 
     * Description for Deletes a domain ownership identifier for a web app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteDomainOwnershipIdentifier(String resourceGroupName, String name,
        String domainOwnershipIdentifierName) {
        deleteDomainOwnershipIdentifierWithResponse(resourceGroupName, name, domainOwnershipIdentifierName,
            Context.NONE);
    }

    /**
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     * 
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain