// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Class Representing Solution for problems detected.
 */
@Fluent
public final class Solution {
    /*
     * Solution Id.
     */
    @JsonProperty(value = "id")
    private Double id;

    /*
     * Display Name of the solution
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * Order of the solution.
     */
    @JsonProperty(value = "order")
    private Double order;

    /*
     * Description of the solution
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * Type of Solution
     */
    @JsonProperty(value = "type")
    private SolutionType type;

    /*
     * Solution Data.
     */
    @JsonProperty(value = "data")
    private List<List<NameValuePair>> data;

    /*
     * Solution Metadata.
     */
    @JsonProperty(value = "metadata")
    private List<List<NameValuePair>> metadata;

    /**
     * Creates an instance of Solution class.
     */
    public Solution() {
    }

    /**
     * Get the id property: Solution Id.
     * 
     * @return the id value.
     */
    public Double id() {
        return this.id;
    }

    /**
     * Set the id property: Solution Id.
     * 
     * @param id the id value to set.
     * @return the Solution object itself.
     */
    public Solution withId(Double id) {
        this.id = id;
        return this;
    }

    /**
     * Get the displayName property: Display Name of the solution.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Display Name of the solution.
     * 
     * @param displayName the displayName value to set.
     * @return the Solution object itself.
     */
    public Solution withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the order property: Order of the solution.
     * 
     * @return the order value.
     */
    public Double order() {
        return this.order;
    }

    /**
     * Set the order property: Order of the solution.
     * 
     * @param order the order value to set.
     * @return the Solution object itself.
     */
    public Solution withOrder(Double order) {
        this.order = order;
        return this;
    }

    /**
     * Get the description property: Description of the solution.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the solution.
     * 
     * @param description the description value to set.
     * @return the Solution object itself.
     */
    public Solution withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the type property: Type of Solution.
     * 
     * @return the type value.
     */
    public SolutionType type() {
        return this.type;
    }

    /**
     * Set the type property: Type of Solution.
     * 
     * @param type the type value to set.
     * @return the Solution object itself.
     */
    public Solution withType(SolutionType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the data property: Solution Data.
     * 
     * @return the data value.
     */
    public List<List<NameValuePair>> data() {
        return this.data;
    }

    /**
     * Set the data property: Solution Data.
     * 
     * @param data the data value to set.
     * @return the Solution object itself.
     */
    public Solution withData(List<List<NameValuePair>> data) {
        this.data = data;
        return this;
    }

    /**
     * Get the metadata property: Solution Metadata.
     * 
     * @return the metadata value.
     */
    public List<List<NameValuePair>> metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: Solution Metadata.
     * 
     * @param metadata the metadata value to set.
     * @return the Solution object itself.
     */
    public Solution withMetadata(List<List<NameValuePair>> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (data() != null) {
            data().forEach(e -> e.forEach(e1 -> e1.validate()));
        }
        if (metadata() != null) {
            metadata().forEach(e -> e.forEach(e1 -> e1.validate()));
        }
    }
}
