// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.fluent.models.PremierAddOnPatchResourceProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * ARM resource for a PremierAddOn.
 */
@Fluent
public final class PremierAddOnPatchResource extends ProxyOnlyResource {
    /*
     * PremierAddOnPatchResource resource specific properties
     */
    @JsonProperty(value = "properties")
    private PremierAddOnPatchResourceProperties innerProperties;

    /**
     * Creates an instance of PremierAddOnPatchResource class.
     */
    public PremierAddOnPatchResource() {
    }

    /**
     * Get the innerProperties property: PremierAddOnPatchResource resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private PremierAddOnPatchResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PremierAddOnPatchResource withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the sku property: Premier add on SKU.
     * 
     * @return the sku value.
     */
    public String sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    /**
     * Set the sku property: Premier add on SKU.
     * 
     * @param sku the sku value to set.
     * @return the PremierAddOnPatchResource object itself.
     */
    public PremierAddOnPatchResource withSku(String sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PremierAddOnPatchResourceProperties();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    /**
     * Get the product property: Premier add on Product.
     * 
     * @return the product value.
     */
    public String product() {
        return this.innerProperties() == null ? null : this.innerProperties().product();
    }

    /**
     * Set the product property: Premier add on Product.
     * 
     * @param product the product value to set.
     * @return the PremierAddOnPatchResource object itself.
     */
    public PremierAddOnPatchResource withProduct(String product) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PremierAddOnPatchResourceProperties();
        }
        this.innerProperties().withProduct(product);
        return this;
    }

    /**
     * Get the vendor property: Premier add on Vendor.
     * 
     * @return the vendor value.
     */
    public String vendor() {
        return this.innerProperties() == null ? null : this.innerProperties().vendor();
    }

    /**
     * Set the vendor property: Premier add on Vendor.
     * 
     * @param vendor the vendor value to set.
     * @return the PremierAddOnPatchResource object itself.
     */
    public PremierAddOnPatchResource withVendor(String vendor) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PremierAddOnPatchResourceProperties();
        }
        this.innerProperties().withVendor(vendor);
        return this;
    }

    /**
     * Get the marketplacePublisher property: Premier add on Marketplace publisher.
     * 
     * @return the marketplacePublisher value.
     */
    public String marketplacePublisher() {
        return this.innerProperties() == null ? null : this.innerProperties().marketplacePublisher();
    }

    /**
     * Set the marketplacePublisher property: Premier add on Marketplace publisher.
     * 
     * @param marketplacePublisher the marketplacePublisher value to set.
     * @return the PremierAddOnPatchResource object itself.
     */
    public PremierAddOnPatchResource withMarketplacePublisher(String marketplacePublisher) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PremierAddOnPatchResourceProperties();
        }
        this.innerProperties().withMarketplacePublisher(marketplacePublisher);
        return this;
    }

    /**
     * Get the marketplaceOffer property: Premier add on Marketplace offer.
     * 
     * @return the marketplaceOffer value.
     */
    public String marketplaceOffer() {
        return this.innerProperties() == null ? null : this.innerProperties().marketplaceOffer();
    }

    /**
     * Set the marketplaceOffer property: Premier add on Marketplace offer.
     * 
     * @param marketplaceOffer the marketplaceOffer value to set.
     * @return the PremierAddOnPatchResource object itself.
     */
    public PremierAddOnPatchResource withMarketplaceOffer(String marketplaceOffer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PremierAddOnPatchResourceProperties();
        }
        this.innerProperties().withMarketplaceOffer(marketplaceOffer);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
