// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The configuration settings of the registration for the Azure Static Web Apps provider.
 */
@Fluent
public final class AzureStaticWebAppsRegistration {
    /*
     * The Client ID of the app used for login.
     */
    @JsonProperty(value = "clientId")
    private String clientId;

    /**
     * Creates an instance of AzureStaticWebAppsRegistration class.
     */
    public AzureStaticWebAppsRegistration() {
    }

    /**
     * Get the clientId property: The Client ID of the app used for login.
     * 
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: The Client ID of the app used for login.
     * 
     * @param clientId the clientId value to set.
     * @return the AzureStaticWebAppsRegistration object itself.
     */
    public AzureStaticWebAppsRegistration withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
