// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.appservice.fluent.StaticSitesClient;
import com.azure.resourcemanager.appservice.fluent.models.DatabaseConnectionInner;
import com.azure.resourcemanager.appservice.fluent.models.PrivateLinkResourcesWrapperInner;
import com.azure.resourcemanager.appservice.fluent.models.RemotePrivateEndpointConnectionArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteBasicAuthPropertiesArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteBuildArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteCustomDomainOverviewArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteFunctionOverviewArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteLinkedBackendArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteUserArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteUserInvitationResponseResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteUserProvidedFunctionAppArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSitesWorkflowPreviewInner;
import com.azure.resourcemanager.appservice.fluent.models.StringDictionaryInner;
import com.azure.resourcemanager.appservice.fluent.models.StringListInner;
import com.azure.resourcemanager.appservice.models.BasicAuthName;
import com.azure.resourcemanager.appservice.models.DatabaseConnectionCollection;
import com.azure.resourcemanager.appservice.models.DatabaseConnectionPatchRequest;
import com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException;
import com.azure.resourcemanager.appservice.models.PrivateEndpointConnectionCollection;
import com.azure.resourcemanager.appservice.models.PrivateLinkConnectionApprovalRequestResource;
import com.azure.resourcemanager.appservice.models.StaticSiteBasicAuthPropertiesCollection;
import com.azure.resourcemanager.appservice.models.StaticSiteBuildCollection;
import com.azure.resourcemanager.appservice.models.StaticSiteCollection;
import com.azure.resourcemanager.appservice.models.StaticSiteCustomDomainOverviewCollection;
import com.azure.resourcemanager.appservice.models.StaticSiteCustomDomainRequestPropertiesArmResource;
import com.azure.resourcemanager.appservice.models.StaticSiteFunctionOverviewCollection;
import com.azure.resourcemanager.appservice.models.StaticSiteLinkedBackendsCollection;
import com.azure.resourcemanager.appservice.models.StaticSitePatchResource;
import com.azure.resourcemanager.appservice.models.StaticSiteResetPropertiesArmResource;
import com.azure.resourcemanager.appservice.models.StaticSiteUserCollection;
import com.azure.resourcemanager.appservice.models.StaticSiteUserInvitationRequestResource;
import com.azure.resourcemanager.appservice.models.StaticSiteUserProvidedFunctionAppsCollection;
import com.azure.resourcemanager.appservice.models.StaticSiteZipDeploymentArmResource;
import com.azure.resourcemanager.appservice.models.StaticSitesWorkflowPreviewRequest;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in StaticSitesClient.
 */
public final class StaticSitesClientImpl implements InnerSupportsGet<StaticSiteArmResourceInner>,
    InnerSupportsListing<StaticSiteArmResourceInner>, InnerSupportsDelete<Void>, StaticSitesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final StaticSitesService service;

    /**
     * The service client containing this operation class.
     */
    private final WebSiteManagementClientImpl client;

    /**
     * Initializes an instance of StaticSitesClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    StaticSitesClientImpl(WebSiteManagementClientImpl client) {
        this.service
            = RestProxy.create(StaticSitesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for WebSiteManagementClientStaticSites to be used by the proxy service
     * to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "WebSiteManagementCli")
    public interface StaticSitesService {
        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/providers/Microsoft.Web/locations/{location}/previewStaticSiteWorkflowFile")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSitesWorkflowPreviewInner>> previewWorkflow(@HostParam("$host") String endpoint,
            @PathParam("location") String location, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StaticSitesWorkflowPreviewRequest staticSitesWorkflowPreviewRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Web/staticSites")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteCollection>> list(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteCollection>> listByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteArmResourceInner>> getByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdateStaticSite(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StaticSiteArmResourceInner staticSiteEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteArmResourceInner>> updateStaticSite(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StaticSitePatchResource staticSiteEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/listUsers")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteUserCollection>> listStaticSiteUsers(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("authprovider") String authprovider, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/users/{userid}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteStaticSiteUser(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("authprovider") String authprovider, @PathParam("userid") String userid,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/users/{userid}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteUserArmResourceInner>> updateStaticSiteUser(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("authprovider") String authprovider, @PathParam("userid") String userid,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StaticSiteUserArmResourceInner staticSiteUserEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteBuildCollection>> getStaticSiteBuilds(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteBuildArmResourceInner>> getStaticSiteBuild(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("environmentName") String environmentName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteStaticSiteBuild(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("environmentName") String environmentName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/config/appsettings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteBuildAppSettings(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("environmentName") String environmentName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StringDictionaryInner appSettings, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/config/functionappsettings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteBuildFunctionAppSettings(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("environmentName") String environmentName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StringDictionaryInner appSettings, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/databaseConnections")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DatabaseConnectionCollection>> getBuildDatabaseConnections(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("environmentName") String environmentName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/databaseConnections/{databaseConnectionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DatabaseConnectionInner>> getBuildDatabaseConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("environmentName") String environmentName,
            @PathParam("databaseConnectionName") String databaseConnectionName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/databaseConnections/{databaseConnectionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DatabaseConnectionInner>> createOrUpdateBuildDatabaseConnection(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("environmentName") String environmentName,
            @PathParam("databaseConnectionName") String databaseConnectionName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DatabaseConnectionInner databaseConnectionRequestEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/databaseConnections/{databaseConnectionName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteBuildDatabaseConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("environmentName") String environmentName,
            @PathParam("databaseConnectionName") String databaseConnectionName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/databaseConnections/{databaseConnectionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DatabaseConnectionInner>> updateBuildDatabaseConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("environmentName") String environmentName,
            @PathParam("databaseConnectionName") String databaseConnectionName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DatabaseConnectionPatchRequest databaseConnectionRequestEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/databaseConnections/{databaseConnectionName}/show")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DatabaseConnectionInner>> getBuildDatabaseConnectionWithDetails(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("environmentName") String environmentName,
            @PathParam("databaseConnectionName") String databaseConnectionName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/functions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteFunctionOverviewCollection>> listStaticSiteBuildFunctions(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("environmentName") String environmentName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/listAppSettings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StringDictionaryInner>> listStaticSiteBuildAppSettings(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("environmentName") String environmentName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/listFunctionAppSettings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StringDictionaryInner>> listStaticSiteBuildFunctionAppSettings(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("environmentName") String environmentName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/showDatabaseConnections")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DatabaseConnectionCollection>> getBuildDatabaseConnectionsWithDetails(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("environmentName") String environmentName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/userProvidedFunctionApps")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteUserProvidedFunctionAppsCollection>> getUserProvidedFunctionAppsForStaticSiteBuild(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("environmentName") String environmentName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/userProvidedFunctionApps/{functionAppName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteUserProvidedFunctionAppArmResourceInner>> getUserProvidedFunctionAppForStaticSiteBuild(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("environmentName") String environmentName,
            @PathParam("functionAppName") String functionAppName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/userProvidedFunctionApps/{functionAppName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> registerUserProvidedFunctionAppWithStaticSiteBuild(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("environmentName") String environmentName,
            @PathParam("functionAppName") String functionAppName, @QueryParam("isForced") Boolean isForced,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/userProvidedFunctionApps/{functionAppName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> detachUserProvidedFunctionAppFromStaticSiteBuild(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("environmentName") String environmentName, @PathParam("functionAppName") String functionAppName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/zipdeploy")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createZipDeploymentForStaticSiteBuild(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("environmentName") String environmentName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/config/appsettings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteAppSettings(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StringDictionaryInner appSettings, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/basicAuth")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteBasicAuthPropertiesCollection>> listBasicAuth(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/basicAuth/{basicAuthName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteBasicAuthPropertiesArmResourceInner>> getBasicAuth(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("basicAuthName") BasicAuthName basicAuthName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/basicAuth/{basicAuthName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteBasicAuthPropertiesArmResourceInner>> createOrUpdateBasicAuth(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("basicAuthName") BasicAuthName basicAuthName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StaticSiteBasicAuthPropertiesArmResourceInner basicAuthEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/config/functionappsettings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteFunctionAppSettings(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StringDictionaryInner appSettings, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/createUserInvitation")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteUserInvitationResponseResourceInner>> createUserRolesInvitationLink(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StaticSiteUserInvitationRequestResource staticSiteUserRolesInvitationEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteCustomDomainOverviewCollection>> listStaticSiteCustomDomains(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteCustomDomainOverviewArmResourceInner>> getStaticSiteCustomDomain(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("domainName") String domainName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdateStaticSiteCustomDomain(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("domainName") String domainName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteStaticSiteCustomDomain(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("domainName") String domainName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}/validate")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> validateCustomDomainCanBeAddedToStaticSite(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("domainName") String domainName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/databaseConnections")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DatabaseConnectionCollection>> getDatabaseConnections(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/databaseConnections/{databaseConnectionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DatabaseConnectionInner>> getDatabaseConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("databaseConnectionName") String databaseConnectionName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/databaseConnections/{databaseConnectionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DatabaseConnectionInner>> createOrUpdateDatabaseConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("databaseConnectionName") String databaseConnectionName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DatabaseConnectionInner databaseConnectionRequestEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/databaseConnections/{databaseConnectionName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteDatabaseConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("databaseConnectionName") String databaseConnectionName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/databaseConnections/{databaseConnectionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DatabaseConnectionInner>> updateDatabaseConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("databaseConnectionName") String databaseConnectionName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DatabaseConnectionPatchRequest databaseConnectionRequestEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/databaseConnections/{databaseConnectionName}/show")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DatabaseConnectionInner>> getDatabaseConnectionWithDetails(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("databaseConnectionName") String databaseConnectionName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/detach")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> detachStaticSite(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/functions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteFunctionOverviewCollection>> listStaticSiteFunctions(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listAppSettings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StringDictionaryInner>> listStaticSiteAppSettings(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listConfiguredRoles")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StringListInner>> listStaticSiteConfiguredRoles(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listFunctionAppSettings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StringDictionaryInner>> listStaticSiteFunctionAppSettings(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listSecrets")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StringDictionaryInner>> listStaticSiteSecrets(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/privateEndpointConnections")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PrivateEndpointConnectionCollection>> getPrivateEndpointConnectionList(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RemotePrivateEndpointConnectionArmResourceInner>> getPrivateEndpointConnection(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name,
            @PathParam("privateEndpointConnectionName") String privateEndpointConnectionName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> approveOrRejectPrivateEndpointConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("privateEndpointConnectionName") String privateEndpointConnectionName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> deletePrivateEndpointConnection(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("privateEndpointConnectionName") String privateEndpointConnectionName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/privateLinkResources")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PrivateLinkResourcesWrapperInner>> getPrivateLinkResources(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/resetapikey")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> resetStaticSiteApiKey(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StaticSiteResetPropertiesArmResource resetPropertiesEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/showDatabaseConnections")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DatabaseConnectionCollection>> getDatabaseConnectionsWithDetails(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/userProvidedFunctionApps")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteUserProvidedFunctionAppsCollection>> getUserProvidedFunctionAppsForStaticSite(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/userProvidedFunctionApps/{functionAppName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteUserProvidedFunctionAppArmResourceInner>> getUserProvidedFunctionAppForStaticSite(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("functionAppName") String functionAppName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/userProvidedFunctionApps/{functionAppName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> registerUserProvidedFunctionAppWithStaticSite(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("functionAppName") String functionAppName,
            @QueryParam("isForced") Boolean isForced, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/userProvidedFunctionApps/{functionAppName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> detachUserProvidedFunctionAppFromStaticSite(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("functionAppName") String functionAppName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/zipdeploy")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createZipDeploymentForStaticSite(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/linkedBackends/{linkedBackendName}/validate")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> validateBackend(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("linkedBackendName") String linkedBackendName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/linkedBackends/{linkedBackendName}/validate")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> validateBackendForBuild(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("environmentName") String environmentName,
            @PathParam("linkedBackendName") String linkedBackendName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/linkedBackends")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteLinkedBackendsCollection>> getLinkedBackends(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/linkedBackends")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteLinkedBackendsCollection>> getLinkedBackendsForBuild(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("environmentName") String environmentName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/linkedBackends/{linkedBackendName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteLinkedBackendArmResourceInner>> getLinkedBackend(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("linkedBackendName") String linkedBackendName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/linkedBackends/{linkedBackendName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> linkBackend(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("linkedBackendName") String linkedBackendName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/linkedBackends/{linkedBackendName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> unlinkBackend(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("linkedBackendName") String linkedBackendName,
            @QueryParam("isCleaningAuthConfig") Boolean isCleaningAuthConfig,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/linkedBackends/{linkedBackendName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteLinkedBackendArmResourceInner>> getLinkedBackendForBuild(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name, @PathParam("environmentName") String environmentName,
            @PathParam("linkedBackendName") String linkedBackendName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/linkedBackends/{linkedBackendName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> linkBackendToBuild(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("environmentName") String environmentName,
            @PathParam("linkedBackendName") String linkedBackendName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/linkedBackends/{linkedBackendName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> unlinkBackendFromBuild(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("environmentName") String environmentName,
            @PathParam("linkedBackendName") String linkedBackendName,
            @QueryParam("isCleaningAuthConfig") Boolean isCleaningAuthConfig,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteCollection>> listNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteCollection>> getStaticSitesByResourceGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteUserCollection>> listStaticSiteUsersNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteBuildCollection>> getStaticSiteBuildsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DatabaseConnectionCollection>> getBuildDatabaseConnectionsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteFunctionOverviewCollection>> listStaticSiteBuildFunctionsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DatabaseConnectionCollection>> getBuildDatabaseConnectionsWithDetailsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteUserProvidedFunctionAppsCollection>> getUserProvidedFunctionAppsForStaticSiteBuildNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteBasicAuthPropertiesCollection>> listBasicAuthNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteCustomDomainOverviewCollection>> listStaticSiteCustomDomainsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DatabaseConnectionCollection>> getDatabaseConnectionsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteFunctionOverviewCollection>> listStaticSiteFunctionsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<PrivateEndpointConnectionCollection>> getPrivateEndpointConnectionListNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DatabaseConnectionCollection>> getDatabaseConnectionsWithDetailsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteUserProvidedFunctionAppsCollection>> getUserProvidedFunctionAppsForStaticSiteNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteLinkedBackendsCollection>> getLinkedBackendsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<StaticSiteLinkedBackendsCollection>> getLinkedBackendsForBuildNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Generates a preview workflow file for the static site
     * 
     * Description for Generates a preview workflow file for the static site.
     * 
     * @param location Location where you plan to create the static site.
     * @param staticSitesWorkflowPreviewRequest A JSON representation of the StaticSitesWorkflowPreviewRequest
     * properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return preview for the Static Site Workflow to be generated along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StaticSitesWorkflowPreviewInner>> previewWorkflowWithResponseAsync(String location,
        StaticSitesWorkflowPreviewRequest staticSitesWorkflowPreviewRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSitesWorkflowPreviewRequest == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSitesWorkflowPreviewRequest is required and cannot be null."));
        } else {
            staticSitesWorkflowPreviewRequest.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.previewWorkflow(this.client.getEndpoint(), location, this.client.getSubscriptionId(),
                    this.client.getApiVersion(), staticSitesWorkflowPreviewRequest, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Generates a preview workflow file for the static site
     * 
     * Description for Generates a preview workflow file for the static site.
     * 
     * @param location Location where you plan to create the static site.
     * @param staticSitesWorkflowPreviewRequest A JSON representation of the StaticSitesWorkflowPreviewRequest
     * properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return preview for the Static Site Workflow to be generated along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StaticSitesWorkflowPreviewInner>> previewWorkflowWithResponseAsync(String location,
        StaticSitesWorkflowPreviewRequest staticSitesWorkflowPreviewRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSitesWorkflowPreviewRequest == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSitesWorkflowPreviewRequest is required and cannot be null."));
        } else {
            staticSitesWorkflowPreviewRequest.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.previewWorkflow(this.client.getEndpoint(), location, this.client.getSubscriptionId(),
            this.client.getApiVersion(), staticSitesWorkflowPreviewRequest, accept, context);
    }

    /**
     * Generates a preview workflow file for the static site
     * 
     * Description for Generates a preview workflow file for the static site.
     * 
     * @param location Location where you plan to create the static site.
     * @param staticSitesWorkflowPreviewRequest A JSON representation of the StaticSitesWorkflowPreviewRequest
     * properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return preview for the Static Site Workflow to be generated on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSitesWorkflowPreviewInner> previewWorkflowAsync(String location,
        StaticSitesWorkflowPreviewRequest staticSitesWorkflowPreviewRequest) {
        return previewWorkflowWithResponseAsync(location, staticSitesWorkflowPreviewRequest)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Generates a preview workflow file for the static site
     * 
     * Description for Generates a preview workflow file for the static site.
     * 
     * @param location Location where you plan to create the static site.
     * @param staticSitesWorkflowPreviewRequest A JSON representation of the StaticSitesWorkflowPreviewRequest
     * properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return preview for the Static Site Workflow to be generated along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StaticSitesWorkflowPreviewInner> previewWorkflowWithResponse(String location,
        StaticSitesWorkflowPreviewRequest staticSitesWorkflowPreviewRequest, Context context) {
        return previewWorkflowWithResponseAsync(location, staticSitesWorkflowPreviewRequest, context).block();
    }

    /**
     * Generates a preview workflow file for the static site
     * 
     * Description for Generates a preview workflow file for the static site.
     * 
     * @param location Location where you plan to create the static site.
     * @param staticSitesWorkflowPreviewRequest A JSON representation of the StaticSitesWorkflowPreviewRequest
     * properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return preview for the Static Site Workflow to be generated.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSitesWorkflowPreviewInner previewWorkflow(String location,
        StaticSitesWorkflowPreviewRequest staticSitesWorkflowPreviewRequest) {
        return previewWorkflowWithResponse(location, staticSitesWorkflowPreviewRequest, Context.NONE).getValue();
    }

    /**
     * Get all Static Sites for a subscription.
     * 
     * Description for Get all Static Sites for a subscription.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteArmResourceInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .<PagedResponse<StaticSiteArmResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get all Static Sites for a subscription.
     * 
     * Description for Get all Static Sites for a subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteArmResourceInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), accept,
                context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get all Static Sites for a subscription.
     * 
     * Description for Get all Static Sites for a subscription.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<StaticSiteArmResourceInner> listAsync() {
        return new PagedFlux<>(() -> listSinglePageAsync(), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Get all Static Sites for a subscription.
     * 
     * Description for Get all Static Sites for a subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<StaticSiteArmResourceInner> listAsync(Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get all Static Sites for a subscription.
     * 
     * Description for Get all Static Sites for a subscription.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteArmResourceInner> list() {
        return new PagedIterable<>(listAsync());
    }

    /**
     * Get all Static Sites for a subscription.
     * 
     * Description for Get all Static Sites for a subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteArmResourceInner> list(Context context) {
        return new PagedIterable<>(listAsync(context));
    }

    /**
     * Gets all static sites in the specified resource group.
     * 
     * Description for Gets all static sites in the specified resource group.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteArmResourceInner>>
        listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<StaticSiteArmResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets all static sites in the specified resource group.
     * 
     * Description for Gets all static sites in the specified resource group.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteArmResourceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets all static sites in the specified resource group.
     * 
     * Description for Gets all static sites in the specified resource group.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<StaticSiteArmResourceInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName),
            nextLink -> getStaticSitesByResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Gets all static sites in the specified resource group.
     * 
     * Description for Gets all static sites in the specified resource group.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<StaticSiteArmResourceInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, context),
            nextLink -> getStaticSitesByResourceGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets all static sites in the specified resource group.
     * 
     * Description for Gets all static sites in the specified resource group.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteArmResourceInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName));
    }

    /**
     * Gets all static sites in the specified resource group.
     * 
     * Description for Gets all static sites in the specified resource group.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteArmResourceInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, context));
    }

    /**
     * Gets the details of a static site.
     * 
     * Description for Gets the details of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StaticSiteArmResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the details of a static site.
     * 
     * Description for Gets the details of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StaticSiteArmResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the details of a static site.
     * 
     * Description for Gets the details of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSiteArmResourceInner> getByResourceGroupAsync(String resourceGroupName, String name) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the details of a static site.
     * 
     * Description for Gets the details of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StaticSiteArmResourceInner> getByResourceGroupWithResponse(String resourceGroupName, String name,
        Context context) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets the details of a static site.
     * 
     * Description for Gets the details of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteArmResourceInner getByResourceGroup(String resourceGroupName, String name) {
        return getByResourceGroupWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateStaticSiteWithResponseAsync(String resourceGroupName,
        String name, StaticSiteArmResourceInner staticSiteEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter staticSiteEnvelope is required and cannot be null."));
        } else {
            staticSiteEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdateStaticSite(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateStaticSiteWithResponseAsync(String resourceGroupName,
        String name, StaticSiteArmResourceInner staticSiteEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter staticSiteEnvelope is required and cannot be null."));
        } else {
            staticSiteEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdateStaticSite(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteEnvelope, accept, context);
    }

    /**
     * Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<StaticSiteArmResourceInner>, StaticSiteArmResourceInner>
        beginCreateOrUpdateStaticSiteAsync(String resourceGroupName, String name,
            StaticSiteArmResourceInner staticSiteEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateStaticSiteWithResponseAsync(resourceGroupName, name, staticSiteEnvelope);
        return this.client.<StaticSiteArmResourceInner, StaticSiteArmResourceInner>getLroResult(mono,
            this.client.getHttpPipeline(), StaticSiteArmResourceInner.class, StaticSiteArmResourceInner.class,
            this.client.getContext());
    }

    /**
     * Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<StaticSiteArmResourceInner>, StaticSiteArmResourceInner>
        beginCreateOrUpdateStaticSiteAsync(String resourceGroupName, String name,
            StaticSiteArmResourceInner staticSiteEnvelope, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateStaticSiteWithResponseAsync(resourceGroupName, name, staticSiteEnvelope, context);
        return this.client.<StaticSiteArmResourceInner, StaticSiteArmResourceInner>getLroResult(mono,
            this.client.getHttpPipeline(), StaticSiteArmResourceInner.class, StaticSiteArmResourceInner.class, context);
    }

    /**
     * Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<StaticSiteArmResourceInner>, StaticSiteArmResourceInner> beginCreateOrUpdateStaticSite(
        String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope) {
        return this.beginCreateOrUpdateStaticSiteAsync(resourceGroupName, name, staticSiteEnvelope).getSyncPoller();
    }

    /**
     * Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<StaticSiteArmResourceInner>, StaticSiteArmResourceInner> beginCreateOrUpdateStaticSite(
        String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope, Context context) {
        return this.beginCreateOrUpdateStaticSiteAsync(resourceGroupName, name, staticSiteEnvelope, context)
            .getSyncPoller();
    }

    /**
     * Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSiteArmResourceInner> createOrUpdateStaticSiteAsync(String resourceGroupName, String name,
        StaticSiteArmResourceInner staticSiteEnvelope) {
        return beginCreateOrUpdateStaticSiteAsync(resourceGroupName, name, staticSiteEnvelope).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<StaticSiteArmResourceInner> createOrUpdateStaticSiteAsync(String resourceGroupName, String name,
        StaticSiteArmResourceInner staticSiteEnvelope, Context context) {
        return beginCreateOrUpdateStaticSiteAsync(resourceGroupName, name, staticSiteEnvelope, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteArmResourceInner createOrUpdateStaticSite(String resourceGroupName, String name,
        StaticSiteArmResourceInner staticSiteEnvelope) {
        return createOrUpdateStaticSiteAsync(resourceGroupName, name, staticSiteEnvelope).block();
    }

    /**
     * Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteArmResourceInner createOrUpdateStaticSite(String resourceGroupName, String name,
        StaticSiteArmResourceInner staticSiteEnvelope, Context context) {
        return createOrUpdateStaticSiteAsync(resourceGroupName, name, staticSiteEnvelope, context).block();
    }

    /**
     * Deletes a static site.
     * 
     * Description for Deletes a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a static site.
     * 
     * Description for Deletes a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String name,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(),
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes a static site.
     * 
     * Description for Deletes a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String name) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, name);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes a static site.
     * 
     * Description for Deletes a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String name,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, name, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes a static site.
     * 
     * Description for Deletes a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String name) {
        return this.beginDeleteAsync(resourceGroupName, name).getSyncPoller();
    }

    /**
     * Deletes a static site.
     * 
     * Description for Deletes a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String name, Context context) {
        return this.beginDeleteAsync(resourceGroupName, name, context).getSyncPoller();
    }

    /**
     * Deletes a static site.
     * 
     * Description for Deletes a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String name) {
        return beginDeleteAsync(resourceGroupName, name).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a static site.
     * 
     * Description for Deletes a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String name, Context context) {
        return beginDeleteAsync(resourceGroupName, name, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a static site.
     * 
     * Description for Deletes a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String name) {
        deleteAsync(resourceGroupName, name).block();
    }

    /**
     * Deletes a static site.
     * 
     * Description for Deletes a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String name, Context context) {
        deleteAsync(resourceGroupName, name, context).block();
    }

    /**
     * Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StaticSiteArmResourceInner>> updateStaticSiteWithResponseAsync(String resourceGroupName,
        String name, StaticSitePatchResource staticSiteEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter staticSiteEnvelope is required and cannot be null."));
        } else {
            staticSiteEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateStaticSite(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StaticSiteArmResourceInner>> updateStaticSiteWithResponseAsync(String resourceGroupName,
        String name, StaticSitePatchResource staticSiteEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter staticSiteEnvelope is required and cannot be null."));
        } else {
            staticSiteEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateStaticSite(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteEnvelope, accept, context);
    }

    /**
     * Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSiteArmResourceInner> updateStaticSiteAsync(String resourceGroupName, String name,
        StaticSitePatchResource staticSiteEnvelope) {
        return updateStaticSiteWithResponseAsync(resourceGroupName, name, staticSiteEnvelope)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StaticSiteArmResourceInner> updateStaticSiteWithResponse(String resourceGroupName, String name,
        StaticSitePatchResource staticSiteEnvelope, Context context) {
        return updateStaticSiteWithResponseAsync(resourceGroupName, name, staticSiteEnvelope, context).block();
    }

    /**
     * Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteArmResourceInner updateStaticSite(String resourceGroupName, String name,
        StaticSitePatchResource staticSiteEnvelope) {
        return updateStaticSiteWithResponse(resourceGroupName, name, staticSiteEnvelope, Context.NONE).getValue();
    }

    /**
     * Gets the list of users of a static site.
     * 
     * Description for Gets the list of users of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param authprovider The auth provider for the users.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom users along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteUserArmResourceInner>>
        listStaticSiteUsersSinglePageAsync(String resourceGroupName, String name, String authprovider) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (authprovider == null) {
            return Mono.error(new IllegalArgumentException("Parameter authprovider is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listStaticSiteUsers(this.client.getEndpoint(), resourceGroupName, name,
                authprovider, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<StaticSiteUserArmResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the list of users of a static site.
     * 
     * Description for Gets the list of users of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param authprovider The auth provider for the users.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom users along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteUserArmResourceInner>> listStaticSiteUsersSinglePageAsync(
        String resourceGroupName, String name, String authprovider, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (authprovider == null) {
            return Mono.error(new IllegalArgumentException("Parameter authprovider is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listStaticSiteUsers(this.client.getEndpoint(), resourceGroupName, name, authprovider,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets the list of users of a static site.
     * 
     * Description for Gets the list of users of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param authprovider The auth provider for the users.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom users as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<StaticSiteUserArmResourceInner> listStaticSiteUsersAsync(String resourceGroupName, String name,
        String authprovider) {
        return new PagedFlux<>(() -> listStaticSiteUsersSinglePageAsync(resourceGroupName, name, authprovider),
            nextLink -> listStaticSiteUsersNextSinglePageAsync(nextLink));
    }

    /**
     * Gets the list of users of a static site.
     * 
     * Description for Gets the list of users of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param authprovider The auth provider for the users.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom users as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<StaticSiteUserArmResourceInner> listStaticSiteUsersAsync(String resourceGroupName, String name,
        String authprovider, Context context) {
        return new PagedFlux<>(() -> listStaticSiteUsersSinglePageAsync(resourceGroupName, name, authprovider, context),
            nextLink -> listStaticSiteUsersNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets the list of users of a static site.
     * 
     * Description for Gets the list of users of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param authprovider The auth provider for the users.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom users as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteUserArmResourceInner> listStaticSiteUsers(String resourceGroupName, String name,
        String authprovider) {
        return new PagedIterable<>(listStaticSiteUsersAsync(resourceGroupName, name, authprovider));
    }

    /**
     * Gets the list of users of a static site.
     * 
     * Description for Gets the list of users of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param authprovider The auth provider for the users.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom users as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteUserArmResourceInner> listStaticSiteUsers(String resourceGroupName, String name,
        String authprovider, Context context) {
        return new PagedIterable<>(listStaticSiteUsersAsync(resourceGroupName, name, authprovider, context));
    }

    /**
     * Deletes the user entry from the static site.
     * 
     * Description for Deletes the user entry from the static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the staticsite.
     * @param authprovider The auth provider for this user.
     * @param userid The user id of the user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteStaticSiteUserWithResponseAsync(String resourceGroupName, String name,
        String authprovider, String userid) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (authprovider == null) {
            return Mono.error(new IllegalArgumentException("Parameter authprovider is required and cannot be null."));
        }
        if (userid == null) {
            return Mono.error(new IllegalArgumentException("Parameter userid is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteStaticSiteUser(this.client.getEndpoint(), resourceGroupName, name,
                authprovider, userid, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes the user entry from the static site.
     * 
     * Description for Deletes the user entry from the static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the staticsite.
     * @param authprovider The auth provider for this user.
     * @param userid The user id of the user.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteStaticSiteUserWithResponseAsync(String resourceGroupName, String name,
        String authprovider, String userid, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (authprovider == null) {
            return Mono.error(new IllegalArgumentException("Parameter authprovider is required and cannot be null."));
        }
        if (userid == null) {
            return Mono.error(new IllegalArgumentException("Parameter userid is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteStaticSiteUser(this.client.getEndpoint(), resourceGroupName, name, authprovider, userid,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes the user entry from the static site.
     * 
     * Description for Deletes the user entry from the static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the staticsite.
     * @param authprovider The auth provider for this user.
     * @param userid The user id of the user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteStaticSiteUserAsync(String resourceGroupName, String name, String authprovider,
        String userid) {
        return deleteStaticSiteUserWithResponseAsync(resourceGroupName, name, authprovider, userid)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes the user entry from the static site.
     * 
     * Description for Deletes the user entry from the static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the staticsite.
     * @param authprovider The auth provider for this user.
     * @param userid The user id of the user.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteStaticSiteUserWithResponse(String resourceGroupName, String name, String authprovider,
        String userid, Context context) {
        return deleteStaticSiteUserWithResponseAsync(resourceGroupName, name, authprovider, userid, context).block();
    }

    /**
     * Deletes the user entry from the static site.
     * 
     * Description for Deletes the user entry from the static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the staticsite.
     * @param authprovider The auth provider for this user.
     * @param userid The user id of the user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteStaticSiteUser(String resourceGroupName, String name, String authprovider, String userid) {
        deleteStaticSiteUserWithResponse(resourceGroupName, name, authprovider, userid, Context.NONE);
    }

    /**
     * Updates a user entry with the listed roles
     * 
     * Description for Updates a user entry with the listed roles.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param authprovider The auth provider for this user.
     * @param userid The user id of the user.
     * @param staticSiteUserEnvelope A JSON representation of the StaticSiteUser properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StaticSiteUserArmResourceInner>> updateStaticSiteUserWithResponseAsync(
        String resourceGroupName, String name, String authprovider, String userid,
        StaticSiteUserArmResourceInner staticSiteUserEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (authprovider == null) {
            return Mono.error(new IllegalArgumentException("Parameter authprovider is required and cannot be null."));
        }
        if (userid == null) {
            return Mono.error(new IllegalArgumentException("Parameter userid is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteUserEnvelope == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter staticSiteUserEnvelope is required and cannot be null."));
        } else {
            staticSiteUserEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateStaticSiteUser(this.client.getEndpoint(), resourceGroupName, name,
                authprovider, userid, this.client.getSubscriptionId(), this.client.getApiVersion(),
                staticSiteUserEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates a user entry with the listed roles
     * 
     * Description for Updates a user entry with the listed roles.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param authprovider The auth provider for this user.
     * @param userid The user id of the user.
     * @param staticSiteUserEnvelope A JSON representation of the StaticSiteUser properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StaticSiteUserArmResourceInner>> updateStaticSiteUserWithResponseAsync(
        String resourceGroupName, String name, String authprovider, String userid,
        StaticSiteUserArmResourceInner staticSiteUserEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (authprovider == null) {
            return Mono.error(new IllegalArgumentException("Parameter authprovider is required and cannot be null."));
        }
        if (userid == null) {
            return Mono.error(new IllegalArgumentException("Parameter userid is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteUserEnvelope == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter staticSiteUserEnvelope is required and cannot be null."));
        } else {
            staticSiteUserEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateStaticSiteUser(this.client.getEndpoint(), resourceGroupName, name, authprovider, userid,
            this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteUserEnvelope, accept, context);
    }

    /**
     * Updates a user entry with the listed roles
     * 
     * Description for Updates a user entry with the listed roles.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param authprovider The auth provider for this user.
     * @param userid The user id of the user.
     * @param staticSiteUserEnvelope A JSON representation of the StaticSiteUser properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSiteUserArmResourceInner> updateStaticSiteUserAsync(String resourceGroupName, String name,
        String authprovider, String userid, StaticSiteUserArmResourceInner staticSiteUserEnvelope) {
        return updateStaticSiteUserWithResponseAsync(resourceGroupName, name, authprovider, userid,
            staticSiteUserEnvelope).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates a user entry with the listed roles
     * 
     * Description for Updates a user entry with the listed roles.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param authprovider The auth provider for this user.
     * @param userid The user id of the user.
     * @param staticSiteUserEnvelope A JSON representation of the StaticSiteUser properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StaticSiteUserArmResourceInner> updateStaticSiteUserWithResponse(String resourceGroupName,
        String name, String authprovider, String userid, StaticSiteUserArmResourceInner staticSiteUserEnvelope,
        Context context) {
        return updateStaticSiteUserWithResponseAsync(resourceGroupName, name, authprovider, userid,
            staticSiteUserEnvelope, context).block();
    }

    /**
     * Updates a user entry with the listed roles
     * 
     * Description for Updates a user entry with the listed roles.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param authprovider The auth provider for this user.
     * @param userid The user id of the user.
     * @param staticSiteUserEnvelope A JSON representation of the StaticSiteUser properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteUserArmResourceInner updateStaticSiteUser(String resourceGroupName, String name,
        String authprovider, String userid, StaticSiteUserArmResourceInner staticSiteUserEnvelope) {
        return updateStaticSiteUserWithResponse(resourceGroupName, name, authprovider, userid, staticSiteUserEnvelope,
            Context.NONE).getValue();
    }

    /**
     * Gets all static site builds for a particular static site.
     * 
     * Description for Gets all static site builds for a particular static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site builds along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteBuildArmResourceInner>>
        getStaticSiteBuildsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getStaticSiteBuilds(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<StaticSiteBuildArmResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets all static site builds for a particular static site.
     * 
     * Description for Gets all static site builds for a particular static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site builds along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteBuildArmResourceInner>>
        getStaticSiteBuildsSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getStaticSiteBuilds(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets all static site builds for a particular static site.
     * 
     * Description for Gets all static site builds for a particular static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site builds as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<StaticSiteBuildArmResourceInner> getStaticSiteBuildsAsync(String resourceGroupName, String name) {
        return new PagedFlux<>(() -> getStaticSiteBuildsSinglePageAsync(resourceGroupName, name),
            nextLink -> getStaticSiteBuildsNextSinglePageAsync(nextLink));
    }

    /**
     * Gets all static site builds for a particular static site.
     * 
     * Description for Gets all static site builds for a particular static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site builds as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<StaticSiteBuildArmResourceInner> getStaticSiteBuildsAsync(String resourceGroupName, String name,
        Context context) {
        return new PagedFlux<>(() -> getStaticSiteBuildsSinglePageAsync(resourceGroupName, name, context),
            nextLink -> getStaticSiteBuildsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets all static site builds for a particular static site.
     * 
     * Description for Gets all static site builds for a particular static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site builds as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteBuildArmResourceInner> getStaticSiteBuilds(String resourceGroupName, String name) {
        return new PagedIterable<>(getStaticSiteBuildsAsync(resourceGroupName, name));
    }

    /**
     * Gets all static site builds for a particular static site.
     * 
     * Description for Gets all static site builds for a particular static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site builds as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteBuildArmResourceInner> getStaticSiteBuilds(String resourceGroupName, String name,
        Context context) {
        return new PagedIterable<>(getStaticSiteBuildsAsync(resourceGroupName, name, context));
    }

    /**
     * Gets the details of a static site build.
     * 
     * Description for Gets the details of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Build ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StaticSiteBuildArmResourceInner>> getStaticSiteBuildWithResponseAsync(String resourceGroupName,
        String name, String environmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name,
                environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the details of a static site build.
     * 
     * Description for Gets the details of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Build ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StaticSiteBuildArmResourceInner>> getStaticSiteBuildWithResponseAsync(
        String resourceGroupName, String name, String environmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the details of a static site build.
     * 
     * Description for Gets the details of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Build ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSiteBuildArmResourceInner> getStaticSiteBuildAsync(String resourceGroupName, String name,
        String environmentName) {
        return getStaticSiteBuildWithResponseAsync(resourceGroupName, name, environmentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the details of a static site build.
     * 
     * Description for Gets the details of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Build ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StaticSiteBuildArmResourceInner> getStaticSiteBuildWithResponse(String resourceGroupName,
        String name, String environmentName, Context context) {
        return getStaticSiteBuildWithResponseAsync(resourceGroupName, name, environmentName, context).block();
    }

    /**
     * Gets the details of a static site build.
     * 
     * Description for Gets the details of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Build ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteBuildArmResourceInner getStaticSiteBuild(String resourceGroupName, String name,
        String environmentName) {
        return getStaticSiteBuildWithResponse(resourceGroupName, name, environmentName, Context.NONE).getValue();
    }

    /**
     * Deletes a static site build.
     * 
     * Description for Deletes a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteStaticSiteBuildWithResponseAsync(String resourceGroupName,
        String name, String environmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name,
                environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a static site build.
     * 
     * Description for Deletes a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteStaticSiteBuildWithResponseAsync(String resourceGroupName,
        String name, String environmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes a static site build.
     * 
     * Description for Deletes a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteStaticSiteBuildAsync(String resourceGroupName, String name,
        String environmentName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteStaticSiteBuildWithResponseAsync(resourceGroupName, name, environmentName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes a static site build.
     * 
     * Description for Deletes a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteStaticSiteBuildAsync(String resourceGroupName, String name,
        String environmentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteStaticSiteBuildWithResponseAsync(resourceGroupName, name, environmentName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes a static site build.
     * 
     * Description for Deletes a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteStaticSiteBuild(String resourceGroupName, String name,
        String environmentName) {
        return this.beginDeleteStaticSiteBuildAsync(resourceGroupName, name, environmentName).getSyncPoller();
    }

    /**
     * Deletes a static site build.
     * 
     * Description for Deletes a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteStaticSiteBuild(String resourceGroupName, String name,
        String environmentName, Context context) {
        return this.beginDeleteStaticSiteBuildAsync(resourceGroupName, name, environmentName, context).getSyncPoller();
    }

    /**
     * Deletes a static site build.
     * 
     * Description for Deletes a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName) {
        return beginDeleteStaticSiteBuildAsync(resourceGroupName, name, environmentName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a static site build.
     * 
     * Description for Deletes a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName,
        Context context) {
        return beginDeleteStaticSiteBuildAsync(resourceGroupName, name, environmentName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a static site build.
     * 
     * Description for Deletes a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteStaticSiteBuild(String resourceGroupName, String name, String environmentName) {
        deleteStaticSiteBuildAsync(resourceGroupName, name, environmentName).block();
    }

    /**
     * Deletes a static site build.
     * 
     * Description for Deletes a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteStaticSiteBuild(String resourceGroupName, String name, String environmentName, Context context) {
        deleteStaticSiteBuildAsync(resourceGroupName, name, environmentName, context).block();
    }

    /**
     * Creates or updates the app settings of a static site build.
     * 
     * Description for Creates or updates the app settings of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param appSettings The dictionary containing the static site app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteBuildAppSettingsWithResponseAsync(
        String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error(new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        } else {
            appSettings.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdateStaticSiteBuildAppSettings(this.client.getEndpoint(),
                resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                appSettings, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates the app settings of a static site build.
     * 
     * Description for Creates or updates the app settings of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param appSettings The dictionary containing the static site app settings to update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteBuildAppSettingsWithResponseAsync(
        String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error(new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        } else {
            appSettings.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdateStaticSiteBuildAppSettings(this.client.getEndpoint(), resourceGroupName, name,
            environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, accept,
            context);
    }

    /**
     * Creates or updates the app settings of a static site build.
     * 
     * Description for Creates or updates the app settings of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param appSettings The dictionary containing the static site app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StringDictionaryInner> createOrUpdateStaticSiteBuildAppSettingsAsync(String resourceGroupName,
        String name, String environmentName, StringDictionaryInner appSettings) {
        return createOrUpdateStaticSiteBuildAppSettingsWithResponseAsync(resourceGroupName, name, environmentName,
            appSettings).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates or updates the app settings of a static site build.
     * 
     * Description for Creates or updates the app settings of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param appSettings The dictionary containing the static site app settings to update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StringDictionaryInner> createOrUpdateStaticSiteBuildAppSettingsWithResponse(
        String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings,
        Context context) {
        return createOrUpdateStaticSiteBuildAppSettingsWithResponseAsync(resourceGroupName, name, environmentName,
            appSettings, context).block();
    }

    /**
     * Creates or updates the app settings of a static site build.
     * 
     * Description for Creates or updates the app settings of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param appSettings The dictionary containing the static site app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StringDictionaryInner createOrUpdateStaticSiteBuildAppSettings(String resourceGroupName, String name,
        String environmentName, StringDictionaryInner appSettings) {
        return createOrUpdateStaticSiteBuildAppSettingsWithResponse(resourceGroupName, name, environmentName,
            appSettings, Context.NONE).getValue();
    }

    /**
     * Creates or updates the function app settings of a static site build.
     * 
     * Description for Creates or updates the function app settings of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param appSettings The dictionary containing the static site function app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteBuildFunctionAppSettingsWithResponseAsync(
        String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error(new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        } else {
            appSettings.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdateStaticSiteBuildFunctionAppSettings(this.client.getEndpoint(),
                resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                appSettings, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates the function app settings of a static site build.
     * 
     * Description for Creates or updates the function app settings of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param appSettings The dictionary containing the static site function app settings to update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteBuildFunctionAppSettingsWithResponseAsync(
        String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error(new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        } else {
            appSettings.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdateStaticSiteBuildFunctionAppSettings(this.client.getEndpoint(), resourceGroupName,
            name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, accept,
            context);
    }

    /**
     * Creates or updates the function app settings of a static site build.
     * 
     * Description for Creates or updates the function app settings of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param appSettings The dictionary containing the static site function app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StringDictionaryInner> createOrUpdateStaticSiteBuildFunctionAppSettingsAsync(String resourceGroupName,
        String name, String environmentName, StringDictionaryInner appSettings) {
        return createOrUpdateStaticSiteBuildFunctionAppSettingsWithResponseAsync(resourceGroupName, name,
            environmentName, appSettings).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates or updates the function app settings of a static site build.
     * 
     * Description for Creates or updates the function app settings of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param appSettings The dictionary containing the static site function app settings to update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StringDictionaryInner> createOrUpdateStaticSiteBuildFunctionAppSettingsWithResponse(
        String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings,
        Context context) {
        return createOrUpdateStaticSiteBuildFunctionAppSettingsWithResponseAsync(resourceGroupName, name,
            environmentName, appSettings, context).block();
    }

    /**
     * Creates or updates the function app settings of a static site build.
     * 
     * Description for Creates or updates the function app settings of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param appSettings The dictionary containing the static site function app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StringDictionaryInner createOrUpdateStaticSiteBuildFunctionAppSettings(String resourceGroupName, String name,
        String environmentName, StringDictionaryInner appSettings) {
        return createOrUpdateStaticSiteBuildFunctionAppSettingsWithResponse(resourceGroupName, name, environmentName,
            appSettings, Context.NONE).getValue();
    }

    /**
     * Returns overviews of database connections for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseConnectionInner>>
        getBuildDatabaseConnectionsSinglePageAsync(String resourceGroupName, String name, String environmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getBuildDatabaseConnections(this.client.getEndpoint(), resourceGroupName,
                name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<DatabaseConnectionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns overviews of database connections for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseConnectionInner>> getBuildDatabaseConnectionsSinglePageAsync(
        String resourceGroupName, String name, String environmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getBuildDatabaseConnections(this.client.getEndpoint(), resourceGroupName, name, environmentName,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Returns overviews of database connections for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DatabaseConnectionInner> getBuildDatabaseConnectionsAsync(String resourceGroupName, String name,
        String environmentName) {
        return new PagedFlux<>(
            () -> getBuildDatabaseConnectionsSinglePageAsync(resourceGroupName, name, environmentName),
            nextLink -> getBuildDatabaseConnectionsNextSinglePageAsync(nextLink));
    }

    /**
     * Returns overviews of database connections for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DatabaseConnectionInner> getBuildDatabaseConnectionsAsync(String resourceGroupName, String name,
        String environmentName, Context context) {
        return new PagedFlux<>(
            () -> getBuildDatabaseConnectionsSinglePageAsync(resourceGroupName, name, environmentName, context),
            nextLink -> getBuildDatabaseConnectionsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Returns overviews of database connections for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DatabaseConnectionInner> getBuildDatabaseConnections(String resourceGroupName, String name,
        String environmentName) {
        return new PagedIterable<>(getBuildDatabaseConnectionsAsync(resourceGroupName, name, environmentName));
    }

    /**
     * Returns overviews of database connections for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DatabaseConnectionInner> getBuildDatabaseConnections(String resourceGroupName, String name,
        String environmentName, Context context) {
        return new PagedIterable<>(getBuildDatabaseConnectionsAsync(resourceGroupName, name, environmentName, context));
    }

    /**
     * Returns overview of a database connection for a static site build by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DatabaseConnectionInner>> getBuildDatabaseConnectionWithResponseAsync(String resourceGroupName,
        String name, String environmentName, String databaseConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (databaseConnectionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter databaseConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getBuildDatabaseConnection(this.client.getEndpoint(), resourceGroupName,
                name, environmentName, databaseConnectionName, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns overview of a database connection for a static site build by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DatabaseConnectionInner>> getBuildDatabaseConnectionWithResponseAsync(
        String resourceGroupName, String name, String environmentName, String databaseConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (databaseConnectionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter databaseConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getBuildDatabaseConnection(this.client.getEndpoint(), resourceGroupName, name, environmentName,
            databaseConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Returns overview of a database connection for a static site build by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DatabaseConnectionInner> getBuildDatabaseConnectionAsync(String resourceGroupName, String name,
        String environmentName, String databaseConnectionName) {
        return getBuildDatabaseConnectionWithResponseAsync(resourceGroupName, name, environmentName,
            databaseConnectionName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Returns overview of a database connection for a static site build by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DatabaseConnectionInner> getBuildDatabaseConnectionWithResponse(String resourceGroupName,
        String name, String environmentName, String databaseConnectionName, Context context) {
        return getBuildDatabaseConnectionWithResponseAsync(resourceGroupName, name, environmentName,
            databaseConnectionName, context).block();
    }

    /**
     * Returns overview of a database connection for a static site build by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DatabaseConnectionInner getBuildDatabaseConnection(String resourceGroupName, String name,
        String environmentName, String databaseConnectionName) {
        return getBuildDatabaseConnectionWithResponse(resourceGroupName, name, environmentName, databaseConnectionName,
            Context.NONE).getValue();
    }

    /**
     * Create or update a database connection for a static site build
     * 
     * Description for Create or update a database connection for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @param databaseConnectionRequestEnvelope A JSON representation of the database connection request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DatabaseConnectionInner>> createOrUpdateBuildDatabaseConnectionWithResponseAsync(
        String resourceGroupName, String name, String environmentName, String databaseConnectionName,
        DatabaseConnectionInner databaseConnectionRequestEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (databaseConnectionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter databaseConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (databaseConnectionRequestEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter databaseConnectionRequestEnvelope is required and cannot be null."));
        } else {
            databaseConnectionRequestEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdateBuildDatabaseConnection(this.client.getEndpoint(),
                resourceGroupName, name, environmentName, databaseConnectionName, this.client.getSubscriptionId(),
                this.client.getApiVersion(), databaseConnectionRequestEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update a database connection for a static site build
     * 
     * Description for Create or update a database connection for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @param databaseConnectionRequestEnvelope A JSON representation of the database connection request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DatabaseConnectionInner>> createOrUpdateBuildDatabaseConnectionWithResponseAsync(
        String resourceGroupName, String name, String environmentName, String databaseConnectionName,
        DatabaseConnectionInner databaseConnectionRequestEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (databaseConnectionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter databaseConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (databaseConnectionRequestEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter databaseConnectionRequestEnvelope is required and cannot be null."));
        } else {
            databaseConnectionRequestEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdateBuildDatabaseConnection(this.client.getEndpoint(), resourceGroupName, name,
            environmentName, databaseConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(),
            databaseConnectionRequestEnvelope, accept, context);
    }

    /**
     * Create or update a database connection for a static site build
     * 
     * Description for Create or update a database connection for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @param databaseConnectionRequestEnvelope A JSON representation of the database connection request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DatabaseConnectionInner> createOrUpdateBuildDatabaseConnectionAsync(String resourceGroupName,
        String name, String environmentName, String databaseConnectionName,
        DatabaseConnectionInner databaseConnectionRequestEnvelope) {
        return createOrUpdateBuildDatabaseConnectionWithResponseAsync(resourceGroupName, name, environmentName,
            databaseConnectionName, databaseConnectionRequestEnvelope).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Create or update a database connection for a static site build
     * 
     * Description for Create or update a database connection for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @param databaseConnectionRequestEnvelope A JSON representation of the database connection request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DatabaseConnectionInner> createOrUpdateBuildDatabaseConnectionWithResponse(String resourceGroupName,
        String name, String environmentName, String databaseConnectionName,
        DatabaseConnectionInner databaseConnectionRequestEnvelope, Context context) {
        return createOrUpdateBuildDatabaseConnectionWithResponseAsync(resourceGroupName, name, environmentName,
            databaseConnectionName, databaseConnectionRequestEnvelope, context).block();
    }

    /**
     * Create or update a database connection for a static site build
     * 
     * Description for Create or update a database connection for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @param databaseConnectionRequestEnvelope A JSON representation of the database connection request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DatabaseConnectionInner createOrUpdateBuildDatabaseConnection(String resourceGroupName, String name,
        String environmentName, String databaseConnectionName,
        DatabaseConnectionInner databaseConnectionRequestEnvelope) {
        return createOrUpdateBuildDatabaseConnectionWithResponse(resourceGroupName, name, environmentName,
            databaseConnectionName, databaseConnectionRequestEnvelope, Context.NONE).getValue();
    }

    /**
     * Delete a database connection for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteBuildDatabaseConnectionWithResponseAsync(String resourceGroupName, String name,
        String environmentName, String databaseConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (databaseConnectionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter databaseConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteBuildDatabaseConnection(this.client.getEndpoint(), resourceGroupName,
                name, environmentName, databaseConnectionName, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete a database connection for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteBuildDatabaseConnectionWithResponseAsync(String resourceGroupName, String name,
        String environmentName, String databaseConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (databaseConnectionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter databaseConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteBuildDatabaseConnection(this.client.getEndpoint(), resourceGroupName, name,
            environmentName, databaseConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Delete a database connection for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteBuildDatabaseConnectionAsync(String resourceGroupName, String name, String environmentName,
        String databaseConnectionName) {
        return deleteBuildDatabaseConnectionWithResponseAsync(resourceGroupName, name, environmentName,
            databaseConnectionName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete a database connection for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteBuildDatabaseConnectionWithResponse(String resourceGroupName, String name,
        String environmentName, String databaseConnectionName, Context context) {
        return deleteBuildDatabaseConnectionWithResponseAsync(resourceGroupName, name, environmentName,
            databaseConnectionName, context).block();
    }

    /**
     * Delete a database connection for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteBuildDatabaseConnection(String resourceGroupName, String name, String environmentName,
        String databaseConnectionName) {
        deleteBuildDatabaseConnectionWithResponse(resourceGroupName, name, environmentName, databaseConnectionName,
            Context.NONE);
    }

    /**
     * Create or update a database connection for a static site build
     * 
     * Description for Create or update a database connection for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @param databaseConnectionRequestEnvelope A JSON representation of the database connection request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DatabaseConnectionInner>> updateBuildDatabaseConnectionWithResponseAsync(
        String resourceGroupName, String name, String environmentName, String databaseConnectionName,
        DatabaseConnectionPatchRequest databaseConnectionRequestEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (databaseConnectionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter databaseConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (databaseConnectionRequestEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter databaseConnectionRequestEnvelope is required and cannot be null."));
        } else {
            databaseConnectionRequestEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateBuildDatabaseConnection(this.client.getEndpoint(), resourceGroupName,
                name, environmentName, databaseConnectionName, this.client.getSubscriptionId(),
                this.client.getApiVersion(), databaseConnectionRequestEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update a database connection for a static site build
     * 
     * Description for Create or update a database connection for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @param databaseConnectionRequestEnvelope A JSON representation of the database connection request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DatabaseConnectionInner>> updateBuildDatabaseConnectionWithResponseAsync(
        String resourceGroupName, String name, String environmentName, String databaseConnectionName,
        DatabaseConnectionPatchRequest databaseConnectionRequestEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (databaseConnectionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter databaseConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (databaseConnectionRequestEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter databaseConnectionRequestEnvelope is required and cannot be null."));
        } else {
            databaseConnectionRequestEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateBuildDatabaseConnection(this.client.getEndpoint(), resourceGroupName, name,
            environmentName, databaseConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(),
            databaseConnectionRequestEnvelope, accept, context);
    }

    /**
     * Create or update a database connection for a static site build
     * 
     * Description for Create or update a database connection for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @param databaseConnectionRequestEnvelope A JSON representation of the database connection request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DatabaseConnectionInner> updateBuildDatabaseConnectionAsync(String resourceGroupName, String name,
        String environmentName, String databaseConnectionName,
        DatabaseConnectionPatchRequest databaseConnectionRequestEnvelope) {
        return updateBuildDatabaseConnectionWithResponseAsync(resourceGroupName, name, environmentName,
            databaseConnectionName, databaseConnectionRequestEnvelope).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Create or update a database connection for a static site build
     * 
     * Description for Create or update a database connection for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @param databaseConnectionRequestEnvelope A JSON representation of the database connection request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DatabaseConnectionInner> updateBuildDatabaseConnectionWithResponse(String resourceGroupName,
        String name, String environmentName, String databaseConnectionName,
        DatabaseConnectionPatchRequest databaseConnectionRequestEnvelope, Context context) {
        return updateBuildDatabaseConnectionWithResponseAsync(resourceGroupName, name, environmentName,
            databaseConnectionName, databaseConnectionRequestEnvelope, context).block();
    }

    /**
     * Create or update a database connection for a static site build
     * 
     * Description for Create or update a database connection for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @param databaseConnectionRequestEnvelope A JSON representation of the database connection request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DatabaseConnectionInner updateBuildDatabaseConnection(String resourceGroupName, String name,
        String environmentName, String databaseConnectionName,
        DatabaseConnectionPatchRequest databaseConnectionRequestEnvelope) {
        return updateBuildDatabaseConnectionWithResponse(resourceGroupName, name, environmentName,
            databaseConnectionName, databaseConnectionRequestEnvelope, Context.NONE).getValue();
    }

    /**
     * Returns details of a database connection for a static site build by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DatabaseConnectionInner>> getBuildDatabaseConnectionWithDetailsWithResponseAsync(
        String resourceGroupName, String name, String environmentName, String databaseConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (databaseConnectionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter databaseConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getBuildDatabaseConnectionWithDetails(this.client.getEndpoint(),
                resourceGroupName, name, environmentName, databaseConnectionName, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns details of a database connection for a static site build by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DatabaseConnectionInner>> getBuildDatabaseConnectionWithDetailsWithResponseAsync(
        String resourceGroupName, String name, String environmentName, String databaseConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (databaseConnectionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter databaseConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getBuildDatabaseConnectionWithDetails(this.client.getEndpoint(), resourceGroupName, name,
            environmentName, databaseConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Returns details of a database connection for a static site build by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DatabaseConnectionInner> getBuildDatabaseConnectionWithDetailsAsync(String resourceGroupName,
        String name, String environmentName, String databaseConnectionName) {
        return getBuildDatabaseConnectionWithDetailsWithResponseAsync(resourceGroupName, name, environmentName,
            databaseConnectionName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Returns details of a database connection for a static site build by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DatabaseConnectionInner> getBuildDatabaseConnectionWithDetailsWithResponse(String resourceGroupName,
        String name, String environmentName, String databaseConnectionName, Context context) {
        return getBuildDatabaseConnectionWithDetailsWithResponseAsync(resourceGroupName, name, environmentName,
            databaseConnectionName, context).block();
    }

    /**
     * Returns details of a database connection for a static site build by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param databaseConnectionName Name of the database connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DatabaseConnectionInner getBuildDatabaseConnectionWithDetails(String resourceGroupName, String name,
        String environmentName, String databaseConnectionName) {
        return getBuildDatabaseConnectionWithDetailsWithResponse(resourceGroupName, name, environmentName,
            databaseConnectionName, Context.NONE).getValue();
    }

    /**
     * Gets the functions of a particular static site build.
     * 
     * Description for Gets the functions of a particular static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>>
        listStaticSiteBuildFunctionsSinglePageAsync(String resourceGroupName, String name, String environmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listStaticSiteBuildFunctions(this.client.getEndpoint(), resourceGroupName,
                name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the functions of a particular static site build.
     * 
     * Description for Gets the functions of a particular static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>> listStaticSiteBuildFunctionsSinglePageAsync(
        String resourceGroupName, String name, String environmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listStaticSiteBuildFunctions(this.client.getEndpoint(), resourceGroupName, name, environmentName,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets the functions of a particular static site build.
     * 
     * Description for Gets the functions of a particular static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<StaticSiteFunctionOverviewArmResourceInner>
        listStaticSiteBuildFunctionsAsync(String resourceGroupName, String name, String environmentName) {
        return new PagedFlux<>(
            () -> listStaticSiteBuildFunctionsSinglePageAsync(resourceGroupName, name, environmentName),
            nextLink -> listStaticSiteBuildFunctionsNextSinglePageAsync(nextLink));
    }

    /**
     * Gets the functions of a particular static site build.
     * 
     * Description for Gets the functions of a particular static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteBuildFunctionsAsync(
        String resourceGroupName, String name, String environmentName, Context context) {
        return new PagedFlux<>(
            () -> listStaticSiteBuildFunctionsSinglePageAsync(resourceGroupName, name, environmentName, context),
            nextLink -> listStaticSiteBuildFunctionsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets the functions of a particular static site build.
     * 
     * Description for Gets the functions of a particular static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteFunctionOverviewArmResourceInner>
        listStaticSiteBuildFunctions(String resourceGroupName, String name, String environmentName) {
        return new PagedIterable<>(listStaticSiteBuildFunctionsAsync(resourceGroupName, name, environmentName));
    }

    /**
     * Gets the functions of a particular static site build.
     * 
     * Description for Gets the functions of a particular static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteFunctionOverviewArmResourceInner>
        listStaticSiteBuildFunctions(String resourceGroupName, String name, String environmentName, Context context) {
        return new PagedIterable<>(
            listStaticSiteBuildFunctionsAsync(resourceGroupName, name, environmentName, context));
    }

    /**
     * Gets the application settings of a static site build.
     * 
     * Description for Gets the application settings of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>>
        listStaticSiteBuildAppSettingsWithResponseAsync(String resourceGroupName, String name, String environmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listStaticSiteBuildAppSettings(this.client.getEndpoint(), resourceGroupName,
                name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the application settings of a static site build.
     * 
     * Description for Gets the application settings of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>> listStaticSiteBuildAppSettingsWithResponseAsync(
        String resourceGroupName, String name, String environmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listStaticSiteBuildAppSettings(this.client.getEndpoint(), resourceGroupName, name,
            environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the application settings of a static site build.
     * 
     * Description for Gets the application settings of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StringDictionaryInner> listStaticSiteBuildAppSettingsAsync(String resourceGroupName, String name,
        String environmentName) {
        return listStaticSiteBuildAppSettingsWithResponseAsync(resourceGroupName, name, environmentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the application settings of a static site build.
     * 
     * Description for Gets the application settings of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StringDictionaryInner> listStaticSiteBuildAppSettingsWithResponse(String resourceGroupName,
        String name, String environmentName, Context context) {
        return listStaticSiteBuildAppSettingsWithResponseAsync(resourceGroupName, name, environmentName, context)
            .block();
    }

    /**
     * Gets the application settings of a static site build.
     * 
     * Description for Gets the application settings of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StringDictionaryInner listStaticSiteBuildAppSettings(String resourceGroupName, String name,
        String environmentName) {
        return listStaticSiteBuildAppSettingsWithResponse(resourceGroupName, name, environmentName, Context.NONE)
            .getValue();
    }

    /**
     * Gets the application settings of a static site build.
     * 
     * Description for Gets the application settings of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>> listStaticSiteBuildFunctionAppSettingsWithResponseAsync(
        String resourceGroupName, String name, String environmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listStaticSiteBuildFunctionAppSettings(this.client.getEndpoint(),
                resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the application settings of a static site build.
     * 
     * Description for Gets the application settings of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>> listStaticSiteBuildFunctionAppSettingsWithResponseAsync(
        String resourceGroupName, String name, String environmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listStaticSiteBuildFunctionAppSettings(this.client.getEndpoint(), resourceGroupName, name,
            environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the application settings of a static site build.
     * 
     * Description for Gets the application settings of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StringDictionaryInner> listStaticSiteBuildFunctionAppSettingsAsync(String resourceGroupName,
        String name, String environmentName) {
        return listStaticSiteBuildFunctionAppSettingsWithResponseAsync(resourceGroupName, name, environmentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the application settings of a static site build.
     * 
     * Description for Gets the application settings of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StringDictionaryInner> listStaticSiteBuildFunctionAppSettingsWithResponse(String resourceGroupName,
        String name, String environmentName, Context context) {
        return listStaticSiteBuildFunctionAppSettingsWithResponseAsync(resourceGroupName, name, environmentName,
            context).block();
    }

    /**
     * Gets the application settings of a static site build.
     * 
     * Description for Gets the application settings of a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StringDictionaryInner listStaticSiteBuildFunctionAppSettings(String resourceGroupName, String name,
        String environmentName) {
        return listStaticSiteBuildFunctionAppSettingsWithResponse(resourceGroupName, name, environmentName,
            Context.NONE).getValue();
    }

    /**
     * Returns details of database connections for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseConnectionInner>> getBuildDatabaseConnectionsWithDetailsSinglePageAsync(
        String resourceGroupName, String name, String environmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getBuildDatabaseConnectionsWithDetails(this.client.getEndpoint(),
                resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                accept, context))
            .<PagedResponse<DatabaseConnectionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns details of database connections for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseConnectionInner>> getBuildDatabaseConnectionsWithDetailsSinglePageAsync(
        String resourceGroupName, String name, String environmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getBuildDatabaseConnectionsWithDetails(this.client.getEndpoint(), resourceGroupName, name, environmentName,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Returns details of database connections for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DatabaseConnectionInner> getBuildDatabaseConnectionsWithDetailsAsync(String resourceGroupName,
        String name, String environmentName) {
        return new PagedFlux<>(
            () -> getBuildDatabaseConnectionsWithDetailsSinglePageAsync(resourceGroupName, name, environmentName),
            nextLink -> getBuildDatabaseConnectionsWithDetailsNextSinglePageAsync(nextLink));
    }

    /**
     * Returns details of database connections for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DatabaseConnectionInner> getBuildDatabaseConnectionsWithDetailsAsync(String resourceGroupName,
        String name, String environmentName, Context context) {
        return new PagedFlux<>(() -> getBuildDatabaseConnectionsWithDetailsSinglePageAsync(resourceGroupName, name,
            environmentName, context),
            nextLink -> getBuildDatabaseConnectionsWithDetailsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Returns details of database connections for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DatabaseConnectionInner> getBuildDatabaseConnectionsWithDetails(String resourceGroupName,
        String name, String environmentName) {
        return new PagedIterable<>(
            getBuildDatabaseConnectionsWithDetailsAsync(resourceGroupName, name, environmentName));
    }

    /**
     * Returns details of database connections for a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DatabaseConnectionInner> getBuildDatabaseConnectionsWithDetails(String resourceGroupName,
        String name, String environmentName, Context context) {
        return new PagedIterable<>(
            getBuildDatabaseConnectionsWithDetailsAsync(resourceGroupName, name, environmentName, context));
    }

    /**
     * Gets the details of the user provided function apps registered with a static site build
     * 
     * Description for Gets the details of the user provided function apps registered with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteUserProvidedFunctionAppArmResourceInner>>
        getUserProvidedFunctionAppsForStaticSiteBuildSinglePageAsync(String resourceGroupName, String name,
            String environmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getUserProvidedFunctionAppsForStaticSiteBuild(this.client.getEndpoint(),
                resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                accept, context))
            .<PagedResponse<StaticSiteUserProvidedFunctionAppArmResourceInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the details of the user provided function apps registered with a static site build
     * 
     * Description for Gets the details of the user provided function apps registered with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteUserProvidedFunctionAppArmResourceInner>>
        getUserProvidedFunctionAppsForStaticSiteBuildSinglePageAsync(String resourceGroupName, String name,
            String environmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getUserProvidedFunctionAppsForStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name,
                environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets the details of the user provided function apps registered with a static site build
     * 
     * Description for Gets the details of the user provided function apps registered with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<StaticSiteUserProvidedFunctionAppArmResourceInner>
        getUserProvidedFunctionAppsForStaticSiteBuildAsync(String resourceGroupName, String name,
            String environmentName) {
        return new PagedFlux<>(
            () -> getUserProvidedFunctionAppsForStaticSiteBuildSinglePageAsync(resourceGroupName, name,
                environmentName),
            nextLink -> getUserProvidedFunctionAppsForStaticSiteBuildNextSinglePageAsync(nextLink));
    }

    /**
     * Gets the details of the user provided function apps registered with a static site build
     * 
     * Description for Gets the details of the user provided function apps registered with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<StaticSiteUserProvidedFunctionAppArmResourceInner>
        getUserProvidedFunctionAppsForStaticSiteBuildAsync(String resourceGroupName, String name,
            String environmentName, Context context) {
        return new PagedFlux<>(
            () -> getUserProvidedFunctionAppsForStaticSiteBuildSinglePageAsync(resourceGroupName, name, environmentName,
                context),
            nextLink -> getUserProvidedFunctionAppsForStaticSiteBuildNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets the details of the user provided function apps registered with a static site build
     * 
     * Description for Gets the details of the user provided function apps registered with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteUserProvidedFunctionAppArmResourceInner>
        getUserProvidedFunctionAppsForStaticSiteBuild(String resourceGroupName, String name, String environmentName) {
        return new PagedIterable<>(
            getUserProvidedFunctionAppsForStaticSiteBuildAsync(resourceGroupName, name, environmentName));
    }

    /**
     * Gets the details of the user provided function apps registered with a static site build
     * 
     * Description for Gets the details of the user provided function apps registered with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteUserProvidedFunctionAppArmResourceInner>
        getUserProvidedFunctionAppsForStaticSiteBuild(String resourceGroupName, String name, String environmentName,
            Context context) {
        return new PagedIterable<>(
            getUserProvidedFunctionAppsForStaticSiteBuildAsync(resourceGroupName, name, environmentName, context));
    }

    /**
     * Gets the details of the user provided function app registered with a static site build
     * 
     * Description for Gets the details of the user provided function app registered with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app registered with the static site build.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StaticSiteUserProvidedFunctionAppArmResourceInner>>
        getUserProvidedFunctionAppForStaticSiteBuildWithResponseAsync(String resourceGroupName, String name,
            String environmentName, String functionAppName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getUserProvidedFunctionAppForStaticSiteBuild(this.client.getEndpoint(),
                resourceGroupName, name, environmentName, functionAppName, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the details of the user provided function app registered with a static site build
     * 
     * Description for Gets the details of the user provided function app registered with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app registered with the static site build.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StaticSiteUserProvidedFunctionAppArmResourceInner>>
        getUserProvidedFunctionAppForStaticSiteBuildWithResponseAsync(String resourceGroupName, String name,
            String environmentName, String functionAppName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getUserProvidedFunctionAppForStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name,
            environmentName, functionAppName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Gets the details of the user provided function app registered with a static site build
     * 
     * Description for Gets the details of the user provided function app registered with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app registered with the static site build.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppForStaticSiteBuildAsync(
        String resourceGroupName, String name, String environmentName, String functionAppName) {
        return getUserProvidedFunctionAppForStaticSiteBuildWithResponseAsync(resourceGroupName, name, environmentName,
            functionAppName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the details of the user provided function app registered with a static site build
     * 
     * Description for Gets the details of the user provided function app registered with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app registered with the static site build.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StaticSiteUserProvidedFunctionAppArmResourceInner>
        getUserProvidedFunctionAppForStaticSiteBuildWithResponse(String resourceGroupName, String name,
            String environmentName, String functionAppName, Context context) {
        return getUserProvidedFunctionAppForStaticSiteBuildWithResponseAsync(resourceGroupName, name, environmentName,
            functionAppName, context).block();
    }

    /**
     * Gets the details of the user provided function app registered with a static site build
     * 
     * Description for Gets the details of the user provided function app registered with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app registered with the static site build.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteUserProvidedFunctionAppArmResourceInner getUserProvidedFunctionAppForStaticSiteBuild(
        String resourceGroupName, String name, String environmentName, String functionAppName) {
        return getUserProvidedFunctionAppForStaticSiteBuildWithResponse(resourceGroupName, name, environmentName,
            functionAppName, Context.NONE).getValue();
    }

    /**
     * Register a user provided function app with a static site build
     * 
     * Description for Register a user provided function app with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     * function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     * &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> registerUserProvidedFunctionAppWithStaticSiteBuildWithResponseAsync(
        String resourceGroupName, String name, String environmentName, String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteUserProvidedFunctionEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteUserProvidedFunctionEnvelope is required and cannot be null."));
        } else {
            staticSiteUserProvidedFunctionEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.registerUserProvidedFunctionAppWithStaticSiteBuild(
                this.client.getEndpoint(), resourceGroupName, name, environmentName, functionAppName, isForced,
                this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteUserProvidedFunctionEnvelope,
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Register a user provided function app with a static site build
     * 
     * Description for Register a user provided function app with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     * function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     * &lt;code&gt;false&lt;/code&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> registerUserProvidedFunctionAppWithStaticSiteBuildWithResponseAsync(
        String resourceGroupName, String name, String environmentName, String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteUserProvidedFunctionEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteUserProvidedFunctionEnvelope is required and cannot be null."));
        } else {
            staticSiteUserProvidedFunctionEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.registerUserProvidedFunctionAppWithStaticSiteBuild(this.client.getEndpoint(), resourceGroupName,
            name, environmentName, functionAppName, isForced, this.client.getSubscriptionId(),
            this.client.getApiVersion(), staticSiteUserProvidedFunctionEnvelope, accept, context);
    }

    /**
     * Register a user provided function app with a static site build
     * 
     * Description for Register a user provided function app with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     * function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     * &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        PollerFlux<PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>, StaticSiteUserProvidedFunctionAppArmResourceInner>
        beginRegisterUserProvidedFunctionAppWithStaticSiteBuildAsync(String resourceGroupName, String name,
            String environmentName, String functionAppName,
            StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope,
            Boolean isForced) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = registerUserProvidedFunctionAppWithStaticSiteBuildWithResponseAsync(resourceGroupName, name,
                environmentName, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced);
        return this.client
            .<StaticSiteUserProvidedFunctionAppArmResourceInner, StaticSiteUserProvidedFunctionAppArmResourceInner>getLroResult(
                mono, this.client.getHttpPipeline(), StaticSiteUserProvidedFunctionAppArmResourceInner.class,
                StaticSiteUserProvidedFunctionAppArmResourceInner.class, this.client.getContext());
    }

    /**
     * Register a user provided function app with a static site build
     * 
     * Description for Register a user provided function app with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        PollerFlux<PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>, StaticSiteUserProvidedFunctionAppArmResourceInner>
        beginRegisterUserProvidedFunctionAppWithStaticSiteBuildAsync(String resourceGroupName, String name,
            String environmentName, String functionAppName,
            StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope) {
        final Boolean isForced = null;
        Mono<Response<Flux<ByteBuffer>>> mono
            = registerUserProvidedFunctionAppWithStaticSiteBuildWithResponseAsync(resourceGroupName, name,
                environmentName, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced);
        return this.client
            .<StaticSiteUserProvidedFunctionAppArmResourceInner, StaticSiteUserProvidedFunctionAppArmResourceInner>getLroResult(
                mono, this.client.getHttpPipeline(), StaticSiteUserProvidedFunctionAppArmResourceInner.class,
                StaticSiteUserProvidedFunctionAppArmResourceInner.class, this.client.getContext());
    }

    /**
     * Register a user provided function app with a static site build
     * 
     * Description for Register a user provided function app with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     * function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     * &lt;code&gt;false&lt;/code&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private
        PollerFlux<PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>, StaticSiteUserProvidedFunctionAppArmResourceInner>
        beginRegisterUserProvidedFunctionAppWithStaticSiteBuildAsync(String resourceGroupName, String name,
            String environmentName, String functionAppName,
            StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = registerUserProvidedFunctionAppWithStaticSiteBuildWithResponseAsync(resourceGroupName, name,
                environmentName, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced, context);
        return this.client
            .<StaticSiteUserProvidedFunctionAppArmResourceInner, StaticSiteUserProvidedFunctionAppArmResourceInner>getLroResult(
                mono, this.client.getHttpPipeline(), StaticSiteUserProvidedFunctionAppArmResourceInner.class,
                StaticSiteUserProvidedFunctionAppArmResourceInner.class, context);
    }

    /**
     * Register a user provided function app with a static site build
     * 
     * Description for Register a user provided function app with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>, StaticSiteUserProvidedFunctionAppArmResourceInner>
        beginRegisterUserProvidedFunctionAppWithStaticSiteBuild(String resourceGroupName, String name,
            String environmentName, String functionAppName,
            StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope) {
        final Boolean isForced = null;
        return this.beginRegisterUserProvidedFunctionAppWithStaticSiteBuildAsync(resourceGroupName, name,
            environmentName, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced).getSyncPoller();
    }

    /**
     * Register a user provided function app with a static site build
     * 
     * Description for Register a user provided function app with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     * function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     * &lt;code&gt;false&lt;/code&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>, StaticSiteUserProvidedFunctionAppArmResourceInner>
        beginRegisterUserProvidedFunctionAppWithStaticSiteBuild(String resourceGroupName, String name,
            String environmentName, String functionAppName,
            StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced,
            Context context) {
        return this.beginRegisterUserProvidedFunctionAppWithStaticSiteBuildAsync(resourceGroupName, name,
            environmentName, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced, context)
            .getSyncPoller();
    }

    /**
     * Register a user provided function app with a static site build
     * 
     * Description for Register a user provided function app with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     * function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     * &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSiteUserProvidedFunctionAppArmResourceInner>
        registerUserProvidedFunctionAppWithStaticSiteBuildAsync(String resourceGroupName, String name,
            String environmentName, String functionAppName,
            StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope,
            Boolean isForced) {
        return beginRegisterUserProvidedFunctionAppWithStaticSiteBuildAsync(resourceGroupName, name, environmentName,
            functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Register a user provided function app with a static site build
     * 
     * Description for Register a user provided function app with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSiteUserProvidedFunctionAppArmResourceInner>
        registerUserProvidedFunctionAppWithStaticSiteBuildAsync(String resourceGroupName, String name,
            String environmentName, String functionAppName,
            StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope) {
        final Boolean isForced = null;
        return beginRegisterUserProvidedFunctionAppWithStaticSiteBuildAsync(resourceGroupName, name, environmentName,
            functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Register a user provided function app with a static site build
     * 
     * Description for Register a user provided function app with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     * function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     * &lt;code&gt;false&lt;/code&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<StaticSiteUserProvidedFunctionAppArmResourceInner>
        registerUserProvidedFunctionAppWithStaticSiteBuildAsync(String resourceGroupName, String name,
            String environmentName, String functionAppName,
            StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced,
            Context context) {
        return beginRegisterUserProvidedFunctionAppWithStaticSiteBuildAsync(resourceGroupName, name, environmentName,
            functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced, context).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Register a user provided function app with a static site build
     * 
     * Description for Register a user provided function app with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteUserProvidedFunctionAppArmResourceInner registerUserProvidedFunctionAppWithStaticSiteBuild(
        String resourceGroupName, String name, String environmentName, String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope) {
        final Boolean isForced = null;
        return registerUserProvidedFunctionAppWithStaticSiteBuildAsync(resourceGroupName, name, environmentName,
            functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced).block();
    }

    /**
     * Register a user provided function app with a static site build
     * 
     * Description for Register a user provided function app with a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     * function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     * &lt;code&gt;false&lt;/code&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteUserProvidedFunctionAppArmResourceInner registerUserProvidedFunctionAppWithStaticSiteBuild(
        String resourceGroupName, String name, String environmentName, String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced,
        Context context) {
        return registerUserProvidedFunctionAppWithStaticSiteBuildAsync(resourceGroupName, name, environmentName,
            functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced, context).block();
    }

    /**
     * Detach the user provided function app from the static site build
     * 
     * Description for Detach the user provided function app from the static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app registered with the static site build.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> detachUserProvidedFunctionAppFromStaticSiteBuildWithResponseAsync(
        String resourceGroupName, String name, String environmentName, String functionAppName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.detachUserProvidedFunctionAppFromStaticSiteBuild(this.client.getEndpoint(),
                resourceGroupName, name, environmentName, functionAppName, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Detach the user provided function app from the static site build
     * 
     * Description for Detach the user provided function app from the static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app registered with the static site build.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> detachUserProvidedFunctionAppFromStaticSiteBuildWithResponseAsync(
        String resourceGroupName, String name, String environmentName, String functionAppName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.detachUserProvidedFunctionAppFromStaticSiteBuild(this.client.getEndpoint(), resourceGroupName,
            name, environmentName, functionAppName, this.client.getSubscriptionId(), this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Detach the user provided function app from the static site build
     * 
     * Description for Detach the user provided function app from the static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app registered with the static site build.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> detachUserProvidedFunctionAppFromStaticSiteBuildAsync(String resourceGroupName, String name,
        String environmentName, String functionAppName) {
        return detachUserProvidedFunctionAppFromStaticSiteBuildWithResponseAsync(resourceGroupName, name,
            environmentName, functionAppName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Detach the user provided function app from the static site build
     * 
     * Description for Detach the user provided function app from the static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app registered with the static site build.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> detachUserProvidedFunctionAppFromStaticSiteBuildWithResponse(String resourceGroupName,
        String name, String environmentName, String functionAppName, Context context) {
        return detachUserProvidedFunctionAppFromStaticSiteBuildWithResponseAsync(resourceGroupName, name,
            environmentName, functionAppName, context).block();
    }

    /**
     * Detach the user provided function app from the static site build
     * 
     * Description for Detach the user provided function app from the static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app registered with the static site build.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void detachUserProvidedFunctionAppFromStaticSiteBuild(String resourceGroupName, String name,
        String environmentName, String functionAppName) {
        detachUserProvidedFunctionAppFromStaticSiteBuildWithResponse(resourceGroupName, name, environmentName,
            functionAppName, Context.NONE);
    }

    /**
     * Deploys zipped content to a specific environment of a static site.
     * 
     * Description for Deploys zipped content to a specific environment of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName Name of the environment.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     * example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createZipDeploymentForStaticSiteBuildWithResponseAsync(
        String resourceGroupName, String name, String environmentName,
        StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteZipDeploymentEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteZipDeploymentEnvelope is required and cannot be null."));
        } else {
            staticSiteZipDeploymentEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createZipDeploymentForStaticSiteBuild(this.client.getEndpoint(),
                resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                staticSiteZipDeploymentEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deploys zipped content to a specific environment of a static site.
     * 
     * Description for Deploys zipped content to a specific environment of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName Name of the environment.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     * example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createZipDeploymentForStaticSiteBuildWithResponseAsync(
        String resourceGroupName, String name, String environmentName,
        StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteZipDeploymentEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteZipDeploymentEnvelope is required and cannot be null."));
        } else {
            staticSiteZipDeploymentEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createZipDeploymentForStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name,
            environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(),
            staticSiteZipDeploymentEnvelope, accept, context);
    }

    /**
     * Deploys zipped content to a specific environment of a static site.
     * 
     * Description for Deploys zipped content to a specific environment of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName Name of the environment.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     * example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSiteBuildAsync(String resourceGroupName,
        String name, String environmentName, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = createZipDeploymentForStaticSiteBuildWithResponseAsync(
            resourceGroupName, name, environmentName, staticSiteZipDeploymentEnvelope);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deploys zipped content to a specific environment of a static site.
     * 
     * Description for Deploys zipped content to a specific environment of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName Name of the environment.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     * example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSiteBuildAsync(String resourceGroupName,
        String name, String environmentName, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createZipDeploymentForStaticSiteBuildWithResponseAsync(
            resourceGroupName, name, environmentName, staticSiteZipDeploymentEnvelope, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deploys zipped content to a specific environment of a static site.
     * 
     * Description for Deploys zipped content to a specific environment of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName Name of the environment.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     * example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSiteBuild(String resourceGroupName,
        String name, String environmentName, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope) {
        return this.beginCreateZipDeploymentForStaticSiteBuildAsync(resourceGroupName, name, environmentName,
            staticSiteZipDeploymentEnvelope).getSyncPoller();
    }

    /**
     * Deploys zipped content to a specific environment of a static site.
     * 
     * Description for Deploys zipped content to a specific environment of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName Name of the environment.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     * example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSiteBuild(String resourceGroupName,
        String name, String environmentName, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope,
        Context context) {
        return this.beginCreateZipDeploymentForStaticSiteBuildAsync(resourceGroupName, name, environmentName,
            staticSiteZipDeploymentEnvelope, context).getSyncPoller();
    }

    /**
     * Deploys zipped content to a specific environment of a static site.
     * 
     * Description for Deploys zipped content to a specific environment of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName Name of the environment.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     * example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createZipDeploymentForStaticSiteBuildAsync(String resourceGroupName, String name,
        String environmentName, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope) {
        return beginCreateZipDeploymentForStaticSiteBuildAsync(resourceGroupName, name, environmentName,
            staticSiteZipDeploymentEnvelope).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deploys zipped content to a specific environment of a static site.
     * 
     * Description for Deploys zipped content to a specific environment of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName Name of the environment.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     * example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> createZipDeploymentForStaticSiteBuildAsync(String resourceGroupName, String name,
        String environmentName, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope, Context context) {
        return beginCreateZipDeploymentForStaticSiteBuildAsync(resourceGroupName, name, environmentName,
            staticSiteZipDeploymentEnvelope, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deploys zipped content to a specific environment of a static site.
     * 
     * Description for Deploys zipped content to a specific environment of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName Name of the environment.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     * example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void createZipDeploymentForStaticSiteBuild(String resourceGroupName, String name, String environmentName,
        StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope) {
        createZipDeploymentForStaticSiteBuildAsync(resourceGroupName, name, environmentName,
            staticSiteZipDeploymentEnvelope).block();
    }

    /**
     * Deploys zipped content to a specific environment of a static site.
     * 
     * Description for Deploys zipped content to a specific environment of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName Name of the environment.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     * example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void createZipDeploymentForStaticSiteBuild(String resourceGroupName, String name, String environmentName,
        StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope, Context context) {
        createZipDeploymentForStaticSiteBuildAsync(resourceGroupName, name, environmentName,
            staticSiteZipDeploymentEnvelope, context).block();
    }

    /**
     * Creates or updates the app settings of a static site.
     * 
     * Description for Creates or updates the app settings of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param appSettings The dictionary containing the static site app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteAppSettingsWithResponseAsync(
        String resourceGroupName, String name, StringDictionaryInner appSettings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error(new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        } else {
            appSettings.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.createOrUpdateStaticSiteAppSettings(this.client.getEndpoint(), resourceGroupName,
                    name, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates the app settings of a static site.
     * 
     * Description for Creates or updates the app settings of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param appSettings The dictionary containing the static site app settings to update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteAppSettingsWithResponseAsync(
        String resourceGroupName, String name, StringDictionaryInner appSettings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error(new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        } else {
            appSettings.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdateStaticSiteAppSettings(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, accept, context);
    }

    /**
     * Creates or updates the app settings of a static site.
     * 
     * Description for Creates or updates the app settings of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param appSettings The dictionary containing the static site app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StringDictionaryInner> createOrUpdateStaticSiteAppSettingsAsync(String resourceGroupName, String name,
        StringDictionaryInner appSettings) {
        return createOrUpdateStaticSiteAppSettingsWithResponseAsync(resourceGroupName, name, appSettings)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates or updates the app settings of a static site.
     * 
     * Description for Creates or updates the app settings of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param appSettings The dictionary containing the static site app settings to update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StringDictionaryInner> createOrUpdateStaticSiteAppSettingsWithResponse(String resourceGroupName,
        String name, StringDictionaryInner appSettings, Context context) {
        return createOrUpdateStaticSiteAppSettingsWithResponseAsync(resourceGroupName, name, appSettings, context)
            .block();
    }

    /**
     * Creates or updates the app settings of a static site.
     * 
     * Description for Creates or updates the app settings of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param appSettings The dictionary containing the static site app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StringDictionaryInner createOrUpdateStaticSiteAppSettings(String resourceGroupName, String name,
        StringDictionaryInner appSettings) {
        return createOrUpdateStaticSiteAppSettingsWithResponse(resourceGroupName, name, appSettings, Context.NONE)
            .getValue();
    }

    /**
     * Gets the basic auth properties for a static site as a collection.
     * 
     * Description for Gets the basic auth properties for a static site as a collection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site basic auth along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteBasicAuthPropertiesArmResourceInner>>
        listBasicAuthSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listBasicAuth(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<StaticSiteBasicAuthPropertiesArmResourceInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the basic auth properties for a static site as a collection.
     * 
     * Description for Gets the basic auth properties for a static site as a collection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site basic auth along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteBasicAuthPropertiesArmResourceInner>>
        listBasicAuthSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listBasicAuth(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets the basic auth properties for a static site as a collection.
     * 
     * Description for Gets the basic auth properties for a static site as a collection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site basic auth as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<StaticSiteBasicAuthPropertiesArmResourceInner> listBasicAuthAsync(String resourceGroupName,
        String name) {
        return new PagedFlux<>(() -> listBasicAuthSinglePageAsync(resourceGroupName, name),
            nextLink -> listBasicAuthNextSinglePageAsync(nextLink));
    }

    /**
     * Gets the basic auth properties for a static site as a collection.
     * 
     * Description for Gets the basic auth properties for a static site as a collection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site basic auth as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<StaticSiteBasicAuthPropertiesArmResourceInner> listBasicAuthAsync(String resourceGroupName,
        String name, Context context) {
        return new PagedFlux<>(() -> listBasicAuthSinglePageAsync(resourceGroupName, name, context),
            nextLink -> listBasicAuthNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets the basic auth properties for a static site as a collection.
     * 
     * Description for Gets the basic auth properties for a static site as a collection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site basic auth as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteBasicAuthPropertiesArmResourceInner> listBasicAuth(String resourceGroupName,
        String name) {
        return new PagedIterable<>(listBasicAuthAsync(resourceGroupName, name));
    }

    /**
     * Gets the basic auth properties for a static site as a collection.
     * 
     * Description for Gets the basic auth properties for a static site as a collection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site basic auth as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteBasicAuthPropertiesArmResourceInner> listBasicAuth(String resourceGroupName,
        String name, Context context) {
        return new PagedIterable<>(listBasicAuthAsync(resourceGroupName, name, context));
    }

    /**
     * Gets the basic auth properties for a static site.
     * 
     * Description for Gets the basic auth properties for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param basicAuthName name of the basic auth entry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static site basic auth properties ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StaticSiteBasicAuthPropertiesArmResourceInner>>
        getBasicAuthWithResponseAsync(String resourceGroupName, String name, BasicAuthName basicAuthName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (basicAuthName == null) {
            return Mono.error(new IllegalArgumentException("Parameter basicAuthName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getBasicAuth(this.client.getEndpoint(), resourceGroupName, name,
                basicAuthName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the basic auth properties for a static site.
     * 
     * Description for Gets the basic auth properties for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param basicAuthName name of the basic auth entry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static site basic auth properties ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StaticSiteBasicAuthPropertiesArmResourceInner>> getBasicAuthWithResponseAsync(
        String resourceGroupName, String name, BasicAuthName basicAuthName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (basicAuthName == null) {
            return Mono.error(new IllegalArgumentException("Parameter basicAuthName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getBasicAuth(this.client.getEndpoint(), resourceGroupName, name, basicAuthName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the basic auth properties for a static site.
     * 
     * Description for Gets the basic auth properties for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param basicAuthName name of the basic auth entry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static site basic auth properties ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSiteBasicAuthPropertiesArmResourceInner> getBasicAuthAsync(String resourceGroupName, String name,
        BasicAuthName basicAuthName) {
        return getBasicAuthWithResponseAsync(resourceGroupName, name, basicAuthName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the basic auth properties for a static site.
     * 
     * Description for Gets the basic auth properties for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param basicAuthName name of the basic auth entry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static site basic auth properties ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StaticSiteBasicAuthPropertiesArmResourceInner> getBasicAuthWithResponse(String resourceGroupName,
        String name, BasicAuthName basicAuthName, Context context) {
        return getBasicAuthWithResponseAsync(resourceGroupName, name, basicAuthName, context).block();
    }

    /**
     * Gets the basic auth properties for a static site.
     * 
     * Description for Gets the basic auth properties for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param basicAuthName name of the basic auth entry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static site basic auth properties ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteBasicAuthPropertiesArmResourceInner getBasicAuth(String resourceGroupName, String name,
        BasicAuthName basicAuthName) {
        return getBasicAuthWithResponse(resourceGroupName, name, basicAuthName, Context.NONE).getValue();
    }

    /**
     * Adds or updates basic auth for a static site.
     * 
     * Description for Adds or updates basic auth for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param basicAuthName name of the basic auth entry.
     * @param basicAuthEnvelope A JSON representation of the basic auth properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static site basic auth properties ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StaticSiteBasicAuthPropertiesArmResourceInner>> createOrUpdateBasicAuthWithResponseAsync(
        String resourceGroupName, String name, BasicAuthName basicAuthName,
        StaticSiteBasicAuthPropertiesArmResourceInner basicAuthEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (basicAuthName == null) {
            return Mono.error(new IllegalArgumentException("Parameter basicAuthName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (basicAuthEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter basicAuthEnvelope is required and cannot be null."));
        } else {
            basicAuthEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdateBasicAuth(this.client.getEndpoint(), resourceGroupName, name,
                basicAuthName, this.client.getSubscriptionId(), this.client.getApiVersion(), basicAuthEnvelope, accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Adds or updates basic auth for a static site.
     * 
     * Description for Adds or updates basic auth for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param basicAuthName name of the basic auth entry.
     * @param basicAuthEnvelope A JSON representation of the basic auth properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static site basic auth properties ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StaticSiteBasicAuthPropertiesArmResourceInner>> createOrUpdateBasicAuthWithResponseAsync(
        String resourceGroupName, String name, BasicAuthName basicAuthName,
        StaticSiteBasicAuthPropertiesArmResourceInner basicAuthEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (basicAuthName == null) {
            return Mono.error(new IllegalArgumentException("Parameter basicAuthName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (basicAuthEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter basicAuthEnvelope is required and cannot be null."));
        } else {
            basicAuthEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdateBasicAuth(this.client.getEndpoint(), resourceGroupName, name, basicAuthName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), basicAuthEnvelope, accept, context);
    }

    /**
     * Adds or updates basic auth for a static site.
     * 
     * Description for Adds or updates basic auth for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param basicAuthName name of the basic auth entry.
     * @param basicAuthEnvelope A JSON representation of the basic auth properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static site basic auth properties ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSiteBasicAuthPropertiesArmResourceInner> createOrUpdateBasicAuthAsync(String resourceGroupName,
        String name, BasicAuthName basicAuthName, StaticSiteBasicAuthPropertiesArmResourceInner basicAuthEnvelope) {
        return createOrUpdateBasicAuthWithResponseAsync(resourceGroupName, name, basicAuthName, basicAuthEnvelope)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Adds or updates basic auth for a static site.
     * 
     * Description for Adds or updates basic auth for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param basicAuthName name of the basic auth entry.
     * @param basicAuthEnvelope A JSON representation of the basic auth properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static site basic auth properties ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StaticSiteBasicAuthPropertiesArmResourceInner> createOrUpdateBasicAuthWithResponse(
        String resourceGroupName, String name, BasicAuthName basicAuthName,
        StaticSiteBasicAuthPropertiesArmResourceInner basicAuthEnvelope, Context context) {
        return createOrUpdateBasicAuthWithResponseAsync(resourceGroupName, name, basicAuthName, basicAuthEnvelope,
            context).block();
    }

    /**
     * Adds or updates basic auth for a static site.
     * 
     * Description for Adds or updates basic auth for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param basicAuthName name of the basic auth entry.
     * @param basicAuthEnvelope A JSON representation of the basic auth properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static site basic auth properties ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteBasicAuthPropertiesArmResourceInner createOrUpdateBasicAuth(String resourceGroupName, String name,
        BasicAuthName basicAuthName, StaticSiteBasicAuthPropertiesArmResourceInner basicAuthEnvelope) {
        return createOrUpdateBasicAuthWithResponse(resourceGroupName, name, basicAuthName, basicAuthEnvelope,
            Context.NONE).getValue();
    }

    /**
     * Creates or updates the function app settings of a static site.
     * 
     * Description for Creates or updates the function app settings of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param appSettings The dictionary containing the static site function app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteFunctionAppSettingsWithResponseAsync(
        String resourceGroupName, String name, StringDictionaryInner appSettings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error(new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        } else {
            appSettings.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdateStaticSiteFunctionAppSettings(this.client.getEndpoint(),
                resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings,
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates the function app settings of a static site.
     * 
     * Description for Creates or updates the function app settings of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param appSettings The dictionary containing the static site function app settings to update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteFunctionAppSettingsWithResponseAsync(
        String resourceGroupName, String name, StringDictionaryInner appSettings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error(new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        } else {
            appSettings.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdateStaticSiteFunctionAppSettings(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, accept, context);
    }

    /**
     * Creates or updates the function app settings of a static site.
     * 
     * Description for Creates or updates the function app settings of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param appSettings The dictionary containing the static site function app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StringDictionaryInner> createOrUpdateStaticSiteFunctionAppSettingsAsync(String resourceGroupName,
        String name, StringDictionaryInner appSettings) {
        return createOrUpdateStaticSiteFunctionAppSettingsWithResponseAsync(resourceGroupName, name, appSettings)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates or updates the function app settings of a static site.
     * 
     * Description for Creates or updates the function app settings of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param appSettings The dictionary containing the static site function app settings to update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StringDictionaryInner> createOrUpdateStaticSiteFunctionAppSettingsWithResponse(
        String resourceGroupName, String name, StringDictionaryInner appSettings, Context context) {
        return createOrUpdateStaticSiteFunctionAppSettingsWithResponseAsync(resourceGroupName, name, appSettings,
            context).block();
    }

    /**
     * Creates or updates the function app settings of a static site.
     * 
     * Description for Creates or updates the function app settings of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param appSettings The dictionary containing the static site function app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StringDictionaryInner createOrUpdateStaticSiteFunctionAppSettings(String resourceGroupName, String name,
        StringDictionaryInner appSettings) {
        return createOrUpdateStaticSiteFunctionAppSettingsWithResponse(resourceGroupName, name, appSettings,
            Context.NONE).getValue();
    }

    /**
     * Creates an invitation link for a user with the role
     * 
     * Description for Creates an invitation link for a user with the role.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteUserRolesInvitationEnvelope Static sites user roles invitation resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static sites user roles invitation link resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StaticSiteUserInvitationResponseResourceInner>> createUserRolesInvitationLinkWithResponseAsync(
        String resourceGroupName, String name,
        StaticSiteUserInvitationRequestResource staticSiteUserRolesInvitationEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteUserRolesInvitationEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteUserRolesInvitationEnvelope is required and cannot be null."));
        } else {
            staticSiteUserRolesInvitationEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createUserRolesInvitationLink(this.client.getEndpoint(), resourceGroupName,
                name, this.client.getSubscriptionId(), this.client.getApiVersion(),
                staticSiteUserRolesInvitationEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates an invitation link for a user with the role
     * 
     * Description for Creates an invitation link for a user with the role.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteUserRolesInvitationEnvelope Static sites user roles invitation resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static sites user roles invitation link resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StaticSiteUserInvitationResponseResourceInner>>
        createUserRolesInvitationLinkWithResponseAsync(String resourceGroupName, String name,
            StaticSiteUserInvitationRequestResource staticSiteUserRolesInvitationEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteUserRolesInvitationEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteUserRolesInvitationEnvelope is required and cannot be null."));
        } else {
            staticSiteUserRolesInvitationEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createUserRolesInvitationLink(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteUserRolesInvitationEnvelope, accept,
            context);
    }

    /**
     * Creates an invitation link for a user with the role
     * 
     * Description for Creates an invitation link for a user with the role.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteUserRolesInvitationEnvelope Static sites user roles invitation resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static sites user roles invitation link resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSiteUserInvitationResponseResourceInner> createUserRolesInvitationLinkAsync(
        String resourceGroupName, String name,
        StaticSiteUserInvitationRequestResource staticSiteUserRolesInvitationEnvelope) {
        return createUserRolesInvitationLinkWithResponseAsync(resourceGroupName, name,
            staticSiteUserRolesInvitationEnvelope).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates an invitation link for a user with the role
     * 
     * Description for Creates an invitation link for a user with the role.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteUserRolesInvitationEnvelope Static sites user roles invitation resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static sites user roles invitation link resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StaticSiteUserInvitationResponseResourceInner> createUserRolesInvitationLinkWithResponse(
        String resourceGroupName, String name,
        StaticSiteUserInvitationRequestResource staticSiteUserRolesInvitationEnvelope, Context context) {
        return createUserRolesInvitationLinkWithResponseAsync(resourceGroupName, name,
            staticSiteUserRolesInvitationEnvelope, context).block();
    }

    /**
     * Creates an invitation link for a user with the role
     * 
     * Description for Creates an invitation link for a user with the role.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteUserRolesInvitationEnvelope Static sites user roles invitation resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static sites user roles invitation link resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteUserInvitationResponseResourceInner createUserRolesInvitationLink(String resourceGroupName,
        String name, StaticSiteUserInvitationRequestResource staticSiteUserRolesInvitationEnvelope) {
        return createUserRolesInvitationLinkWithResponse(resourceGroupName, name, staticSiteUserRolesInvitationEnvelope,
            Context.NONE).getValue();
    }

    /**
     * Gets all static site custom domains for a particular static site.
     * 
     * Description for Gets all static site custom domains for a particular static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site resource to search in.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom domains along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteCustomDomainOverviewArmResourceInner>>
        listStaticSiteCustomDomainsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listStaticSiteCustomDomains(this.client.getEndpoint(), resourceGroupName,
                name, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<StaticSiteCustomDomainOverviewArmResourceInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets all static site custom domains for a particular static site.
     * 
     * Description for Gets all static site custom domains for a particular static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site resource to search in.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom domains along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteCustomDomainOverviewArmResourceInner>>
        listStaticSiteCustomDomainsSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listStaticSiteCustomDomains(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets all static site custom domains for a particular static site.
     * 
     * Description for Gets all static site custom domains for a particular static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site resource to search in.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom domains as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<StaticSiteCustomDomainOverviewArmResourceInner>
        listStaticSiteCustomDomainsAsync(String resourceGroupName, String name) {
        return new PagedFlux<>(() -> listStaticSiteCustomDomainsSinglePageAsync(resourceGroupName, name),
            nextLink -> listStaticSiteCustomDomainsNextSinglePageAsync(nextLink));
    }

    /**
     * Gets all static site custom domains for a particular static site.
     * 
     * Description for Gets all static site custom domains for a particular static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site resource to search in.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom domains as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<StaticSiteCustomDomainOverviewArmResourceInner>
        listStaticSiteCustomDomainsAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux<>(() -> listStaticSiteCustomDomainsSinglePageAsync(resourceGroupName, name, context),
            nextLink -> listStaticSiteCustomDomainsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets all static site custom domains for a particular static site.
     * 
     * Description for Gets all static site custom domains for a particular static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site resource to search in.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom domains as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteCustomDomainOverviewArmResourceInner>
        listStaticSiteCustomDomains(String resourceGroupName, String name) {
        return new PagedIterable<>(listStaticSiteCustomDomainsAsync(resourceGroupName, name));
    }

    /**
     * Gets all static site custom domains for a particular static site.
     * 
     * Description for Gets all static site custom domains for a particular static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site resource to search in.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom domains as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteCustomDomainOverviewArmResourceInner>
        listStaticSiteCustomDomains(String resourceGroupName, String name, Context context) {
        return new PagedIterable<>(listStaticSiteCustomDomainsAsync(resourceGroupName, name, context));
    }

    /**
     * Gets an existing custom domain for a particular static site.
     * 
     * Description for Gets an existing custom domain for a particular static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site resource to search in.
     * @param domainName The custom domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StaticSiteCustomDomainOverviewArmResourceInner>>
        getStaticSiteCustomDomainWithResponseAsync(String resourceGroupName, String name, String domainName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getStaticSiteCustomDomain(this.client.getEndpoint(), resourceGroupName,
                name, domainName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets an existing custom domain for a particular static site.
     * 
     * Description for Gets an existing custom domain for a particular static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site resource to search in.
     * @param domainName The custom domain name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StaticSiteCustomDomainOverviewArmResourceInner>> getStaticSiteCustomDomainWithResponseAsync(
        String resourceGroupName, String name, String domainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getStaticSiteCustomDomain(this.client.getEndpoint(), resourceGroupName, name, domainName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets an existing custom domain for a particular static site.
     * 
     * Description for Gets an existing custom domain for a particular static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site resource to search in.
     * @param domainName The custom domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSiteCustomDomainOverviewArmResourceInner> getStaticSiteCustomDomainAsync(String resourceGroupName,
        String name, String domainName) {
        return getStaticSiteCustomDomainWithResponseAsync(resourceGroupName, name, domainName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets an existing custom domain for a particular static site.
     * 
     * Description for Gets an existing custom domain for a particular static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site resource to search in.
     * @param domainName The custom domain name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StaticSiteCustomDomainOverviewArmResourceInner> getStaticSiteCustomDomainWithResponse(
        String resourceGroupName, String name, String domainName, Context context) {
        return getStaticSiteCustomDomainWithResponseAsync(resourceGroupName, name, domainName, context).block();
    }

    /**
     * Gets an existing custom domain for a particular static site.
     * 
     * Description for Gets an existing custom domain for a particular static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site resource to search in.
     * @param domainName The custom domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteCustomDomainOverviewArmResourceInner getStaticSiteCustomDomain(String resourceGroupName,
        String name, String domainName) {
        return getStaticSiteCustomDomainWithResponse(resourceGroupName, name, domainName, Context.NONE).getValue();
    }

    /**
     * Creates a new static site custom domain in an existing resource group and static site.
     * 
     * Description for Creates a new static site custom domain in an existing resource group and static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to create.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     * request properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateStaticSiteCustomDomainWithResponseAsync(
        String resourceGroupName, String name, String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteCustomDomainRequestPropertiesEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteCustomDomainRequestPropertiesEnvelope is required and cannot be null."));
        } else {
            staticSiteCustomDomainRequestPropertiesEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdateStaticSiteCustomDomain(this.client.getEndpoint(),
                resourceGroupName, name, domainName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                staticSiteCustomDomainRequestPropertiesEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates a new static site custom domain in an existing resource group and static site.
     * 
     * Description for Creates a new static site custom domain in an existing resource group and static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to create.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     * request properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateStaticSiteCustomDomainWithResponseAsync(
        String resourceGroupName, String name, String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteCustomDomainRequestPropertiesEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteCustomDomainRequestPropertiesEnvelope is required and cannot be null."));
        } else {
            staticSiteCustomDomainRequestPropertiesEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdateStaticSiteCustomDomain(this.client.getEndpoint(), resourceGroupName, name,
            domainName, this.client.getSubscriptionId(), this.client.getApiVersion(),
            staticSiteCustomDomainRequestPropertiesEnvelope, accept, context);
    }

    /**
     * Creates a new static site custom domain in an existing resource group and static site.
     * 
     * Description for Creates a new static site custom domain in an existing resource group and static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to create.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     * request properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of static Site Custom Domain Overview ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        PollerFlux<PollResult<StaticSiteCustomDomainOverviewArmResourceInner>, StaticSiteCustomDomainOverviewArmResourceInner>
        beginCreateOrUpdateStaticSiteCustomDomainAsync(String resourceGroupName, String name, String domainName,
            StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateStaticSiteCustomDomainWithResponseAsync(resourceGroupName,
            name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope);
        return this.client
            .<StaticSiteCustomDomainOverviewArmResourceInner, StaticSiteCustomDomainOverviewArmResourceInner>getLroResult(
                mono, this.client.getHttpPipeline(), StaticSiteCustomDomainOverviewArmResourceInner.class,
                StaticSiteCustomDomainOverviewArmResourceInner.class, this.client.getContext());
    }

    /**
     * Creates a new static site custom domain in an existing resource group and static site.
     * 
     * Description for Creates a new static site custom domain in an existing resource group and static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to create.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     * request properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of static Site Custom Domain Overview ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private
        PollerFlux<PollResult<StaticSiteCustomDomainOverviewArmResourceInner>, StaticSiteCustomDomainOverviewArmResourceInner>
        beginCreateOrUpdateStaticSiteCustomDomainAsync(String resourceGroupName, String name, String domainName,
            StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateStaticSiteCustomDomainWithResponseAsync(resourceGroupName,
            name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope, context);
        return this.client
            .<StaticSiteCustomDomainOverviewArmResourceInner, StaticSiteCustomDomainOverviewArmResourceInner>getLroResult(
                mono, this.client.getHttpPipeline(), StaticSiteCustomDomainOverviewArmResourceInner.class,
                StaticSiteCustomDomainOverviewArmResourceInner.class, context);
    }

    /**
     * Creates a new static site custom domain in an existing resource group and static site.
     * 
     * Description for Creates a new static site custom domain in an existing resource group and static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to create.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     * request properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of static Site Custom Domain Overview ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<StaticSiteCustomDomainOverviewArmResourceInner>, StaticSiteCustomDomainOverviewArmResourceInner>
        beginCreateOrUpdateStaticSiteCustomDomain(String resourceGroupName, String name, String domainName,
            StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope) {
        return this.beginCreateOrUpdateStaticSiteCustomDomainAsync(resourceGroupName, name, domainName,
            staticSiteCustomDomainRequestPropertiesEnvelope).getSyncPoller();
    }

    /**
     * Creates a new static site custom domain in an existing resource group and static site.
     * 
     * Description for Creates a new static site custom domain in an existing resource group and static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to create.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     * request properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of static Site Custom Domain Overview ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<StaticSiteCustomDomainOverviewArmResourceInner>, StaticSiteCustomDomainOverviewArmResourceInner>
        beginCreateOrUpdateStaticSiteCustomDomain(String resourceGroupName, String name, String domainName,
            StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope,
            Context context) {
        return this.beginCreateOrUpdateStaticSiteCustomDomainAsync(resourceGroupName, name, domainName,
            staticSiteCustomDomainRequestPropertiesEnvelope, context).getSyncPoller();
    }

    /**
     * Creates a new static site custom domain in an existing resource group and static site.
     * 
     * Description for Creates a new static site custom domain in an existing resource group and static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to create.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     * request properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSiteCustomDomainOverviewArmResourceInner> createOrUpdateStaticSiteCustomDomainAsync(
        String resourceGroupName, String name, String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope) {
        return beginCreateOrUpdateStaticSiteCustomDomainAsync(resourceGroupName, name, domainName,
            staticSiteCustomDomainRequestPropertiesEnvelope).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a new static site custom domain in an existing resource group and static site.
     * 
     * Description for Creates a new static site custom domain in an existing resource group and static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to create.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     * request properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<StaticSiteCustomDomainOverviewArmResourceInner> createOrUpdateStaticSiteCustomDomainAsync(
        String resourceGroupName, String name, String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope,
        Context context) {
        return beginCreateOrUpdateStaticSiteCustomDomainAsync(resourceGroupName, name, domainName,
            staticSiteCustomDomainRequestPropertiesEnvelope, context).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a new static site custom domain in an existing resource group and static site.
     * 
     * Description for Creates a new static site custom domain in an existing resource group and static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to create.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     * request properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteCustomDomainOverviewArmResourceInner createOrUpdateStaticSiteCustomDomain(String resourceGroupName,
        String name, String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope) {
        return createOrUpdateStaticSiteCustomDomainAsync(resourceGroupName, name, domainName,
            staticSiteCustomDomainRequestPropertiesEnvelope).block();
    }

    /**
     * Creates a new static site custom domain in an existing resource group and static site.
     * 
     * Description for Creates a new static site custom domain in an existing resource group and static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to create.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     * request properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteCustomDomainOverviewArmResourceInner createOrUpdateStaticSiteCustomDomain(String resourceGroupName,
        String name, String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope,
        Context context) {
        return createOrUpdateStaticSiteCustomDomainAsync(resourceGroupName, name, domainName,
            staticSiteCustomDomainRequestPropertiesEnvelope, context).block();
    }

    /**
     * Deletes a custom domain.
     * 
     * Description for Deletes a custom domain.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteStaticSiteCustomDomainWithResponseAsync(String resourceGroupName,
        String name, String domainName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteStaticSiteCustomDomain(this.client.getEndpoint(), resourceGroupName,
                name, domainName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a custom domain.
     * 
     * Description for Deletes a custom domain.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteStaticSiteCustomDomainWithResponseAsync(String resourceGroupName,
        String name, String domainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteStaticSiteCustomDomain(this.client.getEndpoint(), resourceGroupName, name, domainName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes a custom domain.
     * 
     * Description for Deletes a custom domain.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteStaticSiteCustomDomainAsync(String resourceGroupName,
        String name, String domainName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteStaticSiteCustomDomainWithResponseAsync(resourceGroupName, name, domainName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes a custom domain.
     * 
     * Description for Deletes a custom domain.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteStaticSiteCustomDomainAsync(String resourceGroupName,
        String name, String domainName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteStaticSiteCustomDomainWithResponseAsync(resourceGroupName, name, domainName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes a custom domain.
     * 
     * Description for Deletes a custom domain.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteStaticSiteCustomDomain(String resourceGroupName, String name,
        String domainName) {
        return this.beginDeleteStaticSiteCustomDomainAsync(resourceGroupName, name, domainName).getSyncPoller();
    }

    /**
     * Deletes a custom domain.
     * 
     * Description for Deletes a custom domain.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteStaticSiteCustomDomain(String resourceGroupName, String name,
        String domainName, Context context) {
        return this.beginDeleteStaticSiteCustomDomainAsync(resourceGroupName, name, domainName, context)
            .getSyncPoller();
    }

    /**
     * Deletes a custom domain.
     * 
     * Description for Deletes a custom domain.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteStaticSiteCustomDomainAsync(String resourceGroupName, String name, String domainName) {
        return beginDeleteStaticSiteCustomDomainAsync(resourceGroupName, name, domainName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a custom domain.
     * 
     * Description for Deletes a custom domain.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteStaticSiteCustomDomainAsync(String resourceGroupName, String name, String domainName,
        Context context) {
        return beginDeleteStaticSiteCustomDomainAsync(resourceGroupName, name, domainName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a custom domain.
     * 
     * Description for Deletes a custom domain.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteStaticSiteCustomDomain(String resourceGroupName, String name, String domainName) {
        deleteStaticSiteCustomDomainAsync(resourceGroupName, name, domainName).block();
    }

    /**
     * Deletes a custom domain.
     * 
     * Description for Deletes a custom domain.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteStaticSiteCustomDomain(String resourceGroupName, String name, String domainName,
        Context context) {
        deleteStaticSiteCustomDomainAsync(resourceGroupName, name, domainName, context).block();
    }

    /**
     * Validates a particular custom domain can be added to a static site.
     * 
     * Description for Validates a particular custom domain can be added to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to validate.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     * request properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateCustomDomainCanBeAddedToStaticSiteWithResponseAsync(
        String resourceGroupName, String name, String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteCustomDomainRequestPropertiesEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteCustomDomainRequestPropertiesEnvelope is required and cannot be null."));
        } else {
            staticSiteCustomDomainRequestPropertiesEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.validateCustomDomainCanBeAddedToStaticSite(this.client.getEndpoint(),
                resourceGroupName, name, domainName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                staticSiteCustomDomainRequestPropertiesEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Validates a particular custom domain can be added to a static site.
     * 
     * Description for Validates a particular custom domain can be added to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to validate.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     * request properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateCustomDomainCanBeAddedToStaticSiteWithResponseAsync(
        String resourceGroupName, String name, String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteCustomDomainRequestPropertiesEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteCustomDomainRequestPropertiesEnvelope is required and cannot be null."));
        } else {
            staticSiteCustomDomainRequestPropertiesEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.validateCustomDomainCanBeAddedToStaticSite(this.client.getEndpoint(), resourceGroupName, name,
            domainName, this.client.getSubscriptionId(), this.client.getApiVersion(),
            staticSiteCustomDomainRequestPropertiesEnvelope, accept, context);
    }

    /**
     * Validates a particular custom domain can be added to a static site.
     * 
     * Description for Validates a particular custom domain can be added to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to validate.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     * request properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginValidateCustomDomainCanBeAddedToStaticSiteAsync(
        String resourceGroupName, String name, String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = validateCustomDomainCanBeAddedToStaticSiteWithResponseAsync(
            resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Validates a particular custom domain can be added to a static site.
     * 
     * Description for Validates a particular custom domain can be added to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to validate.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     * request properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginValidateCustomDomainCanBeAddedToStaticSiteAsync(
        String resourceGroupName, String name, String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = validateCustomDomainCanBeAddedToStaticSiteWithResponseAsync(
            resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Validates a particular custom domain can be added to a static site.
     * 
     * Description for Validates a particular custom domain can be added to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to validate.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     * request properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginValidateCustomDomainCanBeAddedToStaticSite(String resourceGroupName,
        String name, String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope) {
        return this.beginValidateCustomDomainCanBeAddedToStaticSiteAsync(resourceGroupName, name, domainName,
            staticSiteCustomDomainRequestPropertiesEnvelope).getSyncPoller();
    }

    /**
     * Validates a particular custom domain can be added to a static site.
     * 
     * Description for Validates a particular custom domain can be added to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to validate.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     * request properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginValidateCustomDomainCanBeAddedToStaticSite(String resourceGroupName,
        String name, String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope,
        Context context) {
        return this.beginValidateCustomDomainCanBeAddedToStaticSiteAsync(resourceGroupName, name, domainName,
            staticSiteCustomDomainRequestPropertiesEnvelope, context).getSyncPoller();
    }

    /**
     * Validates a particular custom domain can be added to a static site.
     * 
     * Description for Validates a particular custom domain can be added to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to validate.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     * request properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> validateCustomDomainCanBeAddedToStaticSiteAsync(String resourceGroupName, String name,
        String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope) {
        return beginValidateCustomDomainCanBeAddedToStaticSiteAsync(resourceGroupName, name, domainName,
            staticSiteCustomDomainRequestPropertiesEnvelope).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Validates a particular custom domain can be added to a static site.
     * 
     * Description for Validates a particular custom domain can be added to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to validate.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     * request properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> validateCustomDomainCanBeAddedToStaticSiteAsync(String resourceGroupName, String name,
        String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope,
        Context context) {
        return beginValidateCustomDomainCanBeAddedToStaticSiteAsync(resourceGroupName, name, domainName,
            staticSiteCustomDomainRequestPropertiesEnvelope, context).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Validates a particular custom domain can be added to a static site.
     * 
     * Description for Validates a particular custom domain can be added to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to validate.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     * request properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void validateCustomDomainCanBeAddedToStaticSite(String resourceGroupName, String name, String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope) {
        validateCustomDomainCanBeAddedToStaticSiteAsync(resourceGroupName, name, domainName,
            staticSiteCustomDomainRequestPropertiesEnvelope).block();
    }

    /**
     * Validates a particular custom domain can be added to a static site.
     * 
     * Description for Validates a particular custom domain can be added to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to validate.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     * request properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void validateCustomDomainCanBeAddedToStaticSite(String resourceGroupName, String name, String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope,
        Context context) {
        validateCustomDomainCanBeAddedToStaticSiteAsync(resourceGroupName, name, domainName,
            staticSiteCustomDomainRequestPropertiesEnvelope, context).block();
    }

    /**
     * Returns overviews of database connections for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseConnectionInner>> getDatabaseConnectionsSinglePageAsync(String resourceGroupName,
        String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getDatabaseConnections(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<DatabaseConnectionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns overviews of database connections for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseConnectionInner>> getDatabaseConnectionsSinglePageAsync(String resourceGroupName,
        String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getDatabaseConnections(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Returns overviews of database connections for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DatabaseConnectionInner> getDatabaseConnectionsAsync(String resourceGroupName, String name) {
        return new PagedFlux<>(() -> getDatabaseConnectionsSinglePageAsync(resourceGroupName, name),
            nextLink -> getDatabaseConnectionsNextSinglePageAsync(nextLink));
    }

    /**
     * Returns overviews of database connections for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DatabaseConnectionInner> getDatabaseConnectionsAsync(String resourceGroupName, String name,
        Context context) {
        return new PagedFlux<>(() -> getDatabaseConnectionsSinglePageAsync(resourceGroupName, name, context),
            nextLink -> getDatabaseConnectionsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Returns overviews of database connections for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DatabaseConnectionInner> getDatabaseConnections(String resourceGroupName, String name) {
        return new PagedIterable<>(getDatabaseConnectionsAsync(resourceGroupName, name));
    }

    /**
     * Returns overviews of database connections for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DatabaseConnectionInner> getDatabaseConnections(String resourceGroupName, String name,
        Context context) {
        return new PagedIterable<>(getDatabaseConnectionsAsync(resourceGroupName, name, context));
    }

    /**
     * Returns overview of a database connection for a static site by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DatabaseConnectionInner>> getDatabaseConnectionWithResponseAsync(String resourceGroupName,
        String name, String databaseConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (databaseConnectionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter databaseConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getDatabaseConnection(this.client.getEndpoint(), resourceGroupName, name,
                databaseConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns overview of a database connection for a static site by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DatabaseConnectionInner>> getDatabaseConnectionWithResponseAsync(String resourceGroupName,
        String name, String databaseConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (databaseConnectionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter databaseConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getDatabaseConnection(this.client.getEndpoint(), resourceGroupName, name, databaseConnectionName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Returns overview of a database connection for a static site by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DatabaseConnectionInner> getDatabaseConnectionAsync(String resourceGroupName, String name,
        String databaseConnectionName) {
        return getDatabaseConnectionWithResponseAsync(resourceGroupName, name, databaseConnectionName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Returns overview of a database connection for a static site by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DatabaseConnectionInner> getDatabaseConnectionWithResponse(String resourceGroupName, String name,
        String databaseConnectionName, Context context) {
        return getDatabaseConnectionWithResponseAsync(resourceGroupName, name, databaseConnectionName, context).block();
    }

    /**
     * Returns overview of a database connection for a static site by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DatabaseConnectionInner getDatabaseConnection(String resourceGroupName, String name,
        String databaseConnectionName) {
        return getDatabaseConnectionWithResponse(resourceGroupName, name, databaseConnectionName, Context.NONE)
            .getValue();
    }

    /**
     * Create or update a database connection for a static site
     * 
     * Description for Create or update a database connection for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @param databaseConnectionRequestEnvelope A JSON representation of the database connection request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DatabaseConnectionInner>> createOrUpdateDatabaseConnectionWithResponseAsync(
        String resourceGroupName, String name, String databaseConnectionName,
        DatabaseConnectionInner databaseConnectionRequestEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (databaseConnectionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter databaseConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (databaseConnectionRequestEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter databaseConnectionRequestEnvelope is required and cannot be null."));
        } else {
            databaseConnectionRequestEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdateDatabaseConnection(this.client.getEndpoint(),
                resourceGroupName, name, databaseConnectionName, this.client.getSubscriptionId(),
                this.client.getApiVersion(), databaseConnectionRequestEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update a database connection for a static site
     * 
     * Description for Create or update a database connection for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @param databaseConnectionRequestEnvelope A JSON representation of the database connection request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DatabaseConnectionInner>> createOrUpdateDatabaseConnectionWithResponseAsync(
        String resourceGroupName, String name, String databaseConnectionName,
        DatabaseConnectionInner databaseConnectionRequestEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (databaseConnectionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter databaseConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (databaseConnectionRequestEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter databaseConnectionRequestEnvelope is required and cannot be null."));
        } else {
            databaseConnectionRequestEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdateDatabaseConnection(this.client.getEndpoint(), resourceGroupName, name,
            databaseConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(),
            databaseConnectionRequestEnvelope, accept, context);
    }

    /**
     * Create or update a database connection for a static site
     * 
     * Description for Create or update a database connection for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @param databaseConnectionRequestEnvelope A JSON representation of the database connection request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DatabaseConnectionInner> createOrUpdateDatabaseConnectionAsync(String resourceGroupName, String name,
        String databaseConnectionName, DatabaseConnectionInner databaseConnectionRequestEnvelope) {
        return createOrUpdateDatabaseConnectionWithResponseAsync(resourceGroupName, name, databaseConnectionName,
            databaseConnectionRequestEnvelope).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Create or update a database connection for a static site
     * 
     * Description for Create or update a database connection for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @param databaseConnectionRequestEnvelope A JSON representation of the database connection request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DatabaseConnectionInner> createOrUpdateDatabaseConnectionWithResponse(String resourceGroupName,
        String name, String databaseConnectionName, DatabaseConnectionInner databaseConnectionRequestEnvelope,
        Context context) {
        return createOrUpdateDatabaseConnectionWithResponseAsync(resourceGroupName, name, databaseConnectionName,
            databaseConnectionRequestEnvelope, context).block();
    }

    /**
     * Create or update a database connection for a static site
     * 
     * Description for Create or update a database connection for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @param databaseConnectionRequestEnvelope A JSON representation of the database connection request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DatabaseConnectionInner createOrUpdateDatabaseConnection(String resourceGroupName, String name,
        String databaseConnectionName, DatabaseConnectionInner databaseConnectionRequestEnvelope) {
        return createOrUpdateDatabaseConnectionWithResponse(resourceGroupName, name, databaseConnectionName,
            databaseConnectionRequestEnvelope, Context.NONE).getValue();
    }

    /**
     * Delete a database connection for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDatabaseConnectionWithResponseAsync(String resourceGroupName, String name,
        String databaseConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (databaseConnectionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter databaseConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteDatabaseConnection(this.client.getEndpoint(), resourceGroupName, name,
                databaseConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete a database connection for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteDatabaseConnectionWithResponseAsync(String resourceGroupName, String name,
        String databaseConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (databaseConnectionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter databaseConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteDatabaseConnection(this.client.getEndpoint(), resourceGroupName, name,
            databaseConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Delete a database connection for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteDatabaseConnectionAsync(String resourceGroupName, String name,
        String databaseConnectionName) {
        return deleteDatabaseConnectionWithResponseAsync(resourceGroupName, name, databaseConnectionName)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete a database connection for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteDatabaseConnectionWithResponse(String resourceGroupName, String name,
        String databaseConnectionName, Context context) {
        return deleteDatabaseConnectionWithResponseAsync(resourceGroupName, name, databaseConnectionName, context)
            .block();
    }

    /**
     * Delete a database connection for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteDatabaseConnection(String resourceGroupName, String name, String databaseConnectionName) {
        deleteDatabaseConnectionWithResponse(resourceGroupName, name, databaseConnectionName, Context.NONE);
    }

    /**
     * Create or update a database connection for a static site
     * 
     * Description for Create or update a database connection for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @param databaseConnectionRequestEnvelope A JSON representation of the database connection request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DatabaseConnectionInner>> updateDatabaseConnectionWithResponseAsync(String resourceGroupName,
        String name, String databaseConnectionName, DatabaseConnectionPatchRequest databaseConnectionRequestEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (databaseConnectionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter databaseConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (databaseConnectionRequestEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter databaseConnectionRequestEnvelope is required and cannot be null."));
        } else {
            databaseConnectionRequestEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateDatabaseConnection(this.client.getEndpoint(), resourceGroupName, name,
                databaseConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                databaseConnectionRequestEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update a database connection for a static site
     * 
     * Description for Create or update a database connection for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @param databaseConnectionRequestEnvelope A JSON representation of the database connection request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DatabaseConnectionInner>> updateDatabaseConnectionWithResponseAsync(String resourceGroupName,
        String name, String databaseConnectionName, DatabaseConnectionPatchRequest databaseConnectionRequestEnvelope,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (databaseConnectionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter databaseConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (databaseConnectionRequestEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter databaseConnectionRequestEnvelope is required and cannot be null."));
        } else {
            databaseConnectionRequestEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateDatabaseConnection(this.client.getEndpoint(), resourceGroupName, name,
            databaseConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(),
            databaseConnectionRequestEnvelope, accept, context);
    }

    /**
     * Create or update a database connection for a static site
     * 
     * Description for Create or update a database connection for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @param databaseConnectionRequestEnvelope A JSON representation of the database connection request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DatabaseConnectionInner> updateDatabaseConnectionAsync(String resourceGroupName, String name,
        String databaseConnectionName, DatabaseConnectionPatchRequest databaseConnectionRequestEnvelope) {
        return updateDatabaseConnectionWithResponseAsync(resourceGroupName, name, databaseConnectionName,
            databaseConnectionRequestEnvelope).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Create or update a database connection for a static site
     * 
     * Description for Create or update a database connection for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @param databaseConnectionRequestEnvelope A JSON representation of the database connection request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DatabaseConnectionInner> updateDatabaseConnectionWithResponse(String resourceGroupName, String name,
        String databaseConnectionName, DatabaseConnectionPatchRequest databaseConnectionRequestEnvelope,
        Context context) {
        return updateDatabaseConnectionWithResponseAsync(resourceGroupName, name, databaseConnectionName,
            databaseConnectionRequestEnvelope, context).block();
    }

    /**
     * Create or update a database connection for a static site
     * 
     * Description for Create or update a database connection for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @param databaseConnectionRequestEnvelope A JSON representation of the database connection request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DatabaseConnectionInner updateDatabaseConnection(String resourceGroupName, String name,
        String databaseConnectionName, DatabaseConnectionPatchRequest databaseConnectionRequestEnvelope) {
        return updateDatabaseConnectionWithResponse(resourceGroupName, name, databaseConnectionName,
            databaseConnectionRequestEnvelope, Context.NONE).getValue();
    }

    /**
     * Returns details of a database connection for a static site by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DatabaseConnectionInner>> getDatabaseConnectionWithDetailsWithResponseAsync(
        String resourceGroupName, String name, String databaseConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (databaseConnectionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter databaseConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getDatabaseConnectionWithDetails(this.client.getEndpoint(),
                resourceGroupName, name, databaseConnectionName, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns details of a database connection for a static site by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DatabaseConnectionInner>> getDatabaseConnectionWithDetailsWithResponseAsync(
        String resourceGroupName, String name, String databaseConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (databaseConnectionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter databaseConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getDatabaseConnectionWithDetails(this.client.getEndpoint(), resourceGroupName, name,
            databaseConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Returns details of a database connection for a static site by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DatabaseConnectionInner> getDatabaseConnectionWithDetailsAsync(String resourceGroupName, String name,
        String databaseConnectionName) {
        return getDatabaseConnectionWithDetailsWithResponseAsync(resourceGroupName, name, databaseConnectionName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Returns details of a database connection for a static site by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DatabaseConnectionInner> getDatabaseConnectionWithDetailsWithResponse(String resourceGroupName,
        String name, String databaseConnectionName, Context context) {
        return getDatabaseConnectionWithDetailsWithResponseAsync(resourceGroupName, name, databaseConnectionName,
            context).block();
    }

    /**
     * Returns details of a database connection for a static site by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param databaseConnectionName Name of the database connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Database Connection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DatabaseConnectionInner getDatabaseConnectionWithDetails(String resourceGroupName, String name,
        String databaseConnectionName) {
        return getDatabaseConnectionWithDetailsWithResponse(resourceGroupName, name, databaseConnectionName,
            Context.NONE).getValue();
    }

    /**
     * Detaches a static site.
     * 
     * Description for Detaches a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to detach.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> detachStaticSiteWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.detachStaticSite(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Detaches a static site.
     * 
     * Description for Detaches a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to detach.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> detachStaticSiteWithResponseAsync(String resourceGroupName, String name,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.detachStaticSite(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Detaches a static site.
     * 
     * Description for Detaches a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to detach.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDetachStaticSiteAsync(String resourceGroupName, String name) {
        Mono<Response<Flux<ByteBuffer>>> mono = detachStaticSiteWithResponseAsync(resourceGroupName, name);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Detaches a static site.
     * 
     * Description for Detaches a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to detach.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDetachStaticSiteAsync(String resourceGroupName, String name,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = detachStaticSiteWithResponseAsync(resourceGroupName, name, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Detaches a static site.
     * 
     * Description for Detaches a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to detach.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDetachStaticSite(String resourceGroupName, String name) {
        return this.beginDetachStaticSiteAsync(resourceGroupName, name).getSyncPoller();
    }

    /**
     * Detaches a static site.
     * 
     * Description for Detaches a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to detach.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDetachStaticSite(String resourceGroupName, String name,
        Context context) {
        return this.beginDetachStaticSiteAsync(resourceGroupName, name, context).getSyncPoller();
    }

    /**
     * Detaches a static site.
     * 
     * Description for Detaches a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to detach.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> detachStaticSiteAsync(String resourceGroupName, String name) {
        return beginDetachStaticSiteAsync(resourceGroupName, name).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Detaches a static site.
     * 
     * Description for Detaches a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to detach.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> detachStaticSiteAsync(String resourceGroupName, String name, Context context) {
        return beginDetachStaticSiteAsync(resourceGroupName, name, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Detaches a static site.
     * 
     * Description for Detaches a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to detach.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void detachStaticSite(String resourceGroupName, String name) {
        detachStaticSiteAsync(resourceGroupName, name).block();
    }

    /**
     * Detaches a static site.
     * 
     * Description for Detaches a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to detach.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void detachStaticSite(String resourceGroupName, String name, Context context) {
        detachStaticSiteAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets the functions of a static site.
     * 
     * Description for Gets the functions of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>>
        listStaticSiteFunctionsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listStaticSiteFunctions(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the functions of a static site.
     * 
     * Description for Gets the functions of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>>
        listStaticSiteFunctionsSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listStaticSiteFunctions(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets the functions of a static site.
     * 
     * Description for Gets the functions of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteFunctionsAsync(String resourceGroupName,
        String name) {
        return new PagedFlux<>(() -> listStaticSiteFunctionsSinglePageAsync(resourceGroupName, name),
            nextLink -> listStaticSiteFunctionsNextSinglePageAsync(nextLink));
    }

    /**
     * Gets the functions of a static site.
     * 
     * Description for Gets the functions of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteFunctionsAsync(String resourceGroupName,
        String name, Context context) {
        return new PagedFlux<>(() -> listStaticSiteFunctionsSinglePageAsync(resourceGroupName, name, context),
            nextLink -> listStaticSiteFunctionsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets the functions of a static site.
     * 
     * Description for Gets the functions of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteFunctions(String resourceGroupName,
        String name) {
        return new PagedIterable<>(listStaticSiteFunctionsAsync(resourceGroupName, name));
    }

    /**
     * Gets the functions of a static site.
     * 
     * Description for Gets the functions of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteFunctions(String resourceGroupName,
        String name, Context context) {
        return new PagedIterable<>(listStaticSiteFunctionsAsync(resourceGroupName, name, context));
    }

    /**
     * Gets the application settings of a static site.
     * 
     * Description for Gets the application settings of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>> listStaticSiteAppSettingsWithResponseAsync(String resourceGroupName,
        String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listStaticSiteAppSettings(this.client.getEndpoint(), resourceGroupName,
                name, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the application settings of a static site.
     * 
     * Description for Gets the application settings of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>> listStaticSiteAppSettingsWithResponseAsync(String resourceGroupName,
        String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listStaticSiteAppSettings(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the application settings of a static site.
     * 
     * Description for Gets the application settings of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StringDictionaryInner> listStaticSiteAppSettingsAsync(String resourceGroupName, String name) {
        return listStaticSiteAppSettingsWithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the application settings of a static site.
     * 
     * Description for Gets the application settings of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StringDictionaryInner> listStaticSiteAppSettingsWithResponse(String resourceGroupName, String name,
        Context context) {
        return listStaticSiteAppSettingsWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets the application settings of a static site.
     * 
     * Description for Gets the application settings of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StringDictionaryInner listStaticSiteAppSettings(String resourceGroupName, String name) {
        return listStaticSiteAppSettingsWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Lists the roles configured for the static site.
     * 
     * Description for Lists the roles configured for the static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string list resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StringListInner>> listStaticSiteConfiguredRolesWithResponseAsync(String resourceGroupName,
        String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listStaticSiteConfiguredRoles(this.client.getEndpoint(), resourceGroupName,
                name, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the roles configured for the static site.
     * 
     * Description for Lists the roles configured for the static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string list resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StringListInner>> listStaticSiteConfiguredRolesWithResponseAsync(String resourceGroupName,
        String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listStaticSiteConfiguredRoles(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Lists the roles configured for the static site.
     * 
     * Description for Lists the roles configured for the static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string list resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StringListInner> listStaticSiteConfiguredRolesAsync(String resourceGroupName, String name) {
        return listStaticSiteConfiguredRolesWithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Lists the roles configured for the static site.
     * 
     * Description for Lists the roles configured for the static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string list resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StringListInner> listStaticSiteConfiguredRolesWithResponse(String resourceGroupName, String name,
        Context context) {
        return listStaticSiteConfiguredRolesWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Lists the roles configured for the static site.
     * 
     * Description for Lists the roles configured for the static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string list resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StringListInner listStaticSiteConfiguredRoles(String resourceGroupName, String name) {
        return listStaticSiteConfiguredRolesWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Gets the application settings of a static site.
     * 
     * Description for Gets the application settings of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>>
        listStaticSiteFunctionAppSettingsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listStaticSiteFunctionAppSettings(this.client.getEndpoint(),
                resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the application settings of a static site.
     * 
     * Description for Gets the application settings of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>>
        listStaticSiteFunctionAppSettingsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listStaticSiteFunctionAppSettings(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the application settings of a static site.
     * 
     * Description for Gets the application settings of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StringDictionaryInner> listStaticSiteFunctionAppSettingsAsync(String resourceGroupName, String name) {
        return listStaticSiteFunctionAppSettingsWithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the application settings of a static site.
     * 
     * Description for Gets the application settings of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StringDictionaryInner> listStaticSiteFunctionAppSettingsWithResponse(String resourceGroupName,
        String name, Context context) {
        return listStaticSiteFunctionAppSettingsWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets the application settings of a static site.
     * 
     * Description for Gets the application settings of a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StringDictionaryInner listStaticSiteFunctionAppSettings(String resourceGroupName, String name) {
        return listStaticSiteFunctionAppSettingsWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Lists the secrets for an existing static site.
     * 
     * Description for Lists the secrets for an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>> listStaticSiteSecretsWithResponseAsync(String resourceGroupName,
        String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listStaticSiteSecrets(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the secrets for an existing static site.
     * 
     * Description for Lists the secrets for an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>> listStaticSiteSecretsWithResponseAsync(String resourceGroupName,
        String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listStaticSiteSecrets(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Lists the secrets for an existing static site.
     * 
     * Description for Lists the secrets for an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StringDictionaryInner> listStaticSiteSecretsAsync(String resourceGroupName, String name) {
        return listStaticSiteSecretsWithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Lists the secrets for an existing static site.
     * 
     * Description for Lists the secrets for an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StringDictionaryInner> listStaticSiteSecretsWithResponse(String resourceGroupName, String name,
        Context context) {
        return listStaticSiteSecretsWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Lists the secrets for an existing static site.
     * 
     * Description for Lists the secrets for an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StringDictionaryInner listStaticSiteSecrets(String resourceGroupName, String name) {
        return listStaticSiteSecretsWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Gets the list of private endpoint connections associated with a static site
     * 
     * Description for Gets the list of private endpoint connections associated with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RemotePrivateEndpointConnectionArmResourceInner>>
        getPrivateEndpointConnectionListSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getPrivateEndpointConnectionList(this.client.getEndpoint(),
                resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<RemotePrivateEndpointConnectionArmResourceInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the list of private endpoint connections associated with a static site
     * 
     * Description for Gets the list of private endpoint connections associated with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RemotePrivateEndpointConnectionArmResourceInner>>
        getPrivateEndpointConnectionListSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getPrivateEndpointConnectionList(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets the list of private endpoint connections associated with a static site
     * 
     * Description for Gets the list of private endpoint connections associated with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RemotePrivateEndpointConnectionArmResourceInner>
        getPrivateEndpointConnectionListAsync(String resourceGroupName, String name) {
        return new PagedFlux<>(() -> getPrivateEndpointConnectionListSinglePageAsync(resourceGroupName, name),
            nextLink -> getPrivateEndpointConnectionListNextSinglePageAsync(nextLink));
    }

    /**
     * Gets the list of private endpoint connections associated with a static site
     * 
     * Description for Gets the list of private endpoint connections associated with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RemotePrivateEndpointConnectionArmResourceInner>
        getPrivateEndpointConnectionListAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux<>(() -> getPrivateEndpointConnectionListSinglePageAsync(resourceGroupName, name, context),
            nextLink -> getPrivateEndpointConnectionListNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets the list of private endpoint connections associated with a static site
     * 
     * Description for Gets the list of private endpoint connections associated with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RemotePrivateEndpointConnectionArmResourceInner>
        getPrivateEndpointConnectionList(String resourceGroupName, String name) {
        return new PagedIterable<>(getPrivateEndpointConnectionListAsync(resourceGroupName, name));
    }

    /**
     * Gets the list of private endpoint connections associated with a static site
     * 
     * Description for Gets the list of private endpoint connections associated with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RemotePrivateEndpointConnectionArmResourceInner>
        getPrivateEndpointConnectionList(String resourceGroupName, String name, Context context) {
        return new PagedIterable<>(getPrivateEndpointConnectionListAsync(resourceGroupName, name, context));
    }

    /**
     * Gets a private endpoint connection
     * 
     * Description for Gets a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RemotePrivateEndpointConnectionArmResourceInner>>
        getPrivateEndpointConnectionWithResponseAsync(String resourceGroupName, String name,
            String privateEndpointConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getPrivateEndpointConnection(this.client.getEndpoint(), resourceGroupName,
                name, privateEndpointConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a private endpoint connection
     * 
     * Description for Gets a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RemotePrivateEndpointConnectionArmResourceInner>>
        getPrivateEndpointConnectionWithResponseAsync(String resourceGroupName, String name,
            String privateEndpointConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getPrivateEndpointConnection(this.client.getEndpoint(), resourceGroupName, name,
            privateEndpointConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Gets a private endpoint connection
     * 
     * Description for Gets a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RemotePrivateEndpointConnectionArmResourceInner>
        getPrivateEndpointConnectionAsync(String resourceGroupName, String name, String privateEndpointConnectionName) {
        return getPrivateEndpointConnectionWithResponseAsync(resourceGroupName, name, privateEndpointConnectionName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a private endpoint connection
     * 
     * Description for Gets a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionWithResponse(
        String resourceGroupName, String name, String privateEndpointConnectionName, Context context) {
        return getPrivateEndpointConnectionWithResponseAsync(resourceGroupName, name, privateEndpointConnectionName,
            context).block();
    }

    /**
     * Gets a private endpoint connection
     * 
     * Description for Gets a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RemotePrivateEndpointConnectionArmResourceInner getPrivateEndpointConnection(String resourceGroupName,
        String name, String privateEndpointConnectionName) {
        return getPrivateEndpointConnectionWithResponse(resourceGroupName, name, privateEndpointConnectionName,
            Context.NONE).getValue();
    }

    /**
     * Approves or rejects a private endpoint connection
     * 
     * Description for Approves or rejects a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param privateEndpointWrapper Request body.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> approveOrRejectPrivateEndpointConnectionWithResponseAsync(
        String resourceGroupName, String name, String privateEndpointConnectionName,
        PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (privateEndpointWrapper == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter privateEndpointWrapper is required and cannot be null."));
        } else {
            privateEndpointWrapper.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.approveOrRejectPrivateEndpointConnection(this.client.getEndpoint(),
                resourceGroupName, name, privateEndpointConnectionName, this.client.getSubscriptionId(),
                this.client.getApiVersion(), privateEndpointWrapper, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Approves or rejects a private endpoint connection
     * 
     * Description for Approves or rejects a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param privateEndpointWrapper Request body.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> approveOrRejectPrivateEndpointConnectionWithResponseAsync(
        String resourceGroupName, String name, String privateEndpointConnectionName,
        PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (privateEndpointWrapper == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter privateEndpointWrapper is required and cannot be null."));
        } else {
            privateEndpointWrapper.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.approveOrRejectPrivateEndpointConnection(this.client.getEndpoint(), resourceGroupName, name,
            privateEndpointConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(),
            privateEndpointWrapper, accept, context);
    }

    /**
     * Approves or rejects a private endpoint connection
     * 
     * Description for Approves or rejects a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param privateEndpointWrapper Request body.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        PollerFlux<PollResult<RemotePrivateEndpointConnectionArmResourceInner>, RemotePrivateEndpointConnectionArmResourceInner>
        beginApproveOrRejectPrivateEndpointConnectionAsync(String resourceGroupName, String name,
            String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper) {
        Mono<Response<Flux<ByteBuffer>>> mono = approveOrRejectPrivateEndpointConnectionWithResponseAsync(
            resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper);
        return this.client
            .<RemotePrivateEndpointConnectionArmResourceInner, RemotePrivateEndpointConnectionArmResourceInner>getLroResult(
                mono, this.client.getHttpPipeline(), RemotePrivateEndpointConnectionArmResourceInner.class,
                RemotePrivateEndpointConnectionArmResourceInner.class, this.client.getContext());
    }

    /**
     * Approves or rejects a private endpoint connection
     * 
     * Description for Approves or rejects a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param privateEndpointWrapper Request body.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private
        PollerFlux<PollResult<RemotePrivateEndpointConnectionArmResourceInner>, RemotePrivateEndpointConnectionArmResourceInner>
        beginApproveOrRejectPrivateEndpointConnectionAsync(String resourceGroupName, String name,
            String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = approveOrRejectPrivateEndpointConnectionWithResponseAsync(
            resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper, context);
        return this.client
            .<RemotePrivateEndpointConnectionArmResourceInner, RemotePrivateEndpointConnectionArmResourceInner>getLroResult(
                mono, this.client.getHttpPipeline(), RemotePrivateEndpointConnectionArmResourceInner.class,
                RemotePrivateEndpointConnectionArmResourceInner.class, context);
    }

    /**
     * Approves or rejects a private endpoint connection
     * 
     * Description for Approves or rejects a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param privateEndpointWrapper Request body.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<RemotePrivateEndpointConnectionArmResourceInner>, RemotePrivateEndpointConnectionArmResourceInner>
        beginApproveOrRejectPrivateEndpointConnection(String resourceGroupName, String name,
            String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper) {
        return this.beginApproveOrRejectPrivateEndpointConnectionAsync(resourceGroupName, name,
            privateEndpointConnectionName, privateEndpointWrapper).getSyncPoller();
    }

    /**
     * Approves or rejects a private endpoint connection
     * 
     * Description for Approves or rejects a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param privateEndpointWrapper Request body.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<RemotePrivateEndpointConnectionArmResourceInner>, RemotePrivateEndpointConnectionArmResourceInner>
        beginApproveOrRejectPrivateEndpointConnection(String resourceGroupName, String name,
            String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper,
            Context context) {
        return this.beginApproveOrRejectPrivateEndpointConnectionAsync(resourceGroupName, name,
            privateEndpointConnectionName, privateEndpointWrapper, context).getSyncPoller();
    }

    /**
     * Approves or rejects a private endpoint connection
     * 
     * Description for Approves or rejects a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param privateEndpointWrapper Request body.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RemotePrivateEndpointConnectionArmResourceInner> approveOrRejectPrivateEndpointConnectionAsync(
        String resourceGroupName, String name, String privateEndpointConnectionName,
        PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper) {
        return beginApproveOrRejectPrivateEndpointConnectionAsync(resourceGroupName, name,
            privateEndpointConnectionName, privateEndpointWrapper).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Approves or rejects a private endpoint connection
     * 
     * Description for Approves or rejects a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param privateEndpointWrapper Request body.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<RemotePrivateEndpointConnectionArmResourceInner> approveOrRejectPrivateEndpointConnectionAsync(
        String resourceGroupName, String name, String privateEndpointConnectionName,
        PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper, Context context) {
        return beginApproveOrRejectPrivateEndpointConnectionAsync(resourceGroupName, name,
            privateEndpointConnectionName, privateEndpointWrapper, context).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Approves or rejects a private endpoint connection
     * 
     * Description for Approves or rejects a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param privateEndpointWrapper Request body.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RemotePrivateEndpointConnectionArmResourceInner approveOrRejectPrivateEndpointConnection(
        String resourceGroupName, String name, String privateEndpointConnectionName,
        PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper) {
        return approveOrRejectPrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName,
            privateEndpointWrapper).block();
    }

    /**
     * Approves or rejects a private endpoint connection
     * 
     * Description for Approves or rejects a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param privateEndpointWrapper Request body.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RemotePrivateEndpointConnectionArmResourceInner approveOrRejectPrivateEndpointConnection(
        String resourceGroupName, String name, String privateEndpointConnectionName,
        PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper, Context context) {
        return approveOrRejectPrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName,
            privateEndpointWrapper, context).block();
    }

    /**
     * Deletes a private endpoint connection
     * 
     * Description for Deletes a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deletePrivateEndpointConnectionWithResponseAsync(String resourceGroupName,
        String name, String privateEndpointConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deletePrivateEndpointConnection(this.client.getEndpoint(),
                resourceGroupName, name, privateEndpointConnectionName, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a private endpoint connection
     * 
     * Description for Deletes a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deletePrivateEndpointConnectionWithResponseAsync(String resourceGroupName,
        String name, String privateEndpointConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deletePrivateEndpointConnection(this.client.getEndpoint(), resourceGroupName, name,
            privateEndpointConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Deletes a private endpoint connection
     * 
     * Description for Deletes a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of any object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Object>, Object> beginDeletePrivateEndpointConnectionAsync(String resourceGroupName,
        String name, String privateEndpointConnectionName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deletePrivateEndpointConnectionWithResponseAsync(resourceGroupName, name, privateEndpointConnectionName);
        return this.client.<Object, Object>getLroResult(mono, this.client.getHttpPipeline(), Object.class, Object.class,
            this.client.getContext());
    }

    /**
     * Deletes a private endpoint connection
     * 
     * Description for Deletes a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of any object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Object>, Object> beginDeletePrivateEndpointConnectionAsync(String resourceGroupName,
        String name, String privateEndpointConnectionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deletePrivateEndpointConnectionWithResponseAsync(resourceGroupName,
            name, privateEndpointConnectionName, context);
        return this.client.<Object, Object>getLroResult(mono, this.client.getHttpPipeline(), Object.class, Object.class,
            context);
    }

    /**
     * Deletes a private endpoint connection
     * 
     * Description for Deletes a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of any object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Object>, Object> beginDeletePrivateEndpointConnection(String resourceGroupName,
        String name, String privateEndpointConnectionName) {
        return this.beginDeletePrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName)
            .getSyncPoller();
    }

    /**
     * Deletes a private endpoint connection
     * 
     * Description for Deletes a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of any object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Object>, Object> beginDeletePrivateEndpointConnection(String resourceGroupName,
        String name, String privateEndpointConnectionName, Context context) {
        return this
            .beginDeletePrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName, context)
            .getSyncPoller();
    }

    /**
     * Deletes a private endpoint connection
     * 
     * Description for Deletes a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Object> deletePrivateEndpointConnectionAsync(String resourceGroupName, String name,
        String privateEndpointConnectionName) {
        return beginDeletePrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a private endpoint connection
     * 
     * Description for Deletes a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Object> deletePrivateEndpointConnectionAsync(String resourceGroupName, String name,
        String privateEndpointConnectionName, Context context) {
        return beginDeletePrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName,
            context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a private endpoint connection
     * 
     * Description for Deletes a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Object deletePrivateEndpointConnection(String resourceGroupName, String name,
        String privateEndpointConnectionName) {
        return deletePrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName).block();
    }

    /**
     * Deletes a private endpoint connection
     * 
     * Description for Deletes a private endpoint connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Object deletePrivateEndpointConnection(String resourceGroupName, String name,
        String privateEndpointConnectionName, Context context) {
        return deletePrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName, context)
            .block();
    }

    /**
     * Gets the private link resources
     * 
     * Description for Gets the private link resources.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper for a collection of private link resources along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PrivateLinkResourcesWrapperInner>>
        getPrivateLinkResourcesWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getPrivateLinkResources(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the private link resources
     * 
     * Description for Gets the private link resources.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper for a collection of private link resources along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PrivateLinkResourcesWrapperInner>>
        getPrivateLinkResourcesWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getPrivateLinkResources(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the private link resources
     * 
     * Description for Gets the private link resources.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper for a collection of private link resources on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PrivateLinkResourcesWrapperInner> getPrivateLinkResourcesAsync(String resourceGroupName, String name) {
        return getPrivateLinkResourcesWithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the private link resources
     * 
     * Description for Gets the private link resources.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper for a collection of private link resources along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PrivateLinkResourcesWrapperInner> getPrivateLinkResourcesWithResponse(String resourceGroupName,
        String name, Context context) {
        return getPrivateLinkResourcesWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets the private link resources
     * 
     * Description for Gets the private link resources.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper for a collection of private link resources.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PrivateLinkResourcesWrapperInner getPrivateLinkResources(String resourceGroupName, String name) {
        return getPrivateLinkResourcesWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Resets the api key for an existing static site.
     * 
     * Description for Resets the api key for an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param resetPropertiesEnvelope Static Site Reset Properties ARM resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> resetStaticSiteApiKeyWithResponseAsync(String resourceGroupName, String name,
        StaticSiteResetPropertiesArmResource resetPropertiesEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resetPropertiesEnvelope == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter resetPropertiesEnvelope is required and cannot be null."));
        } else {
            resetPropertiesEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.resetStaticSiteApiKey(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), resetPropertiesEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Resets the api key for an existing static site.
     * 
     * Description for Resets the api key for an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param resetPropertiesEnvelope Static Site Reset Properties ARM resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> resetStaticSiteApiKeyWithResponseAsync(String resourceGroupName, String name,
        StaticSiteResetPropertiesArmResource resetPropertiesEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resetPropertiesEnvelope == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter resetPropertiesEnvelope is required and cannot be null."));
        } else {
            resetPropertiesEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.resetStaticSiteApiKey(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), resetPropertiesEnvelope, accept, context);
    }

    /**
     * Resets the api key for an existing static site.
     * 
     * Description for Resets the api key for an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param resetPropertiesEnvelope Static Site Reset Properties ARM resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> resetStaticSiteApiKeyAsync(String resourceGroupName, String name,
        StaticSiteResetPropertiesArmResource resetPropertiesEnvelope) {
        return resetStaticSiteApiKeyWithResponseAsync(resourceGroupName, name, resetPropertiesEnvelope)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Resets the api key for an existing static site.
     * 
     * Description for Resets the api key for an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param resetPropertiesEnvelope Static Site Reset Properties ARM resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> resetStaticSiteApiKeyWithResponse(String resourceGroupName, String name,
        StaticSiteResetPropertiesArmResource resetPropertiesEnvelope, Context context) {
        return resetStaticSiteApiKeyWithResponseAsync(resourceGroupName, name, resetPropertiesEnvelope, context)
            .block();
    }

    /**
     * Resets the api key for an existing static site.
     * 
     * Description for Resets the api key for an existing static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param resetPropertiesEnvelope Static Site Reset Properties ARM resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void resetStaticSiteApiKey(String resourceGroupName, String name,
        StaticSiteResetPropertiesArmResource resetPropertiesEnvelope) {
        resetStaticSiteApiKeyWithResponse(resourceGroupName, name, resetPropertiesEnvelope, Context.NONE);
    }

    /**
     * Returns details of database connections for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseConnectionInner>>
        getDatabaseConnectionsWithDetailsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getDatabaseConnectionsWithDetails(this.client.getEndpoint(),
                resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<DatabaseConnectionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns details of database connections for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseConnectionInner>>
        getDatabaseConnectionsWithDetailsSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getDatabaseConnectionsWithDetails(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Returns details of database connections for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DatabaseConnectionInner> getDatabaseConnectionsWithDetailsAsync(String resourceGroupName,
        String name) {
        return new PagedFlux<>(() -> getDatabaseConnectionsWithDetailsSinglePageAsync(resourceGroupName, name),
            nextLink -> getDatabaseConnectionsWithDetailsNextSinglePageAsync(nextLink));
    }

    /**
     * Returns details of database connections for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DatabaseConnectionInner> getDatabaseConnectionsWithDetailsAsync(String resourceGroupName,
        String name, Context context) {
        return new PagedFlux<>(() -> getDatabaseConnectionsWithDetailsSinglePageAsync(resourceGroupName, name, context),
            nextLink -> getDatabaseConnectionsWithDetailsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Returns details of database connections for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DatabaseConnectionInner> getDatabaseConnectionsWithDetails(String resourceGroupName,
        String name) {
        return new PagedIterable<>(getDatabaseConnectionsWithDetailsAsync(resourceGroupName, name));
    }

    /**
     * Returns details of database connections for a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DatabaseConnectionInner> getDatabaseConnectionsWithDetails(String resourceGroupName,
        String name, Context context) {
        return new PagedIterable<>(getDatabaseConnectionsWithDetailsAsync(resourceGroupName, name, context));
    }

    /**
     * Gets the details of the user provided function apps registered with a static site
     * 
     * Description for Gets the details of the user provided function apps registered with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteUserProvidedFunctionAppArmResourceInner>>
        getUserProvidedFunctionAppsForStaticSiteSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getUserProvidedFunctionAppsForStaticSite(this.client.getEndpoint(),
                resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<StaticSiteUserProvidedFunctionAppArmResourceInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the details of the user provided function apps registered with a static site
     * 
     * Description for Gets the details of the user provided function apps registered with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteUserProvidedFunctionAppArmResourceInner>>
        getUserProvidedFunctionAppsForStaticSiteSinglePageAsync(String resourceGroupName, String name,
            Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getUserProvidedFunctionAppsForStaticSite(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets the details of the user provided function apps registered with a static site
     * 
     * Description for Gets the details of the user provided function apps registered with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<StaticSiteUserProvidedFunctionAppArmResourceInner>
        getUserProvidedFunctionAppsForStaticSiteAsync(String resourceGroupName, String name) {
        return new PagedFlux<>(() -> getUserProvidedFunctionAppsForStaticSiteSinglePageAsync(resourceGroupName, name),
            nextLink -> getUserProvidedFunctionAppsForStaticSiteNextSinglePageAsync(nextLink));
    }

    /**
     * Gets the details of the user provided function apps registered with a static site
     * 
     * Description for Gets the details of the user provided function apps registered with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<StaticSiteUserProvidedFunctionAppArmResourceInner>
        getUserProvidedFunctionAppsForStaticSiteAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux<>(
            () -> getUserProvidedFunctionAppsForStaticSiteSinglePageAsync(resourceGroupName, name, context),
            nextLink -> getUserProvidedFunctionAppsForStaticSiteNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets the details of the user provided function apps registered with a static site
     * 
     * Description for Gets the details of the user provided function apps registered with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteUserProvidedFunctionAppArmResourceInner>
        getUserProvidedFunctionAppsForStaticSite(String resourceGroupName, String name) {
        return new PagedIterable<>(getUserProvidedFunctionAppsForStaticSiteAsync(resourceGroupName, name));
    }

    /**
     * Gets the details of the user provided function apps registered with a static site
     * 
     * Description for Gets the details of the user provided function apps registered with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteUserProvidedFunctionAppArmResourceInner>
        getUserProvidedFunctionAppsForStaticSite(String resourceGroupName, String name, Context context) {
        return new PagedIterable<>(getUserProvidedFunctionAppsForStaticSiteAsync(resourceGroupName, name, context));
    }

    /**
     * Gets the details of the user provided function app registered with a static site
     * 
     * Description for Gets the details of the user provided function app registered with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app registered with the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StaticSiteUserProvidedFunctionAppArmResourceInner>>
        getUserProvidedFunctionAppForStaticSiteWithResponseAsync(String resourceGroupName, String name,
            String functionAppName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getUserProvidedFunctionAppForStaticSite(this.client.getEndpoint(),
                resourceGroupName, name, functionAppName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the details of the user provided function app registered with a static site
     * 
     * Description for Gets the details of the user provided function app registered with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app registered with the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StaticSiteUserProvidedFunctionAppArmResourceInner>>
        getUserProvidedFunctionAppForStaticSiteWithResponseAsync(String resourceGroupName, String name,
            String functionAppName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getUserProvidedFunctionAppForStaticSite(this.client.getEndpoint(), resourceGroupName, name,
            functionAppName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the details of the user provided function app registered with a static site
     * 
     * Description for Gets the details of the user provided function app registered with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app registered with the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSiteUserProvidedFunctionAppArmResourceInner>
        getUserProvidedFunctionAppForStaticSiteAsync(String resourceGroupName, String name, String functionAppName) {
        return getUserProvidedFunctionAppForStaticSiteWithResponseAsync(resourceGroupName, name, functionAppName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the details of the user provided function app registered with a static site
     * 
     * Description for Gets the details of the user provided function app registered with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app registered with the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StaticSiteUserProvidedFunctionAppArmResourceInner>
        getUserProvidedFunctionAppForStaticSiteWithResponse(String resourceGroupName, String name,
            String functionAppName, Context context) {
        return getUserProvidedFunctionAppForStaticSiteWithResponseAsync(resourceGroupName, name, functionAppName,
            context).block();
    }

    /**
     * Gets the details of the user provided function app registered with a static site
     * 
     * Description for Gets the details of the user provided function app registered with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app registered with the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteUserProvidedFunctionAppArmResourceInner
        getUserProvidedFunctionAppForStaticSite(String resourceGroupName, String name, String functionAppName) {
        return getUserProvidedFunctionAppForStaticSiteWithResponse(resourceGroupName, name, functionAppName,
            Context.NONE).getValue();
    }

    /**
     * Register a user provided function app with a static site
     * 
     * Description for Register a user provided function app with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     * function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     * &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> registerUserProvidedFunctionAppWithStaticSiteWithResponseAsync(
        String resourceGroupName, String name, String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteUserProvidedFunctionEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteUserProvidedFunctionEnvelope is required and cannot be null."));
        } else {
            staticSiteUserProvidedFunctionEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.registerUserProvidedFunctionAppWithStaticSite(this.client.getEndpoint(),
                resourceGroupName, name, functionAppName, isForced, this.client.getSubscriptionId(),
                this.client.getApiVersion(), staticSiteUserProvidedFunctionEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Register a user provided function app with a static site
     * 
     * Description for Register a user provided function app with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     * function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     * &lt;code&gt;false&lt;/code&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> registerUserProvidedFunctionAppWithStaticSiteWithResponseAsync(
        String resourceGroupName, String name, String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteUserProvidedFunctionEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteUserProvidedFunctionEnvelope is required and cannot be null."));
        } else {
            staticSiteUserProvidedFunctionEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.registerUserProvidedFunctionAppWithStaticSite(this.client.getEndpoint(), resourceGroupName, name,
            functionAppName, isForced, this.client.getSubscriptionId(), this.client.getApiVersion(),
            staticSiteUserProvidedFunctionEnvelope, accept, context);
    }

    /**
     * Register a user provided function app with a static site
     * 
     * Description for Register a user provided function app with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     * function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     * &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        PollerFlux<PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>, StaticSiteUserProvidedFunctionAppArmResourceInner>
        beginRegisterUserProvidedFunctionAppWithStaticSiteAsync(String resourceGroupName, String name,
            String functionAppName,
            StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope,
            Boolean isForced) {
        Mono<Response<Flux<ByteBuffer>>> mono = registerUserProvidedFunctionAppWithStaticSiteWithResponseAsync(
            resourceGroupName, name, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced);
        return this.client
            .<StaticSiteUserProvidedFunctionAppArmResourceInner, StaticSiteUserProvidedFunctionAppArmResourceInner>getLroResult(
                mono, this.client.getHttpPipeline(), StaticSiteUserProvidedFunctionAppArmResourceInner.class,
                StaticSiteUserProvidedFunctionAppArmResourceInner.class, this.client.getContext());
    }

    /**
     * Register a user provided function app with a static site
     * 
     * Description for Register a user provided function app with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        PollerFlux<PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>, StaticSiteUserProvidedFunctionAppArmResourceInner>
        beginRegisterUserProvidedFunctionAppWithStaticSiteAsync(String resourceGroupName, String name,
            String functionAppName,
            StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope) {
        final Boolean isForced = null;
        Mono<Response<Flux<ByteBuffer>>> mono = registerUserProvidedFunctionAppWithStaticSiteWithResponseAsync(
            resourceGroupName, name, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced);
        return this.client
            .<StaticSiteUserProvidedFunctionAppArmResourceInner, StaticSiteUserProvidedFunctionAppArmResourceInner>getLroResult(
                mono, this.client.getHttpPipeline(), StaticSiteUserProvidedFunctionAppArmResourceInner.class,
                StaticSiteUserProvidedFunctionAppArmResourceInner.class, this.client.getContext());
    }

    /**
     * Register a user provided function app with a static site
     * 
     * Description for Register a user provided function app with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     * function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     * &lt;code&gt;false&lt;/code&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private
        PollerFlux<PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>, StaticSiteUserProvidedFunctionAppArmResourceInner>
        beginRegisterUserProvidedFunctionAppWithStaticSiteAsync(String resourceGroupName, String name,
            String functionAppName,
            StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = registerUserProvidedFunctionAppWithStaticSiteWithResponseAsync(
            resourceGroupName, name, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced, context);
        return this.client
            .<StaticSiteUserProvidedFunctionAppArmResourceInner, StaticSiteUserProvidedFunctionAppArmResourceInner>getLroResult(
                mono, this.client.getHttpPipeline(), StaticSiteUserProvidedFunctionAppArmResourceInner.class,
                StaticSiteUserProvidedFunctionAppArmResourceInner.class, context);
    }

    /**
     * Register a user provided function app with a static site
     * 
     * Description for Register a user provided function app with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>, StaticSiteUserProvidedFunctionAppArmResourceInner>
        beginRegisterUserProvidedFunctionAppWithStaticSite(String resourceGroupName, String name,
            String functionAppName,
            StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope) {
        final Boolean isForced = null;
        return this.beginRegisterUserProvidedFunctionAppWithStaticSiteAsync(resourceGroupName, name, functionAppName,
            staticSiteUserProvidedFunctionEnvelope, isForced).getSyncPoller();
    }

    /**
     * Register a user provided function app with a static site
     * 
     * Description for Register a user provided function app with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     * function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     * &lt;code&gt;false&lt;/code&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>, StaticSiteUserProvidedFunctionAppArmResourceInner>
        beginRegisterUserProvidedFunctionAppWithStaticSite(String resourceGroupName, String name,
            String functionAppName,
            StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced,
            Context context) {
        return this.beginRegisterUserProvidedFunctionAppWithStaticSiteAsync(resourceGroupName, name, functionAppName,
            staticSiteUserProvidedFunctionEnvelope, isForced, context).getSyncPoller();
    }

    /**
     * Register a user provided function app with a static site
     * 
     * Description for Register a user provided function app with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     * function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     * &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSiteUserProvidedFunctionAppArmResourceInner> registerUserProvidedFunctionAppWithStaticSiteAsync(
        String resourceGroupName, String name, String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced) {
        return beginRegisterUserProvidedFunctionAppWithStaticSiteAsync(resourceGroupName, name, functionAppName,
            staticSiteUserProvidedFunctionEnvelope, isForced).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Register a user provided function app with a static site
     * 
     * Description for Register a user provided function app with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSiteUserProvidedFunctionAppArmResourceInner> registerUserProvidedFunctionAppWithStaticSiteAsync(
        String resourceGroupName, String name, String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope) {
        final Boolean isForced = null;
        return beginRegisterUserProvidedFunctionAppWithStaticSiteAsync(resourceGroupName, name, functionAppName,
            staticSiteUserProvidedFunctionEnvelope, isForced).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Register a user provided function app with a static site
     * 
     * Description for Register a user provided function app with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     * function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     * &lt;code&gt;false&lt;/code&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<StaticSiteUserProvidedFunctionAppArmResourceInner> registerUserProvidedFunctionAppWithStaticSiteAsync(
        String resourceGroupName, String name, String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced,
        Context context) {
        return beginRegisterUserProvidedFunctionAppWithStaticSiteAsync(resourceGroupName, name, functionAppName,
            staticSiteUserProvidedFunctionEnvelope, isForced, context).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Register a user provided function app with a static site
     * 
     * Description for Register a user provided function app with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteUserProvidedFunctionAppArmResourceInner registerUserProvidedFunctionAppWithStaticSite(
        String resourceGroupName, String name, String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope) {
        final Boolean isForced = null;
        return registerUserProvidedFunctionAppWithStaticSiteAsync(resourceGroupName, name, functionAppName,
            staticSiteUserProvidedFunctionEnvelope, isForced).block();
    }

    /**
     * Register a user provided function app with a static site
     * 
     * Description for Register a user provided function app with a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     * See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     * function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     * &lt;code&gt;false&lt;/code&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteUserProvidedFunctionAppArmResourceInner registerUserProvidedFunctionAppWithStaticSite(
        String resourceGroupName, String name, String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced,
        Context context) {
        return registerUserProvidedFunctionAppWithStaticSiteAsync(resourceGroupName, name, functionAppName,
            staticSiteUserProvidedFunctionEnvelope, isForced, context).block();
    }

    /**
     * Detach the user provided function app from the static site
     * 
     * Description for Detach the user provided function app from the static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app registered with the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> detachUserProvidedFunctionAppFromStaticSiteWithResponseAsync(String resourceGroupName,
        String name, String functionAppName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.detachUserProvidedFunctionAppFromStaticSite(this.client.getEndpoint(),
                resourceGroupName, name, functionAppName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Detach the user provided function app from the static site
     * 
     * Description for Detach the user provided function app from the static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app registered with the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> detachUserProvidedFunctionAppFromStaticSiteWithResponseAsync(String resourceGroupName,
        String name, String functionAppName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.detachUserProvidedFunctionAppFromStaticSite(this.client.getEndpoint(), resourceGroupName, name,
            functionAppName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Detach the user provided function app from the static site
     * 
     * Description for Detach the user provided function app from the static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app registered with the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> detachUserProvidedFunctionAppFromStaticSiteAsync(String resourceGroupName, String name,
        String functionAppName) {
        return detachUserProvidedFunctionAppFromStaticSiteWithResponseAsync(resourceGroupName, name, functionAppName)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Detach the user provided function app from the static site
     * 
     * Description for Detach the user provided function app from the static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app registered with the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> detachUserProvidedFunctionAppFromStaticSiteWithResponse(String resourceGroupName, String name,
        String functionAppName, Context context) {
        return detachUserProvidedFunctionAppFromStaticSiteWithResponseAsync(resourceGroupName, name, functionAppName,
            context).block();
    }

    /**
     * Detach the user provided function app from the static site
     * 
     * Description for Detach the user provided function app from the static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app registered with the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void detachUserProvidedFunctionAppFromStaticSite(String resourceGroupName, String name,
        String functionAppName) {
        detachUserProvidedFunctionAppFromStaticSiteWithResponse(resourceGroupName, name, functionAppName, Context.NONE);
    }

    /**
     * Deploys zipped content to a static site.
     * 
     * Description for Deploys zipped content to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     * example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createZipDeploymentForStaticSiteWithResponseAsync(String resourceGroupName,
        String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteZipDeploymentEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteZipDeploymentEnvelope is required and cannot be null."));
        } else {
            staticSiteZipDeploymentEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createZipDeploymentForStaticSite(this.client.getEndpoint(),
                resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(),
                staticSiteZipDeploymentEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deploys zipped content to a static site.
     * 
     * Description for Deploys zipped content to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     * example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createZipDeploymentForStaticSiteWithResponseAsync(String resourceGroupName,
        String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteZipDeploymentEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteZipDeploymentEnvelope is required and cannot be null."));
        } else {
            staticSiteZipDeploymentEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createZipDeploymentForStaticSite(this.client.getEndpoint(), resourceGroupName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteZipDeploymentEnvelope, accept,
            context);
    }

    /**
     * Deploys zipped content to a static site.
     * 
     * Description for Deploys zipped content to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     * example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSiteAsync(String resourceGroupName,
        String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = createZipDeploymentForStaticSiteWithResponseAsync(resourceGroupName,
            name, staticSiteZipDeploymentEnvelope);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deploys zipped content to a static site.
     * 
     * Description for Deploys zipped content to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     * example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSiteAsync(String resourceGroupName,
        String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createZipDeploymentForStaticSiteWithResponseAsync(resourceGroupName,
            name, staticSiteZipDeploymentEnvelope, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deploys zipped content to a static site.
     * 
     * Description for Deploys zipped content to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     * example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSite(String resourceGroupName,
        String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope) {
        return this.beginCreateZipDeploymentForStaticSiteAsync(resourceGroupName, name, staticSiteZipDeploymentEnvelope)
            .getSyncPoller();
    }

    /**
     * Deploys zipped content to a static site.
     * 
     * Description for Deploys zipped content to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     * example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSite(String resourceGroupName,
        String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope, Context context) {
        return this.beginCreateZipDeploymentForStaticSiteAsync(resourceGroupName, name, staticSiteZipDeploymentEnvelope,
            context).getSyncPoller();
    }

    /**
     * Deploys zipped content to a static site.
     * 
     * Description for Deploys zipped content to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     * example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createZipDeploymentForStaticSiteAsync(String resourceGroupName, String name,
        StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope) {
        return beginCreateZipDeploymentForStaticSiteAsync(resourceGroupName, name, staticSiteZipDeploymentEnvelope)
            .last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deploys zipped content to a static site.
     * 
     * Description for Deploys zipped content to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     * example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> createZipDeploymentForStaticSiteAsync(String resourceGroupName, String name,
        StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope, Context context) {
        return beginCreateZipDeploymentForStaticSiteAsync(resourceGroupName, name, staticSiteZipDeploymentEnvelope,
            context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deploys zipped content to a static site.
     * 
     * Description for Deploys zipped content to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     * example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void createZipDeploymentForStaticSite(String resourceGroupName, String name,
        StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope) {
        createZipDeploymentForStaticSiteAsync(resourceGroupName, name, staticSiteZipDeploymentEnvelope).block();
    }

    /**
     * Deploys zipped content to a static site.
     * 
     * Description for Deploys zipped content to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     * example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void createZipDeploymentForStaticSite(String resourceGroupName, String name,
        StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope, Context context) {
        createZipDeploymentForStaticSiteAsync(resourceGroupName, name, staticSiteZipDeploymentEnvelope, context)
            .block();
    }

    /**
     * Validates that a backend can be linked to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateBackendWithResponseAsync(String resourceGroupName, String name,
        String linkedBackendName, StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (linkedBackendName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedBackendName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteLinkedBackendEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteLinkedBackendEnvelope is required and cannot be null."));
        } else {
            staticSiteLinkedBackendEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.validateBackend(this.client.getEndpoint(), resourceGroupName, name,
                linkedBackendName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                staticSiteLinkedBackendEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Validates that a backend can be linked to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateBackendWithResponseAsync(String resourceGroupName, String name,
        String linkedBackendName, StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (linkedBackendName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedBackendName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteLinkedBackendEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteLinkedBackendEnvelope is required and cannot be null."));
        } else {
            staticSiteLinkedBackendEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.validateBackend(this.client.getEndpoint(), resourceGroupName, name, linkedBackendName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteLinkedBackendEnvelope, accept,
            context);
    }

    /**
     * Validates that a backend can be linked to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginValidateBackendAsync(String resourceGroupName, String name,
        String linkedBackendName, StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = validateBackendWithResponseAsync(resourceGroupName, name,
            linkedBackendName, staticSiteLinkedBackendEnvelope);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Validates that a backend can be linked to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginValidateBackendAsync(String resourceGroupName, String name,
        String linkedBackendName, StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = validateBackendWithResponseAsync(resourceGroupName, name,
            linkedBackendName, staticSiteLinkedBackendEnvelope, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Validates that a backend can be linked to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginValidateBackend(String resourceGroupName, String name,
        String linkedBackendName, StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope) {
        return this
            .beginValidateBackendAsync(resourceGroupName, name, linkedBackendName, staticSiteLinkedBackendEnvelope)
            .getSyncPoller();
    }

    /**
     * Validates that a backend can be linked to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginValidateBackend(String resourceGroupName, String name,
        String linkedBackendName, StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope,
        Context context) {
        return this.beginValidateBackendAsync(resourceGroupName, name, linkedBackendName,
            staticSiteLinkedBackendEnvelope, context).getSyncPoller();
    }

    /**
     * Validates that a backend can be linked to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> validateBackendAsync(String resourceGroupName, String name, String linkedBackendName,
        StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope) {
        return beginValidateBackendAsync(resourceGroupName, name, linkedBackendName, staticSiteLinkedBackendEnvelope)
            .last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Validates that a backend can be linked to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> validateBackendAsync(String resourceGroupName, String name, String linkedBackendName,
        StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope, Context context) {
        return beginValidateBackendAsync(resourceGroupName, name, linkedBackendName, staticSiteLinkedBackendEnvelope,
            context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Validates that a backend can be linked to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void validateBackend(String resourceGroupName, String name, String linkedBackendName,
        StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope) {
        validateBackendAsync(resourceGroupName, name, linkedBackendName, staticSiteLinkedBackendEnvelope).block();
    }

    /**
     * Validates that a backend can be linked to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void validateBackend(String resourceGroupName, String name, String linkedBackendName,
        StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope, Context context) {
        validateBackendAsync(resourceGroupName, name, linkedBackendName, staticSiteLinkedBackendEnvelope, context)
            .block();
    }

    /**
     * Validates that a backend can be linked to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateBackendForBuildWithResponseAsync(String resourceGroupName,
        String name, String environmentName, String linkedBackendName,
        StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (linkedBackendName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedBackendName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteLinkedBackendEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteLinkedBackendEnvelope is required and cannot be null."));
        } else {
            staticSiteLinkedBackendEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.validateBackendForBuild(this.client.getEndpoint(), resourceGroupName, name,
                environmentName, linkedBackendName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                staticSiteLinkedBackendEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Validates that a backend can be linked to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateBackendForBuildWithResponseAsync(String resourceGroupName,
        String name, String environmentName, String linkedBackendName,
        StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (linkedBackendName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedBackendName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteLinkedBackendEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteLinkedBackendEnvelope is required and cannot be null."));
        } else {
            staticSiteLinkedBackendEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.validateBackendForBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName,
            linkedBackendName, this.client.getSubscriptionId(), this.client.getApiVersion(),
            staticSiteLinkedBackendEnvelope, accept, context);
    }

    /**
     * Validates that a backend can be linked to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginValidateBackendForBuildAsync(String resourceGroupName, String name,
        String environmentName, String linkedBackendName,
        StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = validateBackendForBuildWithResponseAsync(resourceGroupName, name,
            environmentName, linkedBackendName, staticSiteLinkedBackendEnvelope);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Validates that a backend can be linked to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginValidateBackendForBuildAsync(String resourceGroupName, String name,
        String environmentName, String linkedBackendName,
        StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = validateBackendForBuildWithResponseAsync(resourceGroupName, name,
            environmentName, linkedBackendName, staticSiteLinkedBackendEnvelope, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Validates that a backend can be linked to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginValidateBackendForBuild(String resourceGroupName, String name,
        String environmentName, String linkedBackendName,
        StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope) {
        return this.beginValidateBackendForBuildAsync(resourceGroupName, name, environmentName, linkedBackendName,
            staticSiteLinkedBackendEnvelope).getSyncPoller();
    }

    /**
     * Validates that a backend can be linked to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginValidateBackendForBuild(String resourceGroupName, String name,
        String environmentName, String linkedBackendName,
        StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope, Context context) {
        return this.beginValidateBackendForBuildAsync(resourceGroupName, name, environmentName, linkedBackendName,
            staticSiteLinkedBackendEnvelope, context).getSyncPoller();
    }

    /**
     * Validates that a backend can be linked to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> validateBackendForBuildAsync(String resourceGroupName, String name, String environmentName,
        String linkedBackendName, StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope) {
        return beginValidateBackendForBuildAsync(resourceGroupName, name, environmentName, linkedBackendName,
            staticSiteLinkedBackendEnvelope).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Validates that a backend can be linked to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> validateBackendForBuildAsync(String resourceGroupName, String name, String environmentName,
        String linkedBackendName, StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope,
        Context context) {
        return beginValidateBackendForBuildAsync(resourceGroupName, name, environmentName, linkedBackendName,
            staticSiteLinkedBackendEnvelope, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Validates that a backend can be linked to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void validateBackendForBuild(String resourceGroupName, String name, String environmentName,
        String linkedBackendName, StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope) {
        validateBackendForBuildAsync(resourceGroupName, name, environmentName, linkedBackendName,
            staticSiteLinkedBackendEnvelope).block();
    }

    /**
     * Validates that a backend can be linked to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void validateBackendForBuild(String resourceGroupName, String name, String environmentName,
        String linkedBackendName, StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope,
        Context context) {
        validateBackendForBuildAsync(resourceGroupName, name, environmentName, linkedBackendName,
            staticSiteLinkedBackendEnvelope, context).block();
    }

    /**
     * Returns details of all backends linked to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site linked backends along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteLinkedBackendArmResourceInner>>
        getLinkedBackendsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getLinkedBackends(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<StaticSiteLinkedBackendArmResourceInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns details of all backends linked to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site linked backends along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteLinkedBackendArmResourceInner>>
        getLinkedBackendsSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getLinkedBackends(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Returns details of all backends linked to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site linked backends as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<StaticSiteLinkedBackendArmResourceInner> getLinkedBackendsAsync(String resourceGroupName,
        String name) {
        return new PagedFlux<>(() -> getLinkedBackendsSinglePageAsync(resourceGroupName, name),
            nextLink -> getLinkedBackendsNextSinglePageAsync(nextLink));
    }

    /**
     * Returns details of all backends linked to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site linked backends as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<StaticSiteLinkedBackendArmResourceInner> getLinkedBackendsAsync(String resourceGroupName,
        String name, Context context) {
        return new PagedFlux<>(() -> getLinkedBackendsSinglePageAsync(resourceGroupName, name, context),
            nextLink -> getLinkedBackendsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Returns details of all backends linked to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site linked backends as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteLinkedBackendArmResourceInner> getLinkedBackends(String resourceGroupName,
        String name) {
        return new PagedIterable<>(getLinkedBackendsAsync(resourceGroupName, name));
    }

    /**
     * Returns details of all backends linked to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site linked backends as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteLinkedBackendArmResourceInner> getLinkedBackends(String resourceGroupName,
        String name, Context context) {
        return new PagedIterable<>(getLinkedBackendsAsync(resourceGroupName, name, context));
    }

    /**
     * Returns details of all backends linked to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site linked backends along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteLinkedBackendArmResourceInner>>
        getLinkedBackendsForBuildSinglePageAsync(String resourceGroupName, String name, String environmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getLinkedBackendsForBuild(this.client.getEndpoint(), resourceGroupName,
                name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<StaticSiteLinkedBackendArmResourceInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns details of all backends linked to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site linked backends along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteLinkedBackendArmResourceInner>> getLinkedBackendsForBuildSinglePageAsync(
        String resourceGroupName, String name, String environmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getLinkedBackendsForBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Returns details of all backends linked to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site linked backends as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<StaticSiteLinkedBackendArmResourceInner> getLinkedBackendsForBuildAsync(String resourceGroupName,
        String name, String environmentName) {
        return new PagedFlux<>(() -> getLinkedBackendsForBuildSinglePageAsync(resourceGroupName, name, environmentName),
            nextLink -> getLinkedBackendsForBuildNextSinglePageAsync(nextLink));
    }

    /**
     * Returns details of all backends linked to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site linked backends as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<StaticSiteLinkedBackendArmResourceInner> getLinkedBackendsForBuildAsync(String resourceGroupName,
        String name, String environmentName, Context context) {
        return new PagedFlux<>(
            () -> getLinkedBackendsForBuildSinglePageAsync(resourceGroupName, name, environmentName, context),
            nextLink -> getLinkedBackendsForBuildNextSinglePageAsync(nextLink, context));
    }

    /**
     * Returns details of all backends linked to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site linked backends as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteLinkedBackendArmResourceInner> getLinkedBackendsForBuild(String resourceGroupName,
        String name, String environmentName) {
        return new PagedIterable<>(getLinkedBackendsForBuildAsync(resourceGroupName, name, environmentName));
    }

    /**
     * Returns details of all backends linked to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site linked backends as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StaticSiteLinkedBackendArmResourceInner> getLinkedBackendsForBuild(String resourceGroupName,
        String name, String environmentName, Context context) {
        return new PagedIterable<>(getLinkedBackendsForBuildAsync(resourceGroupName, name, environmentName, context));
    }

    /**
     * Returns the details of a linked backend linked to a static site by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StaticSiteLinkedBackendArmResourceInner>>
        getLinkedBackendWithResponseAsync(String resourceGroupName, String name, String linkedBackendName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (linkedBackendName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedBackendName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getLinkedBackend(this.client.getEndpoint(), resourceGroupName, name,
                linkedBackendName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns the details of a linked backend linked to a static site by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StaticSiteLinkedBackendArmResourceInner>> getLinkedBackendWithResponseAsync(
        String resourceGroupName, String name, String linkedBackendName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (linkedBackendName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedBackendName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getLinkedBackend(this.client.getEndpoint(), resourceGroupName, name, linkedBackendName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Returns the details of a linked backend linked to a static site by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSiteLinkedBackendArmResourceInner> getLinkedBackendAsync(String resourceGroupName, String name,
        String linkedBackendName) {
        return getLinkedBackendWithResponseAsync(resourceGroupName, name, linkedBackendName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Returns the details of a linked backend linked to a static site by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StaticSiteLinkedBackendArmResourceInner> getLinkedBackendWithResponse(String resourceGroupName,
        String name, String linkedBackendName, Context context) {
        return getLinkedBackendWithResponseAsync(resourceGroupName, name, linkedBackendName, context).block();
    }

    /**
     * Returns the details of a linked backend linked to a static site by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteLinkedBackendArmResourceInner getLinkedBackend(String resourceGroupName, String name,
        String linkedBackendName) {
        return getLinkedBackendWithResponse(resourceGroupName, name, linkedBackendName, Context.NONE).getValue();
    }

    /**
     * Link backend to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the backend to link to the static site.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> linkBackendWithResponseAsync(String resourceGroupName, String name,
        String linkedBackendName, StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (linkedBackendName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedBackendName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteLinkedBackendEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteLinkedBackendEnvelope is required and cannot be null."));
        } else {
            staticSiteLinkedBackendEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.linkBackend(this.client.getEndpoint(), resourceGroupName, name,
                linkedBackendName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                staticSiteLinkedBackendEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Link backend to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the backend to link to the static site.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> linkBackendWithResponseAsync(String resourceGroupName, String name,
        String linkedBackendName, StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (linkedBackendName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedBackendName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteLinkedBackendEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteLinkedBackendEnvelope is required and cannot be null."));
        } else {
            staticSiteLinkedBackendEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.linkBackend(this.client.getEndpoint(), resourceGroupName, name, linkedBackendName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteLinkedBackendEnvelope, accept,
            context);
    }

    /**
     * Link backend to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the backend to link to the static site.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of static Site Linked Backend ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<StaticSiteLinkedBackendArmResourceInner>, StaticSiteLinkedBackendArmResourceInner>
        beginLinkBackendAsync(String resourceGroupName, String name, String linkedBackendName,
            StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = linkBackendWithResponseAsync(resourceGroupName, name, linkedBackendName, staticSiteLinkedBackendEnvelope);
        return this.client
            .<StaticSiteLinkedBackendArmResourceInner, StaticSiteLinkedBackendArmResourceInner>getLroResult(mono,
                this.client.getHttpPipeline(), StaticSiteLinkedBackendArmResourceInner.class,
                StaticSiteLinkedBackendArmResourceInner.class, this.client.getContext());
    }

    /**
     * Link backend to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the backend to link to the static site.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of static Site Linked Backend ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<StaticSiteLinkedBackendArmResourceInner>, StaticSiteLinkedBackendArmResourceInner>
        beginLinkBackendAsync(String resourceGroupName, String name, String linkedBackendName,
            StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = linkBackendWithResponseAsync(resourceGroupName, name, linkedBackendName,
            staticSiteLinkedBackendEnvelope, context);
        return this.client
            .<StaticSiteLinkedBackendArmResourceInner, StaticSiteLinkedBackendArmResourceInner>getLroResult(mono,
                this.client.getHttpPipeline(), StaticSiteLinkedBackendArmResourceInner.class,
                StaticSiteLinkedBackendArmResourceInner.class, context);
    }

    /**
     * Link backend to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the backend to link to the static site.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of static Site Linked Backend ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<StaticSiteLinkedBackendArmResourceInner>, StaticSiteLinkedBackendArmResourceInner>
        beginLinkBackend(String resourceGroupName, String name, String linkedBackendName,
            StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope) {
        return this.beginLinkBackendAsync(resourceGroupName, name, linkedBackendName, staticSiteLinkedBackendEnvelope)
            .getSyncPoller();
    }

    /**
     * Link backend to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the backend to link to the static site.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of static Site Linked Backend ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<StaticSiteLinkedBackendArmResourceInner>, StaticSiteLinkedBackendArmResourceInner>
        beginLinkBackend(String resourceGroupName, String name, String linkedBackendName,
            StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope, Context context) {
        return this
            .beginLinkBackendAsync(resourceGroupName, name, linkedBackendName, staticSiteLinkedBackendEnvelope, context)
            .getSyncPoller();
    }

    /**
     * Link backend to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the backend to link to the static site.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSiteLinkedBackendArmResourceInner> linkBackendAsync(String resourceGroupName, String name,
        String linkedBackendName, StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope) {
        return beginLinkBackendAsync(resourceGroupName, name, linkedBackendName, staticSiteLinkedBackendEnvelope).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Link backend to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the backend to link to the static site.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<StaticSiteLinkedBackendArmResourceInner> linkBackendAsync(String resourceGroupName, String name,
        String linkedBackendName, StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope,
        Context context) {
        return beginLinkBackendAsync(resourceGroupName, name, linkedBackendName, staticSiteLinkedBackendEnvelope,
            context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Link backend to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the backend to link to the static site.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteLinkedBackendArmResourceInner linkBackend(String resourceGroupName, String name,
        String linkedBackendName, StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope) {
        return linkBackendAsync(resourceGroupName, name, linkedBackendName, staticSiteLinkedBackendEnvelope).block();
    }

    /**
     * Link backend to a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the backend to link to the static site.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteLinkedBackendArmResourceInner linkBackend(String resourceGroupName, String name,
        String linkedBackendName, StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope,
        Context context) {
        return linkBackendAsync(resourceGroupName, name, linkedBackendName, staticSiteLinkedBackendEnvelope, context)
            .block();
    }

    /**
     * Unlink a backend from a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the backend linked to the static site.
     * @param isCleaningAuthConfig Decides if Easy Auth configuration will be removed from backend configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> unlinkBackendWithResponseAsync(String resourceGroupName, String name,
        String linkedBackendName, Boolean isCleaningAuthConfig) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (linkedBackendName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedBackendName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.unlinkBackend(this.client.getEndpoint(), resourceGroupName, name,
                linkedBackendName, isCleaningAuthConfig, this.client.getSubscriptionId(), this.client.getApiVersion(),
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Unlink a backend from a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the backend linked to the static site.
     * @param isCleaningAuthConfig Decides if Easy Auth configuration will be removed from backend configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> unlinkBackendWithResponseAsync(String resourceGroupName, String name,
        String linkedBackendName, Boolean isCleaningAuthConfig, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (linkedBackendName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedBackendName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.unlinkBackend(this.client.getEndpoint(), resourceGroupName, name, linkedBackendName,
            isCleaningAuthConfig, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Unlink a backend from a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the backend linked to the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> unlinkBackendAsync(String resourceGroupName, String name, String linkedBackendName) {
        final Boolean isCleaningAuthConfig = null;
        return unlinkBackendWithResponseAsync(resourceGroupName, name, linkedBackendName, isCleaningAuthConfig)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Unlink a backend from a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the backend linked to the static site.
     * @param isCleaningAuthConfig Decides if Easy Auth configuration will be removed from backend configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> unlinkBackendWithResponse(String resourceGroupName, String name, String linkedBackendName,
        Boolean isCleaningAuthConfig, Context context) {
        return unlinkBackendWithResponseAsync(resourceGroupName, name, linkedBackendName, isCleaningAuthConfig, context)
            .block();
    }

    /**
     * Unlink a backend from a static site.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param linkedBackendName Name of the backend linked to the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void unlinkBackend(String resourceGroupName, String name, String linkedBackendName) {
        final Boolean isCleaningAuthConfig = null;
        unlinkBackendWithResponse(resourceGroupName, name, linkedBackendName, isCleaningAuthConfig, Context.NONE);
    }

    /**
     * Returns the details of a linked backend linked to a static site build by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StaticSiteLinkedBackendArmResourceInner>> getLinkedBackendForBuildWithResponseAsync(
        String resourceGroupName, String name, String environmentName, String linkedBackendName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (linkedBackendName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedBackendName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getLinkedBackendForBuild(this.client.getEndpoint(), resourceGroupName, name,
                environmentName, linkedBackendName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns the details of a linked backend linked to a static site build by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StaticSiteLinkedBackendArmResourceInner>> getLinkedBackendForBuildWithResponseAsync(
        String resourceGroupName, String name, String environmentName, String linkedBackendName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (linkedBackendName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedBackendName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getLinkedBackendForBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName,
            linkedBackendName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Returns the details of a linked backend linked to a static site build by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSiteLinkedBackendArmResourceInner> getLinkedBackendForBuildAsync(String resourceGroupName,
        String name, String environmentName, String linkedBackendName) {
        return getLinkedBackendForBuildWithResponseAsync(resourceGroupName, name, environmentName, linkedBackendName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Returns the details of a linked backend linked to a static site build by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StaticSiteLinkedBackendArmResourceInner> getLinkedBackendForBuildWithResponse(
        String resourceGroupName, String name, String environmentName, String linkedBackendName, Context context) {
        return getLinkedBackendForBuildWithResponseAsync(resourceGroupName, name, environmentName, linkedBackendName,
            context).block();
    }

    /**
     * Returns the details of a linked backend linked to a static site build by name.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the linked backend that should be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteLinkedBackendArmResourceInner getLinkedBackendForBuild(String resourceGroupName, String name,
        String environmentName, String linkedBackendName) {
        return getLinkedBackendForBuildWithResponse(resourceGroupName, name, environmentName, linkedBackendName,
            Context.NONE).getValue();
    }

    /**
     * Link backend to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the backend to link to the static site.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> linkBackendToBuildWithResponseAsync(String resourceGroupName, String name,
        String environmentName, String linkedBackendName,
        StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (linkedBackendName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedBackendName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteLinkedBackendEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteLinkedBackendEnvelope is required and cannot be null."));
        } else {
            staticSiteLinkedBackendEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.linkBackendToBuild(this.client.getEndpoint(), resourceGroupName, name,
                environmentName, linkedBackendName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                staticSiteLinkedBackendEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Link backend to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the backend to link to the static site.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> linkBackendToBuildWithResponseAsync(String resourceGroupName, String name,
        String environmentName, String linkedBackendName,
        StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (linkedBackendName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedBackendName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteLinkedBackendEnvelope == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter staticSiteLinkedBackendEnvelope is required and cannot be null."));
        } else {
            staticSiteLinkedBackendEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.linkBackendToBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName,
            linkedBackendName, this.client.getSubscriptionId(), this.client.getApiVersion(),
            staticSiteLinkedBackendEnvelope, accept, context);
    }

    /**
     * Link backend to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the backend to link to the static site.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of static Site Linked Backend ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<StaticSiteLinkedBackendArmResourceInner>, StaticSiteLinkedBackendArmResourceInner>
        beginLinkBackendToBuildAsync(String resourceGroupName, String name, String environmentName,
            String linkedBackendName, StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = linkBackendToBuildWithResponseAsync(resourceGroupName, name,
            environmentName, linkedBackendName, staticSiteLinkedBackendEnvelope);
        return this.client
            .<StaticSiteLinkedBackendArmResourceInner, StaticSiteLinkedBackendArmResourceInner>getLroResult(mono,
                this.client.getHttpPipeline(), StaticSiteLinkedBackendArmResourceInner.class,
                StaticSiteLinkedBackendArmResourceInner.class, this.client.getContext());
    }

    /**
     * Link backend to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the backend to link to the static site.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of static Site Linked Backend ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<StaticSiteLinkedBackendArmResourceInner>, StaticSiteLinkedBackendArmResourceInner>
        beginLinkBackendToBuildAsync(String resourceGroupName, String name, String environmentName,
            String linkedBackendName, StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = linkBackendToBuildWithResponseAsync(resourceGroupName, name,
            environmentName, linkedBackendName, staticSiteLinkedBackendEnvelope, context);
        return this.client
            .<StaticSiteLinkedBackendArmResourceInner, StaticSiteLinkedBackendArmResourceInner>getLroResult(mono,
                this.client.getHttpPipeline(), StaticSiteLinkedBackendArmResourceInner.class,
                StaticSiteLinkedBackendArmResourceInner.class, context);
    }

    /**
     * Link backend to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the backend to link to the static site.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of static Site Linked Backend ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<StaticSiteLinkedBackendArmResourceInner>, StaticSiteLinkedBackendArmResourceInner>
        beginLinkBackendToBuild(String resourceGroupName, String name, String environmentName, String linkedBackendName,
            StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope) {
        return this.beginLinkBackendToBuildAsync(resourceGroupName, name, environmentName, linkedBackendName,
            staticSiteLinkedBackendEnvelope).getSyncPoller();
    }

    /**
     * Link backend to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the backend to link to the static site.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of static Site Linked Backend ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<StaticSiteLinkedBackendArmResourceInner>, StaticSiteLinkedBackendArmResourceInner>
        beginLinkBackendToBuild(String resourceGroupName, String name, String environmentName, String linkedBackendName,
            StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope, Context context) {
        return this.beginLinkBackendToBuildAsync(resourceGroupName, name, environmentName, linkedBackendName,
            staticSiteLinkedBackendEnvelope, context).getSyncPoller();
    }

    /**
     * Link backend to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the backend to link to the static site.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StaticSiteLinkedBackendArmResourceInner> linkBackendToBuildAsync(String resourceGroupName, String name,
        String environmentName, String linkedBackendName,
        StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope) {
        return beginLinkBackendToBuildAsync(resourceGroupName, name, environmentName, linkedBackendName,
            staticSiteLinkedBackendEnvelope).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Link backend to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the backend to link to the static site.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<StaticSiteLinkedBackendArmResourceInner> linkBackendToBuildAsync(String resourceGroupName, String name,
        String environmentName, String linkedBackendName,
        StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope, Context context) {
        return beginLinkBackendToBuildAsync(resourceGroupName, name, environmentName, linkedBackendName,
            staticSiteLinkedBackendEnvelope, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Link backend to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the backend to link to the static site.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteLinkedBackendArmResourceInner linkBackendToBuild(String resourceGroupName, String name,
        String environmentName, String linkedBackendName,
        StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope) {
        return linkBackendToBuildAsync(resourceGroupName, name, environmentName, linkedBackendName,
            staticSiteLinkedBackendEnvelope).block();
    }

    /**
     * Link backend to a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the backend to link to the static site.
     * @param staticSiteLinkedBackendEnvelope A JSON representation of the linked backend request properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Linked Backend ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StaticSiteLinkedBackendArmResourceInner linkBackendToBuild(String resourceGroupName, String name,
        String environmentName, String linkedBackendName,
        StaticSiteLinkedBackendArmResourceInner staticSiteLinkedBackendEnvelope, Context context) {
        return linkBackendToBuildAsync(resourceGroupName, name, environmentName, linkedBackendName,
            staticSiteLinkedBackendEnvelope, context).block();
    }

    /**
     * Unlink a backend from a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the backend linked to the static site.
     * @param isCleaningAuthConfig Decides if auth will be removed from backend configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> unlinkBackendFromBuildWithResponseAsync(String resourceGroupName, String name,
        String environmentName, String linkedBackendName, Boolean isCleaningAuthConfig) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (linkedBackendName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedBackendName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.unlinkBackendFromBuild(this.client.getEndpoint(), resourceGroupName, name,
                environmentName, linkedBackendName, isCleaningAuthConfig, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Unlink a backend from a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the backend linked to the static site.
     * @param isCleaningAuthConfig Decides if auth will be removed from backend configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> unlinkBackendFromBuildWithResponseAsync(String resourceGroupName, String name,
        String environmentName, String linkedBackendName, Boolean isCleaningAuthConfig, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (linkedBackendName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedBackendName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.unlinkBackendFromBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName,
            linkedBackendName, isCleaningAuthConfig, this.client.getSubscriptionId(), this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Unlink a backend from a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the backend linked to the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> unlinkBackendFromBuildAsync(String resourceGroupName, String name, String environmentName,
        String linkedBackendName) {
        final Boolean isCleaningAuthConfig = null;
        return unlinkBackendFromBuildWithResponseAsync(resourceGroupName, name, environmentName, linkedBackendName,
            isCleaningAuthConfig).flatMap(ignored -> Mono.empty());
    }

    /**
     * Unlink a backend from a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the backend linked to the static site.
     * @param isCleaningAuthConfig Decides if auth will be removed from backend configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> unlinkBackendFromBuildWithResponse(String resourceGroupName, String name,
        String environmentName, String linkedBackendName, Boolean isCleaningAuthConfig, Context context) {
        return unlinkBackendFromBuildWithResponseAsync(resourceGroupName, name, environmentName, linkedBackendName,
            isCleaningAuthConfig, context).block();
    }

    /**
     * Unlink a backend from a static site build.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param linkedBackendName Name of the backend linked to the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void unlinkBackendFromBuild(String resourceGroupName, String name, String environmentName,
        String linkedBackendName) {
        final Boolean isCleaningAuthConfig = null;
        unlinkBackendFromBuildWithResponse(resourceGroupName, name, environmentName, linkedBackendName,
            isCleaningAuthConfig, Context.NONE);
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteArmResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<StaticSiteArmResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteArmResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteArmResourceInner>>
        getStaticSitesByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.getStaticSitesByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<StaticSiteArmResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteArmResourceInner>>
        getStaticSitesByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getStaticSitesByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom users along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteUserArmResourceInner>>
        listStaticSiteUsersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listStaticSiteUsersNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<StaticSiteUserArmResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom users along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteUserArmResourceInner>> listStaticSiteUsersNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listStaticSiteUsersNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site builds along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteBuildArmResourceInner>>
        getStaticSiteBuildsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getStaticSiteBuildsNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<StaticSiteBuildArmResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site builds along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteBuildArmResourceInner>> getStaticSiteBuildsNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getStaticSiteBuildsNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseConnectionInner>>
        getBuildDatabaseConnectionsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.getBuildDatabaseConnectionsNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DatabaseConnectionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseConnectionInner>> getBuildDatabaseConnectionsNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getBuildDatabaseConnectionsNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>>
        listStaticSiteBuildFunctionsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.listStaticSiteBuildFunctionsNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>>
        listStaticSiteBuildFunctionsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listStaticSiteBuildFunctionsNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseConnectionInner>>
        getBuildDatabaseConnectionsWithDetailsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getBuildDatabaseConnectionsWithDetailsNext(nextLink,
                this.client.getEndpoint(), accept, context))
            .<PagedResponse<DatabaseConnectionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseConnectionInner>>
        getBuildDatabaseConnectionsWithDetailsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getBuildDatabaseConnectionsWithDetailsNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteUserProvidedFunctionAppArmResourceInner>>
        getUserProvidedFunctionAppsForStaticSiteBuildNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getUserProvidedFunctionAppsForStaticSiteBuildNext(nextLink,
                this.client.getEndpoint(), accept, context))
            .<PagedResponse<StaticSiteUserProvidedFunctionAppArmResourceInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteUserProvidedFunctionAppArmResourceInner>>
        getUserProvidedFunctionAppsForStaticSiteBuildNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getUserProvidedFunctionAppsForStaticSiteBuildNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site basic auth along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteBasicAuthPropertiesArmResourceInner>>
        listBasicAuthNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listBasicAuthNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<StaticSiteBasicAuthPropertiesArmResourceInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site basic auth along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteBasicAuthPropertiesArmResourceInner>>
        listBasicAuthNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listBasicAuthNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom domains along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteCustomDomainOverviewArmResourceInner>>
        listStaticSiteCustomDomainsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.listStaticSiteCustomDomainsNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<StaticSiteCustomDomainOverviewArmResourceInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom domains along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteCustomDomainOverviewArmResourceInner>>
        listStaticSiteCustomDomainsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listStaticSiteCustomDomainsNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseConnectionInner>> getDatabaseConnectionsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getDatabaseConnectionsNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DatabaseConnectionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseConnectionInner>> getDatabaseConnectionsNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getDatabaseConnectionsNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>>
        listStaticSiteFunctionsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listStaticSiteFunctionsNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>>
        listStaticSiteFunctionsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listStaticSiteFunctionsNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RemotePrivateEndpointConnectionArmResourceInner>>
        getPrivateEndpointConnectionListNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getPrivateEndpointConnectionListNext(nextLink, this.client.getEndpoint(),
                accept, context))
            .<PagedResponse<RemotePrivateEndpointConnectionArmResourceInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RemotePrivateEndpointConnectionArmResourceInner>>
        getPrivateEndpointConnectionListNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getPrivateEndpointConnectionListNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseConnectionInner>>
        getDatabaseConnectionsWithDetailsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getDatabaseConnectionsWithDetailsNext(nextLink, this.client.getEndpoint(),
                accept, context))
            .<PagedResponse<DatabaseConnectionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site database connections along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseConnectionInner>>
        getDatabaseConnectionsWithDetailsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getDatabaseConnectionsWithDetailsNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteUserProvidedFunctionAppArmResourceInner>>
        getUserProvidedFunctionAppsForStaticSiteNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getUserProvidedFunctionAppsForStaticSiteNext(nextLink,
                this.client.getEndpoint(), accept, context))
            .<PagedResponse<StaticSiteUserProvidedFunctionAppArmResourceInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteUserProvidedFunctionAppArmResourceInner>>
        getUserProvidedFunctionAppsForStaticSiteNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getUserProvidedFunctionAppsForStaticSiteNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site linked backends along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteLinkedBackendArmResourceInner>>
        getLinkedBackendsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getLinkedBackendsNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<StaticSiteLinkedBackendArmResourceInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site linked backends along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteLinkedBackendArmResourceInner>>
        getLinkedBackendsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getLinkedBackendsNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site linked backends along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteLinkedBackendArmResourceInner>>
        getLinkedBackendsForBuildNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getLinkedBackendsForBuildNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<StaticSiteLinkedBackendArmResourceInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site linked backends along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StaticSiteLinkedBackendArmResourceInner>>
        getLinkedBackendsForBuildNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getLinkedBackendsForBuildNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
