// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * StaticSiteUserARMResource resource specific properties.
 */
@Fluent
public final class StaticSiteUserArmResourceProperties {
    /*
     * The identity provider for the static site user.
     */
    @JsonProperty(value = "provider", access = JsonProperty.Access.WRITE_ONLY)
    private String provider;

    /*
     * The user id for the static site user.
     */
    @JsonProperty(value = "userId", access = JsonProperty.Access.WRITE_ONLY)
    private String userId;

    /*
     * The display name for the static site user.
     */
    @JsonProperty(value = "displayName", access = JsonProperty.Access.WRITE_ONLY)
    private String displayName;

    /*
     * The roles for the static site user, in free-form string format
     */
    @JsonProperty(value = "roles")
    private String roles;

    /**
     * Creates an instance of StaticSiteUserArmResourceProperties class.
     */
    public StaticSiteUserArmResourceProperties() {
    }

    /**
     * Get the provider property: The identity provider for the static site user.
     * 
     * @return the provider value.
     */
    public String provider() {
        return this.provider;
    }

    /**
     * Get the userId property: The user id for the static site user.
     * 
     * @return the userId value.
     */
    public String userId() {
        return this.userId;
    }

    /**
     * Get the displayName property: The display name for the static site user.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Get the roles property: The roles for the static site user, in free-form string format.
     * 
     * @return the roles value.
     */
    public String roles() {
        return this.roles;
    }

    /**
     * Set the roles property: The roles for the static site user, in free-form string format.
     * 
     * @param roles the roles value to set.
     * @return the StaticSiteUserArmResourceProperties object itself.
     */
    public StaticSiteUserArmResourceProperties withRoles(String roles) {
        this.roles = roles;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
