// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The GitHub action container configuration.
 */
@Fluent
public final class GitHubActionContainerConfiguration {
    /*
     * The server URL for the container registry where the build will be hosted.
     */
    @JsonProperty(value = "serverUrl")
    private String serverUrl;

    /*
     * The image name for the build.
     */
    @JsonProperty(value = "imageName")
    private String imageName;

    /*
     * The username used to upload the image to the container registry.
     */
    @JsonProperty(value = "username")
    private String username;

    /*
     * The password used to upload the image to the container registry.
     */
    @JsonProperty(value = "password")
    private String password;

    /**
     * Creates an instance of GitHubActionContainerConfiguration class.
     */
    public GitHubActionContainerConfiguration() {
    }

    /**
     * Get the serverUrl property: The server URL for the container registry where the build will be hosted.
     * 
     * @return the serverUrl value.
     */
    public String serverUrl() {
        return this.serverUrl;
    }

    /**
     * Set the serverUrl property: The server URL for the container registry where the build will be hosted.
     * 
     * @param serverUrl the serverUrl value to set.
     * @return the GitHubActionContainerConfiguration object itself.
     */
    public GitHubActionContainerConfiguration withServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    /**
     * Get the imageName property: The image name for the build.
     * 
     * @return the imageName value.
     */
    public String imageName() {
        return this.imageName;
    }

    /**
     * Set the imageName property: The image name for the build.
     * 
     * @param imageName the imageName value to set.
     * @return the GitHubActionContainerConfiguration object itself.
     */
    public GitHubActionContainerConfiguration withImageName(String imageName) {
        this.imageName = imageName;
        return this;
    }

    /**
     * Get the username property: The username used to upload the image to the container registry.
     * 
     * @return the username value.
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the username property: The username used to upload the image to the container registry.
     * 
     * @param username the username value to set.
     * @return the GitHubActionContainerConfiguration object itself.
     */
    public GitHubActionContainerConfiguration withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: The password used to upload the image to the container registry.
     * 
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: The password used to upload the image to the container registry.
     * 
     * @param password the password value to set.
     * @return the GitHubActionContainerConfiguration object itself.
     */
    public GitHubActionContainerConfiguration withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
