// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Application logs azure blob storage configuration.
 */
@Fluent
public final class AzureBlobStorageApplicationLogsConfig {
    /*
     * Log level.
     */
    @JsonProperty(value = "level")
    private LogLevel level;

    /*
     * SAS url to a azure blob container with read/write/list/delete permissions.
     */
    @JsonProperty(value = "sasUrl")
    private String sasUrl;

    /*
     * Retention in days.
     * Remove blobs older than X days.
     * 0 or lower means no retention.
     */
    @JsonProperty(value = "retentionInDays")
    private Integer retentionInDays;

    /**
     * Creates an instance of AzureBlobStorageApplicationLogsConfig class.
     */
    public AzureBlobStorageApplicationLogsConfig() {
    }

    /**
     * Get the level property: Log level.
     * 
     * @return the level value.
     */
    public LogLevel level() {
        return this.level;
    }

    /**
     * Set the level property: Log level.
     * 
     * @param level the level value to set.
     * @return the AzureBlobStorageApplicationLogsConfig object itself.
     */
    public AzureBlobStorageApplicationLogsConfig withLevel(LogLevel level) {
        this.level = level;
        return this;
    }

    /**
     * Get the sasUrl property: SAS url to a azure blob container with read/write/list/delete permissions.
     * 
     * @return the sasUrl value.
     */
    public String sasUrl() {
        return this.sasUrl;
    }

    /**
     * Set the sasUrl property: SAS url to a azure blob container with read/write/list/delete permissions.
     * 
     * @param sasUrl the sasUrl value to set.
     * @return the AzureBlobStorageApplicationLogsConfig object itself.
     */
    public AzureBlobStorageApplicationLogsConfig withSasUrl(String sasUrl) {
        this.sasUrl = sasUrl;
        return this;
    }

    /**
     * Get the retentionInDays property: Retention in days.
     * Remove blobs older than X days.
     * 0 or lower means no retention.
     * 
     * @return the retentionInDays value.
     */
    public Integer retentionInDays() {
        return this.retentionInDays;
    }

    /**
     * Set the retentionInDays property: Retention in days.
     * Remove blobs older than X days.
     * 0 or lower means no retention.
     * 
     * @param retentionInDays the retentionInDays value to set.
     * @return the AzureBlobStorageApplicationLogsConfig object itself.
     */
    public AzureBlobStorageApplicationLogsConfig withRetentionInDays(Integer retentionInDays) {
        this.retentionInDays = retentionInDays;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
