// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A setting difference between two deployment slots of an app.
 */
@Fluent
public final class SlotDifferenceInner extends ProxyOnlyResource {
    /*
     * SlotDifference resource specific properties
     */
    @JsonProperty(value = "properties")
    private SlotDifferenceProperties innerProperties;

    /**
     * Creates an instance of SlotDifferenceInner class.
     */
    public SlotDifferenceInner() {
    }

    /**
     * Get the innerProperties property: SlotDifference resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private SlotDifferenceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SlotDifferenceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the level property: Level of the difference: Information, Warning or Error.
     * 
     * @return the level value.
     */
    public String level() {
        return this.innerProperties() == null ? null : this.innerProperties().level();
    }

    /**
     * Get the settingType property: The type of the setting: General, AppSetting or ConnectionString.
     * 
     * @return the settingType value.
     */
    public String settingType() {
        return this.innerProperties() == null ? null : this.innerProperties().settingType();
    }

    /**
     * Get the diffRule property: Rule that describes how to process the setting difference during a slot swap.
     * 
     * @return the diffRule value.
     */
    public String diffRule() {
        return this.innerProperties() == null ? null : this.innerProperties().diffRule();
    }

    /**
     * Get the settingName property: Name of the setting.
     * 
     * @return the settingName value.
     */
    public String settingName() {
        return this.innerProperties() == null ? null : this.innerProperties().settingName();
    }

    /**
     * Get the valueInCurrentSlot property: Value of the setting in the current slot.
     * 
     * @return the valueInCurrentSlot value.
     */
    public String valueInCurrentSlot() {
        return this.innerProperties() == null ? null : this.innerProperties().valueInCurrentSlot();
    }

    /**
     * Get the valueInTargetSlot property: Value of the setting in the target slot.
     * 
     * @return the valueInTargetSlot value.
     */
    public String valueInTargetSlot() {
        return this.innerProperties() == null ? null : this.innerProperties().valueInTargetSlot();
    }

    /**
     * Get the description property: Description of the setting difference.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
