// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/**
 * A snapshot of a web app configuration.
 */
@Fluent
public final class SiteConfigurationSnapshotInfoInner extends ProxyOnlyResource {
    /*
     * SiteConfigurationSnapshotInfo resource specific properties
     */
    @JsonProperty(value = "properties")
    private SiteConfigurationSnapshotInfoProperties innerProperties;

    /**
     * Creates an instance of SiteConfigurationSnapshotInfoInner class.
     */
    public SiteConfigurationSnapshotInfoInner() {
    }

    /**
     * Get the innerProperties property: SiteConfigurationSnapshotInfo resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private SiteConfigurationSnapshotInfoProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SiteConfigurationSnapshotInfoInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the time property: The time the snapshot was taken.
     * 
     * @return the time value.
     */
    public OffsetDateTime time() {
        return this.innerProperties() == null ? null : this.innerProperties().time();
    }

    /**
     * Get the snapshotId property: The id of the snapshot.
     * 
     * @return the snapshotId value.
     */
    public Integer snapshotId() {
        return this.innerProperties() == null ? null : this.innerProperties().snapshotId();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
