/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.ConnectionStringDictionaryInner;
import com.azure.resourcemanager.appservice.fluent.models.HostnameBindingInner;
import com.azure.resourcemanager.appservice.fluent.models.IdentifierInner;
import com.azure.resourcemanager.appservice.fluent.models.MSDeployStatusInner;
import com.azure.resourcemanager.appservice.fluent.models.PrivateLinkResourcesWrapperInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteAuthSettingsInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.azure.resourcemanager.appservice.fluent.models.SitePatchResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteSourceControlInner;
import com.azure.resourcemanager.appservice.fluent.models.SlotConfigNamesResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StringDictionaryInner;
import com.azure.resourcemanager.appservice.implementation.AppServicePlanImpl;
import com.azure.resourcemanager.appservice.implementation.HostnameBindingImpl;
import com.azure.resourcemanager.appservice.implementation.PublishingProfileImpl;
import com.azure.resourcemanager.appservice.implementation.Utils;
import com.azure.resourcemanager.appservice.implementation.WebAppBaseImpl;
import com.azure.resourcemanager.appservice.implementation.WebAppSourceControlImpl;
import com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.azure.resourcemanager.appservice.models.CsmPublishingProfileOptions;
import com.azure.resourcemanager.appservice.models.CsmSlotEntity;
import com.azure.resourcemanager.appservice.models.HostnameBinding;
import com.azure.resourcemanager.appservice.models.MSDeploy;
import com.azure.resourcemanager.appservice.models.OperatingSystem;
import com.azure.resourcemanager.appservice.models.PricingTier;
import com.azure.resourcemanager.appservice.models.PrivateLinkConnectionApprovalRequestResource;
import com.azure.resourcemanager.appservice.models.PrivateLinkConnectionState;
import com.azure.resourcemanager.appservice.models.PublishingProfile;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.appservice.models.WebAppSourceControl;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpointConnection;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpointServiceConnectionStatus;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateLinkResource;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsListingPrivateEndpointConnection;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsListingPrivateLinkResource;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsUpdatingPrivateEndpointConnection;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

abstract class AppServiceBaseImpl<FluentT extends WebAppBase, FluentImplT extends AppServiceBaseImpl<FluentT, FluentImplT, FluentWithCreateT, FluentUpdateT>, FluentWithCreateT, FluentUpdateT>
extends WebAppBaseImpl<FluentT, FluentImplT>
implements SupportsListingPrivateLinkResource,
SupportsListingPrivateEndpointConnection,
SupportsUpdatingPrivateEndpointConnection {
    private final ClientLogger logger = new ClientLogger(this.getClass());

    AppServiceBaseImpl(String name, SiteInner innerObject, SiteConfigResourceInner siteConfig, SiteLogsConfigInner logConfig, AppServiceManager manager) {
        super(name, innerObject, siteConfig, logConfig, manager);
    }

    @Override
    Mono<SiteInner> createOrUpdateInner(SiteInner site) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().createOrUpdateAsync(this.resourceGroupName(), this.name(), site);
    }

    @Override
    Mono<SiteInner> updateInner(SitePatchResourceInner siteUpdate) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().updateAsync(this.resourceGroupName(), this.name(), siteUpdate);
    }

    @Override
    Mono<SiteInner> getInner() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    Mono<SiteConfigResourceInner> getConfigInner() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().getConfigurationAsync(this.resourceGroupName(), this.name());
    }

    @Override
    Mono<SiteConfigResourceInner> createOrUpdateSiteConfig(SiteConfigResourceInner siteConfig) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().createOrUpdateConfigurationAsync(this.resourceGroupName(), this.name(), siteConfig);
    }

    @Override
    Mono<Void> deleteHostnameBinding(String hostname) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().deleteHostnameBindingAsync(this.resourceGroupName(), this.name(), hostname);
    }

    @Override
    Mono<StringDictionaryInner> listAppSettings() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().listApplicationSettingsAsync(this.resourceGroupName(), this.name());
    }

    @Override
    Mono<StringDictionaryInner> updateAppSettings(StringDictionaryInner inner) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().updateApplicationSettingsAsync(this.resourceGroupName(), this.name(), inner);
    }

    @Override
    Mono<ConnectionStringDictionaryInner> listConnectionStrings() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().listConnectionStringsAsync(this.resourceGroupName(), this.name());
    }

    @Override
    Mono<ConnectionStringDictionaryInner> updateConnectionStrings(ConnectionStringDictionaryInner inner) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().updateConnectionStringsAsync(this.resourceGroupName(), this.name(), inner);
    }

    @Override
    Mono<SlotConfigNamesResourceInner> listSlotConfigurations() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().listSlotConfigurationNamesAsync(this.resourceGroupName(), this.name());
    }

    @Override
    Mono<SlotConfigNamesResourceInner> updateSlotConfigurations(SlotConfigNamesResourceInner inner) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().updateSlotConfigurationNamesAsync(this.resourceGroupName(), this.name(), inner);
    }

    @Override
    Mono<SiteSourceControlInner> createOrUpdateSourceControl(SiteSourceControlInner inner) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().createOrUpdateSourceControlAsync(this.resourceGroupName(), this.name(), inner);
    }

    @Override
    Mono<Void> deleteSourceControl() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().deleteSourceControlAsync(this.resourceGroupName(), this.name());
    }

    @Override
    Mono<SiteAuthSettingsInner> updateAuthentication(SiteAuthSettingsInner inner) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().updateAuthSettingsAsync(this.resourceGroupName(), this.name(), inner);
    }

    @Override
    Mono<SiteAuthSettingsInner> getAuthentication() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().getAuthSettingsAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public Map<String, HostnameBinding> getHostnameBindings() {
        return (Map)this.getHostnameBindingsAsync().block();
    }

    @Override
    public Mono<Map<String, HostnameBinding>> getHostnameBindingsAsync() {
        return PagedConverter.mapPage(((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().listHostnameBindingsAsync(this.resourceGroupName(), this.name()), hostNameBindingInner -> new HostnameBindingImpl((HostnameBindingInner)((Object)hostNameBindingInner), this)).collectList().map(hostNameBindings -> Collections.unmodifiableMap(hostNameBindings.stream().collect(Collectors.toMap(binding -> binding.name().replace(this.name() + "/", ""), Function.identity()))));
    }

    @Override
    public PublishingProfile getPublishingProfile() {
        return (PublishingProfile)this.getPublishingProfileAsync().block();
    }

    @Override
    public Mono<PublishingProfile> getPublishingProfileAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().listPublishingProfileXmlWithSecretsAsync(this.resourceGroupName(), this.name(), new CsmPublishingProfileOptions()).map(binaryData -> new PublishingProfileImpl(binaryData.toString(), this));
    }

    @Override
    public WebAppSourceControl getSourceControl() {
        return (WebAppSourceControl)this.getSourceControlAsync().block();
    }

    @Override
    public Mono<WebAppSourceControl> getSourceControlAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().getSourceControlAsync(this.resourceGroupName(), this.name()).map(siteSourceControlInner -> new WebAppSourceControlImpl((SiteSourceControlInner)((Object)siteSourceControlInner), this));
    }

    @Override
    Mono<MSDeployStatusInner> createMSDeploy(MSDeploy msDeployInner) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().createMSDeployOperationAsync(this.resourceGroupName(), this.name(), msDeployInner);
    }

    @Override
    public void verifyDomainOwnership(String certificateOrderName, String domainVerificationToken) {
        this.verifyDomainOwnershipAsync(certificateOrderName, domainVerificationToken).block();
    }

    @Override
    public Mono<Void> verifyDomainOwnershipAsync(String certificateOrderName, String domainVerificationToken) {
        IdentifierInner identifierInner = new IdentifierInner().withValue(domainVerificationToken);
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().createOrUpdateDomainOwnershipIdentifierAsync(this.resourceGroupName(), this.name(), certificateOrderName, identifierInner).then(Mono.empty());
    }

    @Override
    public void start() {
        this.startAsync().block();
    }

    @Override
    public Mono<Void> startAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().startAsync(this.resourceGroupName(), this.name()).then(this.refreshAsync()).then(Mono.empty());
    }

    @Override
    public void stop() {
        this.stopAsync().block();
    }

    @Override
    public Mono<Void> stopAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().stopAsync(this.resourceGroupName(), this.name()).then(this.refreshAsync()).then(Mono.empty());
    }

    @Override
    public void restart() {
        this.restartAsync().block();
    }

    @Override
    public Mono<Void> restartAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().restartAsync(this.resourceGroupName(), this.name()).then(this.refreshAsync()).then(Mono.empty());
    }

    @Override
    public void swap(String slotName) {
        this.swapAsync(slotName).block();
    }

    @Override
    public Mono<Void> swapAsync(String slotName) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().swapSlotWithProductionAsync(this.resourceGroupName(), this.name(), new CsmSlotEntity().withTargetSlot(slotName)).then(this.refreshAsync()).then(Mono.empty());
    }

    @Override
    public void applySlotConfigurations(String slotName) {
        this.applySlotConfigurationsAsync(slotName).block();
    }

    @Override
    public Mono<Void> applySlotConfigurationsAsync(String slotName) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().applySlotConfigToProductionAsync(this.resourceGroupName(), this.name(), new CsmSlotEntity().withTargetSlot(slotName)).then(this.refreshAsync()).then(Mono.empty());
    }

    @Override
    public void resetSlotConfigurations() {
        this.resetSlotConfigurationsAsync().block();
    }

    @Override
    public Mono<Void> resetSlotConfigurationsAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().resetProductionSlotConfigAsync(this.resourceGroupName(), this.name()).then(this.refreshAsync()).then(Mono.empty());
    }

    @Override
    public byte[] getContainerLogs() {
        return (byte[])this.getContainerLogsAsync().block();
    }

    @Override
    public Mono<byte[]> getContainerLogsAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().getWebSiteContainerLogsAsync(this.resourceGroupName(), this.name()).map(BinaryData::toBytes);
    }

    @Override
    public byte[] getContainerLogsZip() {
        return (byte[])this.getContainerLogsZipAsync().block();
    }

    @Override
    public Mono<byte[]> getContainerLogsZipAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().getContainerLogsZipAsync(this.resourceGroupName(), this.name()).map(BinaryData::toBytes);
    }

    @Override
    Mono<SiteLogsConfigInner> updateDiagnosticLogsConfig(SiteLogsConfigInner siteLogsConfigInner) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().updateDiagnosticLogsConfigAsync(this.resourceGroupName(), this.name(), siteLogsConfigInner);
    }

    private AppServicePlanImpl newDefaultAppServicePlan() {
        String planName = ((AppServiceManager)this.manager()).resourceManager().internalContext().randomResourceName(this.name() + "plan", 32);
        return this.newDefaultAppServicePlan(planName);
    }

    private AppServicePlanImpl newDefaultAppServicePlan(String appServicePlanName) {
        AppServicePlanImpl appServicePlan = (AppServicePlanImpl)((AppServicePlan.DefinitionStages.Blank)((AppServiceManager)this.manager()).appServicePlans().define(appServicePlanName)).withRegion(this.regionName());
        appServicePlan = this.creatableGroup != null && this.isInCreateMode() ? (AppServicePlanImpl)appServicePlan.withNewResourceGroup(this.creatableGroup) : (AppServicePlanImpl)appServicePlan.withExistingResourceGroup(this.resourceGroupName());
        return appServicePlan;
    }

    public FluentImplT withNewFreeAppServicePlan() {
        return this.withNewAppServicePlan(OperatingSystem.WINDOWS, PricingTier.FREE_F1);
    }

    public FluentImplT withNewSharedAppServicePlan() {
        return this.withNewAppServicePlan(OperatingSystem.WINDOWS, PricingTier.SHARED_D1);
    }

    FluentImplT withNewAppServicePlan(OperatingSystem operatingSystem, PricingTier pricingTier) {
        return this.withNewAppServicePlan(this.newDefaultAppServicePlan().withOperatingSystem(operatingSystem).withPricingTier(pricingTier));
    }

    FluentImplT withNewAppServicePlan(String appServicePlanName, OperatingSystem operatingSystem, PricingTier pricingTier) {
        return this.withNewAppServicePlan(this.newDefaultAppServicePlan(appServicePlanName).withOperatingSystem(operatingSystem).withPricingTier(pricingTier));
    }

    public FluentImplT withNewAppServicePlan(PricingTier pricingTier) {
        return this.withNewAppServicePlan(this.operatingSystem(), pricingTier);
    }

    public FluentImplT withNewAppServicePlan(String appServicePlanName, PricingTier pricingTier) {
        return this.withNewAppServicePlan(appServicePlanName, this.operatingSystem(), pricingTier);
    }

    public FluentImplT withNewAppServicePlan(Creatable<AppServicePlan> appServicePlanCreatable) {
        this.addDependency(appServicePlanCreatable);
        String id = ResourceUtils.constructResourceId((String)((AppServiceManager)this.manager()).subscriptionId(), (String)this.resourceGroupName(), (String)"Microsoft.Web", (String)"serverFarms", (String)appServicePlanCreatable.name(), (String)"");
        ((SiteInner)((Object)this.innerModel())).withServerFarmId(id);
        if (appServicePlanCreatable instanceof AppServicePlanImpl) {
            return this.withOperatingSystem(((AppServicePlanImpl)appServicePlanCreatable).operatingSystem());
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Internal error, appServicePlanCreatable must be class AppServicePlanImpl"));
    }

    private FluentImplT withOperatingSystem(OperatingSystem os) {
        if (os == OperatingSystem.LINUX) {
            ((SiteInner)((Object)this.innerModel())).withReserved(true);
            ((SiteInner)((Object)this.innerModel())).withKind(((SiteInner)((Object)this.innerModel())).kind() + ",linux");
        }
        return (FluentImplT)this;
    }

    public FluentImplT withExistingAppServicePlan(AppServicePlan appServicePlan) {
        ((SiteInner)((Object)this.innerModel())).withServerFarmId(appServicePlan.id());
        this.withRegion(appServicePlan.regionName());
        return this.withOperatingSystem(this.appServicePlanOperatingSystem(appServicePlan));
    }

    public FluentImplT withPublicDockerHubImage(String imageAndTag) {
        this.cleanUpContainerSettings();
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.setAppFrameworkVersion(String.format("DOCKER|%s", imageAndTag));
        this.withAppSetting("DOCKER_CUSTOM_IMAGE_NAME", imageAndTag);
        return (FluentImplT)this;
    }

    public FluentImplT withPrivateDockerHubImage(String imageAndTag) {
        return this.withPublicDockerHubImage(imageAndTag);
    }

    public FluentImplT withPrivateRegistryImage(String imageAndTag, String serverUrl) {
        imageAndTag = Utils.smartCompletionPrivateRegistryImage(imageAndTag, serverUrl);
        this.cleanUpContainerSettings();
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.setAppFrameworkVersion(String.format("DOCKER|%s", imageAndTag));
        this.withAppSetting("DOCKER_CUSTOM_IMAGE_NAME", imageAndTag);
        this.withAppSetting("DOCKER_REGISTRY_SERVER_URL", serverUrl);
        return (FluentImplT)this;
    }

    public FluentImplT withCredentials(String username, String password) {
        this.withAppSetting("DOCKER_REGISTRY_SERVER_USERNAME", username);
        this.withAppSetting("DOCKER_REGISTRY_SERVER_PASSWORD", password);
        return (FluentImplT)this;
    }

    protected abstract void cleanUpContainerSettings();

    protected void ensureLinuxPlan() {
        if (OperatingSystem.WINDOWS.equals((Object)this.operatingSystem())) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Docker container settings only apply to Linux app service plans."));
        }
    }

    protected OperatingSystem appServicePlanOperatingSystem(AppServicePlan appServicePlan) {
        return appServicePlan.operatingSystem();
    }

    public PagedIterable<PrivateLinkResource> listPrivateLinkResources() {
        return new PagedIterable(this.listPrivateLinkResourcesAsync());
    }

    public PagedFlux<PrivateLinkResource> listPrivateLinkResourcesAsync() {
        Mono retList = ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().getPrivateLinkResourcesWithResponseAsync(this.resourceGroupName(), this.name()).map(response -> new SimpleResponse(response, ((PrivateLinkResourcesWrapperInner)response.getValue()).value().stream().map(WebAppBaseImpl.PrivateLinkResourceImpl::new).collect(Collectors.toList())));
        return PagedConverter.convertListToPagedFlux((Mono)retList);
    }

    public PagedIterable<PrivateEndpointConnection> listPrivateEndpointConnections() {
        return new PagedIterable(this.listPrivateEndpointConnectionsAsync());
    }

    public PagedFlux<PrivateEndpointConnection> listPrivateEndpointConnectionsAsync() {
        return PagedConverter.mapPage(((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().getPrivateEndpointConnectionListAsync(this.resourceGroupName(), this.name()), WebAppBaseImpl.PrivateEndpointConnectionImpl::new);
    }

    public void approvePrivateEndpointConnection(String privateEndpointConnectionName) {
        this.approvePrivateEndpointConnectionAsync(privateEndpointConnectionName).block();
    }

    public Mono<Void> approvePrivateEndpointConnectionAsync(String privateEndpointConnectionName) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().approveOrRejectPrivateEndpointConnectionAsync(this.resourceGroupName(), this.name(), privateEndpointConnectionName, new PrivateLinkConnectionApprovalRequestResource().withPrivateLinkServiceConnectionState(new PrivateLinkConnectionState().withStatus(PrivateEndpointServiceConnectionStatus.APPROVED.toString()))).then();
    }

    public void rejectPrivateEndpointConnection(String privateEndpointConnectionName) {
        this.rejectPrivateEndpointConnectionAsync(privateEndpointConnectionName).block();
    }

    public Mono<Void> rejectPrivateEndpointConnectionAsync(String privateEndpointConnectionName) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().approveOrRejectPrivateEndpointConnectionAsync(this.resourceGroupName(), this.name(), privateEndpointConnectionName, new PrivateLinkConnectionApprovalRequestResource().withPrivateLinkServiceConnectionState(new PrivateLinkConnectionState().withStatus(PrivateEndpointServiceConnectionStatus.REJECTED.toString()))).then();
    }
}

