// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.fluent.models.WorkflowRunActionRepetitionDefinitionInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** A collection of workflow run action repetitions. */
@Fluent
public final class WorkflowRunActionRepetitionDefinitionCollection {
    /*
     * The link used to get the next page of recommendations.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /*
     * The value property.
     */
    @JsonProperty(value = "value")
    private List<WorkflowRunActionRepetitionDefinitionInner> value;

    /**
     * Get the nextLink property: The link used to get the next page of recommendations.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link used to get the next page of recommendations.
     *
     * @param nextLink the nextLink value to set.
     * @return the WorkflowRunActionRepetitionDefinitionCollection object itself.
     */
    public WorkflowRunActionRepetitionDefinitionCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Get the value property: The value property.
     *
     * @return the value value.
     */
    public List<WorkflowRunActionRepetitionDefinitionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The value property.
     *
     * @param value the value value to set.
     * @return the WorkflowRunActionRepetitionDefinitionCollection object itself.
     */
    public WorkflowRunActionRepetitionDefinitionCollection withValue(
        List<WorkflowRunActionRepetitionDefinitionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
