// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The correlation properties. */
@Fluent
public class RunCorrelation {
    /*
     * The client tracking identifier.
     */
    @JsonProperty(value = "clientTrackingId")
    private String clientTrackingId;

    /*
     * The client keywords.
     */
    @JsonProperty(value = "clientKeywords")
    private List<String> clientKeywords;

    /**
     * Get the clientTrackingId property: The client tracking identifier.
     *
     * @return the clientTrackingId value.
     */
    public String clientTrackingId() {
        return this.clientTrackingId;
    }

    /**
     * Set the clientTrackingId property: The client tracking identifier.
     *
     * @param clientTrackingId the clientTrackingId value to set.
     * @return the RunCorrelation object itself.
     */
    public RunCorrelation withClientTrackingId(String clientTrackingId) {
        this.clientTrackingId = clientTrackingId;
        return this;
    }

    /**
     * Get the clientKeywords property: The client keywords.
     *
     * @return the clientKeywords value.
     */
    public List<String> clientKeywords() {
        return this.clientKeywords;
    }

    /**
     * Set the clientKeywords property: The client keywords.
     *
     * @param clientKeywords the clientKeywords value to set.
     * @return the RunCorrelation object itself.
     */
    public RunCorrelation withClientKeywords(List<String> clientKeywords) {
        this.clientKeywords = clientKeywords;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
