// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** A request. */
@Fluent
public final class Request {
    /*
     * A list of all the headers attached to the request.
     */
    @JsonProperty(value = "headers")
    private Object headers;

    /*
     * The destination for the request.
     */
    @JsonProperty(value = "uri")
    private String uri;

    /*
     * The HTTP method used for the request.
     */
    @JsonProperty(value = "method")
    private String method;

    /**
     * Get the headers property: A list of all the headers attached to the request.
     *
     * @return the headers value.
     */
    public Object headers() {
        return this.headers;
    }

    /**
     * Set the headers property: A list of all the headers attached to the request.
     *
     * @param headers the headers value to set.
     * @return the Request object itself.
     */
    public Request withHeaders(Object headers) {
        this.headers = headers;
        return this;
    }

    /**
     * Get the uri property: The destination for the request.
     *
     * @return the uri value.
     */
    public String uri() {
        return this.uri;
    }

    /**
     * Set the uri property: The destination for the request.
     *
     * @param uri the uri value to set.
     * @return the Request object itself.
     */
    public Request withUri(String uri) {
        this.uri = uri;
        return this;
    }

    /**
     * Get the method property: The HTTP method used for the request.
     *
     * @return the method value.
     */
    public String method() {
        return this.method;
    }

    /**
     * Set the method property: The HTTP method used for the request.
     *
     * @param method the method value to set.
     * @return the Request object itself.
     */
    public Request withMethod(String method) {
        this.method = method;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
