// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The workflow run action repetition index. */
@Fluent
public final class RepetitionIndex {
    /*
     * The scope.
     */
    @JsonProperty(value = "scopeName")
    private String scopeName;

    /*
     * The index.
     */
    @JsonProperty(value = "itemIndex", required = true)
    private int itemIndex;

    /**
     * Get the scopeName property: The scope.
     *
     * @return the scopeName value.
     */
    public String scopeName() {
        return this.scopeName;
    }

    /**
     * Set the scopeName property: The scope.
     *
     * @param scopeName the scopeName value to set.
     * @return the RepetitionIndex object itself.
     */
    public RepetitionIndex withScopeName(String scopeName) {
        this.scopeName = scopeName;
        return this;
    }

    /**
     * Get the itemIndex property: The index.
     *
     * @return the itemIndex value.
     */
    public int itemIndex() {
        return this.itemIndex;
    }

    /**
     * Set the itemIndex property: The index.
     *
     * @param itemIndex the itemIndex value to set.
     * @return the RepetitionIndex object itself.
     */
    public RepetitionIndex withItemIndex(int itemIndex) {
        this.itemIndex = itemIndex;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
