// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** SSL certificate details. */
@Immutable
public final class CertificateDetails {
    /*
     * Certificate Version.
     */
    @JsonProperty(value = "version", access = JsonProperty.Access.WRITE_ONLY)
    private Integer version;

    /*
     * Certificate Serial Number.
     */
    @JsonProperty(value = "serialNumber", access = JsonProperty.Access.WRITE_ONLY)
    private String serialNumber;

    /*
     * Certificate Thumbprint.
     */
    @JsonProperty(value = "thumbprint", access = JsonProperty.Access.WRITE_ONLY)
    private String thumbprint;

    /*
     * Certificate Subject.
     */
    @JsonProperty(value = "subject", access = JsonProperty.Access.WRITE_ONLY)
    private String subject;

    /*
     * Date Certificate is valid from.
     */
    @JsonProperty(value = "notBefore", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime notBefore;

    /*
     * Date Certificate is valid to.
     */
    @JsonProperty(value = "notAfter", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime notAfter;

    /*
     * Certificate Signature algorithm.
     */
    @JsonProperty(value = "signatureAlgorithm", access = JsonProperty.Access.WRITE_ONLY)
    private String signatureAlgorithm;

    /*
     * Certificate Issuer.
     */
    @JsonProperty(value = "issuer", access = JsonProperty.Access.WRITE_ONLY)
    private String issuer;

    /*
     * Raw certificate data.
     */
    @JsonProperty(value = "rawData", access = JsonProperty.Access.WRITE_ONLY)
    private String rawData;

    /**
     * Get the version property: Certificate Version.
     *
     * @return the version value.
     */
    public Integer version() {
        return this.version;
    }

    /**
     * Get the serialNumber property: Certificate Serial Number.
     *
     * @return the serialNumber value.
     */
    public String serialNumber() {
        return this.serialNumber;
    }

    /**
     * Get the thumbprint property: Certificate Thumbprint.
     *
     * @return the thumbprint value.
     */
    public String thumbprint() {
        return this.thumbprint;
    }

    /**
     * Get the subject property: Certificate Subject.
     *
     * @return the subject value.
     */
    public String subject() {
        return this.subject;
    }

    /**
     * Get the notBefore property: Date Certificate is valid from.
     *
     * @return the notBefore value.
     */
    public OffsetDateTime notBefore() {
        return this.notBefore;
    }

    /**
     * Get the notAfter property: Date Certificate is valid to.
     *
     * @return the notAfter value.
     */
    public OffsetDateTime notAfter() {
        return this.notAfter;
    }

    /**
     * Get the signatureAlgorithm property: Certificate Signature algorithm.
     *
     * @return the signatureAlgorithm value.
     */
    public String signatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    /**
     * Get the issuer property: Certificate Issuer.
     *
     * @return the issuer value.
     */
    public String issuer() {
        return this.issuer;
    }

    /**
     * Get the rawData property: Raw certificate data.
     *
     * @return the rawData value.
     */
    public String rawData() {
        return this.rawData;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
