// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** A static site zip deployment. */
@Fluent
public final class StaticSiteZipDeployment {
    /*
     * URL for the zipped app content
     */
    @JsonProperty(value = "appZipUrl")
    private String appZipUrl;

    /*
     * URL for the zipped api content
     */
    @JsonProperty(value = "apiZipUrl")
    private String apiZipUrl;

    /*
     * A title to label the deployment
     */
    @JsonProperty(value = "deploymentTitle")
    private String deploymentTitle;

    /*
     * The provider submitting this deployment
     */
    @JsonProperty(value = "provider")
    private String provider;

    /*
     * The language of the api content, if it exists
     */
    @JsonProperty(value = "functionLanguage")
    private String functionLanguage;

    /**
     * Get the appZipUrl property: URL for the zipped app content.
     *
     * @return the appZipUrl value.
     */
    public String appZipUrl() {
        return this.appZipUrl;
    }

    /**
     * Set the appZipUrl property: URL for the zipped app content.
     *
     * @param appZipUrl the appZipUrl value to set.
     * @return the StaticSiteZipDeployment object itself.
     */
    public StaticSiteZipDeployment withAppZipUrl(String appZipUrl) {
        this.appZipUrl = appZipUrl;
        return this;
    }

    /**
     * Get the apiZipUrl property: URL for the zipped api content.
     *
     * @return the apiZipUrl value.
     */
    public String apiZipUrl() {
        return this.apiZipUrl;
    }

    /**
     * Set the apiZipUrl property: URL for the zipped api content.
     *
     * @param apiZipUrl the apiZipUrl value to set.
     * @return the StaticSiteZipDeployment object itself.
     */
    public StaticSiteZipDeployment withApiZipUrl(String apiZipUrl) {
        this.apiZipUrl = apiZipUrl;
        return this;
    }

    /**
     * Get the deploymentTitle property: A title to label the deployment.
     *
     * @return the deploymentTitle value.
     */
    public String deploymentTitle() {
        return this.deploymentTitle;
    }

    /**
     * Set the deploymentTitle property: A title to label the deployment.
     *
     * @param deploymentTitle the deploymentTitle value to set.
     * @return the StaticSiteZipDeployment object itself.
     */
    public StaticSiteZipDeployment withDeploymentTitle(String deploymentTitle) {
        this.deploymentTitle = deploymentTitle;
        return this;
    }

    /**
     * Get the provider property: The provider submitting this deployment.
     *
     * @return the provider value.
     */
    public String provider() {
        return this.provider;
    }

    /**
     * Set the provider property: The provider submitting this deployment.
     *
     * @param provider the provider value to set.
     * @return the StaticSiteZipDeployment object itself.
     */
    public StaticSiteZipDeployment withProvider(String provider) {
        this.provider = provider;
        return this;
    }

    /**
     * Get the functionLanguage property: The language of the api content, if it exists.
     *
     * @return the functionLanguage value.
     */
    public String functionLanguage() {
        return this.functionLanguage;
    }

    /**
     * Set the functionLanguage property: The language of the api content, if it exists.
     *
     * @param functionLanguage the functionLanguage value to set.
     * @return the StaticSiteZipDeployment object itself.
     */
    public StaticSiteZipDeployment withFunctionLanguage(String functionLanguage) {
        this.functionLanguage = functionLanguage;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
