// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** AseV3NetworkingConfiguration resource specific properties. */
@Fluent
public final class AseV3NetworkingConfigurationProperties {
    /*
     * The windowsOutboundIpAddresses property.
     */
    @JsonProperty(value = "windowsOutboundIpAddresses", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> windowsOutboundIpAddresses;

    /*
     * The linuxOutboundIpAddresses property.
     */
    @JsonProperty(value = "linuxOutboundIpAddresses", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> linuxOutboundIpAddresses;

    /*
     * The externalInboundIpAddresses property.
     */
    @JsonProperty(value = "externalInboundIpAddresses", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> externalInboundIpAddresses;

    /*
     * The internalInboundIpAddresses property.
     */
    @JsonProperty(value = "internalInboundIpAddresses", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> internalInboundIpAddresses;

    /*
     * Property to enable and disable new private endpoint connection creation
     * on ASE
     */
    @JsonProperty(value = "allowNewPrivateEndpointConnections")
    private Boolean allowNewPrivateEndpointConnections;

    /*
     * Property to enable and disable FTP on ASEV3
     */
    @JsonProperty(value = "ftpEnabled")
    private Boolean ftpEnabled;

    /*
     * Property to enable and disable Remote Debug on ASEV3
     */
    @JsonProperty(value = "remoteDebugEnabled")
    private Boolean remoteDebugEnabled;

    /*
     * Customer provided Inbound IP Address. Only able to be set on Ase create.
     */
    @JsonProperty(value = "inboundIpAddressOverride")
    private String inboundIpAddressOverride;

    /**
     * Get the windowsOutboundIpAddresses property: The windowsOutboundIpAddresses property.
     *
     * @return the windowsOutboundIpAddresses value.
     */
    public List<String> windowsOutboundIpAddresses() {
        return this.windowsOutboundIpAddresses;
    }

    /**
     * Get the linuxOutboundIpAddresses property: The linuxOutboundIpAddresses property.
     *
     * @return the linuxOutboundIpAddresses value.
     */
    public List<String> linuxOutboundIpAddresses() {
        return this.linuxOutboundIpAddresses;
    }

    /**
     * Get the externalInboundIpAddresses property: The externalInboundIpAddresses property.
     *
     * @return the externalInboundIpAddresses value.
     */
    public List<String> externalInboundIpAddresses() {
        return this.externalInboundIpAddresses;
    }

    /**
     * Get the internalInboundIpAddresses property: The internalInboundIpAddresses property.
     *
     * @return the internalInboundIpAddresses value.
     */
    public List<String> internalInboundIpAddresses() {
        return this.internalInboundIpAddresses;
    }

    /**
     * Get the allowNewPrivateEndpointConnections property: Property to enable and disable new private endpoint
     * connection creation on ASE.
     *
     * @return the allowNewPrivateEndpointConnections value.
     */
    public Boolean allowNewPrivateEndpointConnections() {
        return this.allowNewPrivateEndpointConnections;
    }

    /**
     * Set the allowNewPrivateEndpointConnections property: Property to enable and disable new private endpoint
     * connection creation on ASE.
     *
     * @param allowNewPrivateEndpointConnections the allowNewPrivateEndpointConnections value to set.
     * @return the AseV3NetworkingConfigurationProperties object itself.
     */
    public AseV3NetworkingConfigurationProperties withAllowNewPrivateEndpointConnections(
        Boolean allowNewPrivateEndpointConnections) {
        this.allowNewPrivateEndpointConnections = allowNewPrivateEndpointConnections;
        return this;
    }

    /**
     * Get the ftpEnabled property: Property to enable and disable FTP on ASEV3.
     *
     * @return the ftpEnabled value.
     */
    public Boolean ftpEnabled() {
        return this.ftpEnabled;
    }

    /**
     * Set the ftpEnabled property: Property to enable and disable FTP on ASEV3.
     *
     * @param ftpEnabled the ftpEnabled value to set.
     * @return the AseV3NetworkingConfigurationProperties object itself.
     */
    public AseV3NetworkingConfigurationProperties withFtpEnabled(Boolean ftpEnabled) {
        this.ftpEnabled = ftpEnabled;
        return this;
    }

    /**
     * Get the remoteDebugEnabled property: Property to enable and disable Remote Debug on ASEV3.
     *
     * @return the remoteDebugEnabled value.
     */
    public Boolean remoteDebugEnabled() {
        return this.remoteDebugEnabled;
    }

    /**
     * Set the remoteDebugEnabled property: Property to enable and disable Remote Debug on ASEV3.
     *
     * @param remoteDebugEnabled the remoteDebugEnabled value to set.
     * @return the AseV3NetworkingConfigurationProperties object itself.
     */
    public AseV3NetworkingConfigurationProperties withRemoteDebugEnabled(Boolean remoteDebugEnabled) {
        this.remoteDebugEnabled = remoteDebugEnabled;
        return this;
    }

    /**
     * Get the inboundIpAddressOverride property: Customer provided Inbound IP Address. Only able to be set on Ase
     * create.
     *
     * @return the inboundIpAddressOverride value.
     */
    public String inboundIpAddressOverride() {
        return this.inboundIpAddressOverride;
    }

    /**
     * Set the inboundIpAddressOverride property: Customer provided Inbound IP Address. Only able to be set on Ase
     * create.
     *
     * @param inboundIpAddressOverride the inboundIpAddressOverride value to set.
     * @return the AseV3NetworkingConfigurationProperties object itself.
     */
    public AseV3NetworkingConfigurationProperties withInboundIpAddressOverride(String inboundIpAddressOverride) {
        this.inboundIpAddressOverride = inboundIpAddressOverride;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
