// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appservice.fluent.models.AnalysisDefinitionInner;
import com.azure.resourcemanager.appservice.fluent.models.DetectorDefinitionResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.DetectorResponseInner;
import com.azure.resourcemanager.appservice.fluent.models.DiagnosticAnalysisInner;
import com.azure.resourcemanager.appservice.fluent.models.DiagnosticCategoryInner;
import com.azure.resourcemanager.appservice.fluent.models.DiagnosticDetectorResponseInner;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DiagnosticsClient. */
public interface DiagnosticsClient {
    /**
     * Description for List Hosting Environment Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DetectorResponseInner> listHostingEnvironmentDetectorResponsesAsync(
        String resourceGroupName, String name);

    /**
     * Description for List Hosting Environment Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DetectorResponseInner> listHostingEnvironmentDetectorResponses(String resourceGroupName, String name);

    /**
     * Description for List Hosting Environment Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DetectorResponseInner> listHostingEnvironmentDetectorResponses(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Get Hosting Environment Detector Response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name App Service Environment Name.
     * @param detectorName Detector Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DetectorResponseInner>> getHostingEnvironmentDetectorResponseWithResponseAsync(
        String resourceGroupName,
        String name,
        String detectorName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain);

    /**
     * Description for Get Hosting Environment Detector Response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name App Service Environment Name.
     * @param detectorName Detector Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DetectorResponseInner> getHostingEnvironmentDetectorResponseAsync(
        String resourceGroupName,
        String name,
        String detectorName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain);

    /**
     * Description for Get Hosting Environment Detector Response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name App Service Environment Name.
     * @param detectorName Detector Resource Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DetectorResponseInner> getHostingEnvironmentDetectorResponseAsync(
        String resourceGroupName, String name, String detectorName);

    /**
     * Description for Get Hosting Environment Detector Response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name App Service Environment Name.
     * @param detectorName Detector Resource Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DetectorResponseInner getHostingEnvironmentDetectorResponse(
        String resourceGroupName, String name, String detectorName);

    /**
     * Description for Get Hosting Environment Detector Response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name App Service Environment Name.
     * @param detectorName Detector Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DetectorResponseInner> getHostingEnvironmentDetectorResponseWithResponse(
        String resourceGroupName,
        String name,
        String detectorName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context);

    /**
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DetectorResponseInner> listSiteDetectorResponsesAsync(String resourceGroupName, String siteName);

    /**
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DetectorResponseInner> listSiteDetectorResponses(String resourceGroupName, String siteName);

    /**
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DetectorResponseInner> listSiteDetectorResponses(
        String resourceGroupName, String siteName, Context context);

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DetectorResponseInner>> getSiteDetectorResponseWithResponseAsync(
        String resourceGroupName,
        String siteName,
        String detectorName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain);

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DetectorResponseInner> getSiteDetectorResponseAsync(
        String resourceGroupName,
        String siteName,
        String detectorName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain);

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DetectorResponseInner> getSiteDetectorResponseAsync(
        String resourceGroupName, String siteName, String detectorName);

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DetectorResponseInner getSiteDetectorResponse(String resourceGroupName, String siteName, String detectorName);

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DetectorResponseInner> getSiteDetectorResponseWithResponse(
        String resourceGroupName,
        String siteName,
        String detectorName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context);

    /**
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DiagnosticCategoryInner> listSiteDiagnosticCategoriesAsync(String resourceGroupName, String siteName);

    /**
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DiagnosticCategoryInner> listSiteDiagnosticCategories(String resourceGroupName, String siteName);

    /**
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DiagnosticCategoryInner> listSiteDiagnosticCategories(
        String resourceGroupName, String siteName, Context context);

    /**
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing detector definition along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DiagnosticCategoryInner>> getSiteDiagnosticCategoryWithResponseAsync(
        String resourceGroupName, String siteName, String diagnosticCategory);

    /**
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing detector definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DiagnosticCategoryInner> getSiteDiagnosticCategoryAsync(
        String resourceGroupName, String siteName, String diagnosticCategory);

    /**
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing detector definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DiagnosticCategoryInner getSiteDiagnosticCategory(
        String resourceGroupName, String siteName, String diagnosticCategory);

    /**
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing detector definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DiagnosticCategoryInner> getSiteDiagnosticCategoryWithResponse(
        String resourceGroupName, String siteName, String diagnosticCategory, Context context);

    /**
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<AnalysisDefinitionInner> listSiteAnalysesAsync(
        String resourceGroupName, String siteName, String diagnosticCategory);

    /**
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AnalysisDefinitionInner> listSiteAnalyses(
        String resourceGroupName, String siteName, String diagnosticCategory);

    /**
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AnalysisDefinitionInner> listSiteAnalyses(
        String resourceGroupName, String siteName, String diagnosticCategory, Context context);

    /**
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param analysisName Analysis Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of Analysis along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<AnalysisDefinitionInner>> getSiteAnalysisWithResponseAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName);

    /**
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param analysisName Analysis Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of Analysis on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AnalysisDefinitionInner> getSiteAnalysisAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName);

    /**
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param analysisName Analysis Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of Analysis.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AnalysisDefinitionInner getSiteAnalysis(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName);

    /**
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param analysisName Analysis Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of Analysis along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<AnalysisDefinitionInner> getSiteAnalysisWithResponse(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, Context context);

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DiagnosticAnalysisInner>> executeSiteAnalysisWithResponseAsync(
        String resourceGroupName,
        String siteName,
        String diagnosticCategory,
        String analysisName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain);

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DiagnosticAnalysisInner> executeSiteAnalysisAsync(
        String resourceGroupName,
        String siteName,
        String diagnosticCategory,
        String analysisName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain);

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DiagnosticAnalysisInner> executeSiteAnalysisAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName);

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DiagnosticAnalysisInner executeSiteAnalysis(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName);

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DiagnosticAnalysisInner> executeSiteAnalysisWithResponse(
        String resourceGroupName,
        String siteName,
        String diagnosticCategory,
        String analysisName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context);

    /**
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DetectorDefinitionResourceInner> listSiteDetectorsAsync(
        String resourceGroupName, String siteName, String diagnosticCategory);

    /**
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DetectorDefinitionResourceInner> listSiteDetectors(
        String resourceGroupName, String siteName, String diagnosticCategory);

    /**
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DetectorDefinitionResourceInner> listSiteDetectors(
        String resourceGroupName, String siteName, String diagnosticCategory, Context context);

    /**
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param detectorName Detector Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aRM resource for a detector definition along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DetectorDefinitionResourceInner>> getSiteDetectorWithResponseAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String detectorName);

    /**
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param detectorName Detector Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aRM resource for a detector definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DetectorDefinitionResourceInner> getSiteDetectorAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String detectorName);

    /**
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param detectorName Detector Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aRM resource for a detector definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DetectorDefinitionResourceInner getSiteDetector(
        String resourceGroupName, String siteName, String diagnosticCategory, String detectorName);

    /**
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param detectorName Detector Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aRM resource for a detector definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DetectorDefinitionResourceInner> getSiteDetectorWithResponse(
        String resourceGroupName, String siteName, String diagnosticCategory, String detectorName, Context context);

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DiagnosticDetectorResponseInner>> executeSiteDetectorWithResponseAsync(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String diagnosticCategory,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain);

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DiagnosticDetectorResponseInner> executeSiteDetectorAsync(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String diagnosticCategory,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain);

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DiagnosticDetectorResponseInner> executeSiteDetectorAsync(
        String resourceGroupName, String siteName, String detectorName, String diagnosticCategory);

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DiagnosticDetectorResponseInner executeSiteDetector(
        String resourceGroupName, String siteName, String detectorName, String diagnosticCategory);

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DiagnosticDetectorResponseInner> executeSiteDetectorWithResponse(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String diagnosticCategory,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context);

    /**
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DetectorResponseInner> listSiteDetectorResponsesSlotAsync(
        String resourceGroupName, String siteName, String slot);

    /**
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DetectorResponseInner> listSiteDetectorResponsesSlot(
        String resourceGroupName, String siteName, String slot);

    /**
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DetectorResponseInner> listSiteDetectorResponsesSlot(
        String resourceGroupName, String siteName, String slot, Context context);

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DetectorResponseInner>> getSiteDetectorResponseSlotWithResponseAsync(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain);

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DetectorResponseInner> getSiteDetectorResponseSlotAsync(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain);

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DetectorResponseInner> getSiteDetectorResponseSlotAsync(
        String resourceGroupName, String siteName, String detectorName, String slot);

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DetectorResponseInner getSiteDetectorResponseSlot(
        String resourceGroupName, String siteName, String detectorName, String slot);

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DetectorResponseInner> getSiteDetectorResponseSlotWithResponse(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context);

    /**
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DiagnosticCategoryInner> listSiteDiagnosticCategoriesSlotAsync(
        String resourceGroupName, String siteName, String slot);

    /**
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DiagnosticCategoryInner> listSiteDiagnosticCategoriesSlot(
        String resourceGroupName, String siteName, String slot);

    /**
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DiagnosticCategoryInner> listSiteDiagnosticCategoriesSlot(
        String resourceGroupName, String siteName, String slot, Context context);

    /**
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing detector definition along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DiagnosticCategoryInner>> getSiteDiagnosticCategorySlotWithResponseAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot);

    /**
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing detector definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DiagnosticCategoryInner> getSiteDiagnosticCategorySlotAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot);

    /**
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing detector definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DiagnosticCategoryInner getSiteDiagnosticCategorySlot(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot);

    /**
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing detector definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DiagnosticCategoryInner> getSiteDiagnosticCategorySlotWithResponse(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot, Context context);

    /**
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<AnalysisDefinitionInner> listSiteAnalysesSlotAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot);

    /**
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AnalysisDefinitionInner> listSiteAnalysesSlot(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot);

    /**
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AnalysisDefinitionInner> listSiteAnalysesSlot(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot, Context context);

    /**
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param analysisName Analysis Name.
     * @param slot Slot - optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of Analysis along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<AnalysisDefinitionInner>> getSiteAnalysisSlotWithResponseAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot);

    /**
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param analysisName Analysis Name.
     * @param slot Slot - optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of Analysis on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AnalysisDefinitionInner> getSiteAnalysisSlotAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot);

    /**
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param analysisName Analysis Name.
     * @param slot Slot - optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of Analysis.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AnalysisDefinitionInner getSiteAnalysisSlot(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot);

    /**
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param analysisName Analysis Name.
     * @param slot Slot - optional.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of Analysis along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<AnalysisDefinitionInner> getSiteAnalysisSlotWithResponse(
        String resourceGroupName,
        String siteName,
        String diagnosticCategory,
        String analysisName,
        String slot,
        Context context);

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DiagnosticAnalysisInner>> executeSiteAnalysisSlotWithResponseAsync(
        String resourceGroupName,
        String siteName,
        String diagnosticCategory,
        String analysisName,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain);

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DiagnosticAnalysisInner> executeSiteAnalysisSlotAsync(
        String resourceGroupName,
        String siteName,
        String diagnosticCategory,
        String analysisName,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain);

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DiagnosticAnalysisInner> executeSiteAnalysisSlotAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot);

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DiagnosticAnalysisInner executeSiteAnalysisSlot(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot);

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DiagnosticAnalysisInner> executeSiteAnalysisSlotWithResponse(
        String resourceGroupName,
        String siteName,
        String diagnosticCategory,
        String analysisName,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context);

    /**
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DetectorDefinitionResourceInner> listSiteDetectorsSlotAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot);

    /**
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DetectorDefinitionResourceInner> listSiteDetectorsSlot(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot);

    /**
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DetectorDefinitionResourceInner> listSiteDetectorsSlot(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot, Context context);

    /**
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param detectorName Detector Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aRM resource for a detector definition along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DetectorDefinitionResourceInner>> getSiteDetectorSlotWithResponseAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String detectorName, String slot);

    /**
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param detectorName Detector Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aRM resource for a detector definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DetectorDefinitionResourceInner> getSiteDetectorSlotAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String detectorName, String slot);

    /**
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param detectorName Detector Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aRM resource for a detector definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DetectorDefinitionResourceInner getSiteDetectorSlot(
        String resourceGroupName, String siteName, String diagnosticCategory, String detectorName, String slot);

    /**
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param detectorName Detector Name.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aRM resource for a detector definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DetectorDefinitionResourceInner> getSiteDetectorSlotWithResponse(
        String resourceGroupName,
        String siteName,
        String diagnosticCategory,
        String detectorName,
        String slot,
        Context context);

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DiagnosticDetectorResponseInner>> executeSiteDetectorSlotWithResponseAsync(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String diagnosticCategory,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain);

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DiagnosticDetectorResponseInner> executeSiteDetectorSlotAsync(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String diagnosticCategory,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain);

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DiagnosticDetectorResponseInner> executeSiteDetectorSlotAsync(
        String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, String slot);

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DiagnosticDetectorResponseInner executeSiteDetectorSlot(
        String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, String slot);

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DiagnosticDetectorResponseInner> executeSiteDetectorSlotWithResponse(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String diagnosticCategory,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context);
}
