// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Container App container scaling rule. */
@Fluent
public final class ScaleRule {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ScaleRule.class);

    /*
     * Scale Rule Name
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Azure Queue based scaling.
     */
    @JsonProperty(value = "azureQueue")
    private QueueScaleRule azureQueue;

    /*
     * Custom scale rule.
     */
    @JsonProperty(value = "custom")
    private CustomScaleRule custom;

    /*
     * HTTP requests based scaling.
     */
    @JsonProperty(value = "http")
    private HttpScaleRule http;

    /**
     * Get the name property: Scale Rule Name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Scale Rule Name.
     *
     * @param name the name value to set.
     * @return the ScaleRule object itself.
     */
    public ScaleRule withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the azureQueue property: Azure Queue based scaling.
     *
     * @return the azureQueue value.
     */
    public QueueScaleRule azureQueue() {
        return this.azureQueue;
    }

    /**
     * Set the azureQueue property: Azure Queue based scaling.
     *
     * @param azureQueue the azureQueue value to set.
     * @return the ScaleRule object itself.
     */
    public ScaleRule withAzureQueue(QueueScaleRule azureQueue) {
        this.azureQueue = azureQueue;
        return this;
    }

    /**
     * Get the custom property: Custom scale rule.
     *
     * @return the custom value.
     */
    public CustomScaleRule custom() {
        return this.custom;
    }

    /**
     * Set the custom property: Custom scale rule.
     *
     * @param custom the custom value to set.
     * @return the ScaleRule object itself.
     */
    public ScaleRule withCustom(CustomScaleRule custom) {
        this.custom = custom;
        return this;
    }

    /**
     * Get the http property: HTTP requests based scaling.
     *
     * @return the http value.
     */
    public HttpScaleRule http() {
        return this.http;
    }

    /**
     * Set the http property: HTTP requests based scaling.
     *
     * @param http the http value to set.
     * @return the ScaleRule object itself.
     */
    public ScaleRule withHttp(HttpScaleRule http) {
        this.http = http;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (azureQueue() != null) {
            azureQueue().validate();
        }
        if (custom() != null) {
            custom().validate();
        }
        if (http() != null) {
            http().validate();
        }
    }
}
