// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for IngressTransportMethod. */
public final class IngressTransportMethod extends ExpandableStringEnum<IngressTransportMethod> {
    /** Static value auto for IngressTransportMethod. */
    public static final IngressTransportMethod AUTO = fromString("auto");

    /** Static value http for IngressTransportMethod. */
    public static final IngressTransportMethod HTTP = fromString("http");

    /** Static value http2 for IngressTransportMethod. */
    public static final IngressTransportMethod HTTP2 = fromString("http2");

    /**
     * Creates or finds a IngressTransportMethod from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding IngressTransportMethod.
     */
    @JsonCreator
    public static IngressTransportMethod fromString(String name) {
        return fromString(name, IngressTransportMethod.class);
    }

    /** @return known IngressTransportMethod values. */
    public static Collection<IngressTransportMethod> values() {
        return values(IngressTransportMethod.class);
    }
}
