// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** GitHub Actions Web App stack settings. */
@Immutable
public final class GitHubActionWebAppStackSettings {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(GitHubActionWebAppStackSettings.class);

    /*
     * <code>true</code> if GitHub Actions is supported for the stack;
     * otherwise, <code>false</code>.
     */
    @JsonProperty(value = "isSupported", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isSupported;

    /*
     * The minor version that is supported for GitHub Actions.
     */
    @JsonProperty(value = "supportedVersion", access = JsonProperty.Access.WRITE_ONLY)
    private String supportedVersion;

    /**
     * Get the isSupported property: &lt;code&gt;true&lt;/code&gt; if GitHub Actions is supported for the stack;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the isSupported value.
     */
    public Boolean isSupported() {
        return this.isSupported;
    }

    /**
     * Get the supportedVersion property: The minor version that is supported for GitHub Actions.
     *
     * @return the supportedVersion value.
     */
    public String supportedVersion() {
        return this.supportedVersion;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
