// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Container App container environment variable. */
@Fluent
public final class EnvironmentVar {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(EnvironmentVar.class);

    /*
     * Environment variable name.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Non-secret environment variable value.
     */
    @JsonProperty(value = "value")
    private String value;

    /*
     * Name of the Container App secret from which to pull the environment
     * variable value.
     */
    @JsonProperty(value = "secretRef")
    private String secretRef;

    /**
     * Get the name property: Environment variable name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Environment variable name.
     *
     * @param name the name value to set.
     * @return the EnvironmentVar object itself.
     */
    public EnvironmentVar withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: Non-secret environment variable value.
     *
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Non-secret environment variable value.
     *
     * @param value the value value to set.
     * @return the EnvironmentVar object itself.
     */
    public EnvironmentVar withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the secretRef property: Name of the Container App secret from which to pull the environment variable value.
     *
     * @return the secretRef value.
     */
    public String secretRef() {
        return this.secretRef;
    }

    /**
     * Set the secretRef property: Name of the Container App secret from which to pull the environment variable value.
     *
     * @param secretRef the secretRef value to set.
     * @return the EnvironmentVar object itself.
     */
    public EnvironmentVar withSecretRef(String secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
