// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.fluent.models.DomainPatchResourceProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** ARM resource for a domain. */
@Fluent
public final class DomainPatchResource extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DomainPatchResource.class);

    /*
     * DomainPatchResource resource specific properties
     */
    @JsonProperty(value = "properties")
    private DomainPatchResourceProperties innerProperties;

    /**
     * Get the innerProperties property: DomainPatchResource resource specific properties.
     *
     * @return the innerProperties value.
     */
    private DomainPatchResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public DomainPatchResource withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the contactAdmin property: Administrative contact.
     *
     * @return the contactAdmin value.
     */
    public Contact contactAdmin() {
        return this.innerProperties() == null ? null : this.innerProperties().contactAdmin();
    }

    /**
     * Set the contactAdmin property: Administrative contact.
     *
     * @param contactAdmin the contactAdmin value to set.
     * @return the DomainPatchResource object itself.
     */
    public DomainPatchResource withContactAdmin(Contact contactAdmin) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withContactAdmin(contactAdmin);
        return this;
    }

    /**
     * Get the contactBilling property: Billing contact.
     *
     * @return the contactBilling value.
     */
    public Contact contactBilling() {
        return this.innerProperties() == null ? null : this.innerProperties().contactBilling();
    }

    /**
     * Set the contactBilling property: Billing contact.
     *
     * @param contactBilling the contactBilling value to set.
     * @return the DomainPatchResource object itself.
     */
    public DomainPatchResource withContactBilling(Contact contactBilling) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withContactBilling(contactBilling);
        return this;
    }

    /**
     * Get the contactRegistrant property: Registrant contact.
     *
     * @return the contactRegistrant value.
     */
    public Contact contactRegistrant() {
        return this.innerProperties() == null ? null : this.innerProperties().contactRegistrant();
    }

    /**
     * Set the contactRegistrant property: Registrant contact.
     *
     * @param contactRegistrant the contactRegistrant value to set.
     * @return the DomainPatchResource object itself.
     */
    public DomainPatchResource withContactRegistrant(Contact contactRegistrant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withContactRegistrant(contactRegistrant);
        return this;
    }

    /**
     * Get the contactTech property: Technical contact.
     *
     * @return the contactTech value.
     */
    public Contact contactTech() {
        return this.innerProperties() == null ? null : this.innerProperties().contactTech();
    }

    /**
     * Set the contactTech property: Technical contact.
     *
     * @param contactTech the contactTech value to set.
     * @return the DomainPatchResource object itself.
     */
    public DomainPatchResource withContactTech(Contact contactTech) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withContactTech(contactTech);
        return this;
    }

    /**
     * Get the registrationStatus property: Domain registration status.
     *
     * @return the registrationStatus value.
     */
    public DomainStatus registrationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().registrationStatus();
    }

    /**
     * Get the provisioningState property: Domain provisioning state.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the nameServers property: Name servers.
     *
     * @return the nameServers value.
     */
    public List<String> nameServers() {
        return this.innerProperties() == null ? null : this.innerProperties().nameServers();
    }

    /**
     * Get the privacy property: &lt;code&gt;true&lt;/code&gt; if domain privacy is enabled for this domain; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the privacy value.
     */
    public Boolean privacy() {
        return this.innerProperties() == null ? null : this.innerProperties().privacy();
    }

    /**
     * Set the privacy property: &lt;code&gt;true&lt;/code&gt; if domain privacy is enabled for this domain; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @param privacy the privacy value to set.
     * @return the DomainPatchResource object itself.
     */
    public DomainPatchResource withPrivacy(Boolean privacy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withPrivacy(privacy);
        return this;
    }

    /**
     * Get the createdTime property: Domain creation timestamp.
     *
     * @return the createdTime value.
     */
    public OffsetDateTime createdTime() {
        return this.innerProperties() == null ? null : this.innerProperties().createdTime();
    }

    /**
     * Get the expirationTime property: Domain expiration timestamp.
     *
     * @return the expirationTime value.
     */
    public OffsetDateTime expirationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().expirationTime();
    }

    /**
     * Get the lastRenewedTime property: Timestamp when the domain was renewed last time.
     *
     * @return the lastRenewedTime value.
     */
    public OffsetDateTime lastRenewedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastRenewedTime();
    }

    /**
     * Get the autoRenew property: &lt;code&gt;true&lt;/code&gt; if the domain should be automatically renewed;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the autoRenew value.
     */
    public Boolean autoRenew() {
        return this.innerProperties() == null ? null : this.innerProperties().autoRenew();
    }

    /**
     * Set the autoRenew property: &lt;code&gt;true&lt;/code&gt; if the domain should be automatically renewed;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     *
     * @param autoRenew the autoRenew value to set.
     * @return the DomainPatchResource object itself.
     */
    public DomainPatchResource withAutoRenew(Boolean autoRenew) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withAutoRenew(autoRenew);
        return this;
    }

    /**
     * Get the readyForDnsRecordManagement property: &lt;code&gt;true&lt;/code&gt; if Azure can assign this domain to
     * App Service apps; otherwise, &lt;code&gt;false&lt;/code&gt;. This value will be &lt;code&gt;true&lt;/code&gt; if
     * domain registration status is active and it is hosted on name servers Azure has programmatic access to.
     *
     * @return the readyForDnsRecordManagement value.
     */
    public Boolean readyForDnsRecordManagement() {
        return this.innerProperties() == null ? null : this.innerProperties().readyForDnsRecordManagement();
    }

    /**
     * Get the managedHostNames property: All hostnames derived from the domain and assigned to Azure resources.
     *
     * @return the managedHostNames value.
     */
    public List<Hostname> managedHostNames() {
        return this.innerProperties() == null ? null : this.innerProperties().managedHostNames();
    }

    /**
     * Get the consent property: Legal agreement consent.
     *
     * @return the consent value.
     */
    public DomainPurchaseConsent consent() {
        return this.innerProperties() == null ? null : this.innerProperties().consent();
    }

    /**
     * Set the consent property: Legal agreement consent.
     *
     * @param consent the consent value to set.
     * @return the DomainPatchResource object itself.
     */
    public DomainPatchResource withConsent(DomainPurchaseConsent consent) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withConsent(consent);
        return this;
    }

    /**
     * Get the domainNotRenewableReasons property: Reasons why domain is not renewable.
     *
     * @return the domainNotRenewableReasons value.
     */
    public List<DomainPatchResourcePropertiesDomainNotRenewableReasonsItem> domainNotRenewableReasons() {
        return this.innerProperties() == null ? null : this.innerProperties().domainNotRenewableReasons();
    }

    /**
     * Get the dnsType property: Current DNS type.
     *
     * @return the dnsType value.
     */
    public DnsType dnsType() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsType();
    }

    /**
     * Set the dnsType property: Current DNS type.
     *
     * @param dnsType the dnsType value to set.
     * @return the DomainPatchResource object itself.
     */
    public DomainPatchResource withDnsType(DnsType dnsType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withDnsType(dnsType);
        return this;
    }

    /**
     * Get the dnsZoneId property: Azure DNS Zone to use.
     *
     * @return the dnsZoneId value.
     */
    public String dnsZoneId() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsZoneId();
    }

    /**
     * Set the dnsZoneId property: Azure DNS Zone to use.
     *
     * @param dnsZoneId the dnsZoneId value to set.
     * @return the DomainPatchResource object itself.
     */
    public DomainPatchResource withDnsZoneId(String dnsZoneId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withDnsZoneId(dnsZoneId);
        return this;
    }

    /**
     * Get the targetDnsType property: Target DNS type (would be used for migration).
     *
     * @return the targetDnsType value.
     */
    public DnsType targetDnsType() {
        return this.innerProperties() == null ? null : this.innerProperties().targetDnsType();
    }

    /**
     * Set the targetDnsType property: Target DNS type (would be used for migration).
     *
     * @param targetDnsType the targetDnsType value to set.
     * @return the DomainPatchResource object itself.
     */
    public DomainPatchResource withTargetDnsType(DnsType targetDnsType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withTargetDnsType(targetDnsType);
        return this;
    }

    /**
     * Get the authCode property: The authCode property.
     *
     * @return the authCode value.
     */
    public String authCode() {
        return this.innerProperties() == null ? null : this.innerProperties().authCode();
    }

    /**
     * Set the authCode property: The authCode property.
     *
     * @param authCode the authCode value to set.
     * @return the DomainPatchResource object itself.
     */
    public DomainPatchResource withAuthCode(String authCode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withAuthCode(authCode);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
