// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Rules that can be defined for auto-heal. */
@Fluent
public final class AutoHealRules {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(AutoHealRules.class);

    /*
     * Conditions that describe when to execute the auto-heal actions.
     */
    @JsonProperty(value = "triggers")
    private AutoHealTriggers triggers;

    /*
     * Actions to be executed when a rule is triggered.
     */
    @JsonProperty(value = "actions")
    private AutoHealActions actions;

    /**
     * Get the triggers property: Conditions that describe when to execute the auto-heal actions.
     *
     * @return the triggers value.
     */
    public AutoHealTriggers triggers() {
        return this.triggers;
    }

    /**
     * Set the triggers property: Conditions that describe when to execute the auto-heal actions.
     *
     * @param triggers the triggers value to set.
     * @return the AutoHealRules object itself.
     */
    public AutoHealRules withTriggers(AutoHealTriggers triggers) {
        this.triggers = triggers;
        return this;
    }

    /**
     * Get the actions property: Actions to be executed when a rule is triggered.
     *
     * @return the actions value.
     */
    public AutoHealActions actions() {
        return this.actions;
    }

    /**
     * Set the actions property: Actions to be executed when a rule is triggered.
     *
     * @param actions the actions value to set.
     * @return the AutoHealRules object itself.
     */
    public AutoHealRules withActions(AutoHealActions actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (triggers() != null) {
            triggers().validate();
        }
        if (actions() != null) {
            actions().validate();
        }
    }
}
