// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Azure API management (APIM) configuration linked to the app. */
@Fluent
public final class ApiManagementConfig {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ApiManagementConfig.class);

    /*
     * APIM-Api Identifier.
     */
    @JsonProperty(value = "id")
    private String id;

    /**
     * Get the id property: APIM-Api Identifier.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: APIM-Api Identifier.
     *
     * @param id the id value to set.
     * @return the ApiManagementConfig object itself.
     */
    public ApiManagementConfig withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
