// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Functions host level keys. */
@Fluent
public final class HostKeysInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(HostKeysInner.class);

    /*
     * Secret key.
     */
    @JsonProperty(value = "masterKey")
    private String masterKey;

    /*
     * Host level function keys.
     */
    @JsonProperty(value = "functionKeys")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> functionKeys;

    /*
     * System keys.
     */
    @JsonProperty(value = "systemKeys")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> systemKeys;

    /**
     * Get the masterKey property: Secret key.
     *
     * @return the masterKey value.
     */
    public String masterKey() {
        return this.masterKey;
    }

    /**
     * Set the masterKey property: Secret key.
     *
     * @param masterKey the masterKey value to set.
     * @return the HostKeysInner object itself.
     */
    public HostKeysInner withMasterKey(String masterKey) {
        this.masterKey = masterKey;
        return this;
    }

    /**
     * Get the functionKeys property: Host level function keys.
     *
     * @return the functionKeys value.
     */
    public Map<String, String> functionKeys() {
        return this.functionKeys;
    }

    /**
     * Set the functionKeys property: Host level function keys.
     *
     * @param functionKeys the functionKeys value to set.
     * @return the HostKeysInner object itself.
     */
    public HostKeysInner withFunctionKeys(Map<String, String> functionKeys) {
        this.functionKeys = functionKeys;
        return this;
    }

    /**
     * Get the systemKeys property: System keys.
     *
     * @return the systemKeys value.
     */
    public Map<String, String> systemKeys() {
        return this.systemKeys;
    }

    /**
     * Set the systemKeys property: System keys.
     *
     * @param systemKeys the systemKeys value to set.
     * @return the HostKeysInner object itself.
     */
    public HostKeysInner withSystemKeys(Map<String, String> systemKeys) {
        this.systemKeys = systemKeys;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
