// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * storage resource of type Azure Storage Account.
 */
@Fluent
public final class StorageAccount extends StorageProperties {
    /*
     * The type of the storage.
     */
    private StorageType storageType = StorageType.STORAGE_ACCOUNT;

    /*
     * The account name of the Azure Storage Account.
     */
    private String accountName;

    /*
     * The account key of the Azure Storage Account.
     */
    private String accountKey;

    /**
     * Creates an instance of StorageAccount class.
     */
    public StorageAccount() {
    }

    /**
     * Get the storageType property: The type of the storage.
     * 
     * @return the storageType value.
     */
    @Override
    public StorageType storageType() {
        return this.storageType;
    }

    /**
     * Get the accountName property: The account name of the Azure Storage Account.
     * 
     * @return the accountName value.
     */
    public String accountName() {
        return this.accountName;
    }

    /**
     * Set the accountName property: The account name of the Azure Storage Account.
     * 
     * @param accountName the accountName value to set.
     * @return the StorageAccount object itself.
     */
    public StorageAccount withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    /**
     * Get the accountKey property: The account key of the Azure Storage Account.
     * 
     * @return the accountKey value.
     */
    public String accountKey() {
        return this.accountKey;
    }

    /**
     * Set the accountKey property: The account key of the Azure Storage Account.
     * 
     * @param accountKey the accountKey value to set.
     * @return the StorageAccount object itself.
     */
    public StorageAccount withAccountKey(String accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (accountName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property accountName in model StorageAccount"));
        }
        if (accountKey() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property accountKey in model StorageAccount"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(StorageAccount.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("accountName", this.accountName);
        jsonWriter.writeStringField("accountKey", this.accountKey);
        jsonWriter.writeStringField("storageType", this.storageType == null ? null : this.storageType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageAccount from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageAccount if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StorageAccount.
     */
    public static StorageAccount fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageAccount deserializedStorageAccount = new StorageAccount();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("accountName".equals(fieldName)) {
                    deserializedStorageAccount.accountName = reader.getString();
                } else if ("accountKey".equals(fieldName)) {
                    deserializedStorageAccount.accountKey = reader.getString();
                } else if ("storageType".equals(fieldName)) {
                    deserializedStorageAccount.storageType = StorageType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageAccount;
        });
    }
}
