// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Predefined accelerator properties payload.
 */
@Fluent
public final class PredefinedAcceleratorProperties implements JsonSerializable<PredefinedAcceleratorProperties> {
    /*
     * Provisioning state of the predefined accelerator.
     */
    private PredefinedAcceleratorProvisioningState provisioningState;

    /*
     * The displayName property.
     */
    private String displayName;

    /*
     * The description property.
     */
    private String description;

    /*
     * The iconUrl property.
     */
    private String iconUrl;

    /*
     * The acceleratorTags property.
     */
    private List<String> acceleratorTags;

    /*
     * State of the predefined accelerator.
     */
    private PredefinedAcceleratorState state;

    /**
     * Creates an instance of PredefinedAcceleratorProperties class.
     */
    public PredefinedAcceleratorProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of the predefined accelerator.
     * 
     * @return the provisioningState value.
     */
    public PredefinedAcceleratorProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the displayName property: The displayName property.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Get the description property: The description property.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the iconUrl property: The iconUrl property.
     * 
     * @return the iconUrl value.
     */
    public String iconUrl() {
        return this.iconUrl;
    }

    /**
     * Get the acceleratorTags property: The acceleratorTags property.
     * 
     * @return the acceleratorTags value.
     */
    public List<String> acceleratorTags() {
        return this.acceleratorTags;
    }

    /**
     * Get the state property: State of the predefined accelerator.
     * 
     * @return the state value.
     */
    public PredefinedAcceleratorState state() {
        return this.state;
    }

    /**
     * Set the state property: State of the predefined accelerator.
     * 
     * @param state the state value to set.
     * @return the PredefinedAcceleratorProperties object itself.
     */
    public PredefinedAcceleratorProperties withState(PredefinedAcceleratorState state) {
        this.state = state;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PredefinedAcceleratorProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PredefinedAcceleratorProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PredefinedAcceleratorProperties.
     */
    public static PredefinedAcceleratorProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PredefinedAcceleratorProperties deserializedPredefinedAcceleratorProperties
                = new PredefinedAcceleratorProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedPredefinedAcceleratorProperties.provisioningState
                        = PredefinedAcceleratorProvisioningState.fromString(reader.getString());
                } else if ("displayName".equals(fieldName)) {
                    deserializedPredefinedAcceleratorProperties.displayName = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedPredefinedAcceleratorProperties.description = reader.getString();
                } else if ("iconUrl".equals(fieldName)) {
                    deserializedPredefinedAcceleratorProperties.iconUrl = reader.getString();
                } else if ("acceleratorTags".equals(fieldName)) {
                    List<String> acceleratorTags = reader.readArray(reader1 -> reader1.getString());
                    deserializedPredefinedAcceleratorProperties.acceleratorTags = acceleratorTags;
                } else if ("state".equals(fieldName)) {
                    deserializedPredefinedAcceleratorProperties.state
                        = PredefinedAcceleratorState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPredefinedAcceleratorProperties;
        });
    }
}
