// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifications of the Dimension of metrics.
 */
@Fluent
public final class MetricDimension implements JsonSerializable<MetricDimension> {
    /*
     * Name of the dimension
     */
    private String name;

    /*
     * Localized friendly display name of the dimension
     */
    private String displayName;

    /*
     * Whether this dimension should be included for the Shoebox export scenario
     */
    private Boolean toBeExportedForShoebox;

    /**
     * Creates an instance of MetricDimension class.
     */
    public MetricDimension() {
    }

    /**
     * Get the name property: Name of the dimension.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the dimension.
     * 
     * @param name the name value to set.
     * @return the MetricDimension object itself.
     */
    public MetricDimension withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the displayName property: Localized friendly display name of the dimension.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Localized friendly display name of the dimension.
     * 
     * @param displayName the displayName value to set.
     * @return the MetricDimension object itself.
     */
    public MetricDimension withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the toBeExportedForShoebox property: Whether this dimension should be included for the Shoebox export
     * scenario.
     * 
     * @return the toBeExportedForShoebox value.
     */
    public Boolean toBeExportedForShoebox() {
        return this.toBeExportedForShoebox;
    }

    /**
     * Set the toBeExportedForShoebox property: Whether this dimension should be included for the Shoebox export
     * scenario.
     * 
     * @param toBeExportedForShoebox the toBeExportedForShoebox value to set.
     * @return the MetricDimension object itself.
     */
    public MetricDimension withToBeExportedForShoebox(Boolean toBeExportedForShoebox) {
        this.toBeExportedForShoebox = toBeExportedForShoebox;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeBooleanField("toBeExportedForShoebox", this.toBeExportedForShoebox);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetricDimension from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetricDimension if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MetricDimension.
     */
    public static MetricDimension fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricDimension deserializedMetricDimension = new MetricDimension();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedMetricDimension.name = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedMetricDimension.displayName = reader.getString();
                } else if ("toBeExportedForShoebox".equals(fieldName)) {
                    deserializedMetricDimension.toBeExportedForShoebox = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetricDimension;
        });
    }
}
