// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * OpenAPI properties of Spring Cloud Gateway route config.
 */
@Fluent
public final class GatewayRouteConfigOpenApiProperties
    implements JsonSerializable<GatewayRouteConfigOpenApiProperties> {
    /*
     * The URI of OpenAPI specification.
     */
    private String uri;

    /**
     * Creates an instance of GatewayRouteConfigOpenApiProperties class.
     */
    public GatewayRouteConfigOpenApiProperties() {
    }

    /**
     * Get the uri property: The URI of OpenAPI specification.
     * 
     * @return the uri value.
     */
    public String uri() {
        return this.uri;
    }

    /**
     * Set the uri property: The URI of OpenAPI specification.
     * 
     * @param uri the uri value to set.
     * @return the GatewayRouteConfigOpenApiProperties object itself.
     */
    public GatewayRouteConfigOpenApiProperties withUri(String uri) {
        this.uri = uri;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("uri", this.uri);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayRouteConfigOpenApiProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayRouteConfigOpenApiProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GatewayRouteConfigOpenApiProperties.
     */
    public static GatewayRouteConfigOpenApiProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayRouteConfigOpenApiProperties deserializedGatewayRouteConfigOpenApiProperties
                = new GatewayRouteConfigOpenApiProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("uri".equals(fieldName)) {
                    deserializedGatewayRouteConfigOpenApiProperties.uri = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayRouteConfigOpenApiProperties;
        });
    }
}
