// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Cross-Origin Resource Sharing property.
 */
@Fluent
public final class GatewayCorsProperties implements JsonSerializable<GatewayCorsProperties> {
    /*
     * Allowed origins to make cross-site requests. The special value `*` allows all domains.
     */
    private List<String> allowedOrigins;

    /*
     * Allowed origin patterns to make cross-site requests.
     */
    private List<String> allowedOriginPatterns;

    /*
     * Allowed HTTP methods on cross-site requests. The special value `*` allows all methods. If not set, `GET` and
     * `HEAD` are allowed by default.
     */
    private List<String> allowedMethods;

    /*
     * Allowed headers in cross-site requests. The special value `*` allows actual requests to send any header.
     */
    private List<String> allowedHeaders;

    /*
     * How long, in seconds, the response from a pre-flight request can be cached by clients.
     */
    private Integer maxAge;

    /*
     * Whether user credentials are supported on cross-site requests. Valid values: `true`, `false`.
     */
    private Boolean allowCredentials;

    /*
     * HTTP response headers to expose for cross-site requests.
     */
    private List<String> exposedHeaders;

    /**
     * Creates an instance of GatewayCorsProperties class.
     */
    public GatewayCorsProperties() {
    }

    /**
     * Get the allowedOrigins property: Allowed origins to make cross-site requests. The special value `*` allows all
     * domains.
     * 
     * @return the allowedOrigins value.
     */
    public List<String> allowedOrigins() {
        return this.allowedOrigins;
    }

    /**
     * Set the allowedOrigins property: Allowed origins to make cross-site requests. The special value `*` allows all
     * domains.
     * 
     * @param allowedOrigins the allowedOrigins value to set.
     * @return the GatewayCorsProperties object itself.
     */
    public GatewayCorsProperties withAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    /**
     * Get the allowedOriginPatterns property: Allowed origin patterns to make cross-site requests.
     * 
     * @return the allowedOriginPatterns value.
     */
    public List<String> allowedOriginPatterns() {
        return this.allowedOriginPatterns;
    }

    /**
     * Set the allowedOriginPatterns property: Allowed origin patterns to make cross-site requests.
     * 
     * @param allowedOriginPatterns the allowedOriginPatterns value to set.
     * @return the GatewayCorsProperties object itself.
     */
    public GatewayCorsProperties withAllowedOriginPatterns(List<String> allowedOriginPatterns) {
        this.allowedOriginPatterns = allowedOriginPatterns;
        return this;
    }

    /**
     * Get the allowedMethods property: Allowed HTTP methods on cross-site requests. The special value `*` allows all
     * methods. If not set, `GET` and `HEAD` are allowed by default.
     * 
     * @return the allowedMethods value.
     */
    public List<String> allowedMethods() {
        return this.allowedMethods;
    }

    /**
     * Set the allowedMethods property: Allowed HTTP methods on cross-site requests. The special value `*` allows all
     * methods. If not set, `GET` and `HEAD` are allowed by default.
     * 
     * @param allowedMethods the allowedMethods value to set.
     * @return the GatewayCorsProperties object itself.
     */
    public GatewayCorsProperties withAllowedMethods(List<String> allowedMethods) {
        this.allowedMethods = allowedMethods;
        return this;
    }

    /**
     * Get the allowedHeaders property: Allowed headers in cross-site requests. The special value `*` allows actual
     * requests to send any header.
     * 
     * @return the allowedHeaders value.
     */
    public List<String> allowedHeaders() {
        return this.allowedHeaders;
    }

    /**
     * Set the allowedHeaders property: Allowed headers in cross-site requests. The special value `*` allows actual
     * requests to send any header.
     * 
     * @param allowedHeaders the allowedHeaders value to set.
     * @return the GatewayCorsProperties object itself.
     */
    public GatewayCorsProperties withAllowedHeaders(List<String> allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
        return this;
    }

    /**
     * Get the maxAge property: How long, in seconds, the response from a pre-flight request can be cached by clients.
     * 
     * @return the maxAge value.
     */
    public Integer maxAge() {
        return this.maxAge;
    }

    /**
     * Set the maxAge property: How long, in seconds, the response from a pre-flight request can be cached by clients.
     * 
     * @param maxAge the maxAge value to set.
     * @return the GatewayCorsProperties object itself.
     */
    public GatewayCorsProperties withMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    /**
     * Get the allowCredentials property: Whether user credentials are supported on cross-site requests. Valid values:
     * `true`, `false`.
     * 
     * @return the allowCredentials value.
     */
    public Boolean allowCredentials() {
        return this.allowCredentials;
    }

    /**
     * Set the allowCredentials property: Whether user credentials are supported on cross-site requests. Valid values:
     * `true`, `false`.
     * 
     * @param allowCredentials the allowCredentials value to set.
     * @return the GatewayCorsProperties object itself.
     */
    public GatewayCorsProperties withAllowCredentials(Boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
        return this;
    }

    /**
     * Get the exposedHeaders property: HTTP response headers to expose for cross-site requests.
     * 
     * @return the exposedHeaders value.
     */
    public List<String> exposedHeaders() {
        return this.exposedHeaders;
    }

    /**
     * Set the exposedHeaders property: HTTP response headers to expose for cross-site requests.
     * 
     * @param exposedHeaders the exposedHeaders value to set.
     * @return the GatewayCorsProperties object itself.
     */
    public GatewayCorsProperties withExposedHeaders(List<String> exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("allowedOrigins", this.allowedOrigins,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("allowedOriginPatterns", this.allowedOriginPatterns,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("allowedMethods", this.allowedMethods,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("allowedHeaders", this.allowedHeaders,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("maxAge", this.maxAge);
        jsonWriter.writeBooleanField("allowCredentials", this.allowCredentials);
        jsonWriter.writeArrayField("exposedHeaders", this.exposedHeaders,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayCorsProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayCorsProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GatewayCorsProperties.
     */
    public static GatewayCorsProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayCorsProperties deserializedGatewayCorsProperties = new GatewayCorsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("allowedOrigins".equals(fieldName)) {
                    List<String> allowedOrigins = reader.readArray(reader1 -> reader1.getString());
                    deserializedGatewayCorsProperties.allowedOrigins = allowedOrigins;
                } else if ("allowedOriginPatterns".equals(fieldName)) {
                    List<String> allowedOriginPatterns = reader.readArray(reader1 -> reader1.getString());
                    deserializedGatewayCorsProperties.allowedOriginPatterns = allowedOriginPatterns;
                } else if ("allowedMethods".equals(fieldName)) {
                    List<String> allowedMethods = reader.readArray(reader1 -> reader1.getString());
                    deserializedGatewayCorsProperties.allowedMethods = allowedMethods;
                } else if ("allowedHeaders".equals(fieldName)) {
                    List<String> allowedHeaders = reader.readArray(reader1 -> reader1.getString());
                    deserializedGatewayCorsProperties.allowedHeaders = allowedHeaders;
                } else if ("maxAge".equals(fieldName)) {
                    deserializedGatewayCorsProperties.maxAge = reader.getNullable(JsonReader::getInt);
                } else if ("allowCredentials".equals(fieldName)) {
                    deserializedGatewayCorsProperties.allowCredentials = reader.getNullable(JsonReader::getBoolean);
                } else if ("exposedHeaders".equals(fieldName)) {
                    List<String> exposedHeaders = reader.readArray(reader1 -> reader1.getString());
                    deserializedGatewayCorsProperties.exposedHeaders = exposedHeaders;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayCorsProperties;
        });
    }
}
