// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Single sign-on related configuration.
 */
@Fluent
public final class DevToolPortalSsoProperties implements JsonSerializable<DevToolPortalSsoProperties> {
    /*
     * It defines the specific actions applications can be allowed to do on a user's behalf
     */
    private List<String> scopes;

    /*
     * The public identifier for the application
     */
    private String clientId;

    /*
     * The secret known only to the application and the authorization server
     */
    private String clientSecret;

    /*
     * The URI of a JSON file with generic OIDC provider configuration.
     */
    private String metadataUrl;

    /**
     * Creates an instance of DevToolPortalSsoProperties class.
     */
    public DevToolPortalSsoProperties() {
    }

    /**
     * Get the scopes property: It defines the specific actions applications can be allowed to do on a user's behalf.
     * 
     * @return the scopes value.
     */
    public List<String> scopes() {
        return this.scopes;
    }

    /**
     * Set the scopes property: It defines the specific actions applications can be allowed to do on a user's behalf.
     * 
     * @param scopes the scopes value to set.
     * @return the DevToolPortalSsoProperties object itself.
     */
    public DevToolPortalSsoProperties withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    /**
     * Get the clientId property: The public identifier for the application.
     * 
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: The public identifier for the application.
     * 
     * @param clientId the clientId value to set.
     * @return the DevToolPortalSsoProperties object itself.
     */
    public DevToolPortalSsoProperties withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Get the clientSecret property: The secret known only to the application and the authorization server.
     * 
     * @return the clientSecret value.
     */
    public String clientSecret() {
        return this.clientSecret;
    }

    /**
     * Set the clientSecret property: The secret known only to the application and the authorization server.
     * 
     * @param clientSecret the clientSecret value to set.
     * @return the DevToolPortalSsoProperties object itself.
     */
    public DevToolPortalSsoProperties withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    /**
     * Get the metadataUrl property: The URI of a JSON file with generic OIDC provider configuration.
     * 
     * @return the metadataUrl value.
     */
    public String metadataUrl() {
        return this.metadataUrl;
    }

    /**
     * Set the metadataUrl property: The URI of a JSON file with generic OIDC provider configuration.
     * 
     * @param metadataUrl the metadataUrl value to set.
     * @return the DevToolPortalSsoProperties object itself.
     */
    public DevToolPortalSsoProperties withMetadataUrl(String metadataUrl) {
        this.metadataUrl = metadataUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("scopes", this.scopes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("clientId", this.clientId);
        jsonWriter.writeStringField("clientSecret", this.clientSecret);
        jsonWriter.writeStringField("metadataUrl", this.metadataUrl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DevToolPortalSsoProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DevToolPortalSsoProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DevToolPortalSsoProperties.
     */
    public static DevToolPortalSsoProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DevToolPortalSsoProperties deserializedDevToolPortalSsoProperties = new DevToolPortalSsoProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("scopes".equals(fieldName)) {
                    List<String> scopes = reader.readArray(reader1 -> reader1.getString());
                    deserializedDevToolPortalSsoProperties.scopes = scopes;
                } else if ("clientId".equals(fieldName)) {
                    deserializedDevToolPortalSsoProperties.clientId = reader.getString();
                } else if ("clientSecret".equals(fieldName)) {
                    deserializedDevToolPortalSsoProperties.clientSecret = reader.getString();
                } else if ("metadataUrl".equals(fieldName)) {
                    deserializedDevToolPortalSsoProperties.metadataUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDevToolPortalSsoProperties;
        });
    }
}
