// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Settings for Dev Tool Portal.
 */
@Fluent
public final class DevToolPortalFeatureSettings implements JsonSerializable<DevToolPortalFeatureSettings> {
    /*
     * Detail of Accelerator plugin
     */
    private DevToolPortalFeatureDetail applicationAccelerator;

    /*
     * Detail of App Live View plugin
     */
    private DevToolPortalFeatureDetail applicationLiveView;

    /**
     * Creates an instance of DevToolPortalFeatureSettings class.
     */
    public DevToolPortalFeatureSettings() {
    }

    /**
     * Get the applicationAccelerator property: Detail of Accelerator plugin.
     * 
     * @return the applicationAccelerator value.
     */
    public DevToolPortalFeatureDetail applicationAccelerator() {
        return this.applicationAccelerator;
    }

    /**
     * Set the applicationAccelerator property: Detail of Accelerator plugin.
     * 
     * @param applicationAccelerator the applicationAccelerator value to set.
     * @return the DevToolPortalFeatureSettings object itself.
     */
    public DevToolPortalFeatureSettings withApplicationAccelerator(DevToolPortalFeatureDetail applicationAccelerator) {
        this.applicationAccelerator = applicationAccelerator;
        return this;
    }

    /**
     * Get the applicationLiveView property: Detail of App Live View plugin.
     * 
     * @return the applicationLiveView value.
     */
    public DevToolPortalFeatureDetail applicationLiveView() {
        return this.applicationLiveView;
    }

    /**
     * Set the applicationLiveView property: Detail of App Live View plugin.
     * 
     * @param applicationLiveView the applicationLiveView value to set.
     * @return the DevToolPortalFeatureSettings object itself.
     */
    public DevToolPortalFeatureSettings withApplicationLiveView(DevToolPortalFeatureDetail applicationLiveView) {
        this.applicationLiveView = applicationLiveView;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (applicationAccelerator() != null) {
            applicationAccelerator().validate();
        }
        if (applicationLiveView() != null) {
            applicationLiveView().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("applicationAccelerator", this.applicationAccelerator);
        jsonWriter.writeJsonField("applicationLiveView", this.applicationLiveView);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DevToolPortalFeatureSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DevToolPortalFeatureSettings if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DevToolPortalFeatureSettings.
     */
    public static DevToolPortalFeatureSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DevToolPortalFeatureSettings deserializedDevToolPortalFeatureSettings = new DevToolPortalFeatureSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("applicationAccelerator".equals(fieldName)) {
                    deserializedDevToolPortalFeatureSettings.applicationAccelerator
                        = DevToolPortalFeatureDetail.fromJson(reader);
                } else if ("applicationLiveView".equals(fieldName)) {
                    deserializedDevToolPortalFeatureSettings.applicationLiveView
                        = DevToolPortalFeatureDetail.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDevToolPortalFeatureSettings;
        });
    }
}
