// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.fluent.models.CustomDomainResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * Collection compose of a custom domain resources list and a possible link for next page.
 */
@Fluent
public final class CustomDomainResourceCollection implements JsonSerializable<CustomDomainResourceCollection> {
    /*
     * The custom domain resources list.
     */
    private List<CustomDomainResourceInner> value;

    /*
     * The link to next page of custom domain list.
     */
    private String nextLink;

    /**
     * Creates an instance of CustomDomainResourceCollection class.
     */
    public CustomDomainResourceCollection() {
    }

    /**
     * Get the value property: The custom domain resources list.
     * 
     * @return the value value.
     */
    public List<CustomDomainResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The custom domain resources list.
     * 
     * @param value the value value to set.
     * @return the CustomDomainResourceCollection object itself.
     */
    public CustomDomainResourceCollection withValue(List<CustomDomainResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The link to next page of custom domain list.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link to next page of custom domain list.
     * 
     * @param nextLink the nextLink value to set.
     * @return the CustomDomainResourceCollection object itself.
     */
    public CustomDomainResourceCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomDomainResourceCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomDomainResourceCollection if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CustomDomainResourceCollection.
     */
    public static CustomDomainResourceCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomDomainResourceCollection deserializedCustomDomainResourceCollection
                = new CustomDomainResourceCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<CustomDomainResourceInner> value
                        = reader.readArray(reader1 -> CustomDomainResourceInner.fromJson(reader1));
                    deserializedCustomDomainResourceCollection.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedCustomDomainResourceCollection.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomDomainResourceCollection;
        });
    }
}
