// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Buildpack group properties of the Builder.
 */
@Fluent
public final class BuildpacksGroupProperties implements JsonSerializable<BuildpacksGroupProperties> {
    /*
     * Buildpack group name
     */
    private String name;

    /*
     * Buildpacks in the buildpack group
     */
    private List<BuildpackProperties> buildpacks;

    /**
     * Creates an instance of BuildpacksGroupProperties class.
     */
    public BuildpacksGroupProperties() {
    }

    /**
     * Get the name property: Buildpack group name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Buildpack group name.
     * 
     * @param name the name value to set.
     * @return the BuildpacksGroupProperties object itself.
     */
    public BuildpacksGroupProperties withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the buildpacks property: Buildpacks in the buildpack group.
     * 
     * @return the buildpacks value.
     */
    public List<BuildpackProperties> buildpacks() {
        return this.buildpacks;
    }

    /**
     * Set the buildpacks property: Buildpacks in the buildpack group.
     * 
     * @param buildpacks the buildpacks value to set.
     * @return the BuildpacksGroupProperties object itself.
     */
    public BuildpacksGroupProperties withBuildpacks(List<BuildpackProperties> buildpacks) {
        this.buildpacks = buildpacks;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (buildpacks() != null) {
            buildpacks().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("buildpacks", this.buildpacks, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuildpacksGroupProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuildpacksGroupProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BuildpacksGroupProperties.
     */
    public static BuildpacksGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuildpacksGroupProperties deserializedBuildpacksGroupProperties = new BuildpacksGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedBuildpacksGroupProperties.name = reader.getString();
                } else if ("buildpacks".equals(fieldName)) {
                    List<BuildpackProperties> buildpacks
                        = reader.readArray(reader1 -> BuildpackProperties.fromJson(reader1));
                    deserializedBuildpacksGroupProperties.buildpacks = buildpacks;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBuildpacksGroupProperties;
        });
    }
}
